# 基础语法 - 去重

## 教程
在数据表中，可能存在重复的数据记录，但如果我们想要过滤掉重复的记录，只保留不同的记录，就要使用 SQL 的去重功能。

在 SQL 中，我们可以使用 `DISTINCT` 关键字来实现去重操作。

举个应用场景：假设你是班长，要统计班级中有哪些不同的学生，而不关心他们重复出现的次数，就可以使用去重。



## 示例
假设有一张名为`students`的数据表，它存储了学生信息，包括学生姓名（name）、班级ID（class_id）、考试编号（exam_num）、成绩（score）等：

数据表`students`：

|   name   | class_id | exam_num | score |
|----------|----------|----------|-------|
|   张三   |   1      | 1        | 90    |
|   李四   |   2      | 2        | 85    |
|   王五   |   1      | 1        | 92    |
|   李四   |   2      | 3        | 88    |



现在，我们使用`DISTINCT`关键字来找出不同的班级 ID：

```sql
-- SQL 查询语句
select distinct class_id from students;
```



查询结果：

| class_id |
|----------|
|   1      |
|   2      |



除了按照单字段去重外，`DISTINCT` 关键字还支持根据多个字段的组合来进行去重操作，确保多个字段的组合是唯一的。

示例语法如下：

```sql
distinct 字段1, 字段2, 字段3, ...
```



## 题目

请编写一条 SQL 查询语句，从名为 `student` 的数据表中选择出所有不重复的班级 ID（class_id）和考试编号（exam_num）的组合。

