# 24 年最新项目 - 面试刷题平台

> 作者：[程序员鱼皮](https://yuyuanweb.feishu.cn/wiki/Abldw5WkjidySxkKxU2cQdAtnah)
>
> 本项目为教学项目，提供完整视频教程 + 文字教程 + 简历写法 + 面试题解 + 答疑服务，帮你提升项目能力，给简历增加亮点！
>
> ⭐️ 加入项目系列学习：[加入编程导航（限时优惠中 🧧）](https://yuyuanweb.feishu.cn/wiki/SDtMwjR1DituVpkz5MLc3fZLnzb)

## 项目介绍

深入业务场景的企业级实战项目，基于 Next.js 服务端渲染 + Spring Boot + Redis + MySQL + Elasticsearch 的 面试刷题平台。

管理员可以创建题库、题目和题解，并批量关联题目到题库；用户可以注册登录、分词检索题目、在线刷题并查看刷题记录日历等。

项目涉及大量企业级新技术的讲解，比如使用数据库连接池、热 Key 探测、缓存、高级数据结构来提升性能。通过流量控制、熔断、动态 IP 黑白名单过滤、同端登录冲突检测、分级反爬虫策略来提升系统和内容的安全性。从 0 到 1 的真实企业级项目设计开发，绝对让你收获满满！

> 成品参考：https://mianshiya.com
>
> 在线学习：https://code-nav.cn/course/mianshiya ，感兴趣的同学可以 **免费试看**

![](https://pic.yupi.icu/1285/202409291622990.png)



### 项目三大阶段

该项目业务场景主流、优化点和技术亮点多，为了帮大家循序渐进地学习，鱼皮将项目设计为 3 个阶段，通俗易懂：

1）第一阶段，开发基础的刷题平台，带大家熟悉项目开发流程，实战 Next.js 服务端渲染 + Spring Boot 应用的快速开发。

![](https://pic.yupi.icu/1285/202409291632262.PNG)

2）第二阶段，对项目功能进行扩展，精选 4 个真实业务场景，实战企业主流后端技术如 Redis 缓存和高级数据结构、Elasticsearch 搜索引擎、Druid 连接池、并发编程、热 key 探测的应用。

![](https://pic.yupi.icu/1285/202409291631905.PNG)

3）第三阶段，对项目安全性进行优化，比如基于 Sentinel 进行网站流量控制和熔断、基于 Nacos 实现动态的 IP 黑白名单、基于 Sa-Token 实现同端登录冲突检测、基于 Redis 实现分级反爬虫策略等。最终将项目上线并保证可用性。

![](https://pic.yupi.icu/1285/202409291632109.PNG)



### 项目展示

本项目涉及 10 多个页面手把手从 0 带做，分量十足，而且采用服务端渲染技术实现！前面已经展示部分页面。

题目搜索页面：

![](https://pic.yupi.icu/1285/202409291632524.png)

题库详情页面：

![](https://pic.yupi.icu/1285/202409291633147.png)

题目管理页面，涉及批量操作和动态弹窗的开发：

![](https://pic.yupi.icu/1285/202409291634296.png)

本项目架构设计图：

![](https://pic.yupi.icu/1285/202409291634789.png)



### 项目特点

鱼皮原创项目系列以实战为主，**从 0 到 1** 带大家学习技术知识，并立即实践运用到项目中，做到学以致用。

从需求分析、技术选型、项目设计、项目初始化、Demo 编写、前后端开发实现、项目优化、部署上线等，每个环节我都 **从理论到实践** 给大家讲的明明白白、每个细节都不放过！

满满的项目正反馈：

![](https://pic.yupi.icu/1285/202409291634731.png)

除视频教程外，鱼皮编程导航的项目还提供：

- 详细的直播笔记（本项目有全套文字教程）
- 完整的项目源码（分节的代码，更易学习）
- 答疑解惑和专属项目交流群
- ⭐️ 现成的简历写法（直接写满简历）
- ⭐️ 项目的扩展思路（拉开和其他人的差距）
- ⭐️ 项目相关面试题、题解和真实面经（提前准备，面试不懵逼）
- ⭐️ 前端 + Java 后端万用项目模板（快速创建项目）

![](https://pic.yupi.icu/1285/202409291634728.png)

![](https://pic.yupi.icu/1285/202409291635501.png)



## 加入学习

比起看网上的教程学习，鱼皮项目系列的优势：从学知识 => 实践项目 => 复习笔记 => 项目答疑 => 简历写法 => 面试题解的一条龙服务

编程导航已有 **10 多套项目教程！** 每个项目的学习重点不同，几乎全都是前端 + 后端的 **全栈** 项目，可阅读 [项目实战 - 鱼皮原创项目教程系列](https://yuyuanweb.feishu.cn/wiki/SePYwTc9tipQiCktw7Uc7kujnCd) 了解。

欢迎 [加入编程导航（🧧 限时优惠）](https://yuyuanweb.feishu.cn/wiki/SDtMwjR1DituVpkz5MLc3fZLnzb) ，不仅能学习往期原创项目（10+ 套），还能享受更多原创资料、学习和求职指导，开启你的编程起飞之旅~



## 项目收获

本项目是线上刷题网站 [《面试鸭》](https://mianshiya.com/) 的教学版本，业务真实典型，基于主流的前端 Next.js 服务端渲染和后端经典技术栈实现。区别于增删改查的 “烂大街” 项目，本项目中鱼皮会带你实战大量新技术和企业级场景、掌握系统设计和优化方案，给你的简历大幅增加竞争力。

鱼皮给大家讲的都是 **通用的项目开发方法和架构设计套路**，从这个项目中你可以学到：

- 如何拆解复杂业务，从 0 开始设计实现系统？
- 如何快速构建 Next.js 服务端渲染网站和后端项目？
- 如何结合 Redis + Caffeine + Hotkey 构建高性能实时缓存？
- 如何利用 Elasticsearch 实现灵活高效的内容搜索？
- 如何巧用 Redisson 高级数据结构，实现高性能的接口？
- 如何实现流量控制和动态 IP 黑白名单，增强网站安全性？
- 如何实现登录冲突检测和分级反爬虫策略，保护网站内容？
- 如何快速上线项目并增强可用性？

此外，还能学会很多作图、思考问题、对比方案的方法，提升排查问题、自主解决 Bug 的能力，成为一个项目负责人。



## 技术选型

### 后端

- Java Spring Boot 框架 + Maven 多模块构建
- MySQL 数据库 + MyBatis-Plus 框架 + MyBatis X
- Redis 分布式缓存 + Caffeine 本地缓存
- Redission 分布式锁 + BitMap + BloomFilter
- ⭐️ Elasticsearch 搜索引擎
- ⭐️ Druid 数据库连接池 + 并发编程
- ⭐️ Sa-Token 权限控制
- ⭐️ HotKey 热点探测
- ⭐️ Sentinel 流量控制
- ⭐️ Nacos 配置中心
- ⭐️ 多角度项目优化：性能、安全性、可用性



### 前端

- React 18 框架
- ⭐️ Next.js 服务端渲染
- ⭐️ Redux 状态管理
- Ant Design 组件库
- 富文本编辑器组件
- ⭐️ 前端工程化：ESLint + Prettier + TypeScript
- ⭐️ OpenAPI 前端代码生成



## 项目大纲

以下只展示了核心内容，项目中还讲解了很多扩展知识。

### 第一阶段：基础面试刷题平台

1. 项目介绍 | 项目背景、核心业务流程
2. 项目介绍 | 项目功能梳理
3. 项目介绍 | 技术选型和架构设计
4. 后端开发 | 需求分析和库表设计
5. 后端开发 | 后端项目初始化
6. 后端开发 | 后端基础功能开发
7. 后端开发 | 后端核心业务流程开发
8. 前端开发 | 前端技术选型（服务端渲染）
9. 前端模板 | 前端初始化和工程化配置
10. 前端模板 | Next.js 开发规范
11. 前端模板 | Next.js 万用模板开发
12. 前端开发 | 基础页面开发（登录注册和管理页面）
13. 前端开发 | 核心页面开发（主页 + 刷题页 + 搜索页）

### 第二阶段：进阶功能扩展

1. 用户功能扩展 | 刷题记录日历
2. 用户功能扩展 | BitMap 及性能优化
3. 用户功能扩展 | 题目分词搜索
4. 用户功能扩展 | Elasticsearch 从入门到实战（有原理讲解）
5. 用户功能扩展 | Elasticsearch 数据同步
6. 管理功能扩展 | 题目批量管理
7. 管理功能扩展 | 批处理操作优化（10 多种方案）
8. 管理功能扩展 | Druid 连接池
9. 管理功能扩展 | 自动缓存热门题库
10. 管理功能扩展 | HotKey 从入门到实战（有原理讲解）

### 第三阶段：企业级优化和上线

1. 流量安全优化 | Sentinel 从入门到实战（有原理讲解）
2. 流量安全优化 | 单接口限流熔断
3. 流量安全优化 | 热点参数限流熔断
4. 流量安全优化 | Sentinel 规则持久化
5. 流量安全优化 | 方案设计（BloomFilter + 配置中心）
6. 流量安全优化 | Nacos 从入门到实战
7. 流量安全优化 | 动态 IP 黑名单
8. 内容安全优化 | Sa-Token 从入门到实战（有原理讲解）
9. 内容安全优化 | 同端登录冲突检测
10. 内容安全优化 | 反爬虫方案设计
11. 内容安全优化 | 基于 Redis 分级反爬虫



## 项目资料

包括：

- 学习计划、视频教程、文字教程、项目源码
- 项目答疑、项目交流群、学员笔记
- 简历写法、面试题解、扩展思路



以上资料均可在编程导航网站获取：https://www.code-nav.cn/course/mianshiya

点击 [加入编程导航 🧧 限时优惠](https://yuyuanweb.feishu.cn/wiki/SDtMwjR1DituVpkz5MLc3fZLnzb) ，可以解锁全部项目资料，如图：

![](https://pic.yupi.icu/1285/202409291637084.png)



## 真实评价

编程导航帮助大量小伙伴学会做项目，拿到理想的 Offer！

![](https://pic.yupi.icu/1285/202409291638711.png)

![](https://pic.yupi.icu/1285/202409291638114.png)

![](https://pic.yupi.icu/1285/202409291638987.png)


## 🧧 加入编程导航学习本项目

本项目为教学项目，提供完整视频教程 + 文字教程 + 简历写法 + 面试题解 + 答疑服务，帮你提升项目能力，给简历增加亮点！

点击 [加入编程导航 🧧 限时优惠](https://yuyuanweb.feishu.cn/wiki/SDtMwjR1DituVpkz5MLc3fZLnzb) ，鱼皮带做的所有 10+ 项目教程都可以无限回看！

👨🏻‍💻 超过 3 万人的编程学习交流圈，帮你更快学好编程 => 做出项目 => 搞定毕设 => 拿到 offer

1. 获取原创编程学习路线、几十位大厂嘉宾的独家经验分享和答疑
2. 获取原创编程 **学习指南和求职指南**，帮你解决学习问题、告别迷茫
3. 数十套保姆级 **原创项目实战教程**，简历写法、面试题解、项目答疑一条龙，掌握独立做项目的方法
4. 获取独家写简历技巧，查看几百份 **真实简历参考**，提高简历通过率
5. 获取保姆级求职指南、每日投递信息表、精选面试题、面经汇总
6. 加入专属编程交流群，获取每日优质文章推送，提高学习动力
7. 鱼皮往期所有直播无限回看

