/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.ByteArrayInput;
import io.protostuff.CodedInput;
import io.protostuff.IOUtil;
import io.protostuff.Input;
import io.protostuff.LinkedBuffer;
import io.protostuff.Pipe;
import io.protostuff.ProtobufException;
import io.protostuff.ProtobufOutput;
import io.protostuff.ProtostuffOutput;
import io.protostuff.Schema;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ProtostuffIOUtil {
    private ProtostuffIOUtil() {
    }

    public static Pipe newPipe(byte[] data) {
        return ProtostuffIOUtil.newPipe(data, 0, data.length);
    }

    public static Pipe newPipe(byte[] data, int offset, int len) {
        final ByteArrayInput byteArrayInput = new ByteArrayInput(data, offset, len, true);
        return new Pipe(){

            @Override
            protected Input begin(Pipe.Schema<?> pipeSchema) throws IOException {
                return byteArrayInput;
            }

            @Override
            protected void end(Pipe.Schema<?> pipeSchema, Input input, boolean cleanupOnly) throws IOException {
                if (cleanupOnly) {
                    return;
                }
                assert (input == byteArrayInput);
            }
        };
    }

    public static Pipe newPipe(InputStream in) {
        final CodedInput codedInput = new CodedInput(in, true);
        return new Pipe(){

            @Override
            protected Input begin(Pipe.Schema<?> pipeSchema) throws IOException {
                return codedInput;
            }

            @Override
            protected void end(Pipe.Schema<?> pipeSchema, Input input, boolean cleanupOnly) throws IOException {
                if (cleanupOnly) {
                    return;
                }
                assert (input == codedInput);
            }
        };
    }

    public static <T> void mergeFrom(byte[] data, T message, Schema<T> schema) {
        IOUtil.mergeFrom(data, 0, data.length, message, schema, true);
    }

    public static <T> void mergeFrom(byte[] data, int offset, int length, T message, Schema<T> schema) {
        IOUtil.mergeFrom(data, offset, length, message, schema, true);
    }

    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema) throws IOException {
        IOUtil.mergeFrom(in, message, schema, true);
    }

    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        IOUtil.mergeFrom(in, buffer.buffer, message, schema, true);
    }

    public static <T> int mergeDelimitedFrom(InputStream in, T message, Schema<T> schema) throws IOException {
        return IOUtil.mergeDelimitedFrom(in, message, schema, true);
    }

    public static <T> int mergeDelimitedFrom(InputStream in, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        return IOUtil.mergeDelimitedFrom(in, buffer.buffer, message, schema, true);
    }

    public static <T> int mergeDelimitedFrom(DataInput in, T message, Schema<T> schema) throws IOException {
        return IOUtil.mergeDelimitedFrom(in, message, schema, true);
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, LinkedBuffer buffer) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtostuffOutput output = new ProtostuffOutput(buffer);
        try {
            schema.writeTo(output, message);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return output.toByteArray();
    }

    public static <T> int writeTo(LinkedBuffer buffer, T message, Schema<T> schema) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtostuffOutput output = new ProtostuffOutput(buffer);
        try {
            schema.writeTo(output, message);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a LinkedBuffer threw an IOException (should never happen).", e);
        }
        return output.getSize();
    }

    public static <T> int writeTo(OutputStream out, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtostuffOutput output = new ProtostuffOutput(buffer, out);
        schema.writeTo(output, message);
        LinkedBuffer.writeTo(out, buffer);
        return output.size;
    }

    public static <T> int writeDelimitedTo(OutputStream out, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtostuffOutput output = new ProtostuffOutput(buffer);
        schema.writeTo(output, message);
        ProtobufOutput.writeRawVarInt32Bytes(out, output.size);
        LinkedBuffer.writeTo(out, buffer);
        return output.size;
    }

    public static <T> int writeDelimitedTo(DataOutput out, T message, Schema<T> schema) throws IOException {
        LinkedBuffer buffer = new LinkedBuffer(256);
        ProtostuffOutput output = new ProtostuffOutput(buffer);
        schema.writeTo(output, message);
        ProtobufOutput.writeRawVarInt32Bytes(out, output.size);
        LinkedBuffer.writeTo(out, buffer);
        return output.size;
    }

    public static <T> int writeListTo(OutputStream out, List<T> messages, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        int size = messages.size();
        if (size == 0) {
            return 0;
        }
        ProtostuffOutput output = new ProtostuffOutput(buffer, out);
        output.sink.writeVarInt32(size, output, buffer);
        for (T m3 : messages) {
            schema.writeTo(output, m3);
            output.sink.writeByte((byte)7, output, buffer);
        }
        LinkedBuffer.writeTo(out, buffer);
        return output.size;
    }

    public static <T> List<T> parseListFrom(InputStream in, Schema<T> schema) throws IOException {
        int size = in.read();
        if (size == -1) {
            return Collections.emptyList();
        }
        if (size > 127) {
            size = CodedInput.readRawVarint32(in, size);
        }
        ArrayList<T> list = new ArrayList<T>(size);
        CodedInput input = new CodedInput(in, true);
        for (int i = 0; i < size; ++i) {
            T message = schema.newMessage();
            list.add(message);
            schema.mergeFrom(input, message);
            input.checkLastTagWas(0);
        }
        assert (in.read() == -1);
        return list;
    }

    public static <T> boolean optMergeDelimitedFrom(InputStream in, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        return ProtostuffIOUtil.optMergeDelimitedFrom(in, message, schema, true, buffer);
    }

    public static <T> boolean optMergeDelimitedFrom(InputStream in, T message, Schema<T> schema, boolean drainRemainingBytesIfTooLarge, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        int size = IOUtil.fillBufferWithDelimitedMessageFrom(in, drainRemainingBytesIfTooLarge, buffer);
        if (size == 0) {
            return true;
        }
        if (buffer.start == buffer.offset) {
            return false;
        }
        ByteArrayInput input = new ByteArrayInput(buffer.buffer, buffer.offset, size, true);
        try {
            schema.mergeFrom(input, message);
            input.checkLastTagWas(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw ProtobufException.truncatedMessage(e);
        }
        finally {
            buffer.offset = buffer.start;
        }
        return true;
    }

    public static <T> int optWriteDelimitedTo(OutputStream out, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtostuffOutput output = new ProtostuffOutput(buffer);
        buffer.offset = buffer.start + 5;
        output.size += 5;
        schema.writeTo(output, message);
        int size = output.size - 5;
        int delimOffset = IOUtil.putVarInt32AndGetOffset(size, buffer.buffer, buffer.start);
        out.write(buffer.buffer, delimOffset, buffer.offset - delimOffset);
        if (buffer.next != null) {
            LinkedBuffer.writeTo(out, buffer.next);
        }
        return size;
    }
}

