/*
 * Decompiled with CFR 0.152.
 */
package com.jd.platform.hotkey.client.netty;

import com.jd.platform.hotkey.client.core.worker.WorkerInfoHolder;
import com.jd.platform.hotkey.client.log.JdLogger;
import com.jd.platform.hotkey.client.netty.NettyClientHandler;
import com.jd.platform.hotkey.common.coder.MsgDecoder;
import com.jd.platform.hotkey.common.coder.MsgEncoder;
import com.jd.platform.hotkey.common.tool.Constant;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.List;

public class NettyClient {
    private static final NettyClient nettyClient = new NettyClient();
    private Bootstrap bootstrap;

    public static NettyClient getInstance() {
        return nettyClient;
    }

    private NettyClient() {
        if (this.bootstrap == null) {
            this.bootstrap = this.initBootstrap();
        }
    }

    private Bootstrap initBootstrap() {
        NioEventLoopGroup group = new NioEventLoopGroup(2);
        Bootstrap bootstrap = new Bootstrap();
        final NettyClientHandler nettyClientHandler = new NettyClientHandler();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, true)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) {
                ByteBuf delimiter = Unpooled.copiedBuffer(Constant.DELIMITER.getBytes());
                ch.pipeline().addLast(new DelimiterBasedFrameDecoder(Constant.MAX_LENGTH, delimiter)).addLast(new MsgDecoder()).addLast(new MsgEncoder()).addLast(new IdleStateHandler(0, 0, 30)).addLast(nettyClientHandler);
            }
        });
        return bootstrap;
    }

    public synchronized boolean connect(List<String> addresses) {
        boolean allSuccess = true;
        for (String address : addresses) {
            if (WorkerInfoHolder.hasConnected(address)) continue;
            String[] ss = address.split(":");
            try {
                ChannelFuture channelFuture = this.bootstrap.connect(ss[0], Integer.parseInt(ss[1])).sync();
                Channel channel = channelFuture.channel();
                WorkerInfoHolder.put(address, channel);
            }
            catch (Exception e) {
                JdLogger.error(this.getClass(), "----\u8be5worker\u8fde\u4e0d\u4e0a----" + address);
                WorkerInfoHolder.put(address, null);
                allSuccess = false;
            }
        }
        return allSuccess;
    }
}

