/*
 * Decompiled with CFR 0.152.
 */
package com.jd.platform.hotkey.client.etcd;

import cn.hutool.core.collection.CollectionUtil;
import com.ibm.etcd.api.Event;
import com.ibm.etcd.api.KeyValue;
import com.ibm.etcd.client.kv.KvClient;
import com.ibm.etcd.client.kv.WatchUpdate;
import com.jd.platform.hotkey.client.Context;
import com.jd.platform.hotkey.client.callback.ReceiveNewKeyEvent;
import com.jd.platform.hotkey.client.core.eventbus.EventBusCenter;
import com.jd.platform.hotkey.client.core.rule.KeyRuleInfoChangeEvent;
import com.jd.platform.hotkey.client.core.worker.WorkerInfoChangeEvent;
import com.jd.platform.hotkey.client.core.worker.WorkerInfoHolder;
import com.jd.platform.hotkey.client.etcd.EtcdConfigFactory;
import com.jd.platform.hotkey.client.log.JdLogger;
import com.jd.platform.hotkey.common.configcenter.IConfigCenter;
import com.jd.platform.hotkey.common.model.HotKeyModel;
import com.jd.platform.hotkey.common.rule.KeyRule;
import com.jd.platform.hotkey.common.tool.Constant;
import com.jd.platform.hotkey.common.tool.FastJsonUtils;
import io.grpc.StatusRuntimeException;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class EtcdStarter {
    public void start() {
        this.fetchWorkerInfo();
        this.fetchRule();
        this.startWatchRule();
        this.startWatchHotKey();
    }

    private void fetchExistHotKey() {
        JdLogger.info(this.getClass(), "--- begin fetch exist hotKey from etcd ----");
        IConfigCenter configCenter = EtcdConfigFactory.configCenter();
        try {
            List<KeyValue> handKeyValues = configCenter.getPrefix("/jd/hotkeys/" + Context.APP_NAME);
            for (KeyValue keyValue : handKeyValues) {
                String key = keyValue.getKey().toStringUtf8().replace("/jd/hotkeys/" + Context.APP_NAME + "/", "");
                HotKeyModel model = new HotKeyModel();
                model.setRemove(false);
                model.setKey(key);
                EventBusCenter.getInstance().post(new ReceiveNewKeyEvent(model));
            }
        }
        catch (StatusRuntimeException ex) {
            JdLogger.error(this.getClass(), "etcd connected fail. Check the etcd address!!!");
        }
    }

    private void fetchWorkerInfo() {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            JdLogger.info(this.getClass(), "trying to connect to etcd and fetch worker info");
            this.fetch();
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    private void fetch() {
        IConfigCenter configCenter = EtcdConfigFactory.configCenter();
        try {
            List<KeyValue> keyValues = configCenter.getPrefix("/jd/workers/" + Context.APP_NAME);
            if (CollectionUtil.isEmpty(keyValues)) {
                keyValues = configCenter.getPrefix("/jd/workers/default");
            }
            if (CollectionUtil.isEmpty(keyValues)) {
                JdLogger.warn(this.getClass(), "very important warn !!! workers ip info is null!!!");
            }
            ArrayList<String> addresses = new ArrayList<String>();
            if (keyValues != null) {
                for (KeyValue keyValue : keyValues) {
                    String ipPort = keyValue.getValue().toStringUtf8();
                    addresses.add(ipPort);
                }
            }
            JdLogger.info(this.getClass(), "worker info list is : " + addresses + ", now addresses is " + WorkerInfoHolder.getWorkers());
            this.notifyWorkerChange(addresses);
        }
        catch (StatusRuntimeException ex) {
            JdLogger.error(this.getClass(), "etcd connected fail. Check the etcd address!!!");
        }
    }

    private void notifyWorkerChange(List<String> addresses) {
        EventBusCenter.getInstance().post(new WorkerInfoChangeEvent(addresses));
    }

    private void notifyRuleChange(List<KeyRule> rules) {
        EventBusCenter.getInstance().post(new KeyRuleInfoChangeEvent(rules));
    }

    private void startWatchHotKey() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> {
            JdLogger.info(this.getClass(), "--- begin watch hotKey change ----");
            IConfigCenter configCenter = EtcdConfigFactory.configCenter();
            try {
                KvClient.WatchIterator watchIterator = configCenter.watchPrefix("/jd/hotkeys/" + Context.APP_NAME);
                while (watchIterator.hasNext()) {
                    WatchUpdate watchUpdate = (WatchUpdate)watchIterator.next();
                    List<Event> eventList = watchUpdate.getEvents();
                    KeyValue keyValue = eventList.get(0).getKv();
                    Event.EventType eventType = eventList.get(0).getType();
                    try {
                        HotKeyModel model;
                        String key = keyValue.getKey().toStringUtf8().replace("/jd/hotkeys/" + Context.APP_NAME + "/", "");
                        if (Event.EventType.DELETE == eventType) {
                            model = new HotKeyModel();
                            model.setRemove(true);
                            model.setKey(key);
                            EventBusCenter.getInstance().post(new ReceiveNewKeyEvent(model));
                            continue;
                        }
                        model = new HotKeyModel();
                        model.setRemove(false);
                        String value = keyValue.getValue().toStringUtf8();
                        JdLogger.info(this.getClass(), "etcd receive new key : " + key + " --value:" + value);
                        if (Constant.DEFAULT_DELETE_VALUE.equals(value)) continue;
                        model.setCreateTime(Long.valueOf(keyValue.getValue().toStringUtf8()));
                        model.setKey(key);
                        EventBusCenter.getInstance().post(new ReceiveNewKeyEvent(model));
                    }
                    catch (Exception e) {
                        JdLogger.error(this.getClass(), "new key err \uff1a" + keyValue);
                    }
                }
            }
            catch (Exception e) {
                JdLogger.error(this.getClass(), "watch err");
            }
        });
    }

    private void fetchRule() {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            JdLogger.info(this.getClass(), "trying to connect to etcd and fetch rule info");
            boolean success = this.fetchRuleFromEtcd();
            if (success) {
                this.fetchExistHotKey();
                scheduledExecutorService.shutdown();
            }
        }, 0L, 5L, TimeUnit.SECONDS);
    }

    private boolean fetchRuleFromEtcd() {
        IConfigCenter configCenter = EtcdConfigFactory.configCenter();
        try {
            ArrayList<KeyRule> ruleList = new ArrayList();
            String rules = configCenter.get("/jd/rules/" + Context.APP_NAME);
            if (StringUtil.isNullOrEmpty(rules)) {
                JdLogger.warn(this.getClass(), "rule is empty");
                this.notifyRuleChange(ruleList);
                return true;
            }
            ruleList = FastJsonUtils.toList(rules, KeyRule.class);
            this.notifyRuleChange(ruleList);
            return true;
        }
        catch (StatusRuntimeException ex) {
            JdLogger.error(this.getClass(), "etcd connected fail. Check the etcd address!!!");
            return false;
        }
        catch (Exception e) {
            JdLogger.error(this.getClass(), "fetch rule failure, please check the rule info in etcd");
            return true;
        }
    }

    private void startWatchRule() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> {
            JdLogger.info(this.getClass(), "--- begin watch rule change ----");
            try {
                IConfigCenter configCenter = EtcdConfigFactory.configCenter();
                KvClient.WatchIterator watchIterator = configCenter.watch("/jd/rules/" + Context.APP_NAME);
                while (watchIterator.hasNext()) {
                    WatchUpdate watchUpdate = (WatchUpdate)watchIterator.next();
                    List<Event> eventList = watchUpdate.getEvents();
                    JdLogger.info(this.getClass(), "rules info changed. begin to fetch new infos. rule change is " + eventList);
                    this.fetchRuleFromEtcd();
                }
            }
            catch (Exception e) {
                JdLogger.error(this.getClass(), "watch err");
            }
        });
    }
}

