/*
 * Decompiled with CFR 0.152.
 */
package com.jd.platform.hotkey.client.core.worker;

import cn.hutool.core.util.StrUtil;
import com.jd.platform.hotkey.client.log.JdLogger;
import com.jd.platform.hotkey.client.netty.NettyClient;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class WorkerInfoHolder {
    private static final List<Server> WORKER_HOLDER = new CopyOnWriteArrayList<Server>();

    private WorkerInfoHolder() {
    }

    public static List<Server> getWorkers() {
        return WORKER_HOLDER;
    }

    public static boolean hasConnected(String address) {
        for (Server server : WORKER_HOLDER) {
            if (!address.equals(server.address)) continue;
            return WorkerInfoHolder.channelIsOk(server.channel);
        }
        return false;
    }

    public static List<String> getNonConnectedWorkers() {
        ArrayList<String> list = new ArrayList<String>();
        for (Server server : WORKER_HOLDER) {
            if (WorkerInfoHolder.channelIsOk(server.channel)) continue;
            list.add(server.address);
        }
        return list;
    }

    private static boolean channelIsOk(Channel channel) {
        return channel != null && channel.isActive();
    }

    public static Channel chooseChannel(String key) {
        int size = WORKER_HOLDER.size();
        if (StrUtil.isEmpty(key) || size == 0) {
            return null;
        }
        int index = Math.abs(key.hashCode() % size);
        return WORKER_HOLDER.get(index).channel;
    }

    public static void mergeAndConnectNew(List<String> allAddresses) {
        WorkerInfoHolder.removeNoneUsed(allAddresses);
        List<String> needConnectWorkers = WorkerInfoHolder.newWorkers(allAddresses);
        if (needConnectWorkers.size() == 0) {
            return;
        }
        JdLogger.info(WorkerInfoHolder.class, "new workers : " + needConnectWorkers);
        NettyClient.getInstance().connect(needConnectWorkers);
        Collections.sort(WORKER_HOLDER);
    }

    public static void dealChannelInactive(String address) {
        WORKER_HOLDER.removeIf(server -> address.equals(((Server)server).address));
    }

    public static synchronized void put(String address, Channel channel) {
        Server server;
        Iterator<Server> it = WORKER_HOLDER.iterator();
        boolean exist = false;
        while (it.hasNext()) {
            server = it.next();
            if (!address.equals(server.address)) continue;
            server.channel = channel;
            exist = true;
            break;
        }
        if (!exist) {
            server = new Server();
            server.address = address;
            server.channel = channel;
            WORKER_HOLDER.add(server);
        }
    }

    private static List<String> newWorkers(List<String> allAddresses) {
        HashSet<String> set = new HashSet<String>(WORKER_HOLDER.size());
        for (Server server : WORKER_HOLDER) {
            set.add(server.address);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s2 : allAddresses) {
            if (set.contains(s2)) continue;
            list.add(s2);
        }
        return list;
    }

    private static void removeNoneUsed(List<String> allAddresses) {
        for (Server server : WORKER_HOLDER) {
            boolean exist = false;
            String nowAddress = server.address;
            for (String address : allAddresses) {
                if (!address.equals(nowAddress)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            JdLogger.info(WorkerInfoHolder.class, "worker remove : " + nowAddress);
            if (server.channel != null) {
                server.channel.close();
            }
            WORKER_HOLDER.remove(server);
        }
    }

    private static class Server
    implements Comparable<Server> {
        private String address;
        private Channel channel;

        private Server() {
        }

        @Override
        public int compareTo(Server o) {
            return this.address.compareTo(o.address);
        }

        public String toString() {
            return "Server{address='" + this.address + '\'' + ", channel=" + this.channel + '}';
        }
    }
}

