/*
 * Decompiled with CFR 0.152.
 */
package com.jd.platform.hotkey.client.core.worker;

import com.google.common.eventbus.Subscribe;
import com.jd.platform.hotkey.client.core.worker.WorkerInfoChangeEvent;
import com.jd.platform.hotkey.client.core.worker.WorkerInfoHolder;
import com.jd.platform.hotkey.client.log.JdLogger;
import com.jd.platform.hotkey.client.netty.event.ChannelInactiveEvent;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class WorkerChangeSubscriber {
    @Subscribe
    public void connectAll(WorkerInfoChangeEvent event) {
        List<String> addresses = event.getAddresses();
        if (addresses == null) {
            addresses = new ArrayList<String>();
        }
        WorkerInfoHolder.mergeAndConnectNew(addresses);
    }

    @Subscribe
    public void channelInactive(ChannelInactiveEvent inactiveEvent) {
        Channel channel = inactiveEvent.getChannel();
        InetSocketAddress socketAddress = (InetSocketAddress)channel.remoteAddress();
        String address = socketAddress.getHostName() + ":" + socketAddress.getPort();
        JdLogger.warn(this.getClass(), "this channel is inactive : " + socketAddress + " trying to remove this connection");
        WorkerInfoHolder.dealChannelInactive(address);
    }
}

