/*
 * Decompiled with CFR 0.152.
 */
package com.jd.platform.hotkey.client.core.key;

import com.jd.platform.hotkey.client.Context;
import com.jd.platform.hotkey.client.core.key.KeyHandlerFactory;
import com.jd.platform.hotkey.client.core.rule.KeyRuleHolder;
import com.jd.platform.hotkey.client.etcd.EtcdConfigFactory;
import com.jd.platform.hotkey.common.model.HotKeyModel;
import com.jd.platform.hotkey.common.model.typeenum.KeyType;
import com.jd.platform.hotkey.common.tool.Constant;
import com.jd.platform.hotkey.common.tool.HotKeyPathTool;
import java.util.concurrent.atomic.LongAdder;

public class HotKeyPusher {
    public static void push(String key, KeyType keyType, int count, boolean remove) {
        if (count <= 0) {
            count = 1;
        }
        if (keyType == null) {
            keyType = KeyType.REDIS_KEY;
        }
        if (key == null) {
            return;
        }
        LongAdder adderCnt = new LongAdder();
        adderCnt.add(count);
        HotKeyModel hotKeyModel = new HotKeyModel();
        hotKeyModel.setAppName(Context.APP_NAME);
        hotKeyModel.setKeyType(keyType);
        hotKeyModel.setCount(adderCnt);
        hotKeyModel.setRemove(remove);
        hotKeyModel.setKey(key);
        if (remove) {
            EtcdConfigFactory.configCenter().putAndGrant(HotKeyPathTool.keyPath(hotKeyModel), Constant.DEFAULT_DELETE_VALUE, 1L);
            EtcdConfigFactory.configCenter().delete(HotKeyPathTool.keyPath(hotKeyModel));
            EtcdConfigFactory.configCenter().delete(HotKeyPathTool.keyRecordPath(hotKeyModel));
        } else if (KeyRuleHolder.isKeyInRule(key)) {
            KeyHandlerFactory.getCollector().collect(hotKeyModel);
        }
    }

    public static void push(String key, KeyType keyType, int count) {
        HotKeyPusher.push(key, keyType, count, false);
    }

    public static void push(String key, KeyType keyType) {
        HotKeyPusher.push(key, keyType, 1, false);
    }

    public static void push(String key) {
        HotKeyPusher.push(key, KeyType.REDIS_KEY, 1, false);
    }

    public static void remove(String key) {
        HotKeyPusher.push(key, KeyType.REDIS_KEY, 1, true);
    }
}

