/*
 * Decompiled with CFR 0.152.
 */
package com.jd.platform.hotkey.client.callback;

import com.jd.platform.hotkey.client.cache.CacheFactory;
import com.jd.platform.hotkey.client.cache.LocalCache;
import com.jd.platform.hotkey.client.callback.ValueModel;
import com.jd.platform.hotkey.client.core.key.HotKeyPusher;
import com.jd.platform.hotkey.client.core.key.KeyHandlerFactory;
import com.jd.platform.hotkey.client.core.key.KeyHotModel;
import com.jd.platform.hotkey.common.model.typeenum.KeyType;
import com.jd.platform.hotkey.common.tool.Constant;

public class JdHotKeyStore {
    private static boolean isNearExpire(ValueModel valueModel) {
        if (valueModel == null) {
            return true;
        }
        return valueModel.getCreateTime() + (long)valueModel.getDuration() - System.currentTimeMillis() <= 2000L;
    }

    public static boolean isHotKey(String key) {
        try {
            if (!JdHotKeyStore.inRule(key)) {
                return false;
            }
            boolean isHot = JdHotKeyStore.isHot(key);
            if (!isHot) {
                HotKeyPusher.push(key, null);
            } else {
                ValueModel valueModel = JdHotKeyStore.getValueSimple(key);
                if (JdHotKeyStore.isNearExpire(valueModel)) {
                    HotKeyPusher.push(key, null);
                }
            }
            KeyHandlerFactory.getCounter().collect(new KeyHotModel(key, isHot));
            return isHot;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object get(String key) {
        ValueModel value = JdHotKeyStore.getValueSimple(key);
        if (value == null) {
            return null;
        }
        Object object = value.getValue();
        if (object instanceof Integer && Constant.MAGIC_NUMBER == (Integer)object) {
            return null;
        }
        return object;
    }

    public static void smartSet(String key, Object value) {
        if (JdHotKeyStore.isHot(key)) {
            ValueModel valueModel = JdHotKeyStore.getValueSimple(key);
            if (valueModel == null) {
                return;
            }
            valueModel.setValue(value);
        }
    }

    public static void forceSet(String key, Object value) {
        ValueModel valueModel = ValueModel.defaultValue(key);
        if (valueModel != null) {
            valueModel.setValue(value);
        }
        JdHotKeyStore.setValueDirectly(key, valueModel);
    }

    public static Object getValue(String key, KeyType keyType) {
        try {
            if (!JdHotKeyStore.inRule(key)) {
                return null;
            }
            Object userValue = null;
            ValueModel value = JdHotKeyStore.getValueSimple(key);
            if (value == null) {
                HotKeyPusher.push(key, keyType);
            } else {
                Object object;
                if (JdHotKeyStore.isNearExpire(value)) {
                    HotKeyPusher.push(key, keyType);
                }
                userValue = (object = value.getValue()) instanceof Integer && Constant.MAGIC_NUMBER == (Integer)object ? null : object;
            }
            KeyHandlerFactory.getCounter().collect(new KeyHotModel(key, value != null));
            return userValue;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getValue(String key) {
        return JdHotKeyStore.getValue(key, null);
    }

    static ValueModel getValueSimple(String key) {
        Object object = JdHotKeyStore.getCache(key).get(key);
        if (object == null) {
            return null;
        }
        return (ValueModel)object;
    }

    static void setValueDirectly(String key, Object value) {
        JdHotKeyStore.getCache(key).set(key, value);
    }

    public static void remove(String key) {
        JdHotKeyStore.getCache(key).delete(key);
        HotKeyPusher.remove(key);
    }

    static boolean isHot(String key) {
        return JdHotKeyStore.getValueSimple(key) != null;
    }

    private static LocalCache getCache(String key) {
        return CacheFactory.getNonNullCache(key);
    }

    private static boolean inRule(String key) {
        return CacheFactory.getCache(key) != null;
    }
}

