/*
 * Decompiled with CFR 0.152.
 */
package com.jd.platform.hotkey.client.callback;

import com.jd.platform.hotkey.client.cache.CacheFactory;
import com.jd.platform.hotkey.client.callback.JdHotKeyStore;
import com.jd.platform.hotkey.client.callback.ReceiveNewKeyListener;
import com.jd.platform.hotkey.client.callback.ValueModel;
import com.jd.platform.hotkey.client.log.JdLogger;
import com.jd.platform.hotkey.common.model.HotKeyModel;

public class DefaultNewKeyListener
implements ReceiveNewKeyListener {
    @Override
    public void newKey(HotKeyModel hotKeyModel) {
        long now = System.currentTimeMillis();
        if (hotKeyModel.getCreateTime() != 0L && Math.abs(now - hotKeyModel.getCreateTime()) > 1000L) {
            JdLogger.warn(this.getClass(), "the key comes too late : " + hotKeyModel.getKey() + " now " + now + " keyCreateAt " + hotKeyModel.getCreateTime());
        }
        if (hotKeyModel.isRemove()) {
            this.deleteKey(hotKeyModel.getKey());
            return;
        }
        if (JdHotKeyStore.isHot(hotKeyModel.getKey())) {
            JdLogger.warn(this.getClass(), "receive repeat hot key \uff1a" + hotKeyModel.getKey() + " at " + now);
        }
        this.addKey(hotKeyModel.getKey());
    }

    private void addKey(String key) {
        ValueModel valueModel = ValueModel.defaultValue(key);
        if (valueModel == null) {
            this.deleteKey(key);
            return;
        }
        JdHotKeyStore.setValueDirectly(key, valueModel);
    }

    private void deleteKey(String key) {
        CacheFactory.getNonNullCache(key).delete(key);
    }
}

