/*
 * Decompiled with CFR 0.152.
 */
package com.jd.platform.hotkey.client.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.jd.platform.hotkey.client.cache.CaffeineBuilder;
import com.jd.platform.hotkey.client.cache.LocalCache;

public class CaffeineCache
implements LocalCache {
    private Cache<String, Object> cache;

    public CaffeineCache(int duration) {
        this.cache = CaffeineBuilder.cache(duration);
    }

    @Override
    public Object get(String key) {
        return this.get(key, null);
    }

    @Override
    public Object get(String key, Object defaultValue) {
        Object o = this.cache.getIfPresent(key);
        if (o == null) {
            return defaultValue;
        }
        return o;
    }

    @Override
    public void delete(String key) {
        this.cache.invalidate(key);
    }

    @Override
    public void set(String key, Object value) {
        this.cache.put(key, value);
    }

    @Override
    public void set(String key, Object value, long expire) {
        this.set(key, value);
    }

    @Override
    public void removeAll() {
        this.cache.invalidateAll();
    }
}

