/*
 * Decompiled with CFR 0.152.
 */
package com.jd.platform.hotkey.client;

import com.jd.platform.hotkey.client.Context;
import com.jd.platform.hotkey.client.callback.ReceiveNewKeySubscribe;
import com.jd.platform.hotkey.client.core.eventbus.EventBusCenter;
import com.jd.platform.hotkey.client.core.key.PushSchedulerStarter;
import com.jd.platform.hotkey.client.core.rule.KeyRuleHolder;
import com.jd.platform.hotkey.client.core.worker.WorkerChangeSubscriber;
import com.jd.platform.hotkey.client.core.worker.WorkerRetryConnector;
import com.jd.platform.hotkey.client.etcd.EtcdConfigFactory;
import com.jd.platform.hotkey.client.etcd.EtcdStarter;
import com.jd.platform.hotkey.client.log.JdLogger;

public class ClientStarter {
    private String etcdServer;
    private Long pushPeriod;
    private int caffeineSize;

    public ClientStarter(String appName) {
        if (appName == null) {
            throw new NullPointerException("APP_NAME cannot be null!");
        }
        Context.APP_NAME = appName;
    }

    public void startPipeline() {
        JdLogger.info(this.getClass(), "etcdServer:" + this.etcdServer);
        Context.CAFFEINE_SIZE = this.caffeineSize;
        EtcdConfigFactory.buildConfigCenter(this.etcdServer);
        PushSchedulerStarter.startPusher(this.pushPeriod);
        PushSchedulerStarter.startCountPusher(10);
        WorkerRetryConnector.retryConnectWorkers();
        this.registEventBus();
        EtcdStarter starter = new EtcdStarter();
        starter.start();
    }

    private void registEventBus() {
        EventBusCenter.register(new WorkerChangeSubscriber());
        EventBusCenter.register(new ReceiveNewKeySubscribe());
        EventBusCenter.register(new KeyRuleHolder());
    }

    public static class Builder {
        private String appName;
        private String etcdServer;
        private Long pushPeriod;
        private int caffeineSize = 200000;

        public Builder setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder setCaffeineSize(int caffeineSize) {
            if (caffeineSize < 128) {
                caffeineSize = 128;
            }
            this.caffeineSize = caffeineSize;
            return this;
        }

        public Builder setEtcdServer(String etcdServer) {
            this.etcdServer = etcdServer;
            return this;
        }

        public Builder setPushPeriod(Long pushPeriod) {
            this.pushPeriod = pushPeriod;
            return this;
        }

        public ClientStarter build() {
            ClientStarter clientStarter = new ClientStarter(this.appName);
            clientStarter.etcdServer = this.etcdServer;
            clientStarter.pushPeriod = this.pushPeriod;
            clientStarter.caffeineSize = this.caffeineSize;
            return clientStarter;
        }
    }
}

