/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client.watch;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.ibm.etcd.api.ResponseHeader;
import com.ibm.etcd.api.WatchCancelRequest;
import com.ibm.etcd.api.WatchCreateRequest;
import com.ibm.etcd.api.WatchGrpc;
import com.ibm.etcd.api.WatchRequest;
import com.ibm.etcd.api.WatchResponse;
import com.ibm.etcd.client.GrpcClient;
import com.ibm.etcd.client.kv.KvClient;
import com.ibm.etcd.client.kv.WatchUpdate;
import com.ibm.etcd.client.watch.EtcdWatchIterator;
import com.ibm.etcd.client.watch.EtcdWatchUpdate;
import com.ibm.etcd.client.watch.RevisionCompactedException;
import com.ibm.etcd.client.watch.WatchCancelledException;
import com.ibm.etcd.client.watch.WatchCreateException;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EtcdWatchClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(EtcdWatchClient.class);
    private static final Exception CANCEL_EXCEPTION = new CancellationException();
    private static final String UNAUTH_REASON_PREFIX = "rpc error: code = PermissionDenied";
    private static final MethodDescriptor<WatchRequest, WatchResponse> METHOD_WATCH = WatchGrpc.getWatchMethod();
    private final GrpcClient client;
    private final Executor observerExecutor;
    private final Executor eventLoop;
    @GuardedBy(value="this")
    private StreamObserver<WatchRequest> requestStream;
    private final Queue<WatcherRecord> pendingCreate = new ConcurrentLinkedQueue<WatcherRecord>();
    @GuardedBy(value="eventLoop")
    private final Map<Long, WatcherRecord> activeWatchers = new HashMap<Long, WatcherRecord>();
    protected final GrpcClient.ResilientResponseObserver<WatchRequest, WatchResponse> responseObserver = new GrpcClient.ResilientResponseObserver<WatchRequest, WatchResponse>(){

        @Override
        public void onEstablished() {
            logger.debug("onEstablished called for watch request stream");
        }

        @Override
        public void onNext(WatchResponse wr) {
            EtcdWatchClient.this.processResponse(wr);
        }

        @Override
        public void onReplaced(StreamObserver<WatchRequest> newStreamRequestObserver) {
            if (!EtcdWatchClient.this.closed) {
                logger.info("onReplaced called for watch request stream" + (newStreamRequestObserver == null ? " with newReqStream == null" : ""));
            }
            this.onReplacedOrFailed(newStreamRequestObserver, null);
        }

        @Override
        public void onCompleted() {
            logger.debug("onCompleted called for watch request stream");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t) {
            logger.debug("onError called for watch request stream", t);
            if (EtcdWatchClient.this.closed || GrpcClient.causedBy(t, CancellationException.class)) {
                return;
            }
            EtcdWatchClient etcdWatchClient = EtcdWatchClient.this;
            synchronized (etcdWatchClient) {
                if (EtcdWatchClient.this.closed) {
                    return;
                }
            }
            logger.warn("Unexpected fatal watch stream error", t);
            this.onReplacedOrFailed(null, t instanceof Exception ? (Exception)t : new RuntimeException(t));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onReplacedOrFailed(StreamObserver<WatchRequest> newRequestStream, Exception err) {
            ArrayList pending = null;
            EtcdWatchClient etcdWatchClient = EtcdWatchClient.this;
            synchronized (etcdWatchClient) {
                EtcdWatchClient.this.requestStream = newRequestStream;
                if (!EtcdWatchClient.this.activeWatchers.isEmpty() || !EtcdWatchClient.this.pendingCreate.isEmpty()) {
                    pending = new ArrayList(EtcdWatchClient.this.pendingCreate);
                    pending.addAll(EtcdWatchClient.this.activeWatchers.values());
                    EtcdWatchClient.this.pendingCreate.clear();
                    EtcdWatchClient.this.activeWatchers.clear();
                }
            }
            boolean watchesExist = false;
            if (pending != null) {
                for (WatcherRecord wrec : pending) {
                    boolean cancelled;
                    if (wrec.finished) continue;
                    if (wrec.watchId >= 0L) {
                        wrec.watchId = -1L;
                    }
                    boolean bl = cancelled = wrec.userCancelled || EtcdWatchClient.this.closed;
                    if (!cancelled && newRequestStream != null) {
                        WatchRequest createReq = wrec.newCreateWatchRequest();
                        EtcdWatchClient etcdWatchClient2 = EtcdWatchClient.this;
                        synchronized (etcdWatchClient2) {
                            if (EtcdWatchClient.this.closed) {
                                cancelled = true;
                            } else {
                                EtcdWatchClient.this.pendingCreate.add(wrec);
                                newRequestStream.onNext(createReq);
                                watchesExist = true;
                            }
                        }
                    }
                    if (!cancelled && newRequestStream != null) continue;
                    if (cancelled) {
                        wrec.userCancelled = true;
                        wrec.vUserCancelled = true;
                    }
                    wrec.finished = true;
                    wrec.publishCompletionEvent(err);
                }
            }
            if (!watchesExist) {
                EtcdWatchClient.this.closeRequestStreamIfNoWatches();
            }
        }
    };
    @GuardedBy(value="this")
    protected boolean closed;

    public EtcdWatchClient(GrpcClient client) {
        this(client, client.getResponseExecutor());
    }

    public EtcdWatchClient(GrpcClient client, Executor executor) {
        this.client = client;
        this.observerExecutor = executor != null ? executor : client.getResponseExecutor();
        this.eventLoop = GrpcClient.serialized(client.getInternalExecutor());
    }

    public KvClient.Watch watch(WatchCreateRequest createReq, StreamObserver<WatchUpdate> observer) {
        return this.watch(createReq, observer, null);
    }

    public KvClient.Watch watch(WatchCreateRequest createReq, StreamObserver<WatchUpdate> observer, Executor executor) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        WatcherRecord wrec = new WatcherRecord(createReq, observer, executor != null ? executor : this.observerExecutor);
        WatchHandle handle = new WatchHandle(wrec);
        wrec.creationFuture = handle;
        boolean succ = this.createNewWatch(wrec);
        if (!succ) {
            throw new IllegalStateException("closed");
        }
        return handle;
    }

    public KvClient.WatchIterator watch(WatchCreateRequest createReq) {
        EtcdWatchIterator watchIt = new EtcdWatchIterator();
        KvClient.Watch handle = this.watch(createReq, watchIt, MoreExecutors.directExecutor());
        return watchIt.setWatch(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createNewWatch(WatcherRecord wrec) {
        WatchRequest createReq = wrec.firstCreateWatchRequest();
        EtcdWatchClient etcdWatchClient = this;
        synchronized (etcdWatchClient) {
            StreamObserver<WatchRequest> reqStream = this.getRequestStream();
            if (reqStream == null) {
                return false;
            }
            this.pendingCreate.add(wrec);
            reqStream.onNext(createReq);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="eventLoop")
    protected void sendCancel(long watchId) {
        if (watchId < 0L) {
            return;
        }
        WatchRequest cancelReq = WatchRequest.newBuilder().setCancelRequest(WatchCancelRequest.newBuilder().setWatchId(watchId).build()).build();
        EtcdWatchClient etcdWatchClient = this;
        synchronized (etcdWatchClient) {
            StreamObserver<WatchRequest> reqStream;
            StreamObserver<WatchRequest> streamObserver = reqStream = this.closed ? null : this.requestStream;
            if (reqStream != null) {
                reqStream.onNext(cancelReq);
            }
        }
    }

    @GuardedBy(value="this")
    protected StreamObserver<WatchRequest> getRequestStream() {
        if (this.closed) {
            return null;
        }
        if (this.requestStream == null) {
            logger.debug("Watch stream starting");
            this.requestStream = this.client.callStream(METHOD_WATCH, this.responseObserver, this.eventLoop);
        }
        return this.requestStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="eventLoop")
    protected void closeRequestStreamIfNoWatches() {
        EtcdWatchClient etcdWatchClient = this;
        synchronized (etcdWatchClient) {
            if (this.requestStream != null && this.activeWatchers.isEmpty() && this.pendingCreate.isEmpty()) {
                this.requestStream.onError(CANCEL_EXCEPTION);
                logger.info("Watch stream cancelled due to there being no active watches");
                this.requestStream = null;
            }
        }
    }

    @GuardedBy(value="eventLoop")
    protected void processResponse(WatchResponse wr) {
        boolean cancelled = wr.getCanceled() || wr.getCompactRevision() != 0L;
        long watchId = wr.getWatchId();
        boolean watchCountReduced = false;
        if (wr.getCreated()) {
            WatcherRecord wrec;
            if (logger.isDebugEnabled()) {
                logger.debug("Watch create response received for id " + watchId);
            }
            if ((wrec = this.pendingCreate.poll()) == null) {
                logger.error("State error: received unexpected watch create response: " + wr);
                this.sendCancel(wr.getWatchId());
                return;
            }
            watchCountReduced = !wrec.processCreatedResponse(wr, cancelled);
        } else if (cancelled) {
            WatcherRecord wrec = this.activeWatchers.remove(watchId);
            watchCountReduced = true;
            if (wrec != null) {
                wrec.processCancelledResponse(wr);
            }
        } else {
            WatcherRecord wrec = this.activeWatchers.get(watchId);
            if (wrec != null) {
                wrec.processWatchEvents(wr);
            } else {
                logger.warn("State error: received response for unrecognized watchId " + watchId + ": " + wr);
                this.sendCancel(watchId);
            }
        }
        if (watchCountReduced && this.activeWatchers.isEmpty() && this.pendingCreate.isEmpty()) {
            this.closeRequestStreamIfNoWatches();
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.eventLoop.execute(() -> {
            if (!this.closed) {
                EtcdWatchClient etcdWatchClient = this;
                synchronized (etcdWatchClient) {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    if (this.requestStream != null) {
                        this.requestStream.onError(CANCEL_EXCEPTION);
                        this.requestStream = null;
                    }
                    this.responseObserver.onReplaced(null);
                }
            }
        });
    }

    static final class WatchHandle
    extends AbstractFuture<Boolean>
    implements KvClient.Watch {
        private final WeakReference<WatcherRecord> wrecRef;

        public WatchHandle(WatcherRecord wrec) {
            this.wrecRef = new WeakReference<WatcherRecord>(wrec);
        }

        @Override
        public void close() {
            WatcherRecord wrec = (WatcherRecord)this.wrecRef.get();
            if (wrec != null) {
                wrec.cancel();
            }
        }

        @Override
        protected void interruptTask() {
            this.close();
        }

        void complete(boolean created, Exception error) {
            if (error != null) {
                this.setException(error);
            } else {
                this.set(created);
            }
        }
    }

    final class WatcherRecord {
        private final StreamObserver<WatchUpdate> observer;
        private final WatchCreateRequest request;
        private final Executor watcherExecutor;
        private WatchHandle creationFuture;
        long upToRevision;
        long watchId = -2L;
        boolean lastCreateFailedAuth;
        boolean userCancelled;
        boolean finished;
        volatile boolean vUserCancelled;

        public WatcherRecord(WatchCreateRequest request, StreamObserver<WatchUpdate> observer, Executor parentExecutor) {
            this.observer = observer;
            this.request = request;
            long rev = request.getStartRevision();
            this.upToRevision = rev - 1L;
            this.watcherExecutor = GrpcClient.serialized(parentExecutor);
        }

        public void publishCompletionEvent(Exception err) {
            this.watcherExecutor.execute(() -> {
                this.completeCreateFuture(false, err);
                try {
                    if (err == null || this.vUserCancelled) {
                        this.observer.onCompleted();
                    } else {
                        this.observer.onError(err);
                    }
                }
                catch (RuntimeException e) {
                    logger.warn("Watch " + this.watchId + " observer onCompleted/onError threw", e);
                }
            });
        }

        @GuardedBy(value="eventLoop")
        public void processWatchEvents(WatchResponse wr) {
            long newRevision;
            if (this.userCancelled) {
                return;
            }
            int eventsCount = wr.getEventsCount();
            long l = newRevision = eventsCount <= 0 ? wr.getHeader().getRevision() - 1L : wr.getEvents(eventsCount - 1).getKv().getModRevision();
            if (newRevision <= this.upToRevision) {
                return;
            }
            this.watcherExecutor.execute(() -> {
                try {
                    if (!this.vUserCancelled) {
                        this.observer.onNext(new EtcdWatchUpdate(wr));
                    }
                }
                catch (RuntimeException e) {
                    logger.warn("Watch observer onNext() threw (watchId = " + this.watchId + ")", e);
                    this.cancel();
                }
            });
            this.upToRevision = newRevision;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @GuardedBy(value="eventLoop")
        public boolean processCreatedResponse(WatchResponse wr, boolean cancelled) {
            long newWatchId = wr.getWatchId();
            if (cancelled || newWatchId == -1L) {
                String reason = wr.getCancelReason();
                if (reason != null && reason.startsWith(EtcdWatchClient.UNAUTH_REASON_PREFIX) && !this.lastCreateFailedAuth) {
                    EtcdWatchClient etcdWatchClient = EtcdWatchClient.this;
                    synchronized (etcdWatchClient) {
                        boolean notClosed = EtcdWatchClient.this.createNewWatch(this);
                        if (!notClosed) return false;
                        StreamObserver<WatchRequest> reqStream = EtcdWatchClient.this.getRequestStream();
                        if (reqStream == null) return false;
                        this.lastCreateFailedAuth = true;
                        reqStream.onError(Status.Code.UNAUTHENTICATED.toStatus().withDescription(reason).asException());
                        return false;
                    }
                }
                this.processCancelledResponse(wr);
                return false;
            }
            this.lastCreateFailedAuth = false;
            boolean first = this.watchId < 0L;
            boolean veryFirst = this.watchId == -2L;
            this.watchId = newWatchId;
            if (EtcdWatchClient.this.activeWatchers.putIfAbsent(newWatchId, this) != null) {
                logger.error("State error: watchId conflict: " + this.watchId);
                return false;
            }
            if (this.userCancelled) {
                EtcdWatchClient.this.sendCancel(this.watchId);
                return false;
            }
            if (veryFirst) {
                this.watcherExecutor.execute(() -> this.completeCreateFuture(true, null));
            }
            if (first) {
                if (wr.getEventsCount() <= 0) return true;
            }
            this.processWatchEvents(wr);
            return true;
        }

        @GuardedBy(value="eventLoop")
        public void processCancelledResponse(WatchResponse wr) {
            WatchCancelledException error;
            this.watchId = -1L;
            if (this.finished) {
                logger.warn("Ignoring unexpected cancel response for watchId " + wr.getWatchId() + ", reason=" + wr.getCancelReason());
                return;
            }
            this.finished = true;
            if (this.userCancelled) {
                error = null;
            } else {
                ResponseHeader header = wr.getHeader();
                long cRev = wr.getCompactRevision();
                String reason = wr.getCancelReason();
                long cancelledId = wr.getWatchId();
                error = cRev != 0L ? new RevisionCompactedException(header, cancelledId, reason, cRev) : (wr.getCreated() ? new WatchCreateException(header, cancelledId, reason) : new WatchCancelledException(header, cancelledId, reason));
            }
            this.publishCompletionEvent(error);
        }

        @GuardedBy(value="eventLoop")
        public WatchRequest newCreateWatchRequest() {
            return WatchRequest.newBuilder().setCreateRequest(this.request.toBuilder().setStartRevision(this.upToRevision + 1L)).build();
        }

        public WatchRequest firstCreateWatchRequest() {
            return WatchRequest.newBuilder().setCreateRequest(this.request).build();
        }

        public void cancel() {
            if (EtcdWatchClient.this.closed || this.finished || this.userCancelled) {
                return;
            }
            EtcdWatchClient.this.eventLoop.execute(() -> {
                if (EtcdWatchClient.this.closed || this.userCancelled || this.finished) {
                    return;
                }
                EtcdWatchClient.this.sendCancel(this.watchId);
                this.userCancelled = true;
                this.vUserCancelled = true;
            });
        }

        private void completeCreateFuture(boolean created, Exception error) {
            WatchHandle wh = this.creationFuture;
            if (wh != null) {
                wh.complete(created, error);
                this.creationFuture = null;
            }
        }
    }
}

