/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client.utils;

import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.ibm.etcd.api.Compare;
import com.ibm.etcd.api.CompareOrBuilder;
import com.ibm.etcd.api.DeleteRangeRequest;
import com.ibm.etcd.api.DeleteRangeResponse;
import com.ibm.etcd.api.Event;
import com.ibm.etcd.api.KeyValue;
import com.ibm.etcd.api.PutRequest;
import com.ibm.etcd.api.RangeRequest;
import com.ibm.etcd.api.RangeResponse;
import com.ibm.etcd.api.RequestOp;
import com.ibm.etcd.api.ResponseOp;
import com.ibm.etcd.api.TxnRequest;
import com.ibm.etcd.api.TxnResponse;
import com.ibm.etcd.client.EtcdClient;
import com.ibm.etcd.client.GrpcClient;
import com.ibm.etcd.client.KeyUtils;
import com.ibm.etcd.client.kv.KvClient;
import com.ibm.etcd.client.kv.WatchUpdate;
import com.ibm.etcd.client.watch.RevisionCompactedException;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeCache
implements AutoCloseable,
Iterable<KeyValue> {
    protected static final Logger logger = LoggerFactory.getLogger(RangeCache.class);
    public static final long TIMEOUT_MS = 3500L;
    private final ByteString fromKey;
    private final ByteString toKey;
    private final transient EtcdClient client;
    private final KvClient kvClient;
    private KvClient.Watch watch;
    private volatile boolean closed;
    @GuardedBy(value="this")
    private ListenableFuture<Boolean> startFuture;
    private final ConcurrentMap<ByteString, KeyValue> entries;
    private final NavigableSet<KeyValue> deletionQueue;
    private final AtomicLong seenUpToRev = new AtomicLong(0L);
    protected final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    protected final Executor listenerExecutor;

    public RangeCache(EtcdClient client, ByteString prefix) {
        this(client, prefix, false);
    }

    public RangeCache(EtcdClient client, ByteString prefix, boolean sorted) {
        this(client, prefix, KeyUtils.plusOne(prefix), sorted);
    }

    public RangeCache(EtcdClient client, ByteString fromKey, ByteString toKey, boolean sorted) {
        this.fromKey = fromKey;
        this.toKey = toKey;
        this.client = client;
        this.kvClient = client.getKvClient();
        this.entries = !sorted ? new ConcurrentHashMap(32, 0.75f, 4) : new ConcurrentSkipListMap(KeyUtils::compareByteStrings);
        this.deletionQueue = new ConcurrentSkipListSet<KeyValue>((kv1, kv2) -> {
            int diff = Long.compare(kv1.getModRevision(), kv2.getModRevision());
            return diff != 0 ? diff : KeyUtils.compareByteStrings(kv1.getKey(), kv2.getKey());
        });
        this.listenerExecutor = GrpcClient.serialized(client.getExecutor());
    }

    public synchronized ListenableFuture<Boolean> start() {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.startFuture != null) {
            throw new IllegalStateException("already started");
        }
        this.startFuture = this.fullRefreshCache();
        return this.startFuture;
    }

    protected ListenableFuture<Boolean> fullRefreshCache() {
        ListenableFuture rrfut;
        boolean firstTime;
        long seenUpTo = this.seenUpToRev.get();
        boolean bl = firstTime = seenUpTo == 0L;
        if (firstTime || this.entries.size() <= 20) {
            ListenableFuture rrf = ((KvClient.FluentRangeRequest)((KvClient.FluentRangeRequest)this.kvClient.get(this.fromKey).rangeEnd(this.toKey).backoffRetry(() -> !this.closed)).timeout(300000L)).async();
            rrfut = Futures.transform(rrf, Collections::singletonList, MoreExecutors.directExecutor());
        } else {
            RangeRequest.Builder rangeReqBld = RangeRequest.newBuilder().setKey(this.fromKey).setRangeEnd(this.toKey);
            RangeRequest newModsReq = rangeReqBld.setMinModRevision(seenUpTo + 1L).build();
            RangeRequest otherKeysReq = rangeReqBld.clearMinModRevision().setMaxModRevision(seenUpTo).setKeysOnly(true).build();
            ListenableFuture trf = ((KvClient.FluentTxnOps)((KvClient.FluentTxnOps)this.kvClient.batch().get(newModsReq).get(otherKeysReq).backoffRetry(() -> !this.closed)).timeout(300000L)).async();
            rrfut = Futures.transform(trf, tr -> tr.getResponsesList().stream().map(ResponseOp::getResponseRange).collect(Collectors.toList()), MoreExecutors.directExecutor());
        }
        SettableFuture<Boolean> promise = new SettableFuture<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void interruptTask() {
                KvClient.Watch theWatch;
                if (rrfut.cancel(true)) {
                    return;
                }
                RangeCache rangeCache = RangeCache.this;
                synchronized (rangeCache) {
                    theWatch = RangeCache.this.watch;
                }
                if (theWatch != null) {
                    theWatch.close();
                }
            }
        };
        Futures.addCallback(rrfut, (rrs, err) -> {
            if (rrs != null) {
                try {
                    this.setupWatch((List<RangeResponse>)rrs, firstTime, promise);
                    return;
                }
                catch (Throwable t) {
                    err = t;
                }
            }
            promise.setException(err);
        }, this.listenerExecutor);
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupWatch(List<RangeResponse> rrs, boolean firstTime, final SettableFuture<Boolean> promise) {
        KvClient.Watch newWatch;
        if (this.closed) {
            throw new CancellationException();
        }
        HashSet<ByteString> snapshot = firstTime && this.entries.isEmpty() ? null : new HashSet<ByteString>();
        RangeResponse toUpdate = rrs.get(0);
        if (toUpdate.getKvsCount() > 0) {
            for (KeyValue kv : toUpdate.getKvsList()) {
                if (snapshot != null) {
                    snapshot.add(kv.getKey());
                }
                this.offerUpdate(kv, true);
            }
        }
        long snapshotRev = toUpdate.getHeader().getRevision();
        if (firstTime) {
            this.notifyListeners(Listener.EventType.INITIALIZED, null, true);
        }
        if (snapshot != null) {
            if (rrs.size() > 1) {
                for (KeyValue keyValue : rrs.get(1).getKvsList()) {
                    snapshot.add(keyValue.getKey());
                }
            }
            KeyValue.Builder kvBld = null;
            for (ByteString key : this.entries.keySet()) {
                if (snapshot.contains(key)) continue;
                if (kvBld == null) {
                    kvBld = KeyValue.newBuilder().setVersion(0L).setModRevision(snapshotRev);
                }
                this.offerUpdate(kvBld.setKey(key).build(), true);
            }
        }
        this.revisionUpdate(snapshotRev);
        StreamObserver<WatchUpdate> watchObserver = new StreamObserver<WatchUpdate>(){

            @Override
            public void onNext(WatchUpdate update) {
                int eventCount;
                List<Event> events = update.getEvents();
                int n = eventCount = events != null ? events.size() : 0;
                if (eventCount > 0) {
                    block4: for (Event event : events) {
                        KeyValue kv = event.getKv();
                        switch (event.getType()) {
                            case DELETE: {
                                if (kv.getVersion() != 0L) {
                                    kv = KeyValue.newBuilder(kv).setVersion(0L).clearValue().build();
                                }
                            }
                            case PUT: {
                                RangeCache.this.offerUpdate(kv, true);
                                continue block4;
                            }
                        }
                        logger.warn("Unrecognized event for key " + kv.getKey().toStringUtf8());
                    }
                }
                RangeCache.this.revisionUpdate(eventCount == 0 ? update.getHeader().getRevision() - 1L : events.get(eventCount - 1).getKv().getModRevision());
            }

            @Override
            public void onCompleted() {
                if (!RangeCache.this.closed) {
                    if (!RangeCache.this.client.isClosed()) {
                        logger.warn("Watch completed unexpectedly (not closed) (fromKey = " + RangeCache.this.fromKey.toStringUtf8() + ")");
                    }
                    RangeCache.this.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable t) {
                ListenableFuture<Boolean> refresh;
                if (RangeCache.this.closed) {
                    promise.setException(new CancellationException());
                    return;
                }
                assert (RangeCache.this.startFuture == promise);
                boolean isDone = promise.isDone();
                if (isDone && promise.isCancelled()) {
                    return;
                }
                if (!(t instanceof RevisionCompactedException)) {
                    logger.error("Watch failed with exception (fromKey = " + RangeCache.this.fromKey.toStringUtf8() + ")", t);
                    promise.setException(t);
                    return;
                }
                if (isDone) {
                    refresh = RangeCache.this.fullRefreshCache();
                } else {
                    refresh = Futures.scheduleAsync(RangeCache.this::fullRefreshCache, 1L, TimeUnit.SECONDS, RangeCache.this.client.internalScheduledExecutor());
                    if (promise.setFuture(refresh)) {
                        refresh = null;
                    }
                }
                RangeCache rangeCache = RangeCache.this;
                synchronized (rangeCache) {
                    if (!RangeCache.this.closed) {
                        if (refresh != null) {
                            RangeCache.this.startFuture = refresh;
                            refresh = null;
                        }
                        RangeCache.this.watch = null;
                    }
                }
                if (refresh == null) {
                    logger.warn("Performing full refresh (fromKey = " + RangeCache.this.fromKey.toStringUtf8() + ") following watch compaction error: " + t);
                } else {
                    assert (RangeCache.this.closed);
                    refresh.cancel(false);
                }
            }
        };
        KvClient.FluentWatchRequest fluentWatchRequest = this.kvClient.watch(this.fromKey).rangeEnd(this.toKey).progressNotify().startRevision(snapshotRev + 1L).executor(this.listenerExecutor);
        RangeCache rangeCache = this;
        synchronized (rangeCache) {
            if (this.closed) {
                throw new CancellationException();
            }
            if (promise.isCancelled()) {
                return;
            }
            this.watch = newWatch = fluentWatchRequest.start(watchObserver);
        }
        Futures.addCallback(newWatch, (v, t) -> {
            if (t != null && !newWatch.isCancelled()) {
                return;
            }
            if (!Boolean.TRUE.equals(v) && this.closed) {
                promise.setException(new CancellationException());
            } else {
                promise.set((Boolean)v);
            }
        }, MoreExecutors.directExecutor());
    }

    protected void revisionUpdate(long upToRev) {
        if (this.seenUpToRev.get() >= upToRev) {
            return;
        }
        this.seenUpToRev.lazySet(upToRev);
        if (this.deletionQueue.isEmpty()) {
            return;
        }
        Iterator<KeyValue> it = this.deletionQueue.iterator();
        while (it.hasNext()) {
            KeyValue kv = it.next();
            if (kv.getModRevision() > upToRev) {
                return;
            }
            it.remove();
            this.entries.remove(kv.getKey(), kv);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    protected void notifyListeners(Listener.EventType type, KeyValue keyValue, boolean inListenerExecutor) {
        if (!inListenerExecutor) {
            this.listenerExecutor.execute(() -> this.notifyListeners(type, keyValue, true));
        } else {
            for (Listener l : this.listeners) {
                try {
                    l.event(type, keyValue);
                }
                catch (RuntimeException re) {
                    logger.warn("Listener threw exception for " + (Object)((Object)type) + " event" + (keyValue != null ? " for key " + keyValue.getKey().toStringUtf8() : ""), re);
                }
            }
        }
    }

    protected KeyValue offerExpiry(ByteString key) {
        return this.get(key);
    }

    protected KeyValue offerDelete(ByteString key, long modRevision) {
        return this.offerUpdate(KeyValue.newBuilder().setKey(key).setVersion(0L).setModRevision(modRevision).build(), false);
    }

    protected KeyValue offerUpdate(KeyValue keyValue, boolean watchThread) {
        block12: {
            long modRevision = keyValue.getModRevision();
            if (modRevision <= this.seenUpToRev.get()) {
                return RangeCache.kvOrNullIfDeleted(keyValue);
            }
            ByteString key = keyValue.getKey();
            boolean isDeleted = RangeCache.isDeleted(keyValue);
            if (watchThread && !isDeleted) {
                KeyValue newKv = this.entries.merge(key, keyValue, (existKv, kv) -> kv.getModRevision() > existKv.getModRevision() ? kv : existKv);
                if (newKv == keyValue) {
                    this.notifyListeners(Listener.EventType.UPDATED, keyValue, true);
                }
                return RangeCache.kvOrNullIfDeleted(newKv);
            }
            KeyValue existKv2 = (KeyValue)this.entries.get(key);
            while (true) {
                if (existKv2 != null) {
                    long existModRevision = existKv2.getModRevision();
                    if (existModRevision >= modRevision) {
                        return RangeCache.kvOrNullIfDeleted(existKv2);
                    }
                    KeyValue newKv = this.entries.computeIfPresent(key, (k, v) -> existModRevision == v.getModRevision() ? keyValue : v);
                    if (newKv != keyValue) {
                        existKv2 = newKv;
                        continue;
                    }
                    boolean deletionReplaced = RangeCache.isDeleted(existKv2);
                    if (deletionReplaced) {
                        this.deletionQueue.remove(existKv2);
                    }
                    if (isDeleted) {
                        this.deletionQueue.add(keyValue);
                        if (!deletionReplaced) {
                            this.notifyListeners(Listener.EventType.DELETED, existKv2, watchThread);
                        }
                        return null;
                    }
                    break block12;
                }
                if (modRevision <= this.seenUpToRev.get()) {
                    return null;
                }
                existKv2 = this.entries.putIfAbsent(key, keyValue);
                if (existKv2 == null) break;
            }
            if (isDeleted) {
                this.deletionQueue.add(keyValue);
                return null;
            }
        }
        this.notifyListeners(Listener.EventType.UPDATED, keyValue, false);
        return keyValue;
    }

    protected static KeyValue kvOrNullIfDeleted(KeyValue fromCache) {
        return RangeCache.isDeleted(fromCache) ? null : fromCache;
    }

    protected static boolean isDeleted(KeyValue kv) {
        return kv == null || kv.getVersion() == 0L;
    }

    public KeyValue get(ByteString key) {
        return key == null ? null : RangeCache.kvOrNullIfDeleted((KeyValue)this.entries.get(key));
    }

    public KeyValue getFirst() {
        if (this.entries.isEmpty()) {
            return null;
        }
        if (this.entries instanceof NavigableMap) {
            Map.Entry first = ((NavigableMap)((Object)this.entries)).firstEntry();
            return first != null ? (KeyValue)first.getValue() : null;
        }
        Iterator it = this.entries.values().iterator();
        return it.hasNext() ? (KeyValue)it.next() : null;
    }

    protected KeyValue getRemote(ByteString key, boolean weak) {
        if (key == null) {
            return null;
        }
        RangeResponse rr = (RangeResponse)((KvClient.FluentRangeRequest)this.kvClient.get(key).serializable(weak).timeout(3500L)).sync();
        KeyValue kv = rr.getKvsCount() > 0 ? rr.getKvs(0) : null;
        return kv != null ? this.offerUpdate(kv, false) : this.offerDelete(key, rr.getHeader().getRevision());
    }

    public KeyValue getRemote(ByteString key) {
        return this.getRemote(key, false);
    }

    public KeyValue getRemoteWeak(ByteString key) {
        return this.getRemote(key, true);
    }

    public int size() {
        int total = this.entries.size();
        if (total > 0) {
            KeyValue deletion = this.deletionQueue.pollFirst();
            while (deletion != null) {
                if (this.entries.get(deletion.getKey()) != deletion) {
                    this.deletionQueue.remove(deletion);
                } else if (--total == 0) {
                    return 0;
                }
                deletion = this.deletionQueue.higher(deletion);
            }
        }
        return total;
    }

    public boolean keyExists(ByteString key) {
        return this.get(key) != null;
    }

    public boolean keyExistsRemote(ByteString key) {
        boolean exists;
        if (key == null) {
            return false;
        }
        RangeResponse rr = (RangeResponse)((KvClient.FluentRangeRequest)this.kvClient.get(key).countOnly().timeout(3500L)).sync();
        boolean bl = exists = rr.getCount() > 0L;
        if (!exists) {
            this.offerDelete(key, rr.getHeader().getRevision());
        }
        return exists;
    }

    public long put(ByteString key, ByteString value) {
        return this.putNoGet(key, value, 0L, null);
    }

    public PutResult put(ByteString key, ByteString value, long lease, CompareOrBuilder ... conditions) {
        TxnRequest treq = this.putTxn(key, value, true, lease, conditions);
        TxnResponse tr = this.kvClient.txnSync(treq, 3500L);
        if (tr.getSucceeded()) {
            if (value != null) {
                KeyValue putValue = tr.getResponses(1).getResponseRange().getKvs(0);
                this.offerUpdate(putValue, false);
                return new PutResult(true, putValue);
            }
            this.offerDelete(key, tr.getHeader().getRevision());
            return new PutResult(true, null);
        }
        RangeResponse rr = tr.getResponses(0).getResponseRange();
        KeyValue exist = rr.getKvsCount() > 0 ? this.offerUpdate(rr.getKvs(0), false) : this.offerDelete(key, tr.getHeader().getRevision());
        return new PutResult(false, exist);
    }

    public PutResult put(ByteString key, ByteString value, long modRev) {
        return this.put(key, value, 0L, RangeCache.modRevCompare(key, modRev));
    }

    public PutResult put(ByteString key, ByteString value, long leaseId, long modRev) {
        return this.put(key, value, leaseId, RangeCache.modRevCompare(key, modRev));
    }

    public long putNoGet(ByteString key, ByteString value, long lease, CompareOrBuilder ... conditions) {
        TxnRequest treq = this.putTxn(key, value, false, lease, conditions);
        TxnResponse tr = this.kvClient.txnSync(treq, 3500L);
        if (!tr.getSucceeded()) {
            return -1L;
        }
        if (value != null) {
            KeyValue kv = tr.getResponses(1).getResponseRange().getKvs(0);
            this.offerUpdate(kv, false);
            return kv.getModRevision();
        }
        this.offerDelete(key, tr.getHeader().getRevision());
        return 0L;
    }

    public long putNoGet(ByteString key, ByteString value, long modRev) {
        return this.putNoGet(key, value, 0L, RangeCache.modRevCompare(key, modRev));
    }

    public long putNoGet(ByteString key, ByteString value, long leaseId, long modRev) {
        return this.putNoGet(key, value, leaseId, RangeCache.modRevCompare(key, modRev));
    }

    protected static Compare.Builder modRevCompare(ByteString key, long modRev) {
        return Compare.newBuilder().setKey(key).setTarget(Compare.CompareTarget.MOD).setResult(Compare.CompareResult.EQUAL).setModRevision(modRev);
    }

    protected TxnRequest putTxn(ByteString key, ByteString value, boolean getOnFail, long lease, CompareOrBuilder ... conditions) {
        RequestOp getOp;
        TxnRequest.Builder tb = TxnRequest.newBuilder();
        if (conditions != null && conditions.length > 0) {
            for (CompareOrBuilder comp : conditions) {
                if (comp instanceof Compare) {
                    tb.addCompare((Compare)comp);
                    continue;
                }
                tb.addCompare((Compare.Builder)comp);
            }
        } else {
            getOnFail = false;
        }
        RequestOp.Builder bld = RequestOp.newBuilder();
        RequestOp requestOp = getOp = getOnFail || value != null ? RangeCache.getReq(bld, key) : null;
        if (value != null) {
            tb.addSuccess(RangeCache.putReq(bld, key, value, lease)).addSuccess(getOp);
        } else {
            tb.addSuccess(RangeCache.deleteReq(bld, key));
        }
        if (getOnFail) {
            tb.addFailure(getOp);
        }
        return tb.build();
    }

    private static RequestOp getReq(RequestOp.Builder bld, ByteString key) {
        return bld.setRequestRange(RangeRequest.newBuilder().setKey(key)).build();
    }

    private static RequestOp putReq(RequestOp.Builder bld, ByteString key, ByteString value, long lease) {
        return bld.setRequestPut(PutRequest.newBuilder().setKey(key).setValue(value).setLease(lease)).build();
    }

    private static RequestOp deleteReq(RequestOp.Builder bld, ByteString key) {
        return bld.setRequestDeleteRange(DeleteRangeRequest.newBuilder().setKey(key)).build();
    }

    public boolean delete(ByteString key) {
        DeleteRangeResponse drr = (DeleteRangeResponse)((KvClient.FluentDeleteRequest)this.kvClient.delete(key).timeout(3500L)).sync();
        this.offerDelete(key, drr.getHeader().getRevision());
        return drr.getDeleted() > 0L;
    }

    public boolean delete(ByteString key, long modRev) {
        return this.putNoGet(key, null, modRev) != -1L;
    }

    public Set<ByteString> keySet() {
        return this.entries.keySet();
    }

    @Override
    public Iterator<KeyValue> iterator() {
        return Iterators.filter(this.entries.values().iterator(), kv -> !RangeCache.isDeleted(kv));
    }

    @Override
    public void forEach(Consumer<? super KeyValue> action) {
        this.entries.values().forEach((? super T kv) -> {
            if (!RangeCache.isDeleted(kv)) {
                action.accept((KeyValue)kv);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<KeyValue> strongIterator() {
        TxnResponse txnResp;
        long seenUpTo = this.seenUpToRev.get();
        if (seenUpTo == 0L) {
            ListenableFuture<Boolean> startFut;
            RangeCache rangeCache = this;
            synchronized (rangeCache) {
                startFut = this.startFuture;
            }
            if (startFut == null) {
                return ((RangeResponse)((KvClient.FluentRangeRequest)this.kvClient.get(this.fromKey).rangeEnd(this.toKey).timeout(120000L)).sync()).getKvsList().iterator();
            }
            try {
                startFut.get(2L, TimeUnit.MINUTES);
                seenUpTo = this.seenUpToRev.get();
            }
            catch (TimeoutException te) {
                throw Status.DEADLINE_EXCEEDED.asRuntimeException();
            }
            catch (ExecutionException e) {
                throw Status.UNKNOWN.withCause(e).asRuntimeException();
            }
            catch (InterruptedException | CancellationException e) {
                throw Status.CANCELLED.withCause(e).asRuntimeException();
            }
        }
        RangeRequest.Builder rangeReqBld = RangeRequest.newBuilder().setKey(this.fromKey).setRangeEnd(this.toKey);
        RangeRequest curCountReq = rangeReqBld.setCountOnly(true).setMaxCreateRevision(seenUpTo).build();
        RangeRequest seenCountReq = rangeReqBld.clearMaxCreateRevision().setRevision(seenUpTo).build();
        RangeRequest newModsReq = rangeReqBld.clearRevision().clearCountOnly().setMinModRevision(seenUpTo + 1L).build();
        try {
            txnResp = (TxnResponse)((KvClient.FluentTxnOps)this.kvClient.batch().get(newModsReq).get(curCountReq).get(seenCountReq).timeout(8000L)).sync();
        }
        catch (RuntimeException e) {
            Status.Code code = Status.fromThrowable(e).getCode();
            if (code != Status.Code.OUT_OF_RANGE) {
                throw e;
            }
            RangeRequest otherKeysReq = rangeReqBld.clearMinModRevision().setMaxModRevision(seenUpTo).setKeysOnly(true).build();
            txnResp = (TxnResponse)((KvClient.FluentTxnOps)this.kvClient.batch().get(newModsReq).get(otherKeysReq).timeout(60000L)).sync();
        }
        long revNow = txnResp.getHeader().getRevision();
        if (revNow > this.seenUpToRev.get()) {
            boolean newKvs;
            List<KeyValue> otherKeys;
            RangeResponse newModKvs = txnResp.getResponses(0).getResponseRange();
            if (txnResp.getResponsesCount() == 2) {
                otherKeys = txnResp.getResponses(1).getResponseRange().getKvsList();
            } else if (txnResp.getResponses(1).getResponseRange().getCount() < txnResp.getResponses(2).getResponseRange().getCount()) {
                RangeRequest otherKeysReq = rangeReqBld.clearMinModRevision().setMaxModRevision(seenUpTo).setKeysOnly(true).build();
                otherKeys = GrpcClient.waitFor(this.kvClient.get(otherKeysReq), 60000L).getKvsList();
            } else {
                otherKeys = null;
            }
            boolean bl = newKvs = newModKvs.getKvsCount() > 0;
            if (otherKeys != null) {
                if (otherKeys.isEmpty() && !newKvs) {
                    return Collections.emptyIterator();
                }
                Set keys = Stream.concat(otherKeys.stream(), newModKvs.getKvsList().stream()).map(kv -> kv.getKey()).collect(Collectors.toSet());
                this.entries.values().stream().filter(kv -> kv.getModRevision() < revNow && !keys.contains(kv.getKey())).forEach((? super T kv) -> this.offerDelete(kv.getKey(), revNow));
            }
            if (newKvs) {
                newModKvs.getKvsList().forEach((? super T kv) -> this.offerUpdate((KeyValue)kv, false));
            }
            if (revNow > this.seenUpToRev.get()) {
                this.listenerExecutor.execute(() -> this.revisionUpdate(revNow));
            }
        }
        return this.iterator();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.startFuture != null) {
            if (this.watch != null) {
                this.watch.close();
            } else {
                this.startFuture.addListener(() -> {
                    RangeCache rangeCache = this;
                    synchronized (rangeCache) {
                        if (this.watch != null) {
                            this.watch.close();
                        }
                    }
                }, MoreExecutors.directExecutor());
            }
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    static class SettableFuture<V>
    extends AbstractFuture<V> {
        SettableFuture() {
        }

        @Override
        public boolean set(@Nullable V value) {
            return super.set(value);
        }

        @Override
        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        @Override
        public boolean setFuture(ListenableFuture<? extends V> future) {
            return super.setFuture(future);
        }
    }

    public static class PutResult {
        private final boolean succ;
        private final KeyValue kv;

        public PutResult(boolean success, KeyValue kv) {
            this.succ = success;
            this.kv = kv;
        }

        public boolean succ() {
            return this.succ;
        }

        public KeyValue kv() {
            return this.kv;
        }

        public KeyValue existingOrNull() {
            return this.succ ? null : this.kv;
        }

        public String toString() {
            return "PutResult[succ=" + this.succ + ", kv=" + this.kv + "]";
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void event(EventType var1, KeyValue var2);

        public static enum EventType {
            UPDATED,
            DELETED,
            INITIALIZED;

        }
    }
}

