/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client.utils;

import com.google.protobuf.ByteString;
import com.ibm.etcd.api.KeyValue;
import com.ibm.etcd.client.EtcdClient;
import com.ibm.etcd.client.KeyUtils;
import com.ibm.etcd.client.utils.PersistentLeaseKey;
import com.ibm.etcd.client.utils.RangeCache;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdLeaderElection
implements AutoCloseable {
    protected static final Logger logger = LoggerFactory.getLogger(EtcdLeaderElection.class);
    protected final ByteString bytesPrefix;
    protected final int prefixLen;
    protected final String id;
    protected final RangeCache candidates;
    protected final PersistentLeaseKey ourCandidate;
    protected final List<ElectionListener> listeners = new CopyOnWriteArrayList<ElectionListener>();
    protected volatile String leaderId;
    protected volatile boolean leader;
    protected boolean initialized;

    public EtcdLeaderElection(EtcdClient client, ByteString prefix) {
        this(client, prefix, null);
    }

    public EtcdLeaderElection(EtcdClient client, ByteString prefix, String candidateId) {
        if (candidateId != null && candidateId.contains("\\n")) {
            throw new IllegalArgumentException("id can't contain linebreak");
        }
        this.bytesPrefix = prefix;
        this.prefixLen = this.bytesPrefix.size();
        this.id = candidateId;
        this.candidates = new RangeCache(client, prefix, true);
        this.candidates.addListener((RangeCache.Listener.EventType event, KeyValue kv) -> {
            if (!this.initialized) {
                if (event != RangeCache.Listener.EventType.INITIALIZED) {
                    return;
                }
                this.initialized = true;
            }
            this.updateLeader();
        });
        this.ourCandidate = this.id == null ? null : new PersistentLeaseKey(client, this.cacheKey(this.id), KeyUtils.bs(this.id), this.candidates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLeader() {
        RangeCache rangeCache = this.candidates;
        synchronized (rangeCache) {
            boolean isUs;
            if (this.candidates.isClosed()) {
                return;
            }
            KeyValue chosen = null;
            for (KeyValue kv : this.candidates) {
                if (chosen != null && kv.getCreateRevision() >= chosen.getCreateRevision()) continue;
                chosen = kv;
            }
            String chosenId = chosen == null ? null : EtcdLeaderElection.candId(chosen);
            String priorLeaderId = this.leaderId;
            this.leaderId = chosenId;
            if (this.id == null) {
                return;
            }
            boolean wasUs = this.id.equals(priorLeaderId);
            if (wasUs ^ (isUs = this.id.equals(chosenId))) {
                this.leader = isUs;
                this.notifyListeners(isUs);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLeaderId() {
        return this.leaderId;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public void addListener(ElectionListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(ElectionListener listener) {
        return this.listeners.remove(listener);
    }

    protected void notifyListeners(boolean isLeader) {
        for (ElectionListener l : this.listeners) {
            try {
                l.leadershipChange(isLeader);
            }
            catch (Exception e) {
                logger.warn("ElectionListener threw exception", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        RangeCache rangeCache = this.candidates;
        synchronized (rangeCache) {
            this.candidates.start();
            if (this.ourCandidate != null) {
                this.ourCandidate.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        RangeCache rangeCache = this.candidates;
        synchronized (rangeCache) {
            if (this.ourCandidate != null) {
                this.ourCandidate.close();
            }
            this.candidates.close();
            this.leader = false;
            this.leaderId = null;
        }
    }

    protected ByteString cacheKey(String str) {
        return str == null ? null : this.bytesPrefix.concat(KeyUtils.bs(str));
    }

    protected static String candId(KeyValue kv) {
        String str = kv.getValue().toStringUtf8();
        int nl = str.indexOf(10);
        return nl == -1 ? str : str.substring(0, nl);
    }

    public static interface ElectionListener {
        public void leadershipChange(boolean var1);
    }
}

