/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client;

import com.ibm.etcd.client.EtcdClient;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.DnsNameResolverProvider;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class StaticEtcdNameResolverFactory
extends NameResolver.Factory {
    public static final String ETCD = "etcd";
    protected static final NameResolver.Factory DNS_PROVIDER = new DnsNameResolverProvider();
    private final URI[] uris;
    private final String overrideAuthority;

    public StaticEtcdNameResolverFactory(List<String> endpoints) {
        this(endpoints, null);
    }

    public StaticEtcdNameResolverFactory(List<String> endpoints, String overrideAuthority) {
        if (endpoints == null || endpoints.isEmpty()) {
            throw new IllegalArgumentException("endpoints");
        }
        this.overrideAuthority = overrideAuthority;
        this.uris = (URI[])endpoints.stream().map(ep -> URI.create(EtcdClient.endpointToUriString(ep))).toArray(URI[]::new);
        if (this.uris.length > 1) {
            Collections.shuffle(Arrays.asList(this.uris));
        }
    }

    @Override
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (!ETCD.equals(targetUri.getScheme())) {
            return null;
        }
        if (this.uris.length == 1) {
            return new SubResolver((URI)this.uris[0], (NameResolver.Args)args).resolver;
        }
        final SubResolver[] resolvers = this.createSubResolvers(args);
        return new NameResolver(){
            int currentCount = 0;

            @Override
            public void start(final NameResolver.Listener listener) {
                for (final SubResolver sr : resolvers) {
                    sr.resolver.start(new NameResolver.Listener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onAddresses(List<EquivalentAddressGroup> servers, Attributes attributes) {
                            SubResolver[] subResolverArray = resolvers;
                            synchronized (resolvers) {
                                sr.updateEagList(servers, StaticEtcdNameResolverFactory.this.overrideAuthority == null);
                                List<EquivalentAddressGroup> newList = Stream.of(resolvers).flatMap(r -> r.eagList.stream()).collect(Collectors.toList());
                                currentCount = newList.size();
                                listener.onAddresses(newList, Attributes.EMPTY);
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                return;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onError(Status error) {
                            SubResolver[] subResolverArray = resolvers;
                            synchronized (resolvers) {
                                if (currentCount == 0) {
                                    listener.onError(error);
                                }
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return;
                            }
                        }
                    });
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void refresh() {
                SubResolver[] subResolverArray = resolvers;
                synchronized (resolvers) {
                    for (SubResolver sr : resolvers) {
                        sr.resolver.refresh();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }

            @Override
            public String getServiceAuthority() {
                return StaticEtcdNameResolverFactory.this.overrideAuthority != null ? StaticEtcdNameResolverFactory.this.overrideAuthority : StaticEtcdNameResolverFactory.ETCD;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shutdown() {
                SubResolver[] subResolverArray = resolvers;
                synchronized (resolvers) {
                    for (SubResolver sr : resolvers) {
                        sr.resolver.shutdown();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
    }

    private SubResolver[] createSubResolvers(NameResolver.Args args) {
        int count = this.uris.length;
        SubResolver[] resolvers = new SubResolver[count];
        for (int i = 0; i < count; ++i) {
            resolvers[i] = new SubResolver(this.uris[i], args);
        }
        return resolvers;
    }

    @Override
    public String getDefaultScheme() {
        return ETCD;
    }

    static class SubResolver {
        final NameResolver resolver;
        List<EquivalentAddressGroup> eagList = Collections.emptyList();

        public SubResolver(URI uri, NameResolver.Args args) {
            this.resolver = DNS_PROVIDER.newNameResolver(uri, args);
        }

        void updateEagList(List<EquivalentAddressGroup> servers, boolean ownAuthority) {
            if (ownAuthority) {
                String authority = this.resolver.getServiceAuthority();
                this.eagList = servers.stream().map(eag -> new EquivalentAddressGroup(eag.getAddresses(), eag.getAttributes().toBuilder().set(EquivalentAddressGroup.ATTR_AUTHORITY_OVERRIDE, authority).build())).collect(Collectors.toList());
            } else {
                this.eagList = servers;
            }
        }
    }
}

