/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.lang.Console;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HTMLFilter {
    private static final int REGEX_FLAGS_SI = 34;
    private static final Pattern P_COMMENTS = Pattern.compile("<!--(.*?)-->", 32);
    private static final Pattern P_COMMENT = Pattern.compile("^!--(.*)--$", 34);
    private static final Pattern P_TAGS = Pattern.compile("<(.*?)>", 32);
    private static final Pattern P_END_TAG = Pattern.compile("^/([a-z0-9]+)", 34);
    private static final Pattern P_START_TAG = Pattern.compile("^([a-z0-9]+)(.*?)(/?)$", 34);
    private static final Pattern P_QUOTED_ATTRIBUTES = Pattern.compile("([a-z0-9]+)=([\"'])(.*?)\\2", 34);
    private static final Pattern P_UNQUOTED_ATTRIBUTES = Pattern.compile("([a-z0-9]+)(=)([^\"\\s']+)", 34);
    private static final Pattern P_PROTOCOL = Pattern.compile("^([^:]+):", 34);
    private static final Pattern P_ENTITY = Pattern.compile("&#(\\d+);?");
    private static final Pattern P_ENTITY_UNICODE = Pattern.compile("&#x([0-9a-f]+);?");
    private static final Pattern P_ENCODE = Pattern.compile("%([0-9a-f]{2});?");
    private static final Pattern P_VALID_ENTITIES = Pattern.compile("&([^&;]*)(?=(;|&|$))");
    private static final Pattern P_VALID_QUOTES = Pattern.compile("(>|^)([^<]+?)(<|$)", 32);
    private static final Pattern P_END_ARROW = Pattern.compile("^>");
    private static final Pattern P_BODY_TO_END = Pattern.compile("<([^>]*?)(?=<|$)");
    private static final Pattern P_XML_CONTENT = Pattern.compile("(^|>)([^<]*?)(?=>)");
    private static final Pattern P_STRAY_LEFT_ARROW = Pattern.compile("<([^>]*?)(?=<|$)");
    private static final Pattern P_STRAY_RIGHT_ARROW = Pattern.compile("(^|>)([^<]*?)(?=>)");
    private static final Pattern P_AMP = Pattern.compile("&");
    private static final Pattern P_QUOTE = Pattern.compile("\"");
    private static final Pattern P_LEFT_ARROW = Pattern.compile("<");
    private static final Pattern P_RIGHT_ARROW = Pattern.compile(">");
    private static final Pattern P_BOTH_ARROWS = Pattern.compile("<>");
    private static final ConcurrentMap<String, Pattern> P_REMOVE_PAIR_BLANKS = new ConcurrentHashMap<String, Pattern>();
    private static final ConcurrentMap<String, Pattern> P_REMOVE_SELF_BLANKS = new ConcurrentHashMap<String, Pattern>();
    private final Map<String, List<String>> vAllowed;
    private final Map<String, Integer> vTagCounts = new HashMap<String, Integer>();
    private final String[] vSelfClosingTags;
    private final String[] vNeedClosingTags;
    private final String[] vDisallowed;
    private final String[] vProtocolAtts;
    private final String[] vAllowedProtocols;
    private final String[] vRemoveBlanks;
    private final String[] vAllowedEntities;
    private final boolean stripComment;
    private final boolean encodeQuotes;
    private boolean vDebug = false;
    private final boolean alwaysMakeTags;

    public HTMLFilter() {
        this.vAllowed = new HashMap<String, List<String>>();
        ArrayList<String> a_atts = new ArrayList<String>();
        a_atts.add("href");
        a_atts.add("target");
        this.vAllowed.put("a", a_atts);
        ArrayList<String> img_atts = new ArrayList<String>();
        img_atts.add("src");
        img_atts.add("width");
        img_atts.add("height");
        img_atts.add("alt");
        this.vAllowed.put("img", img_atts);
        ArrayList no_atts = new ArrayList();
        this.vAllowed.put("b", no_atts);
        this.vAllowed.put("strong", no_atts);
        this.vAllowed.put("i", no_atts);
        this.vAllowed.put("em", no_atts);
        this.vSelfClosingTags = new String[]{"img"};
        this.vNeedClosingTags = new String[]{"a", "b", "strong", "i", "em"};
        this.vDisallowed = new String[0];
        this.vAllowedProtocols = new String[]{"http", "mailto", "https"};
        this.vProtocolAtts = new String[]{"src", "href"};
        this.vRemoveBlanks = new String[]{"a", "b", "strong", "i", "em"};
        this.vAllowedEntities = new String[]{"amp", "gt", "lt", "quot"};
        this.stripComment = true;
        this.encodeQuotes = true;
        this.alwaysMakeTags = true;
    }

    public HTMLFilter(boolean debug) {
        this();
        this.vDebug = debug;
    }

    public HTMLFilter(Map<String, Object> conf) {
        assert (conf.containsKey("vAllowed")) : "configuration requires vAllowed";
        assert (conf.containsKey("vSelfClosingTags")) : "configuration requires vSelfClosingTags";
        assert (conf.containsKey("vNeedClosingTags")) : "configuration requires vNeedClosingTags";
        assert (conf.containsKey("vDisallowed")) : "configuration requires vDisallowed";
        assert (conf.containsKey("vAllowedProtocols")) : "configuration requires vAllowedProtocols";
        assert (conf.containsKey("vProtocolAtts")) : "configuration requires vProtocolAtts";
        assert (conf.containsKey("vRemoveBlanks")) : "configuration requires vRemoveBlanks";
        assert (conf.containsKey("vAllowedEntities")) : "configuration requires vAllowedEntities";
        this.vAllowed = Collections.unmodifiableMap((HashMap)conf.get("vAllowed"));
        this.vSelfClosingTags = (String[])conf.get("vSelfClosingTags");
        this.vNeedClosingTags = (String[])conf.get("vNeedClosingTags");
        this.vDisallowed = (String[])conf.get("vDisallowed");
        this.vAllowedProtocols = (String[])conf.get("vAllowedProtocols");
        this.vProtocolAtts = (String[])conf.get("vProtocolAtts");
        this.vRemoveBlanks = (String[])conf.get("vRemoveBlanks");
        this.vAllowedEntities = (String[])conf.get("vAllowedEntities");
        this.stripComment = conf.containsKey("stripComment") ? (Boolean)conf.get("stripComment") : true;
        this.encodeQuotes = conf.containsKey("encodeQuotes") ? (Boolean)conf.get("encodeQuotes") : true;
        this.alwaysMakeTags = conf.containsKey("alwaysMakeTags") ? (Boolean)conf.get("alwaysMakeTags") : true;
    }

    private void reset() {
        this.vTagCounts.clear();
    }

    private void debug(String msg) {
        if (this.vDebug) {
            Console.log(msg);
        }
    }

    public static String chr(int decimal) {
        return String.valueOf((char)decimal);
    }

    public static String htmlSpecialChars(String s2) {
        String result = s2;
        result = HTMLFilter.regexReplace(P_AMP, "&amp;", result);
        result = HTMLFilter.regexReplace(P_QUOTE, "&quot;", result);
        result = HTMLFilter.regexReplace(P_LEFT_ARROW, "&lt;", result);
        result = HTMLFilter.regexReplace(P_RIGHT_ARROW, "&gt;", result);
        return result;
    }

    public String filter(String input) {
        this.reset();
        String s2 = input;
        this.debug("************************************************");
        this.debug("              INPUT: " + input);
        s2 = this.escapeComments(s2);
        this.debug("     escapeComments: " + s2);
        s2 = this.balanceHTML(s2);
        this.debug("        balanceHTML: " + s2);
        s2 = this.checkTags(s2);
        this.debug("          checkTags: " + s2);
        s2 = this.processRemoveBlanks(s2);
        this.debug("processRemoveBlanks: " + s2);
        s2 = this.validateEntities(s2);
        this.debug("    validateEntites: " + s2);
        this.debug("************************************************\n\n");
        return s2;
    }

    public boolean isAlwaysMakeTags() {
        return this.alwaysMakeTags;
    }

    public boolean isStripComments() {
        return this.stripComment;
    }

    private String escapeComments(String s2) {
        Matcher m3 = P_COMMENTS.matcher(s2);
        StringBuffer buf = new StringBuffer();
        if (m3.find()) {
            String match = m3.group(1);
            m3.appendReplacement(buf, Matcher.quoteReplacement("<!--" + HTMLFilter.htmlSpecialChars(match) + "-->"));
        }
        m3.appendTail(buf);
        return buf.toString();
    }

    private String balanceHTML(String s2) {
        if (this.alwaysMakeTags) {
            s2 = HTMLFilter.regexReplace(P_END_ARROW, "", s2);
            s2 = HTMLFilter.regexReplace(P_BODY_TO_END, "<$1>", s2);
            s2 = HTMLFilter.regexReplace(P_XML_CONTENT, "$1<$2", s2);
        } else {
            s2 = HTMLFilter.regexReplace(P_STRAY_LEFT_ARROW, "&lt;$1", s2);
            s2 = HTMLFilter.regexReplace(P_STRAY_RIGHT_ARROW, "$1$2&gt;<", s2);
            s2 = HTMLFilter.regexReplace(P_BOTH_ARROWS, "", s2);
        }
        return s2;
    }

    private String checkTags(String s2) {
        Matcher m3 = P_TAGS.matcher(s2);
        StringBuffer buf = new StringBuffer();
        while (m3.find()) {
            String replaceStr = m3.group(1);
            replaceStr = this.processTag(replaceStr);
            m3.appendReplacement(buf, Matcher.quoteReplacement(replaceStr));
        }
        m3.appendTail(buf);
        StringBuilder sBuilder = new StringBuilder(buf.toString());
        for (String key : this.vTagCounts.keySet()) {
            for (int ii = 0; ii < this.vTagCounts.get(key); ++ii) {
                sBuilder.append("</").append(key).append(">");
            }
        }
        s2 = sBuilder.toString();
        return s2;
    }

    private String processRemoveBlanks(String s2) {
        String result = s2;
        for (String tag : this.vRemoveBlanks) {
            if (!P_REMOVE_PAIR_BLANKS.containsKey(tag)) {
                P_REMOVE_PAIR_BLANKS.putIfAbsent(tag, Pattern.compile("<" + tag + "(\\s[^>]*)?></" + tag + ">"));
            }
            result = HTMLFilter.regexReplace((Pattern)P_REMOVE_PAIR_BLANKS.get(tag), "", result);
            if (!P_REMOVE_SELF_BLANKS.containsKey(tag)) {
                P_REMOVE_SELF_BLANKS.putIfAbsent(tag, Pattern.compile("<" + tag + "(\\s[^>]*)?/>"));
            }
            result = HTMLFilter.regexReplace((Pattern)P_REMOVE_SELF_BLANKS.get(tag), "", result);
        }
        return result;
    }

    private static String regexReplace(Pattern regex_pattern, String replacement, String s2) {
        Matcher m3 = regex_pattern.matcher(s2);
        return m3.replaceAll(replacement);
    }

    private String processTag(String s2) {
        String name;
        Matcher m3 = P_END_TAG.matcher(s2);
        if (m3.find() && this.allowed(name = m3.group(1).toLowerCase()) && !HTMLFilter.inArray(name, this.vSelfClosingTags) && this.vTagCounts.containsKey(name)) {
            this.vTagCounts.put(name, this.vTagCounts.get(name) - 1);
            return "</" + name + ">";
        }
        m3 = P_START_TAG.matcher(s2);
        if (m3.find()) {
            name = m3.group(1).toLowerCase();
            String body = m3.group(2);
            String ending = m3.group(3);
            if (this.allowed(name)) {
                StringBuilder params = new StringBuilder();
                Matcher m22 = P_QUOTED_ATTRIBUTES.matcher(body);
                Matcher m32 = P_UNQUOTED_ATTRIBUTES.matcher(body);
                ArrayList<String> paramNames = new ArrayList<String>();
                ArrayList<String> paramValues = new ArrayList<String>();
                while (m22.find()) {
                    paramNames.add(m22.group(1));
                    paramValues.add(m22.group(3));
                }
                while (m32.find()) {
                    paramNames.add(m32.group(1));
                    paramValues.add(m32.group(3));
                }
                for (int ii = 0; ii < paramNames.size(); ++ii) {
                    String paramName = ((String)paramNames.get(ii)).toLowerCase();
                    String paramValue = (String)paramValues.get(ii);
                    if (!this.allowedAttribute(name, paramName)) continue;
                    if (HTMLFilter.inArray(paramName, this.vProtocolAtts)) {
                        paramValue = this.processParamProtocol(paramValue);
                    }
                    params.append(' ').append(paramName).append("=\"").append(paramValue).append("\"");
                }
                if (HTMLFilter.inArray(name, this.vSelfClosingTags)) {
                    ending = " /";
                }
                if (HTMLFilter.inArray(name, this.vNeedClosingTags)) {
                    ending = "";
                }
                if (ending == null || ending.length() < 1) {
                    if (this.vTagCounts.containsKey(name)) {
                        this.vTagCounts.put(name, this.vTagCounts.get(name) + 1);
                    } else {
                        this.vTagCounts.put(name, 1);
                    }
                } else {
                    ending = " /";
                }
                return "<" + name + params + ending + ">";
            }
            return "";
        }
        m3 = P_COMMENT.matcher(s2);
        if (!this.stripComment && m3.find()) {
            return "<" + m3.group() + ">";
        }
        return "";
    }

    private String processParamProtocol(String s2) {
        String protocol;
        Matcher m3 = P_PROTOCOL.matcher(s2 = this.decodeEntities(s2));
        if (m3.find() && !HTMLFilter.inArray(protocol = m3.group(1), this.vAllowedProtocols) && (s2 = "#" + s2.substring(protocol.length() + 1)).startsWith("#//")) {
            s2 = "#" + s2.substring(3);
        }
        return s2;
    }

    private String decodeEntities(String s2) {
        int decimal;
        String match;
        StringBuffer buf = new StringBuffer();
        Matcher m3 = P_ENTITY.matcher(s2);
        while (m3.find()) {
            match = m3.group(1);
            decimal = Integer.decode(match);
            m3.appendReplacement(buf, Matcher.quoteReplacement(HTMLFilter.chr(decimal)));
        }
        m3.appendTail(buf);
        s2 = buf.toString();
        buf = new StringBuffer();
        m3 = P_ENTITY_UNICODE.matcher(s2);
        while (m3.find()) {
            match = m3.group(1);
            decimal = Integer.valueOf(match, 16);
            m3.appendReplacement(buf, Matcher.quoteReplacement(HTMLFilter.chr(decimal)));
        }
        m3.appendTail(buf);
        s2 = buf.toString();
        buf = new StringBuffer();
        m3 = P_ENCODE.matcher(s2);
        while (m3.find()) {
            match = m3.group(1);
            decimal = Integer.valueOf(match, 16);
            m3.appendReplacement(buf, Matcher.quoteReplacement(HTMLFilter.chr(decimal)));
        }
        m3.appendTail(buf);
        s2 = buf.toString();
        s2 = this.validateEntities(s2);
        return s2;
    }

    private String validateEntities(String s2) {
        StringBuffer buf = new StringBuffer();
        Matcher m3 = P_VALID_ENTITIES.matcher(s2);
        while (m3.find()) {
            String one = m3.group(1);
            String two = m3.group(2);
            m3.appendReplacement(buf, Matcher.quoteReplacement(this.checkEntity(one, two)));
        }
        m3.appendTail(buf);
        return this.encodeQuotes(buf.toString());
    }

    private String encodeQuotes(String s2) {
        if (this.encodeQuotes) {
            StringBuffer buf = new StringBuffer();
            Matcher m3 = P_VALID_QUOTES.matcher(s2);
            while (m3.find()) {
                String one = m3.group(1);
                String two = m3.group(2);
                String three = m3.group(3);
                m3.appendReplacement(buf, Matcher.quoteReplacement(one + HTMLFilter.regexReplace(P_QUOTE, "&quot;", two) + three));
            }
            m3.appendTail(buf);
            return buf.toString();
        }
        return s2;
    }

    private String checkEntity(String preamble, String term) {
        return ";".equals(term) && this.isValidEntity(preamble) ? '&' + preamble : "&amp;" + preamble;
    }

    private boolean isValidEntity(String entity) {
        return HTMLFilter.inArray(entity, this.vAllowedEntities);
    }

    private static boolean inArray(String s2, String[] array) {
        for (String item : array) {
            if (item == null || !item.equals(s2)) continue;
            return true;
        }
        return false;
    }

    private boolean allowed(String name) {
        return (this.vAllowed.isEmpty() || this.vAllowed.containsKey(name)) && !HTMLFilter.inArray(name, this.vDisallowed);
    }

    private boolean allowedAttribute(String name, String paramName) {
        return this.allowed(name) && (this.vAllowed.isEmpty() || this.vAllowed.get(name).contains(paramName));
    }
}

