/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;

public class TextSimilarity {
    public static double similar(String strA, String strB) {
        String newStrB;
        String newStrA;
        if (strA.length() < strB.length()) {
            newStrA = TextSimilarity.removeSign(strB);
            newStrB = TextSimilarity.removeSign(strA);
        } else {
            newStrA = TextSimilarity.removeSign(strA);
            newStrB = TextSimilarity.removeSign(strB);
        }
        int temp = Math.max(newStrA.length(), newStrB.length());
        if (0 == temp) {
            return 1.0;
        }
        int temp2 = TextSimilarity.longestCommonSubstring(newStrA, newStrB).length();
        return NumberUtil.div((float)temp2, (float)temp);
    }

    public static String similar(String strA, String strB, int scale) {
        return NumberUtil.formatPercent(TextSimilarity.similar(strA, strB), scale);
    }

    private static String removeSign(String str) {
        int length = str.length();
        StringBuilder sb = StrUtil.builder(length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (TextSimilarity.isInvalidChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isInvalidChar(char charValue) {
        return charValue >= '\u4e00' && charValue <= '\u0fff' || charValue >= 'a' && charValue <= 'z' || charValue >= 'A' && charValue <= 'Z' || charValue >= '0' && charValue <= '9';
    }

    private static String longestCommonSubstring(String strA, String strB) {
        char[] chars_strA = strA.toCharArray();
        char[] chars_strB = strB.toCharArray();
        int m3 = chars_strA.length;
        int n = chars_strB.length;
        int[][] matrix = new int[m3 + 1][n + 1];
        for (int i = 1; i <= m3; ++i) {
            for (int j = 1; j <= n; ++j) {
                matrix[i][j] = chars_strA[i - 1] == chars_strB[j - 1] ? matrix[i - 1][j - 1] + 1 : Math.max(matrix[i][j - 1], matrix[i - 1][j]);
            }
        }
        char[] result = new char[matrix[m3][n]];
        int currentIndex = result.length - 1;
        while (matrix[m3][n] != 0) {
            if (matrix[m3][n] == matrix[m3][n - 1]) {
                --n;
                continue;
            }
            if (matrix[m3][n] == matrix[m3 - 1][n]) {
                --m3;
                continue;
            }
            result[currentIndex] = chars_strA[m3 - 1];
            --currentIndex;
            --n;
            --m3;
        }
        return new String(result);
    }
}

