/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<K> keys;
    private List<V> values;

    public TableMap(int size) {
        this.keys = new ArrayList<K>(size);
        this.values = new ArrayList<V>(size);
    }

    public TableMap(K[] keys, V[] values) {
        this.keys = CollUtil.toList(keys);
        this.values = CollUtil.toList(values);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return ArrayUtil.isEmpty(this.keys);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public V get(Object key) {
        int index = this.keys.indexOf(key);
        if (index > -1 && index < this.values.size()) {
            return this.values.get(index);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        this.keys.add(key);
        this.values.add(value);
        return null;
    }

    @Override
    public V remove(Object key) {
        int index = this.keys.indexOf(key);
        if (index > -1) {
            this.keys.remove(index);
            if (index < this.values.size()) {
                this.values.remove(index);
            }
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m3) {
        for (Map.Entry<K, V> entry : m3.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public Set<K> keySet() {
        return new HashSet<K>(this.keys);
    }

    @Override
    public Collection<V> values() {
        return new HashSet<V>(this.values);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> hashSet = new HashSet<Map.Entry<K, V>>();
        for (int i = 0; i < this.size(); ++i) {
            hashSet.add(new Entry<K, V>(this.keys.get(i), this.values.get(i)));
        }
        return hashSet;
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("setValue not supported.");
        }
    }
}

