/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.img.ImgUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class GraphicsUtil {
    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        Graphics2D g2 = image.createGraphics();
        if (null != color) {
            g2.setColor(color);
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        return g2;
    }

    public static int getCenterY(Graphics g2, int backgroundHeight) {
        FontMetrics metrics = null;
        try {
            metrics = g2.getFontMetrics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int y = null != metrics ? (backgroundHeight - metrics.getHeight()) / 2 + metrics.getAscent() : backgroundHeight / 3;
        return y;
    }

    public static Graphics drawStringColourful(Graphics g2, String str, Font font, int width, int height) {
        return GraphicsUtil.drawString(g2, str, font, null, width, height);
    }

    public static Graphics drawString(Graphics g2, String str, Font font, Color color, int width, int height) {
        if (g2 instanceof Graphics2D) {
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.setFont(font);
        int midY = GraphicsUtil.getCenterY(g2, height);
        if (null != color) {
            g2.setColor(color);
        }
        int len = str.length();
        int charWidth = width / len;
        for (int i = 0; i < len; ++i) {
            if (null == color) {
                g2.setColor(ImgUtil.randomColor());
            }
            g2.drawString(String.valueOf(str.charAt(i)), i * charWidth, midY);
        }
        return g2;
    }
}

