/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert;

import cn.hutool.core.util.StrUtil;

public class NumberWordFormater {
    private static final String[] NUMBER = new String[]{"", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"};
    private static final String[] NUMBER_TEEN = new String[]{"TEN", "ELEVEN", "TWELEVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"};
    private static final String[] NUMBER_TEN = new String[]{"TEN", "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"};
    private static final String[] NUMBER_MORE = new String[]{"", "THOUSAND", "MILLION", "BILLION"};

    public static String format(Object x) {
        if (x != null) {
            return NumberWordFormater.format(x.toString());
        }
        return "";
    }

    private static String format(String x) {
        String lstr;
        int z = x.indexOf(".");
        String rstr = "";
        if (z > -1) {
            lstr = x.substring(0, z);
            rstr = x.substring(z + 1);
        } else {
            lstr = x;
        }
        String lstrrev = StrUtil.reverse(lstr);
        String[] a = new String[5];
        switch (lstrrev.length() % 3) {
            case 1: {
                lstrrev = lstrrev + "00";
                break;
            }
            case 2: {
                lstrrev = lstrrev + "0";
            }
        }
        StringBuilder lm = new StringBuilder();
        for (int i = 0; i < lstrrev.length() / 3; ++i) {
            a[i] = StrUtil.reverse(lstrrev.substring(3 * i, 3 * i + 3));
            if (!a[i].equals("000")) {
                if (i != 0) {
                    lm.insert(0, NumberWordFormater.transThree(a[i]) + " " + NumberWordFormater.parseMore(i) + " ");
                    continue;
                }
                lm = new StringBuilder(NumberWordFormater.transThree(a[i]));
                continue;
            }
            lm.append(NumberWordFormater.transThree(a[i]));
        }
        String xs = "";
        if (z > -1) {
            xs = "AND CENTS " + NumberWordFormater.transTwo(rstr) + " ";
        }
        return lm.toString().trim() + " " + xs + "ONLY";
    }

    private static String parseFirst(String s2) {
        return NUMBER[Integer.parseInt(s2.substring(s2.length() - 1))];
    }

    private static String parseTeen(String s2) {
        return NUMBER_TEEN[Integer.parseInt(s2) - 10];
    }

    private static String parseTen(String s2) {
        return NUMBER_TEN[Integer.parseInt(s2.substring(0, 1)) - 1];
    }

    private static String parseMore(int i) {
        return NUMBER_MORE[i];
    }

    private static String transTwo(String s2) {
        if (s2.length() > 2) {
            s2 = s2.substring(0, 2);
        } else if (s2.length() < 2) {
            s2 = "0" + s2;
        }
        String value = s2.startsWith("0") ? NumberWordFormater.parseFirst(s2) : (s2.startsWith("1") ? NumberWordFormater.parseTeen(s2) : (s2.endsWith("0") ? NumberWordFormater.parseTen(s2) : NumberWordFormater.parseTen(s2) + " " + NumberWordFormater.parseFirst(s2)));
        return value;
    }

    private static String transThree(String s2) {
        String value = s2.startsWith("0") ? NumberWordFormater.transTwo(s2.substring(1)) : (s2.substring(1).equals("00") ? NumberWordFormater.parseFirst(s2.substring(0, 1)) + " HUNDRED" : NumberWordFormater.parseFirst(s2.substring(0, 1)) + " HUNDRED AND " + NumberWordFormater.transTwo(s2.substring(1)));
        return value;
    }
}

