/*!
 * bootstrap-fileinput v5.0.4
 * http://plugins.krajee.com/file-input
 *
 * Author: Kartik Visweswaran
 * Copyright: 2014 - 2019, Kartik Visweswaran, Krajee.com
 *
 * Licensed under the BSD-3-Clause
 * https://github.com/kartik-v/bootstrap-fileinput/blob/master/LICENSE.md
 */
(function(n){"use strict";typeof define=="function"&&define.amd?define(["jquery"],n):typeof module=="object"&&module.exports?module.exports=n(require("jquery")):n(window.jQuery)})(function(n){"use strict";n.fn.fileinputLocales={};n.fn.fileinputThemes={};String.prototype.setTokens=function(n){var i=this.toString(),t,r;for(t in n)n.hasOwnProperty(t)&&(r=new RegExp("{"+t+"}","g"),i=i.replace(r,n[t]));return i};var t,i;t={FRAMES:".kv-preview-thumb",SORT_CSS:"file-sortable",OBJECT_PARAMS:'<param name="controller" value="true" />\n<param name="allowFullScreen" value="true" />\n<param name="allowScriptAccess" value="always" />\n<param name="autoPlay" value="false" />\n<param name="autoStart" value="false" />\n<param name="quality" value="high" />\n',DEFAULT_PREVIEW:'<div class="file-preview-other">\n<span class="{previewFileIconClass}">{previewFileIcon}<\/span>\n<\/div>',MODAL_ID:"kvFileinputModal",MODAL_EVENTS:["show","shown","hide","hidden","loaded"],logMessages:{ajaxError:"{status}: {error}. Error Details: {text}.",badDroppedFiles:"Error scanning dropped files!",badExifParser:"Error loading the piexif.js library. {details}",badInputType:'The input "type" must be set to "file" for initializing the "bootstrap-fileinput" plugin.',exifWarning:'To avoid this warning, either set "autoOrientImage" to "false" OR ensure you have loaded the "piexif.js" library correctly on your page before the "fileinput.js" script.',invalidChunkSize:'Invalid upload chunk size: "{chunkSize}". Resumable uploads are disabled.',invalidThumb:'Invalid thumb frame with id: "{id}".',noResumableSupport:"The browser does not support resumable or chunk uploads.",noUploadUrl:'The "uploadUrl" is not set. Ajax uploads and resumable uploads have been disabled.',retryStatus:"Retrying upload for chunk # {chunk} for {filename}... retry # {retry}."},objUrl:window.URL||window.webkitURL,now:function(){return new Date},round:function(n){return n=parseFloat(n),isNaN(n)?0:Math.floor(Math.round(n))},getFileRelativePath:function(n){return String(n.relativePath||n.webkitRelativePath||t.getFileName(n)||null)},getFileId:function(n,i){var r=t.getFileRelativePath(n);return typeof i=="function"?i(n):n?r?n.size+"_"+r.replace(/\s/img,"_"):null:null},getElapsed:function(t){var f=t,i="",r={},u={year:31536e3,month:2592e3,week:604800,day:86400,hour:3600,minute:60,second:1};return Object.keys(u).forEach(function(n){r[n]=Math.floor(f/u[n]);f-=r[n]*u[n]}),n.each(r,function(n,t){t>0&&(i+=(i?" ":"")+t+n.substring(0,1))}),i},debounce:function(n,t){var i;return function(){var r=arguments,u=this;clearTimeout(i);i=setTimeout(function(){n.apply(u,r)},t)}},stopEvent:function(n){n.stopPropagation();n.preventDefault()},getFileName:function(n){return n?n.fileName||n.name||"":""},createObjectURL:function(n){return t.objUrl&&t.objUrl.createObjectURL&&n?t.objUrl.createObjectURL(n):""},revokeObjectURL:function(n){t.objUrl&&t.objUrl.revokeObjectURL&&n&&t.objUrl.revokeObjectURL(n)},compare:function(n,t,i){return n!==undefined&&(i?n===t:n.match(t))},isIE:function(n){var t,i;return navigator.appName!=="Microsoft Internet Explorer"?!1:n===10?new RegExp("msie\\s"+n,"i").test(navigator.userAgent):(t=document.createElement("div"),t.innerHTML="<!--[if IE "+n+"]> <i><\/i> <![endif]-->",i=t.getElementsByTagName("i").length,document.body.appendChild(t),t.parentNode.removeChild(t),i)},canAssignFilesToInput:function(){var n=document.createElement("input");try{return n.type="file",n.files=null,!0}catch(t){return!1}},getDragDropFolders:function(n){var t,i,r=n?n.length:0,u=0;if(r>0&&n[0].webkitGetAsEntry())for(t=0;t<r;t++)i=n[t].webkitGetAsEntry(),i&&i.isDirectory&&u++;return u},initModal:function(t){var i=n("body");i.length&&t.appendTo(i)},isEmpty:function(t,i){return t===undefined||t===null||t.length===0||i&&n.trim(t)===""},isArray:function(n){return Array.isArray(n)||Object.prototype.toString.call(n)==="[object Array]"},ifSet:function(n,t,i){return i=i||"",t&&typeof t=="object"&&n in t?t[n]:i},cleanArray:function(n){return n instanceof Array||(n=[]),n.filter(function(n){return n!==undefined&&n!==null})},spliceArray:function(t,i,r){var u,o=0,e=[],f;if(!(t instanceof Array))return[];for(f=n.extend(!0,[],t),r&&f.reverse(),u=0;u<f.length;u++)u!==i&&(e[o]=f[u],o++);return r&&e.reverse(),e},getNum:function(n,t){return(t=t||0,typeof n=="number")?n:(typeof n=="string"&&(n=parseFloat(n)),isNaN(n)?t:n)},hasFileAPISupport:function(){return!!(window.File&&window.FileReader)},hasDragDropSupport:function(){var n=document.createElement("div");return!t.isIE(9)&&(n.draggable!==undefined||n.ondragstart!==undefined&&n.ondrop!==undefined)},hasFileUploadSupport:function(){return t.hasFileAPISupport()&&window.FormData},hasBlobSupport:function(){try{return!!window.Blob&&Boolean(new Blob)}catch(n){return!1}},hasArrayBufferViewSupport:function(){try{return new Blob([new Uint8Array(100)]).size===100}catch(n){return!1}},hasResumableUploadSupport:function(){return t.hasFileUploadSupport()&&t.hasBlobSupport()&&t.hasArrayBufferViewSupport()&&(!!Blob.prototype.webkitSlice||!!Blob.prototype.mozSlice||!!Blob.prototype.slice||!1)},dataURI2Blob:function(n){var s=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder,h=t.hasBlobSupport(),r,u,f,i,e,o,c=(h||s)&&window.atob&&window.ArrayBuffer&&window.Uint8Array;if(!c)return null;for(r=n.split(",")[0].indexOf("base64")>=0?atob(n.split(",")[1]):decodeURIComponent(n.split(",")[1]),u=new ArrayBuffer(r.length),f=new Uint8Array(u),i=0;i<r.length;i+=1)f[i]=r.charCodeAt(i);return(e=n.split(",")[0].split(":")[1].split(";")[0],h)?new Blob([t.hasArrayBufferViewSupport()?f:u],{type:e}):(o=new s,o.append(u),o.getBlob(e))},arrayBuffer2String:function(n){if(window.TextDecoder)return new TextDecoder("utf-8").decode(n);for(var t=Array.prototype.slice.apply(new Uint8Array(n)),u="",i=0,r,f,o,e=t.length;i<e;){r=t[i++];switch(r>>4){case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:u+=String.fromCharCode(r);break;case 12:case 13:f=t[i++];u+=String.fromCharCode((r&31)<<6|f&63);break;case 14:f=t[i++];o=t[i++];u+=String.fromCharCode((r&15)<<12|(f&63)<<6|(o&63)<<0)}}return u},isHtml:function(n){var r=document.createElement("div"),t,i;for(r.innerHTML=n,t=r.childNodes,i=t.length;i--;)if(t[i].nodeType===1)return!0;return!1},isSvg:function(n){return n.match(/^\s*<\?xml/i)&&(n.match(/<!DOCTYPE svg/i)||n.match(/<svg/i))},getMimeType:function(n,t,i){switch(n){case"ffd8ffe0":case"ffd8ffe1":case"ffd8ffe2":return"image/jpeg";case"89504E47":return"image/png";case"47494638":return"image/gif";case"49492a00":return"image/tiff";case"52494646":return"image/webp";case"66747970":return"video/3gp";case"4f676753":return"video/ogg";case"1a45dfa3":return"video/mkv";case"000001ba":case"000001b3":return"video/mpeg";case"3026b275":return"video/wmv";case"25504446":return"application/pdf";case"25215053":return"application/ps";case"504b0304":case"504b0506":case"504b0508":return"application/zip";case"377abcaf":return"application/7z";case"75737461":return"application/tar";case"7801730d":return"application/dmg";default:switch(n.substring(0,6)){case"435753":return"application/x-shockwave-flash";case"494433":return"audio/mp3";case"425a68":return"application/bzip";default:switch(n.substring(0,4)){case"424d":return"image/bmp";case"fffb":return"audio/mp3";case"4d5a":return"application/exe";case"1f9d":case"1fa0":return"application/zip";case"1f8b":return"application/gzip";default:return t&&!t.match(/[^\u0000-\u007f]/)?"application/text-plain":i}}}},addCss:function(n,t){n.removeClass(t).addClass(t)},getElement:function(i,r,u){return t.isEmpty(i)||t.isEmpty(i[r])?u:n(i[r])},uniqId:function(){return Math.round((new Date).getTime())+"_"+Math.round(Math.random()*100)},htmlEncode:function(n,t){return n===undefined?t||null:n.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&apos;")},replaceTags:function(t,i){var r=t;return i?(n.each(i,function(n,t){typeof t=="function"&&(t=t());r=r.split(n).join(t)}),r):r},cleanMemory:function(n){var i=n.is("img")?n.attr("src"):n.find("source").attr("src");t.revokeObjectURL(i)},findFileName:function(n){var t=n.lastIndexOf("/");return t===-1&&(t=n.lastIndexOf("\\")),n.split(n.substring(t,t+1)).pop()},checkFullScreen:function(){return document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement},toggleFullScreen:function(n){var i=document,r=i.documentElement;r&&n&&!t.checkFullScreen()?r.requestFullscreen?r.requestFullscreen():r.msRequestFullscreen?r.msRequestFullscreen():r.mozRequestFullScreen?r.mozRequestFullScreen():r.webkitRequestFullscreen&&r.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT):i.exitFullscreen?i.exitFullscreen():i.msExitFullscreen?i.msExitFullscreen():i.mozCancelFullScreen?i.mozCancelFullScreen():i.webkitExitFullscreen&&i.webkitExitFullscreen()},moveArray:function(t,i,r,u){var f=n.extend(!0,[],t),e;if(u&&f.reverse(),r>=f.length)for(e=r-f.length;e--+1;)f.push(undefined);return f.splice(r,0,f.splice(i,1)[0]),u&&f.reverse(),f},cleanZoomCache:function(n){var t=n.closest(".kv-zoom-cache-theme");t.length||(t=n.closest(".kv-zoom-cache"));t.remove()},closeButton:function(n){return n=n?"close "+n:"close",'<button type="button" class="'+n+'" aria-label="Close">\n  <span aria-hidden="true">&times;<\/span>\n<\/button>'},getRotation:function(n){switch(n){case 2:return"rotateY(180deg)";case 3:return"rotate(180deg)";case 4:return"rotate(180deg) rotateY(180deg)";case 5:return"rotate(270deg) rotateY(180deg)";case 6:return"rotate(90deg)";case 7:return"rotate(90deg) rotateY(180deg)";case 8:return"rotate(270deg)";default:return""}},setTransform:function(n,t){n&&(n.style.transform=t,n.style.webkitTransform=t,n.style["-moz-transform"]=t,n.style["-ms-transform"]=t,n.style["-o-transform"]=t)}};i=function(i,r){var u=this;(u.$element=n(i),u.$parent=u.$element.parent(),u._validate())&&(u.isPreviewable=t.hasFileAPISupport(),u.isIE9=t.isIE(9),u.isIE10=t.isIE(10),(u.isPreviewable||u.isIE9)&&(u._init(r),u._listen()),u.$element.removeClass("file-loading"))};i.prototype={constructor:i,_cleanup:function(){var n=this;n.reader=null;n.clearFileStack();n.fileBatchCompleted=!0;n.isError=!1;n.cancelling=!1;n.paused=!1;n.lastProgress=0;n._initAjax()},_initAjax:function(){var n=this;n.ajaxQueue=[];n.ajaxRequests=[];n.ajaxQueueIntervalId=null;n.ajaxCurrentThreads=0;n.ajaxAborted=!1},_init:function(i,r){var u=this,s,f=u.$element,e,o,h;u.options=i;n.each(i,function(n,i){switch(n){case"minFileCount":case"maxFileCount":case"minFileSize":case"maxFileSize":case"maxFilePreviewSize":case"resizeImageQuality":case"resizeIfSizeMoreThan":case"progressUploadThreshold":case"initialPreviewCount":case"zoomModalHeight":case"minImageHeight":case"maxImageHeight":case"minImageWidth":case"maxImageWidth":u[n]=t.getNum(i);break;default:u[n]=i}});u.rtl&&(h=u.previewZoomButtonIcons.prev,u.previewZoomButtonIcons.prev=u.previewZoomButtonIcons.next,u.previewZoomButtonIcons.next=h);!isNaN(u.maxAjaxThreads)&&u.maxAjaxThreads<u.resumableUploadOptions.maxThreads&&(u.resumableUploadOptions.maxThreads=u.maxAjaxThreads);u._initFileManager();typeof u.autoOrientImage=="function"&&(u.autoOrientImage=u.autoOrientImage());typeof u.autoOrientImageInitial=="function"&&(u.autoOrientImageInitial=u.autoOrientImageInitial());r||u._cleanup();u.$form=f.closest("form");u._initTemplateDefaults();u.uploadFileAttr=t.isEmpty(f.attr("name"))?"file_data":f.attr("name");o=u._getLayoutTemplate("progress");u.progressTemplate=o.replace("{class}",u.progressClass);u.progressInfoTemplate=o.replace("{class}",u.progressInfoClass);u.progressPauseTemplate=o.replace("{class}",u.progressPauseClass);u.progressCompleteTemplate=o.replace("{class}",u.progressCompleteClass);u.progressErrorTemplate=o.replace("{class}",u.progressErrorClass);u.isDisabled=f.attr("disabled")||f.attr("readonly");u.isDisabled&&f.attr("disabled",!0);u.isClickable=u.browseOnZoneClick&&u.showPreview&&(u.dropZoneEnabled||!t.isEmpty(u.defaultPreviewContent));u.isAjaxUpload=t.hasFileUploadSupport()&&!t.isEmpty(u.uploadUrl);u.dropZoneEnabled=t.hasDragDropSupport()&&u.dropZoneEnabled;u.isAjaxUpload||(u.dropZoneEnabled=u.dropZoneEnabled&&t.canAssignFilesToInput());u.slug=typeof i.slugCallback=="function"?i.slugCallback:u._slugDefault;u.mainTemplate=u.showCaption?u._getLayoutTemplate("main1"):u._getLayoutTemplate("main2");u.captionTemplate=u._getLayoutTemplate("caption");u.previewGenericTemplate=u._getPreviewTemplate("generic");!u.imageCanvas&&u.resizeImage&&(u.maxImageWidth||u.maxImageHeight)&&(u.imageCanvas=document.createElement("canvas"),u.imageCanvasContext=u.imageCanvas.getContext("2d"));t.isEmpty(f.attr("id"))&&f.attr("id",t.uniqId());u.namespace=".fileinput_"+f.attr("id").replace(/-/g,"_");u.$container===undefined?u.$container=u._createContainer():u._refreshContainer();e=u.$container;u.$dropZone=e.find(".file-drop-zone");u.$progress=e.find(".kv-upload-progress");u.$btnUpload=e.find(".fileinput-upload");u.$captionContainer=t.getElement(i,"elCaptionContainer",e.find(".file-caption"));u.$caption=t.getElement(i,"elCaptionText",e.find(".file-caption-name"));t.isEmpty(u.msgPlaceholder)||(s=f.attr("multiple")?u.filePlural:u.fileSingle,u.$caption.attr("placeholder",u.msgPlaceholder.replace("{files}",s)));u.$captionIcon=u.$captionContainer.find(".file-caption-icon");u.$previewContainer=t.getElement(i,"elPreviewContainer",e.find(".file-preview"));u.$preview=t.getElement(i,"elPreviewImage",e.find(".file-preview-thumbnails"));u.$previewStatus=t.getElement(i,"elPreviewStatus",e.find(".file-preview-status"));u.$errorContainer=t.getElement(i,"elErrorContainer",u.$previewContainer.find(".kv-fileinput-error"));u._validateDisabled();t.isEmpty(u.msgErrorClass)||t.addCss(u.$errorContainer,u.msgErrorClass);r?u._errorsExist()||u.$errorContainer.hide():(u.$errorContainer.hide(),u.previewInitId="preview-"+t.uniqId(),u._initPreviewCache(),u._initPreview(!0),u._initPreviewActions(),u.$parent.hasClass("file-loading")&&(u.$container.insertBefore(u.$parent),u.$parent.remove()));u._setFileDropZoneTitle();f.attr("disabled")&&u.disable();u._initZoom();u.hideThumbnailContent&&t.addCss(u.$preview,"hide-content")},_initFileManager:function(){var i=this;i.fileManager={stack:{},processed:[],errors:[],loadedImages:{},totalImages:0,totalFiles:null,totalSize:null,uploadedSize:0,stats:{},initStats:function(n){var r={started:t.now().getTime()};n?i.fileManager.stats[n]=r:i.fileManager.stats=r},getUploadStats:function(n,r,u){var f=i.fileManager,e=n?f.stats[n]&&f.stats[n].started||null:null;e||(e=t.now().getTime());var o=(t.now().getTime()-e)/1e3,h=o?r/o:0,c=i._getSize(h,["B/s","KB/s","MB/s","GB/s","TB/s","PB/s","EB/s","ZB/s","YB/s"]),l=u-r,s={fileId:n,started:e,elapsed:o,loaded:r,total:u,bps:h,bitrate:c,pendingBytes:l};return n?f.stats[n]=s:f.stats=s,s},exists:function(t){return n.inArray(t,i.fileManager.getIdList())!==-1},count:function(){return i.fileManager.getIdList().length},total:function(){var n=i.fileManager;return n.totalFiles||(n.totalFiles=n.count()),n.totalFiles},getTotalSize:function(){var t=i.fileManager;return t.totalSize?t.totalSize:(t.totalSize=0,n.each(i.fileManager.stack,function(n,i){var r=parseFloat(i.size);t.totalSize+=isNaN(r)?0:r}),t.totalSize)},add:function(n,r){(r||(r=i.fileManager.getId(n)),r)&&(i.fileManager.stack[r]={file:n,name:t.getFileName(n),relativePath:t.getFileRelativePath(n),size:n.size,nameFmt:i._getFileName(n,""),sizeFmt:i._getSize(n.size)})},remove:function(n){var t=n.attr("data-fileid");t&&i.fileManager.removeFile(t)},removeFile:function(n){delete i.fileManager.stack[n];delete i.fileManager.loadedImages[n]},move:function(t,r){var u={},f=i.fileManager.stack;(t||r)&&t!==r&&(n.each(f,function(n,i){n!==t&&(u[n]=i);n===r&&(u[t]=f[t])}),i.fileManager.stack=u)},list:function(){var t=[];return n.each(i.fileManager.stack,function(n,i){i&&i.file&&t.push(i.file)}),t},isPending:function(t){return n.inArray(t,i.fileManager.processed)===-1&&i.fileManager.exists(t)},isProcessed:function(){var t=!0,r=i.fileManager;return n.each(r.stack,function(n){r.isPending(n)&&(t=!1)}),t},clear:function(){var n=i.fileManager;n.totalFiles=null;n.totalSize=null;n.uploadedSize=0;n.stack={};n.errors=[];n.processed=[];n.stats={};n.clearImages()},clearImages:function(){i.fileManager.loadedImages={};i.fileManager.totalImages=0},addImage:function(n,t){i.fileManager.loadedImages[n]=t},removeImage:function(n){delete i.fileManager.loadedImages[n]},getImageIdList:function(){return Object.keys(i.fileManager.loadedImages)},getImageCount:function(){return i.fileManager.getImageIdList().length},getId:function(n){return i._getFileId(n)},getIndex:function(n){return i.fileManager.getIdList().indexOf(n)},getThumb:function(t){var r=null;return i._getThumbs().each(function(){n(this).attr("data-fileid")===t&&(r=n(this))}),r},getThumbIndex:function(n){var t=n.attr("data-fileid");return i.fileManager.getIndex(t)},getIdList:function(){return Object.keys(i.fileManager.stack)},getFile:function(n){return i.fileManager.stack[n]||null},getFileName:function(n,t){var r=i.fileManager.getFile(n);return r?t?r.nameFmt||"":r.name||"":""},getFirstFile:function(){var n=i.fileManager.getIdList(),t=n&&n.length?n[0]:null;return i.fileManager.getFile(t)},setFile:function(n,t){i.fileManager.getFile(n)?i.fileManager.stack[n].file=t:i.fileManager.add(t,n)},setProcessed:function(n){i.fileManager.processed.push(n)},getProgress:function(){var n=i.fileManager.total(),t=i.fileManager.processed.length;return n?Math.ceil(t/n*100):0},setProgress:function(n,t){var r=i.fileManager.getFile(n);!isNaN(t)&&r&&(r.progress=t)}}},_setUploadData:function(i,r){var u=this;n.each(r,function(n,r){var f=u.uploadParamNames[n]||n;t.isArray(r)?i.append(f,r[0],r[1]):i.append(f,r)})},_initResumableUpload:function(){var i=this,r=i.resumableUploadOptions,u=t.logMessages;if(i.enableResumableUpload){if(r.fallback!==!1&&typeof r.fallback!="function"&&(r.fallback=function(n){n._log(u.noResumableSupport);n.enableResumableUpload=!1}),!t.hasResumableUploadSupport()&&r.fallback!==!1){r.fallback(i);return}if(!i.uploadUrl&&i.enableResumableUpload){i._log(u.noUploadUrl);i.enableResumableUpload=!1;return}if(r.chunkSize=parseFloat(r.chunkSize),r.chunkSize<=0||isNaN(r.chunkSize)){i._log(u.invalidChunkSize,{chunkSize:r.chunkSize});i.enableResumableUpload=!1;return}i.resumableManager={init:function(n,t,r){var u=i.resumableManager,f=i.fileManager;u.currThreads=0;u.logs=[];u.stack=[];u.error="";u.chunkIntervalId=null;u.id=n;u.file=t.file;u.fileName=t.name;u.fileIndex=r;u.completed=!1;u.testing=!1;u.lastProgress=0;i.showPreview&&(u.$thumb=f.getThumb(n)||null,u.$progress=u.$btnDelete=null,u.$thumb&&u.$thumb.length&&(u.$progress=u.$thumb.find(".file-thumb-progress"),u.$btnDelete=u.$thumb.find(".kv-file-remove")));u.chunkSize=i.resumableUploadOptions.chunkSize*1024;u.chunkCount=u.getTotalChunks()},logAjaxError:function(n,t,r){i.resumableUploadOptions.showErrorLog&&i._log(u.ajaxError,{status:n.status,error:r,text:n.responseText||""})},reset:function(){var n=i.resumableManager;n.processed={}},setProcessed:function(n){var t=i.resumableManager,e=i.fileManager,u=t.id,o,r=t.$thumb,s=t.$progress,h=r&&r.length,f={id:h?r.attr("id"):"",index:e.getIndex(u),fileId:u};t.completed=!0;t.lastProgress=0;e.uploadedSize+=t.file.size;h&&r.removeClass("file-uploading");n==="success"?(i.showPreview&&(i._setProgress(101,s),i._setThumbStatus(r,"Success"),i._initUploadSuccess(t.processed[u].data,r)),i.fileManager.removeFile(u),delete t.processed[u],i._raise("fileuploaded",[f.id,f.index,f.fileId]),e.isProcessed()&&i._setProgress(101)):(i.showPreview&&(i._setThumbStatus(r,"Error"),i._setPreviewError(r,!0),i._setProgress(101,s,i.msgProgressError),i._setProgress(101,i.$progress,i.msgProgressError),i.cancelling=!0),i.$errorContainer.find('li[data-file-id="'+f.fileId+'"]').length||(o=i.msgResumableUploadRetriesExceeded.setTokens({file:t.fileName,max:i.resumableUploadOptions.maxRetries,error:t.error}),i._showFileError(o,f)));e.isProcessed()&&t.reset()},check:function(){var t=i.resumableManager,r=!0;n.each(t.logs,function(n,t){if(!t)return r=!1,!1});r&&(clearInterval(t.chunkIntervalId),t.setProcessed("success"))},processedResumables:function(){var n=i.resumableManager.logs,t,r=0;if(!n||!n.length)return 0;for(t=0;t<n.length;t++)n[t]===!0&&r++;return r},getUploadedSize:function(){var n=i.resumableManager,t=n.processedResumables()*n.chunkSize;return t>n.file.size?n.file.size:t},getTotalChunks:function(){var t=i.resumableManager,n=parseFloat(t.chunkSize);return!isNaN(n)&&n>0?Math.ceil(t.file.size/n):0},getProgress:function(){var n=i.resumableManager,r=n.processedResumables(),t=n.chunkCount;return t===0?0:Math.ceil(r/t*100)},checkAborted:function(n){(i.paused||i.cancelling)&&(clearInterval(n),i.unlock())},upload:function(){var r=i.resumableManager,n=i.fileManager,e=n.getIdList(),u="new",f;f=setInterval(function(){var o,s;r.checkAborted(f);u==="new"&&(i.lock(),u="processing",o=e.shift(),n.initStats(o),n.stack[o]&&(r.init(o,n.stack[o],n.getIndex(o)),r.testUpload(),r.uploadResumable()));!n.isPending(o)&&r.completed&&(u="new");n.isProcessed()&&(s=i.$preview.find(".file-preview-initial"),s.length&&(t.addCss(s,t.SORT_CSS),i._initSortable()),clearInterval(f),i._clearFileInput(),i.unlock(),setTimeout(function(){var n=i.previewCache.data;n&&(i.initialPreview=n.content,i.initialPreviewConfig=n.config,i.initialPreviewThumbTags=n.tags);i._raise("filebatchuploadcomplete",[i.initialPreview,i.initialPreviewConfig,i.initialPreviewThumbTags,i._getExtraData()])},i.processDelay))},i.processDelay)},uploadResumable:function(){for(var t=i.resumableManager,r=t.chunkCount,n=0;n<r;n++)t.logs[n]=!!(t.processed[t.id]&&t.processed[t.id][n]);for(n=0;n<r;n++)t.pushAjax(n,0);t.chunkIntervalId=setInterval(t.loopAjax,i.queueDelay)},testUpload:function(){var r=i.resumableManager,h=i.resumableUploadOptions,f,s,o=i.fileManager,u=r.id,c,l,a,v,e;if(!h.testUrl){r.testing=!1;return}r.testing=!0;f=new FormData;s=o.stack[u];i._setUploadData(f,{fileId:u,fileName:s.fileName,fileSize:s.size,fileRelativePath:s.relativePath,chunkSize:r.chunkSize,chunkCount:r.chunkCount});c=function(n){e=i._getOutData(f,n);i._raise("filetestbeforesend",[u,o,r,e])};l=function(s,h,c){e=i._getOutData(f,c,s);var v=i.uploadParamNames,l=v.chunksUploaded||"chunksUploaded",a=[u,o,r,e];s[l]&&t.isArray(s[l])?(r.processed[u]||(r.processed[u]={}),n.each(s[l],function(n,t){r.logs[t]=!0;r.processed[u][t]=!0}),r.processed[u].data=s,i._raise("filetestsuccess",a)):i._raise("filetesterror",a);r.testing=!1};a=function(n,t,s){e=i._getOutData(f,n);i._raise("filetestajaxerror",[u,o,r,e]);r.logAjaxError(n,t,s);r.testing=!1};v=function(){i._raise("filetestcomplete",[u,o,r,i._getOutData(f)]);r.testing=!1};i._ajaxSubmit(c,l,v,a,f,u,r.fileIndex,h.testUrl)},pushAjax:function(n,t){i.resumableManager.stack.push([n,t])},sendAjax:function(n,r){var h=i.fileManager,f=i.resumableManager,g=i.resumableUploadOptions,v,l=f.chunkSize,e=f.id,c=f.file,a=f.$thumb,nt=f.$btnDelete,o,s,y,p,w,b,k,d;if(!f.processed[e]||!f.processed[e][n]){if(f.currThreads++,r>g.maxRetries){f.setProcessed("error");return}k=c.slice?"slice":c.mozSlice?"mozSlice":c.webkitSlice?"webkitSlice":"slice";d=c[k](l*n,l*(n+1));o=new FormData;v=h.stack[e];i._setUploadData(o,{chunkCount:f.chunkCount,chunkIndex:n,chunkSize:l,chunkSizeStart:l*n,fileBlob:[d,f.fileName],fileId:e,fileName:f.fileName,fileRelativePath:v.relativePath,fileSize:c.size,retryCount:r});f.$progress&&f.$progress.length&&f.$progress.show();y=function(u){s=i._getOutData(o,u);i.showPreview&&(a.hasClass("file-preview-success")||(i._setThumbStatus(a,"Loading"),t.addCss(a,"file-uploading")),nt.attr("disabled",!0));i._raise("filechunkbeforesend",[e,n,r,h,f,s])};p=function(t,c,l){s=i._getOutData(o,l,t);var y=i.uploadParamNames,a=y.chunkIndex||"chunkIndex",p=i.resumableUploadOptions,v=[e,n,r,h,f,s];f.currThreads--;t.error?(p.showErrorLog&&i._log(u.retryStatus,{retry:r+1,filename:f.fileName,chunk:n}),f.pushAjax(n,r+1),f.error=t.error,i._raise("filechunkerror",v)):(f.logs[t[a]]=!0,f.processed[e]||(f.processed[e]={}),f.processed[e][t[a]]=!0,f.processed[e].data=t,i._raise("filechunksuccess",v),f.check())};w=function(t,u,c){s=i._getOutData(o,t);f.currThreads--;f.error=c;f.logAjaxError(t,u,c);i._raise("filechunkajaxerror",[e,n,r,h,f,s]);f.pushAjax(n,r+1)};b=function(){i._raise("filechunkcomplete",[e,n,r,h,f,i._getOutData(o)])};i._ajaxSubmit(y,p,b,w,o,e,f.fileIndex)}},loopAjax:function(){var n=i.resumableManager,t,r;n.currThreads<i.resumableUploadOptions.maxThreads&&!n.testing&&(t=n.stack.shift(),typeof t!="undefined"&&(r=t[0],n.processed[n.id]&&n.processed[n.id][r]?n.processedResumables()>=n.getTotalChunks()&&(n.setProcessed("success"),clearInterval(n.chunkIntervalId)):n.sendAjax(r,t[1])))}};i.resumableManager.reset()}},_initTemplateDefaults:function(){var r=this,o,s,h,c,l,a,v,y,p,w,b,k,d,g,nt,tt,it,rt,ut,ft,et,f,ot,st,ht,ct,lt,at,vt,yt,pt,wt,bt,kt,dt,e,gt,i,ni,u,ti;o='{preview}\n<div class="kv-upload-progress kv-hidden"><\/div><div class="clearfix"><\/div>\n<div class="input-group {class}">\n  {caption}\n<div class="input-group-btn input-group-append">\n      {remove}\n      {cancel}\n      {pause}\n      {upload}\n      {browse}\n    <\/div>\n<\/div>';s='{preview}\n<div class="kv-upload-progress kv-hidden"><\/div>\n<div class="clearfix"><\/div>\n{remove}\n{cancel}\n{upload}\n{browse}\n';h='<div class="file-preview {class}">\n    {close}    <div class="{dropClass}">\n    <div class="file-preview-thumbnails">\n    <\/div>\n    <div class="clearfix"><\/div>    <div class="file-preview-status text-center text-success"><\/div>\n    <div class="kv-fileinput-error"><\/div>\n    <\/div>\n<\/div>';l=t.closeButton("fileinput-remove");c='<i class="glyphicon glyphicon-file"><\/i>';a='<div class="file-caption form-control {class}" tabindex="500">\n  <span class="file-caption-icon"><\/span>\n  <input class="file-caption-name" onkeydown="return false;" onpaste="return false;">\n<\/div>';v='<button type="{type}" tabindex="500" title="{title}" class="{css}" {status}>{icon} {label}<\/button>';y='<a href="{href}" tabindex="500" title="{title}" class="{css}" {status}>{icon} {label}<\/a>';p='<div tabindex="500" class="{css}" {status}>{icon} {label}<\/div>';w='<div id="'+t.MODAL_ID+'" class="file-zoom-dialog modal fade" tabindex="-1" aria-labelledby="'+t.MODAL_ID+'Label"><\/div>';b='<div class="modal-dialog modal-lg{rtl}" role="document">\n  <div class="modal-content">\n    <div class="modal-header">\n      <h5 class="modal-title">{heading}<\/h5>\n      <span class="kv-zoom-title"><\/span>\n      <div class="kv-zoom-actions">{toggleheader}{fullscreen}{borderless}{close}<\/div>\n    <\/div>\n    <div class="modal-body">\n      <div class="floating-buttons"><\/div>\n      <div class="kv-zoom-body file-zoom-content {zoomFrameClass}"><\/div>\n{prev} {next}\n    <\/div>\n  <\/div>\n<\/div>\n';k='<div class="progress">\n    <div class="{class}" role="progressbar" aria-valuenow="{percent}" aria-valuemin="0" aria-valuemax="100" style="width:{percent}%;">\n        {status}\n     <\/div>\n<\/div>{stats}';ti='<div class="text-info file-upload-stats"><span class="pending-time">{pendingTime}<\/span> <span class="upload-speed">{uploadSpeed}<\/span><\/div>';d=" <samp>({sizeText})<\/samp>";g='<div class="file-thumbnail-footer">\n    <div class="file-footer-caption" title="{caption}">\n        <div class="file-caption-info">{caption}<\/div>\n        <div class="file-size-info">{size}<\/div>\n    <\/div>\n    {progress}\n{indicator}\n{actions}\n<\/div>';nt='<div class="file-actions">\n    <div class="file-footer-buttons">\n        {download} {upload} {delete} {zoom} {other}    <\/div>\n<\/div>\n{drag}\n<div class="clearfix"><\/div>';tt='<button type="button" class="kv-file-remove {removeClass}" title="{removeTitle}" {dataUrl}{dataKey}>{removeIcon}<\/button>\n';it='<button type="button" class="kv-file-upload {uploadClass}" title="{uploadTitle}">{uploadIcon}<\/button>';rt='<a class="kv-file-download {downloadClass}" title="{downloadTitle}" href="{downloadUrl}" download="{caption}" target="_blank">{downloadIcon}<\/a>';ut='<button type="button" class="kv-file-zoom {zoomClass}" title="{zoomTitle}">{zoomIcon}<\/button>';ft='<span class="file-drag-handle {dragClass}" title="{dragTitle}">{dragIcon}<\/span>';et='<div class="file-upload-indicator" title="{indicatorTitle}">{indicator}<\/div>';f='<div class="file-preview-frame {frameClass}" id="{previewId}" data-fileindex="{fileindex}" data-fileid="{fileid}" data-template="{template}"';ot=f+'><div class="kv-file-content">\n';st=f+' title="{caption}"><div class="kv-file-content">\n';ht="<\/div>{footer}\n<\/div>\n";ct="{content}\n";i=" {style}";lt='<div class="kv-preview-data file-preview-html" title="{caption}"'+i+">{data}<\/div>\n";at='<img src="{data}" class="file-preview-image kv-preview-data" title="{title}" alt="{alt}"'+i+">\n";vt='<textarea class="kv-preview-data file-preview-text" title="{caption}" readonly'+i+">{data}<\/textarea>\n";yt='<iframe class="kv-preview-data file-preview-office" src="https://view.officeapps.live.com/op/embed.aspx?src={data}"'+i+"><\/iframe>";pt='<iframe class="kv-preview-data file-preview-gdocs" src="https://docs.google.com/gview?url={data}&embedded=true"'+i+"><\/iframe>";wt='<video class="kv-preview-data file-preview-video" controls'+i+'>\n<source src="{data}" type="{type}">\n'+t.DEFAULT_PREVIEW+"\n<\/video>\n";bt='<!--suppress ALL --><audio class="kv-preview-data file-preview-audio" controls'+i+'>\n<source src="{data}" type="{type}">\n'+t.DEFAULT_PREVIEW+"\n<\/audio>\n";kt='<embed class="kv-preview-data file-preview-flash" src="{data}" type="application/x-shockwave-flash"'+i+">\n";e='<embed class="kv-preview-data file-preview-pdf" src="{data}" type="application/pdf"'+i+">\n";dt='<object class="kv-preview-data file-preview-object file-object {typeCss}" data="{data}" type="{type}"'+i+'>\n<param name="movie" value="{caption}" />\n'+t.OBJECT_PARAMS+" "+t.DEFAULT_PREVIEW+"\n<\/object>\n";gt='<div class="kv-preview-data file-preview-other-frame"'+i+">\n"+t.DEFAULT_PREVIEW+"\n<\/div>\n";ni='<div class="kv-zoom-cache" style="display:none">{zoomContent}<\/div>';u={width:"100%",height:"100%","min-height":"480px"};r._isPdfRendered()&&(e=r.pdfRendererTemplate.replace("{renderer}",r._encodeURI(r.pdfRendererUrl)));r.defaults={layoutTemplates:{main1:o,main2:s,preview:h,close:l,fileIcon:c,caption:a,modalMain:w,modal:b,progress:k,stats:ti,size:d,footer:g,indicator:et,actions:nt,actionDelete:tt,actionUpload:it,actionDownload:rt,actionZoom:ut,actionDrag:ft,btnDefault:v,btnLink:y,btnBrowse:p,zoomCache:ni},previewMarkupTags:{tagBefore1:ot,tagBefore2:st,tagAfter:ht},previewContentTemplates:{generic:ct,html:lt,image:at,text:vt,office:yt,gdocs:pt,video:wt,audio:bt,flash:kt,object:dt,pdf:e,other:gt},allowedPreviewTypes:["image","html","text","video","audio","flash","pdf","object"],previewTemplates:{},previewSettings:{image:{width:"auto",height:"auto","max-width":"100%","max-height":"100%"},html:{width:"213px",height:"160px"},text:{width:"213px",height:"160px"},office:{width:"213px",height:"160px"},gdocs:{width:"213px",height:"160px"},video:{width:"213px",height:"160px"},audio:{width:"100%",height:"30px"},flash:{width:"213px",height:"160px"},object:{width:"213px",height:"160px"},pdf:{width:"100%",height:"160px"},other:{width:"213px",height:"160px"}},previewSettingsSmall:{image:{width:"auto",height:"auto","max-width":"100%","max-height":"100%"},html:{width:"100%",height:"160px"},text:{width:"100%",height:"160px"},office:{width:"100%",height:"160px"},gdocs:{width:"100%",height:"160px"},video:{width:"100%",height:"auto"},audio:{width:"100%",height:"30px"},flash:{width:"100%",height:"auto"},object:{width:"100%",height:"auto"},pdf:{width:"100%",height:"160px"},other:{width:"100%",height:"160px"}},previewZoomSettings:{image:{width:"auto",height:"auto","max-width":"100%","max-height":"100%"},html:u,text:u,office:{width:"100%",height:"100%","max-width":"100%","min-height":"480px"},gdocs:{width:"100%",height:"100%","max-width":"100%","min-height":"480px"},video:{width:"auto",height:"100%","max-width":"100%"},audio:{width:"100%",height:"30px"},flash:{width:"auto",height:"480px"},object:{width:"auto",height:"100%","max-width":"100%","min-height":"480px"},pdf:u,other:{width:"auto",height:"100%","min-height":"480px"}},mimeTypeAliases:{"video/quicktime":"video/mp4"},fileTypeSettings:{image:function(n,i){return t.compare(n,"image.*")&&!t.compare(n,/(tiff?|wmf)$/i)||t.compare(i,/\.(gif|png|jpe?g)$/i)},html:function(n,i){return t.compare(n,"text/html")||t.compare(i,/\.(htm|html)$/i)},office:function(n,i){return t.compare(n,/(word|excel|powerpoint|office)$/i)||t.compare(i,/\.(docx?|xlsx?|pptx?|pps|potx?)$/i)},gdocs:function(n,i){return t.compare(n,/(word|excel|powerpoint|office|iwork-pages|tiff?)$/i)||t.compare(i,/\.(docx?|xlsx?|pptx?|pps|potx?|rtf|ods|odt|pages|ai|dxf|ttf|tiff?|wmf|e?ps)$/i)},text:function(n,i){return t.compare(n,"text.*")||t.compare(i,/\.(xml|javascript)$/i)||t.compare(i,/\.(txt|md|csv|nfo|ini|json|php|js|css)$/i)},video:function(n,i){return t.compare(n,"video.*")&&(t.compare(n,/(ogg|mp4|mp?g|mov|webm|3gp)$/i)||t.compare(i,/\.(og?|mp4|webm|mp?g|mov|3gp)$/i))},audio:function(n,i){return t.compare(n,"audio.*")&&(t.compare(i,/(ogg|mp3|mp?g|wav)$/i)||t.compare(i,/\.(og?|mp3|mp?g|wav)$/i))},flash:function(n,i){return t.compare(n,"application/x-shockwave-flash",!0)||t.compare(i,/\.(swf)$/i)},pdf:function(n,i){return t.compare(n,"application/pdf",!0)||t.compare(i,/\.(pdf)$/i)},object:function(){return!0},other:function(){return!0}},fileActionSettings:{showRemove:!0,showUpload:!0,showDownload:!0,showZoom:!0,showDrag:!0,removeIcon:'<i class="glyphicon glyphicon-trash"><\/i>',removeClass:"btn btn-sm btn-kv btn-default btn-outline-secondary",removeErrorClass:"btn btn-sm btn-kv btn-danger",removeTitle:"Remove file",uploadIcon:'<i class="glyphicon glyphicon-upload"><\/i>',uploadClass:"btn btn-sm btn-kv btn-default btn-outline-secondary",uploadTitle:"Upload file",uploadRetryIcon:'<i class="glyphicon glyphicon-repeat"><\/i>',uploadRetryTitle:"Retry upload",downloadIcon:'<i class="glyphicon glyphicon-download"><\/i>',downloadClass:"btn btn-sm btn-kv btn-default btn-outline-secondary",downloadTitle:"Download file",zoomIcon:'<i class="glyphicon glyphicon-zoom-in"><\/i>',zoomClass:"btn btn-sm btn-kv btn-default btn-outline-secondary",zoomTitle:"View Details",dragIcon:'<i class="glyphicon glyphicon-move"><\/i>',dragClass:"text-info",dragTitle:"Move / Rearrange",dragSettings:{},indicatorNew:'<i class="glyphicon glyphicon-plus-sign text-warning"><\/i>',indicatorSuccess:'<i class="glyphicon glyphicon-ok-sign text-success"><\/i>',indicatorError:'<i class="glyphicon glyphicon-exclamation-sign text-danger"><\/i>',indicatorLoading:'<i class="glyphicon glyphicon-hourglass text-muted"><\/i>',indicatorPaused:'<i class="glyphicon glyphicon-pause text-primary"><\/i>',indicatorNewTitle:"Not uploaded yet",indicatorSuccessTitle:"Uploaded",indicatorErrorTitle:"Upload Error",indicatorLoadingTitle:"Uploading ...",indicatorPausedTitle:"Upload Paused"}};n.each(r.defaults,function(t,i){if(t==="allowedPreviewTypes"){r.allowedPreviewTypes===undefined&&(r.allowedPreviewTypes=i);return}r[t]=n.extend(!0,{},i,r[t])});r._initPreviewTemplates()},_initPreviewTemplates:function(){var i=this,u=i.previewMarkupTags,r,f=u.tagAfter;n.each(i.previewContentTemplates,function(n,e){t.isEmpty(i.previewTemplates[n])&&(r=u.tagBefore2,(n==="generic"||n==="image"||n==="html"||n==="text")&&(r=u.tagBefore1),i._isPdfRendered()&&n==="pdf"&&(r=r.replace("kv-file-content","kv-file-content kv-pdf-rendered")),i.previewTemplates[n]=r+e+f)})},_initPreviewCache:function(){var i=this;i.previewCache={data:{},init:function(){var n=i.initialPreview;n.length>0&&!t.isArray(n)&&(n=n.split(i.initialPreviewDelimiter));i.previewCache.data={content:n,config:i.initialPreviewConfig,tags:i.initialPreviewThumbTags}},count:function(n){if(!i.previewCache.data||!i.previewCache.data.content)return 0;if(n){var t=i.previewCache.data.content.filter(function(n){return n!==null});return t.length}return i.previewCache.data.content.length},get:function(r,u){var l="init_"+r,e=i.previewCache.data,f=e.config[r],w,s=e.content[r],b=i.previewInitId+"-"+l,o,h,c,a,v,y,p,d=t.ifSet("previewAsData",f,i.initialPreviewAsData),g=f?{title:f.title||null,alt:f.alt||null}:{title:null,alt:null},k=function(n,r,u,e,o,s,h,c,l){return c=" file-preview-initial "+t.SORT_CSS+(c?" "+c:""),w=f&&f.fileId||"file_"+o,i._generatePreviewTemplate(n,r,u,e,o,w,!1,null,c,s,h,l,g,f&&f.zoomData||r)};return!s||!s.length?"":(u=u===undefined?!0:u,c=t.ifSet("type",f,i.initialPreviewFileType||"generic"),v=t.ifSet("filename",f,t.ifSet("caption",f)),y=t.ifSet("filetype",f,c),a=i.previewCache.footer(r,u,f&&f.size||null),p=t.ifSet("frameClass",f),o=d?k(c,s,v,y,b,a,l,p):k("generic",s,v,y,b,a,l,p,c).setTokens({content:e.content[r]}),e.tags.length&&e.tags[r]&&(o=t.replaceTags(o,e.tags[r])),t.isEmpty(f)||t.isEmpty(f.frameAttr)||(h=n(document.createElement("div")).html(o),h.find(".file-preview-initial").attr(f.frameAttr),o=h.html(),h.remove()),o)},clean:function(n){n.content=t.cleanArray(n.content);n.config=t.cleanArray(n.config);n.tags=t.cleanArray(n.tags);i.previewCache.data=n},add:function(n,r,u,f){var e=i.previewCache.data,o=n.length-1;return!n||!n.length?o:(t.isArray(n)||(n=n.split(i.initialPreviewDelimiter)),f?(o=e.content.push(n[0])-1,e.config[o]=r,e.tags[o]=u):(e.content=n,e.config=r,e.tags=u),i.previewCache.clean(e),o)},set:function(n,r,u,f){var o=i.previewCache.data,e,s;if(n&&n.length&&(t.isArray(n)||(n=n.split(i.initialPreviewDelimiter)),s=n.filter(function(n){return n!==null}),s.length)){if(o.content===undefined&&(o.content=[]),o.config===undefined&&(o.config=[]),o.tags===undefined&&(o.tags=[]),f){for(e=0;e<n.length;e++)n[e]&&o.content.push(n[e]);for(e=0;e<r.length;e++)r[e]&&o.config.push(r[e]);for(e=0;e<u.length;e++)u[e]&&o.tags.push(u[e])}else o.content=n,o.config=r,o.tags=u;i.previewCache.clean(o)}},unset:function(r){var f=i.previewCache.count(),u=i.reversePreviewOrder,e;if(f){if(f===1){i.previewCache.data.content=[];i.previewCache.data.config=[];i.previewCache.data.tags=[];i.initialPreview=[];i.initialPreviewConfig=[];i.initialPreviewThumbTags=[];return}i.previewCache.data.content=t.spliceArray(i.previewCache.data.content,r,u);i.previewCache.data.config=t.spliceArray(i.previewCache.data.config,r,u);i.previewCache.data.tags=t.spliceArray(i.previewCache.data.tags,r,u);e=n.extend(!0,{},i.previewCache.data);i.previewCache.clean(e)}},out:function(){var n="",f,r=i.previewCache.count(),t,u;if(r===0)return{content:"",caption:""};for(t=0;t<r;t++)u=i.previewCache.get(t),n=i.reversePreviewOrder?u+n:n+u;return f=i._getMsgSelected(r),{content:n,caption:f}},footer:function(n,r,u){var e=i.previewCache.data||{};if(t.isEmpty(e.content))return"";(t.isEmpty(e.config)||t.isEmpty(e.config[n]))&&(e.config[n]={});r=r===undefined?!0:r;var f=e.config[n],y=t.ifSet("caption",f),c,p=t.ifSet("width",f,"auto"),l=t.ifSet("url",f,!1),a=t.ifSet("key",f,null),v=t.ifSet("fileId",f,null),o=i.fileActionSettings,w=i.initialPreviewShowDelete||!1,b=i.initialPreviewDownloadUrl?i.initialPreviewDownloadUrl+"?key="+a+(v?"&fileId="+v:""):"",s=f.downloadUrl||b,k=f.filename||f.caption||"",d=!!s,g=t.ifSet("showRemove",f,t.ifSet("showRemove",o,w)),h=t.ifSet("showDownload",f,t.ifSet("showDownload",o,d)),nt=t.ifSet("showZoom",f,t.ifSet("showZoom",o,!0)),tt=t.ifSet("showDrag",f,t.ifSet("showDrag",o,!0)),it=l===!1&&r;return h=h&&f.downloadUrl!==!1&&!!s,c=i._renderFileActions(f,!1,h,g,nt,tt,it,l,a,!0,s,k),i._getLayoutTemplate("footer").setTokens({progress:i._renderThumbProgress(),actions:c,caption:y,size:i._getSize(u),width:p,indicator:""})}};i.previewCache.init()},_isPdfRendered:function(){var t=this,n=t.usePdfRenderer,i=typeof n=="function"?n():!!n;return i&&t.pdfRendererUrl},_handler:function(n,t,i){var f=this,r=f.namespace,u=t.split(" ").join(r+" ")+r;if(n&&n.length)n.off(u).on(u,i)},_encodeURI:function(n){var t=this;return t.encodeUrl?encodeURI(n):n},_log:function(n,t){var r=this,i=r.$element.attr("id");i&&(n='"'+i+'": '+n);n="bootstrap-fileinput: "+n;typeof t=="object"&&n.setTokens(t);typeof window.console.log!="undefined"?window.console.log(n):window.alert(n)},_validate:function(){var n=this,i=n.$element.attr("type")==="file";return i||n._log(t.logMessages.badInputType),i},_errorsExist:function(){var i=this,t,r=i.$errorContainer.find("li");return r.length?!0:(t=n(document.createElement("div")).html(i.$errorContainer.html()),t.find(".kv-error-close").remove(),t.find("ul").remove(),!!n.trim(t.text()).length)},_errorHandler:function(n,t){var r=this,i=n.target.error,u=function(n){r._showError(n.replace("{name}",t))};i.code===i.NOT_FOUND_ERR?u(r.msgFileNotFound):i.code===i.SECURITY_ERR?u(r.msgFileSecured):i.code===i.NOT_READABLE_ERR?u(r.msgFileNotReadable):i.code===i.ABORT_ERR?u(r.msgFilePreviewAborted):u(r.msgFilePreviewError)},_addError:function(n){var t=this,i=t.$errorContainer;n&&i.length&&(i.html(t.errorCloseButton+n),t._handler(i.find(".kv-error-close"),"click",function(){setTimeout(function(){t.showPreview&&!t.getFrames().length&&t.clear();i.fadeOut("slow")},t.processDelay)}))},_setValidationError:function(n){var i=this;n=(n?n+" ":"")+"has-error";i.$container.removeClass(n).addClass("has-error");t.addCss(i.$captionContainer,"is-invalid")},_resetErrors:function(n){var t=this,i=t.$errorContainer;t.isError=!1;t.$container.removeClass("has-error");t.$captionContainer.removeClass("is-invalid");i.html("");n?i.fadeOut("slow"):i.hide()},_showFolderError:function(n){var t=this,r=t.$errorContainer,i;n&&(t.isAjaxUpload||t._clearFileInput(),i=t.msgFoldersNotAllowed.replace("{n}",n),t._addError(i),t._setValidationError(),r.fadeIn(800),t._raise("filefoldererror",[n,i]))},_showFileError:function(n,t,i){var r=this,u=r.$errorContainer,e=i||"fileuploaderror",o=t&&t.fileId||"",f=t&&t.id?'<li data-thumb-id="'+t.id+'" data-file-id="'+o+'">'+n+"<\/li>":"<li>"+n+"<\/li>";return u.find("ul").length===0?r._addError("<ul>"+f+"<\/ul>"):u.find("ul").append(f),u.fadeIn(800),r._raise(e,[t,n]),r._setValidationError("file-input-new"),!0},_showError:function(n,t,i){var r=this,u=r.$errorContainer,f=i||"fileerror";return t=t||{},t.reader=r.reader,r._addError(n),u.fadeIn(800),r._raise(f,[t,n]),r.isAjaxUpload||r._clearFileInput(),r._setValidationError("file-input-new"),r.$btnUpload.attr("disabled",!0),!0},_noFilesError:function(n){var t=this,r=t.minFileCount>1?t.filePlural:t.fileSingle,i=t.msgFilesTooLess.replace("{n}",t.minFileCount).replace("{files}",r),u=t.$errorContainer;t._addError(i);t.isError=!0;t._updateFileDetails(0);u.fadeIn(800);t._raise("fileerror",[n,i]);t._clearFileInput();t._setValidationError()},_parseError:function(t,i,r,u){var e=this,f=n.trim(r+""),s,o=i.responseJSON!==undefined&&i.responseJSON.error!==undefined?i.responseJSON.error:i.responseText;return e.cancelling&&e.msgUploadAborted&&(f=e.msgUploadAborted),e.showAjaxErrorDetails&&o&&(o=n.trim(o.replace(/\n\s*\n/g,"\n")),s=o.length?"<pre>"+o+"<\/pre>":"",f+=f?s:o),f||(f=e.msgAjaxError.replace("{operation}",t)),e.cancelling=!1,u?"<b>"+u+": <\/b>"+f:f},_parseFileType:function(n,i){var o=this,u,f,e,r,s=o.allowedPreviewTypes||[];if(n==="application/text-plain")return"text";for(r=0;r<s.length;r++)if(e=s[r],u=o.fileTypeSettings[e],u&&(f=u(n,i)?e:"",!t.isEmpty(f)))return f;return"other"},_getPreviewIcon:function(t){var i=this,r,u=null;return t&&t.indexOf(".")>-1&&(r=t.split(".").pop(),i.previewFileIconSettings&&(u=i.previewFileIconSettings[r]||i.previewFileIconSettings[r.toLowerCase()]||null),i.previewFileExtSettings&&n.each(i.previewFileExtSettings,function(n,t){if(i.previewFileIconSettings[n]&&t(r)){u=i.previewFileIconSettings[n];return}})),u},_parseFilePreviewIcon:function(n,t){var r=this,u=r._getPreviewIcon(t)||r.previewFileIcon,i=n;return i.indexOf("{previewFileIcon}")>-1&&(i=i.setTokens({previewFileIconClass:r.previewFileIconClass,previewFileIcon:u})),i},_raise:function(t,i){var u=this,r=n.Event(t);if(i!==undefined?u.$element.trigger(r,i):u.$element.trigger(r),r.isDefaultPrevented()||r.result===!1)return!1;switch(t){case"filebatchuploadcomplete":case"filebatchuploadsuccess":case"fileuploaded":case"fileclear":case"filecleared":case"filereset":case"fileerror":case"filefoldererror":case"fileuploaderror":case"filebatchuploaderror":case"filedeleteerror":case"filecustomerror":case"filesuccessremove":break;default:u.ajaxAborted||(u.ajaxAborted=r.result)}return!0},_listenFullScreen:function(n){var u=this,t=u.$modal,r,i;t&&t.length&&(r=t&&t.find(".btn-fullscreen"),i=t&&t.find(".btn-borderless"),r.length&&i.length)&&(r.removeClass("active").attr("aria-pressed","false"),i.removeClass("active").attr("aria-pressed","false"),n?r.addClass("active").attr("aria-pressed","true"):i.addClass("active").attr("aria-pressed","true"),t.hasClass("file-zoom-fullscreen")?u._maximizeZoomDialog():n?u._maximizeZoomDialog():i.removeClass("active").attr("aria-pressed","false"))},_listen:function(){var i=this,r=i.$element,f=i.$form,u=i.$container,e;i._handler(r,"click",function(n){r.hasClass("file-no-browse")&&(r.data("zoneClicked")?r.data("zoneClicked",!1):n.preventDefault())});i._handler(r,"change",n.proxy(i._change,i));i.showBrowse&&i._handler(i.$btnFile,"click",n.proxy(i._browse,i));i._handler(u.find(".fileinput-remove:not([disabled])"),"click",n.proxy(i.clear,i));i._handler(u.find(".fileinput-cancel"),"click",n.proxy(i.cancel,i));i._handler(u.find(".fileinput-pause"),"click",n.proxy(i.pause,i));i._initDragDrop();i._handler(f,"reset",n.proxy(i.clear,i));i.isAjaxUpload||i._handler(f,"submit",n.proxy(i._submitForm,i));i._handler(i.$container.find(".fileinput-upload"),"click",n.proxy(i._uploadClick,i));i._handler(n(window),"resize",function(){i._listenFullScreen(screen.width===window.innerWidth&&screen.height===window.innerHeight)});e="webkitfullscreenchange mozfullscreenchange fullscreenchange MSFullscreenChange";i._handler(n(document),e,function(){i._listenFullScreen(t.checkFullScreen())});i._autoFitContent();i._initClickable();i._refreshPreview()},_autoFitContent:function(){var r=window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth,t=this,u=r<400?t.previewSettingsSmall||t.defaults.previewSettingsSmall:t.previewSettings||t.defaults.previewSettings,i;n.each(u,function(n,r){i=".file-preview-frame .file-preview-"+n;t.$preview.find(i+".kv-preview-data,"+i+" .kv-preview-data").css(r)})},_scanDroppedItems:function(n,i,r){r=r||"";var f=this,u,o,e,s=function(n){f._log(t.logMessages.badDroppedFiles);f._log(n)};n.isFile?n.file(function(n){i.push(n)},s):n.isDirectory&&(o=n.createReader(),e=function(){o.readEntries(function(t){if(t&&t.length>0){for(u=0;u<t.length;u++)f._scanDroppedItems(t[u],i,r+n.name+"/");e()}return null},s)},e())},_initDragDrop:function(){var t=this,i=t.$dropZone;t.dropZoneEnabled&&t.showPreview&&(t._handler(i,"dragenter dragover",n.proxy(t._zoneDragEnter,t)),t._handler(i,"dragleave",n.proxy(t._zoneDragLeave,t)),t._handler(i,"drop",n.proxy(t._zoneDrop,t)),t._handler(n(document),"dragenter dragover drop",t._zoneDragDropInit))},_zoneDragDropInit:function(n){n.stopPropagation();n.preventDefault()},_zoneDragEnter:function(i){var r=this,u=i.originalEvent.dataTransfer,f=n.inArray("Files",u.types)>-1;if(r._zoneDragDropInit(i),r.isDisabled||!f){i.originalEvent.dataTransfer.effectAllowed="none";i.originalEvent.dataTransfer.dropEffect="none";return}r._raise("fileDragEnter",{sourceEvent:i,files:u.types.Files})&&t.addCss(r.$dropZone,"file-highlighted")},_zoneDragLeave:function(n){var t=this;(t._zoneDragDropInit(n),t.isDisabled)||t._raise("fileDragLeave",{sourceEvent:n})&&t.$dropZone.removeClass("file-highlighted")},_zoneDrop:function(n){var i=this,u,o=i.$element,s=n.originalEvent.dataTransfer,r=s.files,f=s.items,h=t.getDragDropFolders(f),c=function(){i.isAjaxUpload?i._change(n,r):(i.changeTriggered=!0,o.get(0).files=r,setTimeout(function(){i.changeTriggered=!1;o.trigger("change"+i.namespace)},i.processDelay));i.$dropZone.removeClass("file-highlighted")},e;if((n.preventDefault(),!i.isDisabled&&!t.isEmpty(r))&&i._raise("fileDragDrop",{sourceEvent:n,files:r}))if(h>0){if(!i.isAjaxUpload){i._showFolderError(h);return}for(r=[],u=0;u<f.length;u++)e=f[u].webkitGetAsEntry(),e&&i._scanDroppedItems(e,r);setTimeout(function(){c()},500)}else c()},_uploadClick:function(n){var r=this,i=r.$container.find(".fileinput-upload"),u,f=!i.hasClass("disabled")&&t.isEmpty(i.attr("disabled"));if(!n||!n.isDefaultPrevented()){if(!r.isAjaxUpload){f&&i.attr("type")!=="submit"&&(u=i.closest("form"),u.length&&u.trigger("submit"),n.preventDefault());return}n.preventDefault();f&&r.upload()}},_submitForm:function(){var n=this;return n._isFileSelectionValid()&&!n._abort({})},_clearPreview:function(){var i=this,r=i.$preview,u=i.showUploadedThumbs?i.getFrames(":not(.file-preview-success)"):i.getFrames();u.each(function(){var i=n(this);i.remove();t.cleanZoomCache(r.find("#zoom-"+i.attr("id")))});i.getFrames().length&&i.showPreview||i._resetUpload();i._validateDefaultPreview()},_initSortable:function(){var i=this,r=i.$preview,u,f="."+t.SORT_CSS,e=i.reversePreviewOrder;window.KvSortable&&r.find(f).length!==0&&(u={handle:".drag-handle-init",dataIdAttr:"data-preview-id",scroll:!1,draggable:f,onSort:function(r){var u=r.oldIndex,f=r.newIndex,o=0;i.initialPreview=t.moveArray(i.initialPreview,u,f,e);i.initialPreviewConfig=t.moveArray(i.initialPreviewConfig,u,f,e);i.previewCache.init();i.getFrames(".file-preview-initial").each(function(){n(this).attr("data-fileindex","init_"+o);o++});i._raise("filesorted",{previewId:n(r.item).attr("id"),oldIndex:u,newIndex:f,stack:i.initialPreviewConfig})}},r.data("kvsortable")&&r.kvsortable("destroy"),n.extend(!0,u,i.fileActionSettings.dragSettings),r.kvsortable(u))},_setPreviewContent:function(n){var t=this;t.$preview.html(n);t._autoFitContent()},_initPreviewImageOrientations:function(){var t=this,i=0;t.autoOrientImageInitial&&t.getFrames(".file-preview-initial").each(function(){var u=n(this),f,e,o,r=t.initialPreviewConfig[i];r&&r.exif&&r.exif.Orientation&&(o=u.attr("id"),f=u.find(">.kv-file-content img"),e=t.$preview.find("#zoom-"+o+" >.kv-file-content img"),t.setImageOrientation(f,e,r.exif.Orientation,u));i++})},_initPreview:function(n){var i=this,u=i.initialCaption||"",r;if(!i.previewCache.count(!0)){i._clearPreview();n?i._setCaption(u):i._initCaption();return}r=i.previewCache.out();u=n&&i.initialCaption?i.initialCaption:r.caption;i._setPreviewContent(r.content);i._setInitThumbAttr();i._setCaption(u);i._initSortable();t.isEmpty(r.content)||i.$container.removeClass("file-input-new");i._initPreviewImageOrientations()},_getZoomButton:function(n){var t=this,r=t.previewZoomButtonIcons[n],u=t.previewZoomButtonClasses[n],f=' title="'+(t.previewZoomButtonTitles[n]||"")+'" ',i=f+(n==="close"?' data-dismiss="modal" aria-hidden="true"':"");return(n==="fullscreen"||n==="borderless"||n==="toggleheader")&&(i+=' data-toggle="button" aria-pressed="false" autocomplete="off"'),'<button type="button" class="'+u+" btn-"+n+'"'+i+">"+r+"<\/button>"},_getModalContent:function(){var n=this;return n._getLayoutTemplate("modal").setTokens({rtl:n.rtl?" kv-rtl":"",zoomFrameClass:n.frameClass,heading:n.msgZoomModalHeading,prev:n._getZoomButton("prev"),next:n._getZoomButton("next"),toggleheader:n._getZoomButton("toggleheader"),fullscreen:n._getZoomButton("fullscreen"),borderless:n._getZoomButton("borderless"),close:n._getZoomButton("close")})},_listenModalEvent:function(n){var r=this,i=r.$modal,u=function(n){return{sourceEvent:n,previewId:i.data("previewId"),modal:i}};i.on(n+".bs.modal",function(f){var e=i.find(".btn-fullscreen"),o=i.find(".btn-borderless");r._raise("filezoom"+n,u(f));n==="shown"&&(o.removeClass("active").attr("aria-pressed","false"),e.removeClass("active").attr("aria-pressed","false"),i.hasClass("file-zoom-fullscreen")&&(r._maximizeZoomDialog(),t.checkFullScreen()?e.addClass("active").attr("aria-pressed","true"):o.addClass("active").attr("aria-pressed","true")))})},_initZoom:function(){var i=this,r,f=i._getLayoutTemplate("modalMain"),u="#"+t.MODAL_ID;i.showPreview&&(i.$modal=n(u),i.$modal&&i.$modal.length||(r=n(document.createElement("div")).html(f).insertAfter(i.$container),i.$modal=n(u).insertBefore(r),r.remove()),t.initModal(i.$modal),i.$modal.html(i._getModalContent()),n.each(t.MODAL_EVENTS,function(n,t){i._listenModalEvent(t)}))},_initZoomButtons:function(){var t=this,o=t.$modal.data("previewId")||"",f,e,i=t.getFrames().toArray(),s=i.length,r=t.$modal.find(".btn-prev"),u=t.$modal.find(".btn-next");if(i.length<2){r.hide();u.hide();return}(r.show(),u.show(),s)&&(f=n(i[0]),e=n(i[s-1]),r.removeAttr("disabled"),u.removeAttr("disabled"),f.length&&f.attr("id")===o&&r.attr("disabled",!0),e.length&&e.attr("id")===o&&u.attr("disabled",!0))},_maximizeZoomDialog:function(){var o=this,t=o.$modal,u=t.find(".modal-header:visible"),f=t.find(".modal-footer:visible"),i=t.find(".modal-body"),r=n(window).height(),e=0;t.addClass("file-zoom-fullscreen");u&&u.length&&(r-=u.outerHeight(!0));f&&f.length&&(r-=f.outerHeight(!0));i&&i.length&&(e=i.outerHeight(!0)-i.height(),r-=e);t.find(".kv-zoom-body").height(r)},_resizeZoomDialog:function(n){var r=this,i=r.$modal,u=i.find(".btn-fullscreen"),f=i.find(".btn-borderless");if(i.hasClass("file-zoom-fullscreen"))t.toggleFullScreen(!1),n?u.hasClass("active")||(i.removeClass("file-zoom-fullscreen"),r._resizeZoomDialog(!0),f.hasClass("active")&&f.removeClass("active").attr("aria-pressed","false")):u.hasClass("active")?u.removeClass("active").attr("aria-pressed","false"):(i.removeClass("file-zoom-fullscreen"),r.$modal.find(".kv-zoom-body").css("height",r.zoomModalHeight));else{if(!n){r._maximizeZoomDialog();return}t.toggleFullScreen(!0)}i.focus()},_setZoomContent:function(i,r){var u=this,h,y,c,l,e,o,a,s=i.attr("id"),p=u.$preview.find("#zoom-"+s),f=u.$modal,v,k=f.find(".btn-fullscreen"),d=f.find(".btn-borderless"),w,b,g=f.find(".btn-toggleheader");y=p.attr("data-template")||"generic";h=p.find(".kv-file-content");c=h.length?h.html():"";w=i.data("caption")||"";b=i.data("size")||"";l=w+" "+b;f.find(".kv-zoom-title").attr("title",n("<div/>").html(l).text()).html(l);e=f.find(".kv-zoom-body");f.removeClass("kv-single-content");r?(v=e.addClass("file-thumb-loading").clone().insertAfter(e),e.html(c).hide(),v.fadeOut("fast",function(){e.fadeIn("fast",function(){e.removeClass("file-thumb-loading")});v.remove()})):e.html(c);a=u.previewZoomSettings[y];a&&(o=e.find(".kv-preview-data"),t.addCss(o,"file-zoom-detail"),n.each(a,function(n,t){o.css(n,t);(o.attr("width")&&n==="width"||o.attr("height")&&n==="height")&&o.removeAttr(n)}));f.data("previewId",s);u._handler(f.find(".btn-prev"),"click",function(){u._zoomSlideShow("prev",s)});u._handler(f.find(".btn-next"),"click",function(){u._zoomSlideShow("next",s)});u._handler(k,"click",function(){u._resizeZoomDialog(!0)});u._handler(d,"click",function(){u._resizeZoomDialog(!1)});u._handler(g,"click",function(){var n=f.find(".modal-header"),t=f.find(".modal-body .floating-buttons"),i,r=n.find(".kv-zoom-actions"),e=function(t){var r=u.$modal.find(".kv-zoom-body"),i=u.zoomModalHeight;f.hasClass("file-zoom-fullscreen")&&(i=r.outerHeight(!0),t||(i=i-n.outerHeight(!0)));r.css("height",t?i+t:i)};n.is(":visible")?(i=n.outerHeight(!0),n.slideUp("slow",function(){r.find(".btn").appendTo(t);e(i)})):(t.find(".btn").appendTo(r),n.slideDown("slow",function(){e()}));f.focus()});u._handler(f,"keydown",function(t){var i=t.which||t.keyCode,r=n(this).find(".btn-prev"),f=n(this).find(".btn-next"),e=n(this).data("previewId"),o=u.rtl?39:37,s=u.rtl?37:39;i===o&&r.length&&!r.attr("disabled")&&u._zoomSlideShow("prev",e);i===s&&f.length&&!f.attr("disabled")&&u._zoomSlideShow("next",e)})},_zoomPreview:function(n){var i=this,u,r=i.$modal;if(!n.length)throw"Cannot zoom to detailed preview!";t.initModal(r);r.html(i._getModalContent());u=n.closest(t.FRAMES);i._setZoomContent(u);r.modal("show");i._initZoomButtons()},_zoomSlideShow:function(t,i){var r=this,h=r.$modal.find(".kv-zoom-actions .btn-"+t),o,u,e=r.getFrames().toArray(),s=e.length,f;if(!h.attr("disabled")){for(u=0;u<s;u++)if(n(e[u]).attr("id")===i){f=t==="prev"?u-1:u+1;break}f<0||f>=s||!e[f]||(o=n(e[f]),o.length&&r._setZoomContent(o,!0),r._initZoomButtons(),r._raise("filezoom"+t,{previewId:i,modal:r.$modal}))}},_initZoomButton:function(){var t=this;t.$preview.find(".kv-file-zoom").each(function(){var i=n(this);t._handler(i,"click",function(){t._zoomPreview(i)})})},_inputFileCount:function(){return this.$element.get(0).files.length},_refreshPreview:function(){var t=this,i;(t._inputFileCount()||t.isAjaxUpload)&&t.showPreview&&t.isPreviewable&&(t.isAjaxUpload?t.fileManager.count()>0?(i=n.extend(!0,{},t.fileManager.stack),t.fileManager.clear(),t._clearFileInput()):i=t.$element.get(0).files:i=t.$element.get(0).files,i&&i.length&&(t.readFiles(i),t._setFileDropZoneTitle()))},_clearObjects:function(t){t.find("video audio").each(function(){this.pause();n(this).remove()});t.find("img object div").each(function(){n(this).remove()})},_clearFileInput:function(){var f=this,i=f.$element,u,t,r;f._inputFileCount()&&(u=i.closest("form"),t=n(document.createElement("form")),r=n(document.createElement("div")),i.before(r),u.length?u.after(t):r.after(t),t.append(i).trigger("reset"),r.before(i).remove(),t.remove())},_resetUpload:function(){var n=this;n.uploadCache={content:[],config:[],tags:[],append:!0};n.$btnUpload.removeAttr("disabled");n._setProgress(0);n.$progress.hide();n._resetErrors(!1);n._initAjax();n.fileManager.clearImages();n._resetCanvas();n.cacheInitialPreview={};n.overwriteInitial&&(n.initialPreview=[],n.initialPreviewConfig=[],n.initialPreviewThumbTags=[],n.previewCache.data={content:[],config:[],tags:[]})},_resetCanvas:function(){var n=this;n.canvas&&n.imageCanvasContext&&n.imageCanvasContext.clearRect(0,0,n.canvas.width,n.canvas.height)},_hasInitialPreview:function(){var n=this;return!n.overwriteInitial&&n.previewCache.count(!0)},_resetPreview:function(){var n=this,t,i;n.previewCache.count(!0)?(t=n.previewCache.out(),n._setPreviewContent(t.content),n._setInitThumbAttr(),i=n.initialCaption?n.initialCaption:t.caption,n._setCaption(i)):(n._clearPreview(),n._initCaption());n.showPreview&&(n._initZoom(),n._initSortable())},_clearDefaultPreview:function(){var n=this;n.$preview.find(".file-default-preview").remove()},_validateDefaultPreview:function(){var n=this;n.showPreview&&!t.isEmpty(n.defaultPreviewContent)&&(n._setPreviewContent('<div class="file-default-preview">'+n.defaultPreviewContent+"<\/div>"),n.$container.removeClass("file-input-new"),n._initClickable())},_resetPreviewThumbs:function(n){var t=this,i;if(n){t._clearPreview();t.clearFileStack();return}t._hasInitialPreview()?(i=t.previewCache.out(),t._setPreviewContent(i.content),t._setInitThumbAttr(),t._setCaption(i.caption),t._initPreviewActions()):t._clearPreview()},_getLayoutTemplate:function(n){var i=this,r=i.layoutTemplates[n];return t.isEmpty(i.customLayoutTags)?r:t.replaceTags(r,i.customLayoutTags)},_getPreviewTemplate:function(n){var i=this,r=i.previewTemplates[n];return t.isEmpty(i.customPreviewTags)?r:t.replaceTags(r,i.customPreviewTags)},_getOutData:function(n,t,i,r){var u=this;return t=t||{},i=i||{},r=r||u.fileManager.list(),{formdata:n,files:r,filenames:u.filenames,filescount:u.getFilesCount(),extra:u._getExtraData(),response:i,reader:u.reader,jqXHR:t}},_getMsgSelected:function(n){var t=this,i=n===1?t.fileSingle:t.filePlural;return n>0?t.msgSelected.replace("{n}",n).replace("{files}",i):t.msgNoFilesSelected},_getFrame:function(i){var u=this,r=n("#"+i);return r.length?r:(u._log(t.logMessages.invalidThumb,{id:i}),null)},_getThumbs:function(n){return n=n||"",this.getFrames(":not(.file-preview-initial)"+n)},_getExtraData:function(n,t){var i=this,r=i.uploadExtraData;return typeof i.uploadExtraData=="function"&&(r=i.uploadExtraData(n,t)),r},_initXhr:function(n,i,r){var u=this,e=u.fileManager,f=function(n){var f=0,s=n.total,h=n.loaded||n.position,o=e.getUploadStats(i,h,s);n.lengthComputable&&!u.enableResumableUpload&&(f=t.round(h/s*100));i?u._setFileUploadStats(i,f,r,o):u._setProgress(f,null,null,u._getStats(o));u._raise("fileajaxprogress",[o])};return n.upload&&(u.progressDelay&&(f=t.debounce(f,u.progressDelay)),n.upload.addEventListener("progress",f,!1)),n},_initAjaxSettings:function(){var t=this;t._ajaxSettings=n.extend(!0,{},t.ajaxSettings);t._ajaxDeleteSettings=n.extend(!0,{},t.ajaxDeleteSettings)},_mergeAjaxCallback:function(n,t,i){var r=this,f=r._ajaxSettings,e=r.mergeAjaxCallbacks,u;i==="delete"&&(f=r._ajaxDeleteSettings,e=r.mergeAjaxDeleteCallbacks);u=f[n];f[n]=e&&typeof u=="function"?e==="before"?function(){u.apply(this,arguments);t.apply(this,arguments)}:function(){t.apply(this,arguments);u.apply(this,arguments)}:t},_ajaxSubmit:function(t,i,r,u,f,e,o,s){var h=this,l,a,c,v;h._raise("filepreajax",[f,e,o])&&(f.append("initialPreview",JSON.stringify(h.initialPreview)),f.append("initialPreviewConfig",JSON.stringify(h.initialPreviewConfig)),f.append("initialPreviewThumbTags",JSON.stringify(h.initialPreviewThumbTags)),h._initAjaxSettings(),h._mergeAjaxCallback("beforeSend",t),h._mergeAjaxCallback("success",i),h._mergeAjaxCallback("complete",r),h._mergeAjaxCallback("error",u),s=s||h.uploadUrlThumb||h.uploadUrl,typeof s=="function"&&(s=s()),c=h._getExtraData(e,o)||{},typeof c=="object"&&n.each(c,function(n,t){f.append(n,t)}),a={xhr:function(){var t=n.ajaxSettings.xhr();return h._initXhr(t,e,h.fileManager.count())},url:h._encodeURI(s),type:"POST",dataType:"json",data:f,cache:!1,processData:!1,contentType:!1},l=n.extend(!0,{},a,h._ajaxSettings),h.ajaxQueue.push(l),v=function(){var t,i;h.ajaxCurrentThreads<h.maxAjaxThreads&&(t=h.ajaxQueue.shift(),typeof t!="undefined"&&(h.ajaxCurrentThreads++,i=n.ajax(t).done(function(){clearInterval(h.ajaxQueueIntervalId);h.ajaxCurrentThreads--}),h.ajaxRequests.push(i)))},h.ajaxQueueIntervalId=setInterval(v,h.queueDelay))},_mergeArray:function(n,i){var r=this,u=t.cleanArray(r[n]),f=t.cleanArray(i);r[n]=u.concat(f)},_initUploadSuccess:function(i,r,u){var f=this,h,v,y,c,l,e,o,s,a;f.showPreview&&typeof i=="object"&&!n.isEmptyObject(i)&&i.initialPreview!==undefined&&i.initialPreview.length>0&&(f.hasInitData=!0,e=i.initialPreview||[],o=i.initialPreviewConfig||[],s=i.initialPreviewThumbTags||[],h=i.append===undefined||i.append,e.length>0&&!t.isArray(e)&&(e=e.split(f.initialPreviewDelimiter)),e.length&&(f._mergeArray("initialPreview",e),f._mergeArray("initialPreviewConfig",o),f._mergeArray("initialPreviewThumbTags",s)),r!==undefined?u?(a=r.attr("data-fileindex"),f.uploadCache.content[a]=e[0],f.uploadCache.config[a]=o[0]||[],f.uploadCache.tags[a]=s[0]||[],f.uploadCache.append=h):(y=f.previewCache.add(e[0],o[0],s[0],h),v=f.previewCache.get(y,!1),c=n(document.createElement("div")).html(v).hide().insertAfter(r),l=c.find(".kv-zoom-cache"),l&&l.length&&l.insertAfter(r),r.fadeOut("slow",function(){var n=c.find(".file-preview-frame");n&&n.length&&n.insertBefore(r).fadeIn("slow").css("display:inline-block");f._initPreviewActions();f._clearFileInput();t.cleanZoomCache(f.$preview.find("#zoom-"+r.attr("id")));r.remove();c.remove();f._initSortable()})):(f.previewCache.set(e,o,s,h),f._initPreview(),f._initPreviewActions()))},_initSuccessThumbs:function(){var i=this;i.showPreview&&i._getThumbs(t.FRAMES+".file-preview-success").each(function(){var r=n(this),f=i.$preview,u=r.find(".kv-file-remove");u.removeAttr("disabled");i._handler(u,"click",function(){var n=r.attr("id"),u=i._raise("filesuccessremove",[n,r.attr("data-fileindex")]);(t.cleanMemory(r),u!==!1)&&r.fadeOut("slow",function(){t.cleanZoomCache(f.find("#zoom-"+n));r.remove();i.getFrames().length||i.reset()})})})},_updateInitialPreview:function(){var n=this,i=n.uploadCache,u,f,e=0,r=n.cacheInitialPreview;if(r&&r.content&&(e=r.content.length),n.showPreview){if(n.previewCache.set(i.content,i.config,i.tags,i.append),e){for(u=0;u<i.content.length;u++)f=u+e,r.content[f]=i.content[u],r.config.length&&(r.config[f]=i.config[u]),r.tags.length&&(r.tags[f]=i.tags[u]);n.initialPreview=t.cleanArray(r.content);n.initialPreviewConfig=t.cleanArray(r.config);n.initialPreviewThumbTags=t.cleanArray(r.tags)}else n.initialPreview=i.content,n.initialPreviewConfig=i.config,n.initialPreviewThumbTags=i.tags;n.cacheInitialPreview={};n.hasInitData&&(n._initPreview(),n._initPreviewActions())}},_uploadSingle:function(i,r,u){var f=this,o=f.fileManager,d=o.count(),c=new FormData,l,w=f.previewInitId+"-"+i,e,g,s,v,ut=d>0||!n.isEmptyObject(f.uploadExtraData),b,y,nt,a,tt,it,rt,p,k=f.ajaxOperations.uploadThumb,ft=o.getFile(r),h={id:w,index:i,fileId:r},et=f.fileManager.getFileName(r,!0);f.enableResumableUpload||(f.showPreview&&(e=f.fileManager.getThumb(r),y=e.find(".file-thumb-progress"),s=e.find(".kv-file-upload"),v=e.find(".kv-file-remove"),y.show()),d===0||!ut||f.showPreview&&s&&s.hasClass("disabled")||f._abort(h))||(p=function(){b?o.errors.push(r):o.removeFile(r);o.setProcessed(r);o.isProcessed()&&(f.fileBatchCompleted=!0)},g=function(){var n;f.fileBatchCompleted&&setTimeout(function(){var i=o.count()===0,r=o.errors.length;f._updateInitialPreview();f.unlock(i);i&&f._clearFileInput();n=f.$preview.find(".file-preview-initial");f.uploadAsync&&n.length&&(t.addCss(n,t.SORT_CSS),f._initSortable());f._raise("filebatchuploadcomplete",[o.stack,f._getExtraData()]);f.retryErrorUploads&&r!==0||o.clear();f._setProgress(101);f.ajaxAborted=!1},f.processDelay)},nt=function(a){l=f._getOutData(c,a);o.initStats(r);f.fileBatchCompleted=!1;u||(f.ajaxAborted=!1);f.showPreview&&(e.hasClass("file-preview-success")||(f._setThumbStatus(e,"Loading"),t.addCss(e,"file-uploading")),s.attr("disabled",!0),v.attr("disabled",!0));u||f.lock();o.errors.indexOf(r)!==-1&&delete o.errors[r];f._raise("filepreupload",[l,w,i]);n.extend(!0,h,l);f._abort(h)&&(a.abort(),u||(f._setThumbStatus(e,"New"),e.removeClass("file-uploading"),s.removeAttr("disabled"),v.removeAttr("disabled"),f.unlock()),f._setProgressCancelled())},tt=function(o,v,d){var g=f.showPreview&&e.attr("id")?e.attr("id"):w;l=f._getOutData(c,d,o);n.extend(!0,h,l);setTimeout(function(){t.isEmpty(o)||o.Tag==1?(f.showPreview&&(f._setThumbStatus(e,"Success"),s.hide(),f._initUploadSuccess(o,e,u),f._setProgress(101,y)),f._raise("fileuploaded",[l,g,i]),u?p():f.fileManager.remove(e)):(b=!0,a=o.Message?o.Message:f._parseError(k,d,f.msgUploadError,f.fileManager.getFileName(r)),f._showFileError(a,h),f._setPreviewError(e,!0),f.retryErrorUploads||s.hide(),u&&p(),f._setProgress(101,n("#"+g).find(".file-thumb-progress"),f.msgUploadError))},f.processDelay)},it=function(){setTimeout(function(){f.showPreview&&(s.removeAttr("disabled"),v.removeAttr("disabled"),e.removeClass("file-uploading"));u?g():(f.unlock(!1),f._clearFileInput());f._initSuccessThumbs()},f.processDelay)},rt=function(t,i,o){a=f._parseError(k,t,o,f.fileManager.getFileName(r));b=!0;setTimeout(function(){u&&p();f.fileManager.setProgress(r,100);f._setPreviewError(e,!0);f.retryErrorUploads||s.hide();n.extend(!0,h,f._getOutData(c,t));f._setProgress(101,y,f.msgAjaxProgressError.replace("{operation}",k));f._setProgress(101,e.find(".file-thumb-progress"),f.msgUploadError);f._showFileError(a,h)},f.processDelay)},c.append(f.uploadFileAttr,ft.file,et),f._setUploadData(c,{fileId:r}),f._ajaxSubmit(nt,tt,it,rt,c,r,i))},_uploadBatch:function(){var i=this,s=i.fileManager,f=s.total(),h,c,l,a,y=f>0||!n.isEmptyObject(i.uploadExtraData),r,v,u=new FormData,e=i.ajaxOperations.uploadBatch,o;f!==0&&y&&!i._abort({})&&(v=function(){i.fileManager.clear();i._clearFileInput()},h=function(r){i.lock();s.initStats();var f=i._getOutData(u,r);i.ajaxAborted=!1;i.showPreview&&i._getThumbs().each(function(){var r=n(this),u=r.find(".kv-file-upload"),f=r.find(".kv-file-remove");r.hasClass("file-preview-success")||(i._setThumbStatus(r,"Loading"),t.addCss(r,"file-uploading"));u.attr("disabled",!0);f.attr("disabled",!0)});i._raise("filebatchpreupload",[f]);i._abort(f)&&(r.abort(),i._getThumbs().each(function(){var t=n(this),r=t.find(".kv-file-upload"),u=t.find(".kv-file-remove");t.hasClass("file-preview-loading")&&(i._setThumbStatus(t,"New"),t.removeClass("file-uploading"));r.removeAttr("disabled");u.removeAttr("disabled")}),i._setProgressCancelled())},c=function(f,o,s){var h=i._getOutData(u,s,f),c=0,l=i._getThumbs(":not(.file-preview-success)"),a=t.isEmpty(f)||t.isEmpty(f.errorkeys)?[]:f.errorkeys;t.isEmpty(f)||f.Tag==1?(i._raise("filebatchuploadsuccess",[h]),v(),i.showPreview?(l.each(function(){var t=n(this);i._setThumbStatus(t,"Success");t.removeClass("file-uploading");t.find(".kv-file-upload").hide().removeAttr("disabled")}),i._initUploadSuccess(f)):i.reset(),i._setProgress(101)):(i.showPreview&&(l.each(function(){var t=n(this);t.removeClass("file-uploading");t.find(".kv-file-upload").removeAttr("disabled");t.find(".kv-file-remove").removeAttr("disabled");a.length===0||n.inArray(c,a)!==-1?(i._setPreviewError(t,!0),i.retryErrorUploads||(t.find(".kv-file-upload").hide(),i.fileManager.remove(t))):(t.find(".kv-file-upload").hide(),i._setThumbStatus(t,"Success"),i.fileManager.remove(t));(!t.hasClass("file-preview-error")||i.retryErrorUploads)&&c++}),i._initUploadSuccess(f)),r=f.Message?f.Message:i._parseError(e,s,i.msgUploadError),i._showFileError(r,h,"filebatchuploaderror"),i._setProgress(101,i.$progress,i.msgUploadError))},a=function(){i.unlock();i._initSuccessThumbs();i._clearFileInput();i._raise("filebatchuploadcomplete",[i.fileManager.stack,i._getExtraData()])},l=function(t,o,s){var h=i._getOutData(u,t);(r=i._parseError(e,t,s),i._showFileError(r,h,"filebatchuploaderror"),i.uploadFileCount=f-1,i.showPreview)&&(i._getThumbs().each(function(){var t=n(this);t.removeClass("file-uploading");i.fileManager.getFile(t.attr("data-fileid"))&&i._setPreviewError(t)}),i._getThumbs().removeClass("file-uploading"),i._getThumbs(" .kv-file-upload").removeAttr("disabled"),i._getThumbs(" .kv-file-delete").removeAttr("disabled"),i._setProgress(101,i.$progress,i.msgAjaxProgressError.replace("{operation}",e)))},o=0,n.each(i.fileManager.stack,function(n,r){t.isEmpty(r.file)||u.append(i.uploadFileAttr,r.file,r.nameFmt||"untitled_"+o);o++}),i._ajaxSubmit(h,c,a,l,u))},_uploadExtraOnly:function(){var n=this,i={},e,o,s,h,u=new FormData,r,f=n.ajaxOperations.uploadExtra;n._abort(i)||(e=function(t){n.lock();var r=n._getOutData(u,t);n._raise("filebatchpreupload",[r]);n._setProgress(50);i.data=r;i.xhr=t;n._abort(i)&&(t.abort(),n._setProgressCancelled())},o=function(i,e,o){var s=n._getOutData(u,o,i);t.isEmpty(i)||i.Tag==1?(n._raise("filebatchuploadsuccess",[s]),n._clearFileInput(),n._initUploadSuccess(i),n._setProgress(101)):(r=i.Message?i.Message:n._parseError(f,o,n.msgUploadError),n._showFileError(r,s,"filebatchuploaderror"))},s=function(){n.unlock();n._clearFileInput();n._raise("filebatchuploadcomplete",[n.fileManager.stack,n._getExtraData()])},h=function(t,e,o){var s=n._getOutData(u,t);r=n._parseError(f,t,o);i.data=s;n._showFileError(r,s,"filebatchuploaderror");n._setProgress(101,n.$progress,n.msgAjaxProgressError.replace("{operation}",f))},n._ajaxSubmit(e,o,s,h,u))},_deleteFileIndex:function(i){var r=this,u=i.attr("data-fileindex"),f=r.reversePreviewOrder;u.substring(0,5)==="init_"&&(u=parseInt(u.replace("init_","")),r.initialPreview=t.spliceArray(r.initialPreview,u,f),r.initialPreviewConfig=t.spliceArray(r.initialPreviewConfig,u,f),r.initialPreviewThumbTags=t.spliceArray(r.initialPreviewThumbTags,u,f),r.getFrames().each(function(){var i=n(this),t=i.attr("data-fileindex");t.substring(0,5)==="init_"&&(t=parseInt(t.replace("init_","")),t>u&&(t--,i.attr("data-fileindex","init_"+t)))}),(r.uploadAsync||r.enableResumableUpload)&&(r.cacheInitialPreview=r.getPreview()))},_initFileActions:function(){var i=this,r=i.$preview;i.showPreview&&(i._initZoomButton(),i.getFrames(" .kv-file-remove").each(function(){var s=n(this),u=s.closest(t.FRAMES),h,f=u.attr("id"),c=u.attr("data-fileindex"),e,o,l;i._handler(s,"click",function(){if(l=i._raise("filepreremove",[f,c]),l===!1||!i._validateMinCount())return!1;h=u.hasClass("file-preview-error");t.cleanMemory(u);u.fadeOut("slow",function(){t.cleanZoomCache(r.find("#zoom-"+f));i.fileManager.remove(u);i._clearObjects(u);u.remove();f&&h&&i.$errorContainer.find('li[data-thumb-id="'+f+'"]').fadeOut("fast",function(){n(this).remove();i._errorsExist()||i._resetErrors()});i._clearFileInput();var l=i.previewCache.count(!0),a=i.fileManager.count(),s,v=i.showPreview&&i.getFrames().length;a!==0||l!==0||v?(e=l+a,e>1?o=i._getMsgSelected(e):(s=i.fileManager.getFirstFile(),o=s?s.nameFmt:"_"),i._setCaption(o)):i.reset();i._raise("fileremoved",[f,c])})})}),i.getFrames(" .kv-file-upload").each(function(){var r=n(this);i._handler(r,"click",function(){var n=r.closest(t.FRAMES),u=n.attr("data-fileid");(i.$progress.hide(),!n.hasClass("file-preview-error")||i.retryErrorUploads)&&i._uploadSingle(i.fileManager.getIndex(u),u,!1)})}))},_initPreviewActions:function(){var i=this,e=i.$preview,s=i.deleteExtraData||{},h=t.FRAMES+" .kv-file-remove",o=i.fileActionSettings,r=o.removeClass,u=o.removeErrorClass,f=function(){var n=i.isAjaxUpload?i.previewCache.count(!0):i._inputFileCount();i.getFrames().length||n||(i._setCaption(""),i.reset(),i.initialCaption="")};i._initZoomButton();e.find(h).each(function(){var h=n(this),p=h.data("url")||i.deleteUrl,a=h.data("key"),d,g,nt,tt,it=i.ajaxOperations.deleteThumb;if(!t.isEmpty(p)&&a!==undefined){typeof p=="function"&&(p=p());var o=h.closest(t.FRAMES),w=i.previewCache.data,b,l,v,k,c,y=o.attr("data-fileindex");y=parseInt(y.replace("init_",""));v=t.isEmpty(w.config)&&t.isEmpty(w.config[y])?null:w.config[y];c=t.isEmpty(v)||t.isEmpty(v.extra)?s:v.extra;k=v.filename||v.caption||"";typeof c=="function"&&(c=c());l={id:h.attr("id"),key:a,extra:c};g=function(n){i.ajaxAborted=!1;i._raise("filepredelete",[a,n,c]);i._abort()?n.abort():(h.removeClass(u),t.addCss(o,"file-uploading"),t.addCss(h,"disabled "+r))};nt=function(n,s,v){var p,w;if(!t.isEmpty(n)&&!t.isEmpty(n.error)){l.jqXHR=v;l.response=n;d=i._parseError(it,v,i.msgDeleteError,k);i._showFileError(d,l,"filedeleteerror");o.removeClass("file-uploading");h.removeClass("disabled "+r).addClass(u);f();return}o.removeClass("file-uploading").addClass("file-deleted");o.fadeOut("slow",function(){y=parseInt(o.attr("data-fileindex").replace("init_",""));i.previewCache.unset(y);i._deleteFileIndex(o);p=i.previewCache.count(!0);w=p>0?i._getMsgSelected(p):"";i._setCaption(w);i._raise("filedeleted",[a,v,c]);t.cleanZoomCache(e.find("#zoom-"+o.attr("id")));i._clearObjects(o);o.remove();f()})};tt=function(n,t,e){var s=i._parseError(it,n,e,k);l.jqXHR=n;l.response={};i._showFileError(s,l,"filedeleteerror");o.removeClass("file-uploading");h.removeClass("disabled "+r).addClass(u);f()};i._initAjaxSettings();i._mergeAjaxCallback("beforeSend",g,"delete");i._mergeAjaxCallback("success",nt,"delete");i._mergeAjaxCallback("error",tt,"delete");b=n.extend(!0,{},{url:i._encodeURI(p),type:"POST",dataType:"json",data:n.extend(!0,{},{key:a},c)},i._ajaxDeleteSettings);i._handler(h,"click",function(){if(!i._validateMinCount())return!1;i.ajaxAborted=!1;i._raise("filebeforedelete",[a,c]);ys.confirm("确认要删除吗？",function(){i.ajaxAborted instanceof Promise?i.ajaxAborted.then(function(t){t||n.ajax(b)}):i.ajaxAborted||n.ajax(b)})})}})},_hideFileIcon:function(){var n=this;n.overwriteInitial&&n.$captionContainer.removeClass("icon-visible")},_showFileIcon:function(){var n=this;t.addCss(n.$captionContainer,"icon-visible")},_getSize:function(t,i){var e=this,r=parseFloat(t),f,o=e.fileSizeGetter,u;return!n.isNumeric(t)||!n.isNumeric(r)?"":(typeof o=="function"?u=o(r):r===0?u="0.00 B":(f=Math.floor(Math.log(r)/Math.log(1024)),i||(i=["B","KB","MB","GB","TB","PB","EB","ZB","YB"]),u=(r/Math.pow(1024,f)).toFixed(2)*1+" "+i[f]),e._getLayoutTemplate("size").replace("{sizeText}",u))},_getFileType:function(n){var t=this;return t.mimeTypeAliases[n]||n},_generatePreviewTemplate:function(i,r,u,f,e,o,s,h,c,l,a,v,y,p){var w=this,k=w.slug(u),rt,b="",g="",et=window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth,nt,d=w.preferIconicPreview?"other":i,tt=k,ot=k,st=l||w._renderFileFooter(i,k,h,"auto",s),ut=w._getPreviewIcon(u),ft="type-default",ht=ut&&w.preferIconicPreview,ct=ut&&w.preferIconicZoomPreview,it;return nt=et<400?w.previewSettingsSmall[d]||w.defaults.previewSettingsSmall[d]:w.previewSettings[d]||w.defaults.previewSettings[d],nt&&n.each(nt,function(n,t){g+=n+":"+t+";"}),it=function(r,s,h,l){var d=h?"zoom-"+e:e,b=w._getPreviewTemplate(r),p=(c||"")+" "+l;return w.frameClass&&(p=w.frameClass+" "+p),h&&(p=p.replace(" "+t.SORT_CSS,"")),b=w._parseFilePreviewIcon(b,u),r==="text"&&(s=t.htmlEncode(s)),i!=="object"||f||n.each(w.defaults.fileTypeSettings,function(n,t){n!=="object"&&n!=="other"&&t(u,f)&&(ft="type-"+n)}),t.isEmpty(y)||(y.title!==undefined&&y.title!==null&&(tt=y.title),y.alt!==undefined&&y.alt!==null&&(tt=y.alt)),b.setTokens({previewId:d,caption:k,title:tt,alt:ot,frameClass:p,type:w._getFileType(f),fileindex:a,fileid:o||"",typeCss:ft,footer:st,data:s,template:v||i,style:g?'style="'+g+'"':""})},a=a||e.slice(e.lastIndexOf("-")+1),w.fileActionSettings.showZoom&&(b=it(ct?"other":i,p?p:r,!0,"kv-zoom-thumb")),b="\n"+w._getLayoutTemplate("zoomCache").replace("{zoomContent}",b),typeof w.sanitizeZoomCache=="function"&&(b=w.sanitizeZoomCache(b)),rt=it(ht?"other":i,r,!1,"kv-preview-thumb"),rt+b},_addToPreview:function(n,t){var i=this;return i.reversePreviewOrder?n.prepend(t):n.append(t)},_previewDefault:function(i,r,u){var f=this,s=f.$preview;if(f.showPreview){var h=t.getFileName(i),c=i?i.type:"",e,o=i.size||0,l=f._getFileName(i,""),a=u===!0&&!f.isAjaxUpload,v=t.createObjectURL(i),y=f.fileManager.getId(i);f._clearDefaultPreview();e=f._generatePreviewTemplate("other",v,h,c,r,y,a,o);f._addToPreview(s,e);f._setThumbAttr(r,l,o);u===!0&&f.isAjaxUpload&&f._setThumbStatus(n("#"+r),"Error")}},canPreview:function(n){var i=this;if(!n||!i.showPreview||!i.$preview||!i.$preview.length)return!1;var r=n.name||"",u=n.type||"",b=(n.size||0)/1e3,e=i._parseFileType(u,r),o,s,h,c,l=i.allowedPreviewTypes,a=i.allowedPreviewMimeTypes,v=i.allowedPreviewExtensions||[],y=i.disabledPreviewTypes,p=i.disabledPreviewMimeTypes,w=i.disabledPreviewExtensions||[],f=i.maxFilePreviewSize&&parseFloat(i.maxFilePreviewSize)||0,k=new RegExp("\\.("+v.join("|")+")$","i"),d=new RegExp("\\.("+w.join("|")+")$","i");return o=!l||l.indexOf(e)!==-1,s=!a||a.indexOf(u)!==-1,h=!v.length||t.compare(r,k),c=y&&y.indexOf(e)!==-1||p&&p.indexOf(u)!==-1||w.length&&t.compare(r,d)||f&&!isNaN(f)&&b>f,!c&&(o||s||h)},_previewFile:function(n,i,r,u,f,e){if(this.showPreview){var o=this,a=t.getFileName(i),c=e.type,v=e.name,s=o._parseFileType(c,a),y,p=o.$preview,l=i.size||0,h=s==="text"||s==="html"||s==="image"?r.target.result:f,b=o.fileManager.getId(i);s==="html"&&o.purifyHtml&&window.DOMPurify&&(h=window.DOMPurify.sanitize(h));y=o._generatePreviewTemplate(s,h,a,c,u,b,!1,l);o._clearDefaultPreview();o._addToPreview(p,y);var w=p.find("#"+u),k=w.find("img"),d=w.attr("data-fileid");o._validateImageOrientation(k,i,u,d,v,c,l,h);o._setThumbAttr(u,v,l);o._initSortable()}},_setThumbAttr:function(t,i,r){var f=this,u=n("#"+t);u.length&&(r=r&&r>0?f._getSize(r):"",u.data({caption:i,size:r}))},_setInitThumbAttr:function(){var i=this,s=i.previewCache.data,u=i.previewCache.count(!0),r,f,e,o,n;if(u!==0)for(n=0;n<u;n++)r=s.config[n],o=i.previewInitId+"-init_"+n,f=t.ifSet("caption",r,t.ifSet("filename",r)),e=t.ifSet("size",r),i._setThumbAttr(o,f,e)},_slugDefault:function(n){return t.isEmpty(n)?"":String(n).replace(/[\[\]\/\{}:;#%=\(\)\*\+\?\\\^\$\|<>&"']/g,"_")},_updateFileDetails:function(n){var i=this,u=i.$element,r,f,o,s,h,e=t.isIE(9)&&t.findFileName(u.val())||u[0].files[0]&&u[0].files[0].name;!e&&i.fileManager.count()>0?(h=i.fileManager.getFirstFile(),r=h.nameFmt):r=e?i.slug(e):"_";f=i.isAjaxUpload?i.fileManager.count():n;s=i.previewCache.count(!0)+f;o=f===1?r:i._getMsgSelected(s);i.isError?(i.$previewContainer.removeClass("file-thumb-loading"),i.$previewStatus.html(""),i.$captionContainer.removeClass("icon-visible")):i._showFileIcon();i._setCaption(o,i.isError);i.$container.removeClass("file-input-new file-input-ajax-new");arguments.length===1&&i._raise("fileselect",[n,r]);i.previewCache.count(!0)&&i._initPreviewActions()},_setThumbStatus:function(n,t){var i=this;if(i.showPreview){var r="indicator"+t,e=r+"Title",o="file-preview-"+t.toLowerCase(),u=n.find(".file-upload-indicator"),f=i.fileActionSettings;n.removeClass("file-preview-success file-preview-error file-preview-paused file-preview-loading");t==="Success"&&n.find(".file-drag-handle").remove();u.html(f[r]);u.attr("title",f[e]);n.addClass(o);t!=="Error"||i.retryErrorUploads||n.find(".kv-file-upload").attr("disabled",!0)}},_setProgressCancelled:function(){var n=this;n._setProgress(101,n.$progress,n.msgCancelled)},_setProgress:function(n,i,r,u){var f=this;if(i=i||f.$progress,i.length){var e=Math.min(n,100),o,s=f.progressUploadThreshold,c=n<=100?f.progressTemplate:f.progressCompleteTemplate,h=e<100?f.progressTemplate:r?f.paused?f.progressPauseTemplate:f.progressErrorTemplate:c;n>=100&&(u="");t.isEmpty(h)||(o=s&&e>s&&n<=100?h.setTokens({percent:s,status:f.msgUploadThreshold}):h.setTokens({percent:e,status:n>100?f.msgUploadEnd:e+"%"}),u=u||"",o=o.setTokens({stats:u}),i.html(o),r&&i.find('[role="progressbar"]').html(r))}},_setFileDropZoneTitle:function(){var n=this,i=n.$container.find(".file-drop-zone"),r=n.dropZoneTitle,u;(n.isClickable&&(u=t.isEmpty(n.$element.attr("multiple"))?n.fileSingle:n.filePlural,r+=n.dropZoneClickTitle.replace("{files}",u)),i.find("."+n.dropZoneTitleClass).remove(),!n.showPreview||i.length===0||n.fileManager.count()>0||!n.dropZoneEnabled||!n.isAjaxUpload&&n.$element.files)||(i.find(t.FRAMES).length===0&&t.isEmpty(n.defaultPreviewContent)&&i.prepend('<div class="'+n.dropZoneTitleClass+'">'+r+"<\/div>"),n.$container.removeClass("file-input-new"),t.addCss(n.$container,"file-input-ajax-new"))},_getStats:function(n){var i=this,r,u;return!i.showUploadStats||!n||!n.bitrate?"":(u=i._getLayoutTemplate("stats"),r=!n.elapsed||!n.bps?i.msgCalculatingTime:i.msgPendingTime.setTokens({time:t.getElapsed(Math.ceil(n.pendingBytes/n.bps))}),u.setTokens({uploadSpeed:n.bitrate,pendingTime:r}))},_setResumableProgress:function(n,t,i){var u=this,f=u.resumableManager,r=i?f:u,e=i?i.find(".file-thumb-progress"):null;r.lastProgress===0&&(r.lastProgress=n);n<r.lastProgress&&(n=r.lastProgress);u._setProgress(n,e,null,u._getStats(t));r.lastProgress=n},_setFileUploadStats:function(i,r,u,f){var e=this,s=e.$progress;if(e.showPreview||s&&s.length){var o=e.fileManager,h=o.getThumb(i),c,w=e.resumableManager,v=0,l=o.getTotalSize(),a=n.extend(!0,{},f);if(e.enableResumableUpload){var y=f.loaded,b=w.getUploadedSize(),k=w.file.size,p;y+=b;p=o.uploadedSize+y;r=t.round(100*y/k);f.pendingBytes=k-b;e._setResumableProgress(r,f,h);c=Math.floor(100*p/l);a.pendingBytes=l-p;e._setResumableProgress(c,a)}else o.setProgress(i,r),s=h&&h.length?h.find(".file-thumb-progress"):null,e._setProgress(r,s,null,e._getStats(f)),n.each(o.stats,function(n,t){v+=t.loaded}),a.pendingBytes=l-v,c=t.round(v/l*100),e._setProgress(c,null,null,e._getStats(a))}},_validateMinCount:function(){var n=this,t=n.isAjaxUpload?n.fileManager.count():n._inputFileCount();return n.validateInitialCount&&n.minFileCount>0&&n._getFileCount(t-1)<n.minFileCount?(n._noFilesError({}),!1):!0},_getFileCount:function(n){var t=this,i=0;return t.validateInitialCount&&!t.overwriteInitial&&(i=t.previewCache.count(!0),n+=i),n},_getFileId:function(n){return t.getFileId(n,this.generateFileId)},_getFileName:function(n,i){var u=this,r=t.getFileName(n);return r?u.slug(r):i},_getFileNames:function(n){var t=this;return t.filenames.filter(function(t){return n?t!==undefined:t!==undefined&&t!==null})},_setPreviewError:function(n,t){var i=this,r=i.removeFromPreviewOnError&&!i.retryErrorUploads;if((!t||r)&&i.fileManager.remove(n),i.showPreview){if(r){n.remove();return}i._setThumbStatus(n,"Error");i._refreshUploadButton(n)}},_refreshUploadButton:function(n){var i=this,r=n.find(".kv-file-upload"),t=i.fileActionSettings,u=t.uploadIcon,f=t.uploadTitle;r.length&&(i.retryErrorUploads&&(u=t.uploadRetryIcon,f=t.uploadRetryTitle),r.attr("title",f).html(u))},_checkDimensions:function(n,i,r,u,f,e,o){var h=this,a,l,y=i==="Small"?"min":"max",c=h[y+"Image"+e],s,v;!t.isEmpty(c)&&r.length&&((s=r[0],l=e==="Width"?s.naturalWidth||s.width:s.naturalHeight||s.height,v=i==="Small"?l>=c:l<=c,v)||(a=h["msgImage"+e+i].setTokens({name:f,size:c}),h._showFileError(a,o),h._setPreviewError(u)))},_getExifObj:function(n){var f=this,i=null,r=t.logMessages.exifWarning;if(n.slice(0,23)!=="data:image/jpeg;base64,"&&n.slice(0,22)!=="data:image/jpg;base64,"){i=null;return}try{i=window.piexif?window.piexif.load(n):null}catch(u){i=null;r=u&&u.message||""}return i||f._log(t.logMessages.badExifParser,{details:r}),i},setImageOrientation:function(i,r,u,f){var e=this,l=!i||!i.length,v=!r||!r.length,o,s=!1,h,a=l&&f&&f.attr("data-template")==="image",c;if(!l||!v){c="load.fileinputimageorient";a?(i=r,r=null,i.css(e.previewSettings.image),h=n(document.createElement("div")).appendTo(f.find(".kv-file-content")),o=n(document.createElement("span")).insertBefore(i),i.css("visibility","hidden").removeClass("file-zoom-detail").appendTo(h)):s=!i.is(":visible");i.off(c).on(c,function(){s&&(e.$preview.removeClass("hide-content"),f.find(".kv-file-content").css("visibility","hidden"));var n=i.get(0),l=r&&r.length?r.get(0):null,v=n.offsetHeight,y=n.offsetWidth,c=t.getRotation(u);if(s&&(f.find(".kv-file-content").css("visibility","visible"),e.$preview.addClass("hide-content")),i.data("orientation",u),l&&r.data("orientation",u),u<5){t.setTransform(n,c);t.setTransform(l,c);return}var b=Math.atan(y/v),p=Math.sqrt(Math.pow(v,2)+Math.pow(y,2)),k=p?v/Math.cos(Math.PI/2+b)/p:1,w=" scale("+Math.abs(k)+")";t.setTransform(n,c+w);t.setTransform(l,c+w);a&&(i.css("visibility","visible").insertAfter(o).addClass("file-zoom-detail"),o.remove(),h.remove())})}},_validateImageOrientation:function(t,i,r,u,f,e,o,s){var h=this,c,l,a=h.autoOrientImage;if(c=a?h._getExifObj(s):null,l=c?c["0th"][piexif.ImageIFD.Orientation]:null,!l){h._validateImage(r,u,f,e,o,s,c);return}h.setImageOrientation(t,n("#zoom-"+r+" img"),l,n("#"+r));h._raise("fileimageoriented",{$img:t,file:i});h._validateImage(r,u,f,e,o,s,c)},_validateImage:function(t,i,r,u,f,e,o){var s=this,v=s.$preview,a,y,p,h=v.find("#"+t),l=h.attr("data-fileindex"),c=h.find("img");r=r||"Untitled";c.one("load",function(){y=h.width();p=v.width();y>p&&c.css("width","100%");a={ind:l,id:t,fileId:i};s._checkDimensions(l,"Small",c,h,r,"Width",a);s._checkDimensions(l,"Small",c,h,r,"Height",a);s.resizeImage||(s._checkDimensions(l,"Large",c,h,r,"Width",a),s._checkDimensions(l,"Large",c,h,r,"Height",a));s._raise("fileimageloaded",[t]);s.fileManager.addImage(i,{ind:l,img:c,thumb:h,pid:t,typ:u,siz:f,validated:!1,imgData:e,exifObj:o});h.data("exif",o);s._validateAllImages()}).one("error",function(){s._raise("fileimageloaderror",[t])}).each(function(){this.complete?n(this).trigger("load"):this.error&&n(this).trigger("error")})},_validateAllImages:function(){var t=this,u={val:0},r=t.fileManager.getImageCount(),i,f=t.resizeIfSizeMoreThan;r===t.fileManager.totalImages&&(t._raise("fileimagesloaded"),t.resizeImage)&&n.each(t.fileManager.loadedImages,function(n,e){e.validated||(i=e.siz,i&&i>f*1e3&&t._getResizedImage(n,e,u,r),e.validated=!0)})},_getResizedImage:function(i,r,u,f){var e=this,y=n(r.img)[0],o=y.naturalWidth,s=y.naturalHeight,p,w=1,h=e.maxImageWidth||o,c=e.maxImageHeight||s,b=!!(o&&s),k,d,g=e.imageCanvas,l,st=e.imageCanvasContext,nt=r.typ,rt=r.pid,ut=r.ind,ht=r.thumb,a,ft,et=r.exifObj,ot,tt,v,it;if(a=function(n,t,i){e.isAjaxUpload?e._showFileError(n,t,i):e._showError(n,t,i);e._setPreviewError(ht)},tt=e.fileManager.getFile(i),v={id:rt,index:ut,fileId:i},it=[i,rt,ut],(!tt||!b||o<=h&&s<=c)&&(b&&tt&&e._raise("fileimageresized",it),u.val++,u.val===f&&e._raise("fileimagesresized"),!b)){a(e.msgImageResizeError,v,"fileimageresizeerror");return}nt=nt||e.resizeDefaultImageType;k=o>h;d=s>c;w=e.resizePreference==="width"?k?h/o:d?c/s:1:d?c/s:k?h/o:1;e._resetCanvas();o*=w;s*=w;g.width=o;g.height=s;try{st.drawImage(y,0,0,o,s);l=g.toDataURL(nt,e.resizeQuality);et&&(ot=window.piexif.dump(et),l=window.piexif.insert(ot,l));p=t.dataURI2Blob(l);e.fileManager.setFile(i,p);e._raise("fileimageresized",it);u.val++;u.val===f&&e._raise("fileimagesresized",[undefined,undefined]);p instanceof Blob||a(e.msgImageResizeError,v,"fileimageresizeerror")}catch(ct){u.val++;u.val===f&&e._raise("fileimagesresized",[undefined,undefined]);ft=e.msgImageResizeException.replace("{errors}",ct.message);a(ft,v,"fileimageresizeexception")}},_initBrowse:function(n){var i=this,r=i.$element;i.showBrowse?i.$btnFile=n.find(".btn-file").append(r):(r.appendTo(n).attr("tabindex",-1),t.addCss(r,"file-no-browse"))},_initClickable:function(){var i=this,r,u;i.isClickable&&(r=i.$dropZone,i.isAjaxUpload||(u=i.$preview.find(".file-default-preview"),u.length&&(r=u)),t.addCss(r,"clickable"),r.attr("tabindex",-1),i._handler(r,"click",function(t){var u=n(t.target);n(i.elErrorContainer+":visible").length||u.parents(".file-preview-thumbnails").length&&!u.parents(".file-default-preview").length||(i.$element.data("zoneClicked",!0).trigger("click"),r.blur())}))},_initCaption:function(){var n=this,i=n.initialCaption||"";return n.overwriteInitial||t.isEmpty(i)?(n.$caption.val(""),!1):(n._setCaption(i),!0)},_setCaption:function(i,r){var u=this,f,o,s,e,h,c;if(u.$caption.length){if(u.$captionContainer.removeClass("icon-visible"),r)f=n("<div>"+u.msgValidationError+"<\/div>").text(),e=u.fileManager.count(),e?(c=u.fileManager.getFirstFile(),h=e===1&&c?c.nameFmt:u._getMsgSelected(e)):h=u._getMsgSelected(u.msgNo),o=t.isEmpty(i)?h:i,s='<span class="'+u.msgValidationErrorClass+'">'+u.msgValidationErrorIcon+"<\/span>";else{if(t.isEmpty(i))return;f=n("<div>"+i+"<\/div>").text();o=f;s=u._getLayoutTemplate("fileIcon")}u.$captionContainer.addClass("icon-visible");u.$caption.attr("title",f).val(o);u.$captionIcon.html(s)}},_createContainer:function(){var t=this,r={"class":"file-input file-input-new"+(t.rtl?" kv-rtl":"")},i=n(document.createElement("div")).attr(r).html(t._renderMain());return i.insertBefore(t.$element),t._initBrowse(i),t.theme&&i.addClass("theme-"+t.theme),i},_refreshContainer:function(){var n=this,t=n.$container,i=n.$element;i.insertAfter(t);t.html(n._renderMain());n._initBrowse(t);n._validateDisabled()},_validateDisabled:function(){var n=this;n.$caption.attr({readonly:n.isDisabled})},_renderMain:function(){var n=this,t=n.dropZoneEnabled?" file-drop-zone":"file-drop-disabled",i=n.showClose?n._getLayoutTemplate("close"):"",r=n.showPreview?n._getLayoutTemplate("preview").setTokens({"class":n.previewClass,dropClass:t}):"",u=n.isDisabled?n.captionClass+" file-caption-disabled":n.captionClass,f=n.captionTemplate.setTokens({"class":u+" kv-fileinput-caption"});return n.mainTemplate.setTokens({"class":n.mainClass+(!n.showBrowse&&n.showCaption?" no-browse":""),preview:r,close:i,caption:f,upload:n._renderButton("upload"),remove:n._renderButton("remove"),cancel:n._renderButton("cancel"),pause:n._renderButton("pause"),browse:n._renderButton("browse")})},_renderButton:function(n){var i=this,f=i._getLayoutTemplate("btnDefault"),r=i[n+"Class"],o=i[n+"Title"],s=i[n+"Icon"],u=i[n+"Label"],h=i.isDisabled?" disabled":"",e="button";switch(n){case"remove":if(!i.showRemove)return"";break;case"cancel":if(!i.showCancel)return"";r+=" kv-hidden";break;case"pause":if(!i.showPause)return"";r+=" kv-hidden";break;case"upload":if(!i.showUpload)return"";i.isAjaxUpload&&!i.isDisabled?f=i._getLayoutTemplate("btnLink").replace("{href}",i.uploadUrl):e="submit";break;case"browse":if(!i.showBrowse)return"";f=i._getLayoutTemplate("btnBrowse");break;default:return""}return r+=n==="browse"?" btn-file":" fileinput-"+n+" fileinput-"+n+"-button",t.isEmpty(u)||(u=' <span class="'+i.buttonLabelClass+'">'+u+"<\/span>"),f.setTokens({type:e,css:r,title:o,status:h,icon:s,label:u})},_renderThumbProgress:function(){var n=this;return'<div class="file-thumb-progress kv-hidden">'+n.progressInfoTemplate.setTokens({percent:101,status:n.msgUploadBegin,stats:""})+"<\/div>"},_renderFileFooter:function(n,i,r,u,f){var e=this,o=e.fileActionSettings,a=o.showRemove,h=o.showDrag,v=o.showUpload,c=o.showZoom,l,s,y=e._getLayoutTemplate("footer"),p=e._getLayoutTemplate("indicator"),w=f?o.indicatorError:o.indicatorNew,b=f?o.indicatorErrorTitle:o.indicatorNewTitle,k=p.setTokens({indicator:w,indicatorTitle:b});return r=e._getSize(r),s={type:n,caption:i,size:r,width:u,progress:"",indicator:k},e.isAjaxUpload?(s.progress=e._renderThumbProgress(),s.actions=e._renderFileActions(s,v,!1,a,c,h,!1,!1,!1)):s.actions=e._renderFileActions(s,!1,!1,!1,c,h,!1,!1,!1),l=y.setTokens(s),t.replaceTags(l,e.previewThumbTags)},_renderFileActions:function(n,t,i,r,u,f,e,o,s,h,c,l){var v=this;if(!n.type&&h&&(n.type="image"),v.enableResumableUpload?t=!1:typeof t=="function"&&(t=t(n)),typeof i=="function"&&(i=i(n)),typeof r=="function"&&(r=r(n)),typeof u=="function"&&(u=u(n)),typeof f=="function"&&(f=f(n)),!t&&!i&&!r&&!u&&!f)return"";var nt=o===!1?"":' data-url="'+o+'"',p="",w="",b,k=s===!1?"":' data-key="'+s+'"',d="",g="",y="",tt=v._getLayoutTemplate("actions"),a=v.fileActionSettings,it=v.otherActionButtons.setTokens({dataKey:k,key:s}),rt=e?a.removeClass+" disabled":a.removeClass;return r&&(d=v._getLayoutTemplate("actionDelete").setTokens({removeClass:rt,removeIcon:a.removeIcon,removeTitle:a.removeTitle,dataUrl:nt,dataKey:k,key:s})),t&&(g=v._getLayoutTemplate("actionUpload").setTokens({uploadClass:a.uploadClass,uploadIcon:a.uploadIcon,uploadTitle:a.uploadTitle})),i&&(y=v._getLayoutTemplate("actionDownload").setTokens({downloadClass:a.downloadClass,downloadIcon:a.downloadIcon,downloadTitle:a.downloadTitle,downloadUrl:c||v.initialPreviewDownloadUrl}),y=y.setTokens({filename:l,key:s})),u&&(p=v._getLayoutTemplate("actionZoom").setTokens({zoomClass:a.zoomClass,zoomIcon:a.zoomIcon,zoomTitle:a.zoomTitle})),f&&h&&(b="drag-handle-init "+a.dragClass,w=v._getLayoutTemplate("actionDrag").setTokens({dragClass:b,dragTitle:a.dragTitle,dragIcon:a.dragIcon})),tt.setTokens({"delete":d,upload:g,download:y,zoom:p,drag:w,other:it})},_browse:function(n){var t=this;n&&n.isDefaultPrevented()||!t._raise("filebrowse")||(t.isError&&!t.isAjaxUpload&&t.clear(),t.$captionContainer.focus())},_change:function(i){var r=this;if(!r.changeTriggered){var c=r.$element,v=arguments.length>1,u=r.isAjaxUpload,o,s=v?arguments[1]:c.get(0).files,h,f=!u&&t.isEmpty(c.attr("multiple"))?1:r.maxFileCount,e,l=r.fileManager.count(),y=t.isEmpty(c.attr("multiple")),a=y&&l>0,p=function(t,i,f,e){var o=n.extend(!0,{},r._getOutData(null,{},{},s),{id:f,index:e}),h={id:f,index:e,file:i,files:s};return u?r._showFileError(t,o):r._showError(t,h)},w=function(n,t){var i=r.msgFilesTooMany.replace("{m}",t).replace("{n}",n);r.isError=p(i,null,null,null);r.$captionContainer.removeClass("icon-visible");r._setCaption("",!0);r.$container.removeClass("file-input-new file-input-ajax-new")};if(r.reader=null,r._resetUpload(),r._hideFileIcon(),r.dropZoneEnabled&&r.$container.find(".file-drop-zone ."+r.dropZoneTitleClass).remove(),u||(s=i.target&&i.target.files===undefined?i.target.value?[{name:i.target.value.replace(/^.+\\/,"")}]:[]:i.target.files||{}),o=s,t.isEmpty(o)||o.length===0){u||r.clear();r._raise("fileselectnone");return}if(r._resetErrors(),e=o.length,h=r._getFileCount(u?r.fileManager.count()+e:e),f>0&&h>f){if(!r.autoReplace||e>f){w(r.autoReplace&&e>f?e:h,f);return}h>f&&r._resetPreviewThumbs(u)}else!u||a?(r._resetPreviewThumbs(!1),a&&r.clearFileStack()):u&&l===0&&(!r.previewCache.count(!0)||r.overwriteInitial)&&r._resetPreviewThumbs(!0);r.readFiles(o)}},_abort:function(t){var i=this,r;return i.ajaxAborted&&typeof i.ajaxAborted=="object"&&i.ajaxAborted.message!==undefined?(r=n.extend(!0,{},i._getOutData(null),t),r.abortData=i.ajaxAborted.data||{},r.abortMessage=i.ajaxAborted.message,i._setProgress(101,i.$progress,i.msgCancelled),i._showFileError(i.ajaxAborted.message,r,"filecustomerror"),i.cancel(),!0):!!i.ajaxAborted},_resetFileStack:function(){var i=this,r=0;i._getThumbs().each(function(){var u=n(this),f=u.attr("data-fileindex"),e=u.attr("id");f!=="-1"&&f!==-1&&(i.fileManager.getFile(u.attr("data-fileid"))?u.attr({id:"uploaded-"+t.uniqId(),"data-fileindex":"-1"}):(u.attr({id:i.previewInitId+"-"+r,"data-fileindex":r}),r++),i.$preview.find("#zoom-"+e).attr({id:"zoom-"+u.attr("id"),"data-fileindex":u.attr("data-fileindex")}))})},_isFileSelectionValid:function(n){var t=this;return(n=n||0,t.required&&!t.getFilesCount())?(t.$errorContainer.html(""),t._showFileError(t.msgFileRequired),!1):t.minFileCount>0&&t._getFileCount(n)<t.minFileCount?(t._noFilesError({}),!1):!0},clearFileStack:function(){var n=this;return n.fileManager.clear(),n._initResumableUpload(),n.enableResumableUpload?(n.showPause===null&&(n.showPause=!0),n.showCancel===null&&(n.showCancel=!1)):(n.showPause=!1,n.showCancel===null&&(n.showCancel=!0)),n.$element},getFileStack:function(){return this.fileManager.stack},getFileList:function(){return this.fileManager.list()},getFilesCount:function(){var n=this,t=n.isAjaxUpload?n.fileManager.count():n._inputFileCount();return n._getFileCount(t)},readFiles:function(i){this.reader=new FileReader;var r=this,p=r.$element,f=r.reader,a=r.$previewContainer,l=r.$previewStatus,w=r.msgLoading,v=r.msgProgress,b=r.previewInitId,u=i.length,c=r.fileTypeSettings,k=r.fileManager.count(),o,e=r.allowedFileTypes,y=e?e.length:0,s=r.allowedFileExtensions,d=t.isEmpty(s)?"":s.join(", "),h=function(t,f,e,s,h){var c=n.extend(!0,{},r._getOutData(null,{},{},i),{id:e,index:s,fileId:h}),l=n("#"+e),a={id:e,index:s,fileId:h,file:f,files:i};r._previewDefault(f,e,!0);r.isAjaxUpload?setTimeout(function(){o(s+1)},r.processDelay):u=0;r._initFileActions();l.remove();r.isError=r.isAjaxUpload?r._showFileError(t,c):r._showError(t,a);r._updateFileDetails(u)};r.fileManager.clearImages();n.each(i,function(n,t){var i=r.fileTypeSettings.image;i&&i(t.type)&&r.fileManager.totalImages++});o=function(g){if(t.isEmpty(p.attr("multiple"))&&(u=1),g>=u){r.isAjaxUpload&&r.fileManager.count()>0?r._raise("filebatchselected",[r.fileManager.stack]):r._raise("filebatchselected",[i]);a.removeClass("file-thumb-loading");l.html("");return}var ei=k+g,ut=b+"-"+ei,nt=i[g],ot,rt,it,st,dt=c.text,gt=c.image,ni=c.html,ti,vt,yt,pt,tt=r._getFileName(nt,""),wt=(nt&&nt.size||0)/1e3,bt="",ii=t.createObjectURL(nt),et=0,ri="",ft,ht,ui=0,ct,lt,at,kt,fi=function(){var n=v.setTokens({index:g+1,files:u,percent:50,name:tt});setTimeout(function(){l.html(n);r._updateFileDetails(u);o(g+1)},r.processDelay);r._raise("fileloaded",[nt,ut,g,f])};if(nt){if(ft=r.fileManager.getId(nt),y>0)for(rt=0;rt<y;rt++)yt=e[rt],pt=r.msgFileTypes[yt]||yt,ri+=rt===0?pt:", "+pt;if(tt===!1){o(g+1);return}if(tt.length===0){it=r.msgInvalidFileName.replace("{name}",t.htmlEncode(t.getFileName(nt),"[unknown]"));h(it,nt,ut,g,ft);return}if(t.isEmpty(s)||(bt=new RegExp("\\.("+s.join("|")+")$","i")),ot=wt.toFixed(2),r.maxFileSize>0&&wt>r.maxFileSize){it=r.msgSizeTooLarge.setTokens({name:tt,size:ot,maxSize:r.maxFileSize});h(it,nt,ut,g,ft);return}if(r.minFileSize!==null&&wt<=t.getNum(r.minFileSize)){it=r.msgSizeTooSmall.setTokens({name:tt,size:ot,minSize:r.minFileSize});h(it,nt,ut,g,ft);return}if(!t.isEmpty(e)&&t.isArray(e)){for(rt=0;rt<e.length;rt+=1)ti=e[rt],ht=c[ti],et+=!ht||typeof ht!="function"?0:ht(nt.type,t.getFileName(nt))?1:0;if(et===0){it=r.msgInvalidFileType.setTokens({name:tt,types:ri});h(it,nt,ut,g,ft);return}}if(et===0&&!t.isEmpty(s)&&t.isArray(s)&&!t.isEmpty(bt)&&(vt=t.compare(tt,bt),et+=t.isEmpty(vt)?0:vt.length,et===0)){it=r.msgInvalidFileExtension.setTokens({name:tt,extensions:d});h(it,nt,ut,g,ft);return}if(r.isAjaxUpload&&r.fileManager.exists(ft)){it=r.msgDuplicateFile.setTokens({name:tt,size:ot});h(it,nt,ut,g,ft);st=n("#"+ut);st&&st.length&&st.remove();return}if(!r.canPreview(nt)){r.isAjaxUpload&&r.fileManager.add(nt);r.showPreview&&(a.addClass("file-thumb-loading"),r._previewDefault(nt,ut),r._initFileActions());setTimeout(function(){r._updateFileDetails(u);o(g+1);r._raise("fileloaded",[nt,ut,g])},10);return}ct=dt(nt.type,tt);lt=ni(nt.type,tt);at=gt(nt.type,tt);l.html(w.replace("{index}",g+1).replace("{files}",u));a.addClass("file-thumb-loading");f.onerror=function(n){r._errorHandler(n,tt)};f.onload=function(i){var o,e,s,l,a=[],h,u,v=function(n){var t=new FileReader;t.onerror=function(n){r._errorHandler(n,tt)};t.onload=function(n){r._previewFile(g,nt,n,ut,ii,e);r._initFileActions();fi()};n?t.readAsText(nt,r.textEncoding):t.readAsDataURL(nt)};if(e={name:tt,type:nt.type},n.each(c,function(n,t){n!=="object"&&n!=="other"&&typeof t=="function"&&t(nt.type,tt)&&ui++}),ui===0){for(s=new Uint8Array(i.target.result),rt=0;rt<s.length;rt++)l=s[rt].toString(16),a.push(l);if(o=a.join("").toLowerCase().substring(0,8),u=t.getMimeType(o,"",""),t.isEmpty(u)&&(h=t.arrayBuffer2String(f.result),u=t.isSvg(h)?"image/svg+xml":t.getMimeType(o,h,nt.type)),e={name:tt,type:u},ct=dt(u,""),lt=ni(u,""),at=gt(u,""),kt=ct||lt,kt||at){v(kt);return}}r._previewFile(g,nt,i,ut,ii,e);r._initFileActions();fi()};f.onprogress=function(n){if(n.lengthComputable){var t=n.loaded/n.total*100,i=Math.ceil(t);it=v.setTokens({index:g+1,files:u,percent:i,name:tt});setTimeout(function(){l.html(it)},r.processDelay)}};ct||lt?f.readAsText(nt,r.textEncoding):at?f.readAsDataURL(nt):f.readAsArrayBuffer(nt);r.fileManager.add(nt)}};o(0);r._updateFileDetails(u,!1)},lock:function(){var n=this,t=n.$container;return n._resetErrors(),n.disable(),t.addClass("is-locked"),n.showCancel&&t.find(".fileinput-cancel").show(),n.showPause&&t.find(".fileinput-pause").show(),n._raise("filelock",[n.fileManager.stack,n._getExtraData()]),n.$element},unlock:function(n){var t=this,i=t.$container;return n===undefined&&(n=!0),t.enable(),i.removeClass("is-locked"),t.showCancel&&i.find(".fileinput-cancel").hide(),t.showPause&&i.find(".fileinput-pause").hide(),n&&t._resetFileStack(),t._raise("fileunlock",[t.fileManager.stack,t._getExtraData()]),t.$element},resume:function(){var n=this,t=!1,i=n.$progress,r=n.resumableManager;return n.enableResumableUpload?(n.paused?i.html(n.progressPauseTemplate.setTokens({percent:101,status:n.msgUploadResume,stats:""})):t=!0,n.paused=!1,t&&i.html(n.progressInfoTemplate.setTokens({percent:101,status:n.msgUploadBegin,stats:""})),setTimeout(function(){r.upload()},n.processDelay),n.$element):n.$element},pause:function(){var t=this,i=t.resumableManager,u=t.ajaxRequests,f=u.length,r,e=i.getProgress(),o=t.fileActionSettings;if(!t.enableResumableUpload)return t.$element;if(i.chunkIntervalId&&clearInterval(i.chunkIntervalId),t.ajaxQueueIntervalId&&clearInterval(t.ajaxQueueIntervalId),t._raise("fileuploadpaused",[t.fileManager,i]),f>0)for(r=0;r<f;r+=1)t.paused=!0,u[r].abort();return t.showPreview&&t._getThumbs().each(function(){var i=n(this),u=i.attr("data-fileid"),f=t._getLayoutTemplate("stats"),r,s=i.find(".file-upload-indicator");i.removeClass("file-uploading");s.attr("title")===o.indicatorLoadingTitle&&(t._setThumbStatus(i,"Paused"),r=f.setTokens({pendingTime:t.msgPaused,uploadSpeed:""}),t.paused=!0,t._setProgress(e,i.find(".file-thumb-progress"),e+"%",r));t.fileManager.getFile(u)||i.find(".kv-file-remove").removeClass("disabled").removeAttr("disabled")}),t._setProgress(101,t.$progress,t.msgPaused),t.$element},cancel:function(){var t=this,u=t.ajaxRequests,i=t.resumableManager,f=u.length,r;if(t.enableResumableUpload&&i.chunkIntervalId?(clearInterval(i.chunkIntervalId),i.reset(),t._raise("fileuploadcancelled",[t.fileManager,i])):t._raise("fileuploadcancelled",[t.fileManager]),t.ajaxQueueIntervalId&&clearInterval(t.ajaxQueueIntervalId),t._initAjax(),f>0)for(r=0;r<f;r+=1)t.cancelling=!0,u[r].abort();return t._getThumbs().each(function(){var i=n(this),u=i.attr("data-fileid"),r=i.find(".file-thumb-progress");i.removeClass("file-uploading");t._setProgress(0,r);r.hide();t.fileManager.getFile(u)||(i.find(".kv-file-upload").removeClass("disabled").removeAttr("disabled"),i.find(".kv-file-remove").removeClass("disabled").removeAttr("disabled"));t.unlock()}),setTimeout(function(){t._setProgressCancelled()},t.processDelay),t.$element},clear:function(){var i=this,r;if(i._raise("fileclear"))return i.$btnUpload.removeAttr("disabled"),i._getThumbs().find("video,audio,img").each(function(){t.cleanMemory(n(this))}),i._clearFileInput(),i._resetUpload(),i.clearFileStack(),i._resetErrors(!0),i._hasInitialPreview()?(i._showFileIcon(),i._resetPreview(),i._initPreviewActions(),i.$container.removeClass("file-input-new")):(i._getThumbs().each(function(){i._clearObjects(n(this))}),i.isAjaxUpload&&(i.previewCache.data={}),i.$preview.html(""),r=!i.overwriteInitial&&i.initialCaption.length>0?i.initialCaption:"",i.$caption.attr("title","").val(r),t.addCss(i.$container,"file-input-new"),i._validateDefaultPreview()),i.$container.find(t.FRAMES).length===0&&(i._initCaption()||i.$captionContainer.removeClass("icon-visible")),i._hideFileIcon(),i.$captionContainer.focus(),i._setFileDropZoneTitle(),i._raise("filecleared"),i.$element},reset:function(){var n=this;if(n._raise("filereset"))return n.lastProgress=0,n._resetPreview(),n.$container.find(".fileinput-filename").text(""),t.addCss(n.$container,"file-input-new"),(n.getFrames().length||n.dropZoneEnabled)&&n.$container.removeClass("file-input-new"),n.clearFileStack(),n._setFileDropZoneTitle(),n.$element},disable:function(){var n=this;return n.isDisabled=!0,n._raise("filedisabled"),n.$element.attr("disabled","disabled"),n.$container.find(".kv-fileinput-caption").addClass("file-caption-disabled"),n.$container.find(".fileinput-remove, .fileinput-upload, .file-preview-frame button").attr("disabled",!0),t.addCss(n.$container.find(".btn-file"),"disabled"),n._initDragDrop(),n.$element},enable:function(){var n=this;return n.isDisabled=!1,n._raise("fileenabled"),n.$element.removeAttr("disabled"),n.$container.find(".kv-fileinput-caption").removeClass("file-caption-disabled"),n.$container.find(".fileinput-remove, .fileinput-upload, .file-preview-frame button").removeAttr("disabled"),n.$container.find(".btn-file").removeClass("disabled"),n._initDragDrop(),n.$element},upload:function(){var i=this,u=i.fileManager,f=u.count(),r,e,o,s=!n.isEmptyObject(i._getExtraData());if(i.isAjaxUpload&&!i.isDisabled&&i._isFileSelectionValid(f)){if(i.lastProgress=0,i._resetUpload(),f===0&&!s){i._showFileError(i.msgUploadEmpty);return}if(i.cancelling=!1,i.$progress.show(),i.lock(),o=u.count(),f===0&&s){i._setProgress(2);i._uploadExtraOnly();return}if(i.enableResumableUpload)return i.resume();if(i.uploadAsync||i.enableResumableUpload){for(e=i._getOutData(null),i._raise("filebatchpreupload",[e]),i.fileBatchCompleted=!1,i.uploadCache={content:[],config:[],tags:[],append:!0},r=0;r<o;r++)i.uploadCache.content[r]=null,i.uploadCache.config[r]=null,i.uploadCache.tags[r]=null;i.$preview.find(".file-preview-initial").removeClass(t.SORT_CSS);i._initSortable();i.cacheInitialPreview=i.getPreview()}if(i._setProgress(2),i.hasInitData=!1,i.uploadAsync){r=0;n.each(u.stack,function(n){i._uploadSingle(r,n,!0);r++});return}return i._uploadBatch(),i.$element}},destroy:function(){var t=this,r=t.$form,u=t.$container,f=t.$element,i=t.namespace;return n(document).off(i),n(window).off(i),r&&r.length&&r.off(i),t.isAjaxUpload&&t._clearFileInput(),t._cleanup(),t._initPreviewCache(),f.insertBefore(u).off(i).removeData(),u.off().remove(),f},refresh:function(i){var r=this,u=r.$element;return i=typeof i!="object"||t.isEmpty(i)?r.options:n.extend(!0,{},r.options,i),r._init(i,!0),r._listen(),u},zoom:function(n){var i=this,u=i._getFrame(n),r=i.$modal;u&&(t.initModal(r),r.html(i._getModalContent()),i._setZoomContent(u),r.modal("show"),i._initZoomButtons())},getExif:function(n){var i=this,t=i._getFrame(n);return t&&t.data("exif")||null},getFrames:function(i){var u=this,r;return i=i||"",r=u.$preview.find(t.FRAMES+i),u.reversePreviewOrder&&(r=n(r.get().reverse())),r},getPreview:function(){var n=this;return{content:n.initialPreview,config:n.initialPreviewConfig,tags:n.initialPreviewThumbTags}}};n.fn.fileinput=function(r){if(t.hasFileAPISupport()||t.isIE(9)){var f=Array.apply(null,arguments),u=[];f.shift();this.each(function(){var e=n(this),o=e.data("fileinput"),s=typeof r=="object"&&r,c=s.theme||e.data("theme"),l={},a={},h=s.language||e.data("language")||n.fn.fileinput.defaults.language||"en",v;o||(c&&(a=n.fn.fileinputThemes[c]||{}),h==="en"||t.isEmpty(n.fn.fileinputLocales[h])||(l=n.fn.fileinputLocales[h]||{}),v=n.extend(!0,{},n.fn.fileinput.defaults,a,n.fn.fileinputLocales.en,l,s,e.data()),o=new i(this,v),e.data("fileinput",o));typeof r=="string"&&u.push(o[r].apply(o,f))});switch(u.length){case 0:return this;case 1:return u[0];default:return u}}};n.fn.fileinput.defaults={language:"en",showCaption:!0,showBrowse:!0,showPreview:!0,showRemove:!0,showUpload:!0,showUploadStats:!0,showCancel:null,showPause:null,showClose:!0,showUploadedThumbs:!0,browseOnZoneClick:!1,autoReplace:!1,autoOrientImage:function(){var n=window.navigator.userAgent,t=!!n.match(/WebKit/i),i=!!n.match(/iP(od|ad|hone)/i),r=i&&t&&!n.match(/CriOS/i);return!r},autoOrientImageInitial:!0,required:!1,rtl:!1,hideThumbnailContent:!1,encodeUrl:!0,generateFileId:null,previewClass:"",captionClass:"",frameClass:"krajee-default",mainClass:"file-caption-main",mainTemplate:null,purifyHtml:!0,fileSizeGetter:null,initialCaption:"",initialPreview:[],initialPreviewDelimiter:"*$$*",initialPreviewAsData:!1,initialPreviewFileType:"image",initialPreviewConfig:[],initialPreviewThumbTags:[],previewThumbTags:{},initialPreviewShowDelete:!0,initialPreviewDownloadUrl:"",removeFromPreviewOnError:!1,deleteUrl:"",deleteExtraData:{},overwriteInitial:!0,sanitizeZoomCache:function(t){var i=n(document.createElement("div")).append(t);return i.find("input,select,.file-thumbnail-footer").remove(),i.html()},previewZoomButtonIcons:{prev:'<i class="glyphicon glyphicon-triangle-left"><\/i>',next:'<i class="glyphicon glyphicon-triangle-right"><\/i>',toggleheader:'<i class="glyphicon glyphicon-resize-vertical"><\/i>',fullscreen:'<i class="glyphicon glyphicon-fullscreen"><\/i>',borderless:'<i class="glyphicon glyphicon-resize-full"><\/i>',close:'<i class="glyphicon glyphicon-remove"><\/i>'},previewZoomButtonClasses:{prev:"btn btn-navigate",next:"btn btn-navigate",toggleheader:"btn btn-sm btn-kv btn-default btn-outline-secondary",fullscreen:"btn btn-sm btn-kv btn-default btn-outline-secondary",borderless:"btn btn-sm btn-kv btn-default btn-outline-secondary",close:"btn btn-sm btn-kv btn-default btn-outline-secondary"},previewTemplates:{},previewContentTemplates:{},preferIconicPreview:!1,preferIconicZoomPreview:!1,allowedFileTypes:null,allowedFileExtensions:null,allowedPreviewTypes:undefined,allowedPreviewMimeTypes:null,allowedPreviewExtensions:null,disabledPreviewTypes:undefined,disabledPreviewExtensions:["msi","exe","com","zip","rar","app","vb","scr"],disabledPreviewMimeTypes:null,defaultPreviewContent:null,customLayoutTags:{},customPreviewTags:{},previewFileIcon:'<i class="glyphicon glyphicon-file"><\/i>',previewFileIconClass:"file-other-icon",previewFileIconSettings:{},previewFileExtSettings:{},buttonLabelClass:"hidden-xs",browseIcon:'<i class="glyphicon glyphicon-folder-open"><\/i>&nbsp;',browseClass:"btn btn-primary",removeIcon:'<i class="glyphicon glyphicon-trash"><\/i>',removeClass:"btn btn-default btn-secondary",cancelIcon:'<i class="glyphicon glyphicon-ban-circle"><\/i>',cancelClass:"btn btn-default btn-secondary",pauseIcon:'<i class="glyphicon glyphicon-pause"><\/i>',pauseClass:"btn btn-default btn-secondary",uploadIcon:'<i class="glyphicon glyphicon-upload"><\/i>',uploadClass:"btn btn-default btn-secondary",uploadUrl:null,uploadUrlThumb:null,uploadAsync:!0,uploadParamNames:{chunkCount:"chunkCount",chunkIndex:"chunkIndex",chunkSize:"chunkSize",chunkSizeStart:"chunkSizeStart",chunksUploaded:"chunksUploaded",fileBlob:"fileBlob",fileId:"fileId",fileName:"fileName",fileRelativePath:"fileRelativePath",fileSize:"fileSize",retryCount:"retryCount"},maxAjaxThreads:5,processDelay:100,queueDelay:10,progressDelay:0,enableResumableUpload:!1,resumableUploadOptions:{fallback:null,testUrl:null,chunkSize:2048,maxThreads:4,maxRetries:3,showErrorLog:!0},uploadExtraData:{},zoomModalHeight:480,minImageWidth:null,minImageHeight:null,maxImageWidth:null,maxImageHeight:null,resizeImage:!1,resizePreference:"width",resizeQuality:.92,resizeDefaultImageType:"image/jpeg",resizeIfSizeMoreThan:0,minFileSize:0,maxFileSize:0,maxFilePreviewSize:25600,minFileCount:0,maxFileCount:0,validateInitialCount:!1,msgValidationErrorClass:"text-danger",msgValidationErrorIcon:'<i class="glyphicon glyphicon-exclamation-sign"><\/i> ',msgErrorClass:"file-error-message",progressThumbClass:"progress-bar progress-bar-striped active",progressClass:"progress-bar bg-success progress-bar-success progress-bar-striped active",progressInfoClass:"progress-bar bg-info progress-bar-info progress-bar-striped active",progressCompleteClass:"progress-bar bg-success progress-bar-success",progressPauseClass:"progress-bar bg-primary progress-bar-primary progress-bar-striped active",progressErrorClass:"progress-bar bg-danger progress-bar-danger",progressUploadThreshold:99,previewFileType:"image",elCaptionContainer:null,elCaptionText:null,elPreviewContainer:null,elPreviewImage:null,elPreviewStatus:null,elErrorContainer:null,errorCloseButton:t.closeButton("kv-error-close"),slugCallback:null,dropZoneEnabled:!0,dropZoneTitleClass:"file-drop-zone-title",fileActionSettings:{},otherActionButtons:"",textEncoding:"UTF-8",ajaxSettings:{},ajaxDeleteSettings:{},showAjaxErrorDetails:!0,mergeAjaxCallbacks:!1,mergeAjaxDeleteCallbacks:!1,retryErrorUploads:!0,reversePreviewOrder:!1,usePdfRenderer:function(){var n=!!window.MSInputMethodContext&&!!document.documentMode;return!!navigator.userAgent.match(/(iPod|iPhone|iPad|Android)/i)||n},pdfRendererUrl:"",pdfRendererTemplate:'<iframe class="kv-preview-data file-preview-pdf" src="{renderer}?file={data}" {style}><\/iframe>'};n.fn.fileinputLocales.en={fileSingle:"file",filePlural:"files",browseLabel:"Browse &hellip;",removeLabel:"Remove",removeTitle:"Clear all unprocessed files",cancelLabel:"Cancel",cancelTitle:"Abort ongoing upload",pauseLabel:"Pause",pauseTitle:"Pause ongoing upload",uploadLabel:"Upload",uploadTitle:"Upload selected files",msgNo:"No",msgNoFilesSelected:"No files selected",msgCancelled:"Cancelled",msgPaused:"Paused",msgPlaceholder:"Select {files}...",msgZoomModalHeading:"Detailed Preview",msgFileRequired:"You must select a file to upload.",msgSizeTooSmall:'File "{name}" (<b>{size} KB<\/b>) is too small and must be larger than <b>{minSize} KB<\/b>.',msgSizeTooLarge:'File "{name}" (<b>{size} KB<\/b>) exceeds maximum allowed upload size of <b>{maxSize} KB<\/b>.',msgFilesTooLess:"You must select at least <b>{n}<\/b> {files} to upload.",msgFilesTooMany:"Number of files selected for upload <b>({n})<\/b> exceeds maximum allowed limit of <b>{m}<\/b>.",msgFileNotFound:'File "{name}" not found!',msgFileSecured:'Security restrictions prevent reading the file "{name}".',msgFileNotReadable:'File "{name}" is not readable.',msgFilePreviewAborted:'File preview aborted for "{name}".',msgFilePreviewError:'An error occurred while reading the file "{name}".',msgInvalidFileName:'Invalid or unsupported characters in file name "{name}".',msgInvalidFileType:'Invalid type for file "{name}". Only "{types}" files are supported.',msgInvalidFileExtension:'Invalid extension for file "{name}". Only "{extensions}" files are supported.',msgFileTypes:{image:"image",html:"HTML",text:"text",video:"video",audio:"audio",flash:"flash",pdf:"PDF",object:"object"},msgUploadAborted:"The file upload was aborted",msgUploadThreshold:"Processing...",msgUploadBegin:"Initializing...",msgUploadEnd:"Done",msgUploadResume:"Resuming upload...",msgUploadEmpty:"No valid data available for upload.",msgUploadError:"Upload Error",msgDeleteError:"Delete Error",msgProgressError:"Error",msgValidationError:"Validation Error",msgLoading:"Loading file {index} of {files} &hellip;",msgProgress:"Loading file {index} of {files} - {name} - {percent}% completed.",msgSelected:"{n} {files} selected",msgFoldersNotAllowed:"Drag & drop files only! {n} folder(s) dropped were skipped.",msgImageWidthSmall:'Width of image file "{name}" must be at least {size} px.',msgImageHeightSmall:'Height of image file "{name}" must be at least {size} px.',msgImageWidthLarge:'Width of image file "{name}" cannot exceed {size} px.',msgImageHeightLarge:'Height of image file "{name}" cannot exceed {size} px.',msgImageResizeError:"Could not get the image dimensions to resize.",msgImageResizeException:"Error while resizing the image.<pre>{errors}<\/pre>",msgAjaxError:"Something went wrong with the {operation} operation. Please try again later!",msgAjaxProgressError:"{operation} failed",msgDuplicateFile:'File "{name}" of same size "{size} KB" has already been selected earlier. Skipping duplicate selection.',msgResumableUploadRetriesExceeded:"Upload aborted beyond <b>{max}<\/b> retries for file <b>{file}<\/b>! Error Details: <pre>{error}<\/pre>",msgPendingTime:"{time} remaining",msgCalculatingTime:"calculating time remaining",ajaxOperations:{deleteThumb:"file delete",uploadThumb:"file upload",uploadBatch:"batch file upload",uploadExtra:"form data upload"},dropZoneTitle:"Drag & drop files here &hellip;",dropZoneClickTitle:"<br>(or click to select {files})",previewZoomButtonTitles:{prev:"View previous file",next:"View next file",toggleheader:"Toggle header",fullscreen:"Toggle full screen",borderless:"Toggle borderless mode",close:"Close detailed preview"}};n.fn.fileinput.Constructor=i;n(document).ready(function(){return})});
/*!
 * FileInput Chinese Translations
 *
 * This file must be loaded after 'fileinput.js'. Patterns in braces '{}', or
 * any HTML markup tags in the messages must not be converted or translated.
 *
 * @see http://github.com/kartik-v/bootstrap-fileinput
 * @author kangqf <kangqingfei@gmail.com>
 *
 * NOTE: this file must be saved in UTF-8 encoding.
 */
(function(n){"use strict";n.fn.fileinputLocales.zh={fileSingle:"文件",filePlural:"个文件",browseLabel:"选择 &hellip;",removeLabel:"移除",removeTitle:"清除选中文件",cancelLabel:"取消",cancelTitle:"取消进行中的上传",pauseLabel:"Pause",pauseTitle:"Pause ongoing upload",uploadLabel:"上传",uploadTitle:"上传选中文件",msgNo:"没有",msgNoFilesSelected:"未选择文件",msgPaused:"Paused",msgCancelled:"取消",msgPlaceholder:"选择 {files}...",msgZoomModalHeading:"详细预览",msgFileRequired:"必须选择一个文件上传.",msgSizeTooSmall:'文件 "{name}" (<b>{size} KB<\/b>) 必须大于限定大小 <b>{minSize} KB<\/b>.',msgSizeTooLarge:'文件 "{name}" (<b>{size} KB<\/b>) 超过了允许大小 <b>{maxSize} KB<\/b>.',msgFilesTooLess:"你必须选择最少 <b>{n}<\/b> {files} 来上传. ",msgFilesTooMany:"选择的上传文件个数 <b>({n})<\/b> 超出最大文件的限制个数 <b>{m}<\/b>.",msgFileNotFound:'文件 "{name}" 未找到!',msgFileSecured:'安全限制，为了防止读取文件 "{name}".',msgFileNotReadable:'文件 "{name}" 不可读.',msgFilePreviewAborted:'取消 "{name}" 的预览.',msgFilePreviewError:'读取 "{name}" 时出现了一个错误.',msgInvalidFileName:'文件名 "{name}" 包含非法字符.',msgInvalidFileType:'不正确的类型 "{name}". 只支持 "{types}" 类型的文件.',msgInvalidFileExtension:'不正确的文件扩展名 "{name}". 只支持 "{extensions}" 的文件扩展名.',msgFileTypes:{image:"image",html:"HTML",text:"text",video:"video",audio:"audio",flash:"flash",pdf:"PDF",object:"object"},msgUploadAborted:"该文件上传被中止",msgUploadThreshold:"处理中...",msgUploadBegin:"正在初始化...",msgUploadEnd:"完成",msgUploadResume:"Resuming upload...",msgUploadEmpty:"无效的文件上传.",msgUploadError:"Upload Error",msgDeleteError:"Delete Error",msgProgressError:"上传出错",msgValidationError:"验证错误",msgLoading:"加载第 {index} 文件 共 {files} &hellip;",msgProgress:"加载第 {index} 文件 共 {files} - {name} - {percent}% 完成.",msgSelected:"{n} {files} 选中",msgFoldersNotAllowed:"只支持拖拽文件! 跳过 {n} 拖拽的文件夹.",msgImageWidthSmall:'图像文件的"{name}"的宽度必须是至少{size}像素.',msgImageHeightSmall:'图像文件的"{name}"的高度必须至少为{size}像素.',msgImageWidthLarge:'图像文件"{name}"的宽度不能超过{size}像素.',msgImageHeightLarge:'图像文件"{name}"的高度不能超过{size}像素.',msgImageResizeError:"无法获取的图像尺寸调整。",msgImageResizeException:"调整图像大小时发生错误。<pre>{errors}<\/pre>",msgAjaxError:"{operation} 发生错误. 请重试!",msgAjaxProgressError:"{operation} 失败",msgDuplicateFile:'File "{name}" of same size "{size} KB" has already been selected earlier. Skipping duplicate selection.',msgResumableUploadRetriesExceeded:"Upload aborted beyond <b>{max}<\/b> retries for file <b>{file}<\/b>! Error Details: <pre>{error}<\/pre>",msgPendingTime:"{time} remaining",msgCalculatingTime:"calculating time remaining",ajaxOperations:{deleteThumb:"删除文件",uploadThumb:"上传文件",uploadBatch:"批量上传",uploadExtra:"表单数据上传"},dropZoneTitle:"拖拽文件到这里 &hellip;<br>支持多文件同时上传",dropZoneClickTitle:"<br>(或点击{files}按钮选择文件)",fileActionSettings:{removeTitle:"删除文件",uploadTitle:"上传文件",downloadTitle:"下载文件",uploadRetryTitle:"重试",zoomTitle:"查看详情",dragTitle:"移动 / 重置",indicatorNewTitle:"没有上传",indicatorSuccessTitle:"上传",indicatorErrorTitle:"上传错误",indicatorPausedTitle:"Upload Paused",indicatorLoadingTitle:"上传 ..."},previewZoomButtonTitles:{prev:"预览上一个文件",next:"预览下一个文件",toggleheader:"缩放",fullscreen:"全屏",borderless:"无边界模式",close:"关闭当前预览"}}})(window.jQuery);