<?php

declare(strict_types=1);

return [
    'APARTMENTS' => [
        'insertFileMask' => '/^AS_APARTMENTS_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_APARTMENTS_\\d+_.*\\.XML$/',
        'description' => 'Сведения по помещениям',
        'xmlPath' => '/APARTMENTS/APARTMENT',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уникальный идентификатор записи. Ключевое поле',
                'length' => 19,
                'isPrimary' => true,
            ],
            'OBJECTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор объекта типа INTEGER',
                'length' => 19,
            ],
            'OBJECTGUID' => [
                'type' => 'string',
                'subType' => 'uuid',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор адресного объекта типа UUID',
                'length' => 36,
            ],
            'CHANGEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'ID изменившей транзакции',
                'length' => 19,
            ],
            'NUMBER' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Номер комнаты',
                'length' => 50,
            ],
            'APARTTYPE' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Тип комнаты',
                'length' => 2,
            ],
            'OPERTYPEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус действия над записью – причина появления записи',
                'length' => 2,
            ],
            'PREVID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с предыдущей исторической записью',
                'length' => 19,
            ],
            'NEXTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с последующей исторической записью',
                'length' => 19,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTUAL' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус актуальности адресного объекта ФИАС',
                'length' => 1,
            ],
            'ISACTIVE' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Признак действующего адресного объекта',
                'length' => 1,
            ],
        ],
    ],
    'ADDR_OBJ_DIVISION' => [
        'insertFileMask' => '/^AS_ADDR_OBJ_DIVISION_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_ADDR_OBJ_DIVISION_\\d+_.*\\.XML$/',
        'description' => 'Сведения по операциям переподчинения',
        'xmlPath' => '/ITEMS/ITEM',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уникальный идентификатор записи. Ключевое поле',
                'length' => 19,
                'isPrimary' => true,
            ],
            'PARENTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Родительский ID',
                'length' => 19,
            ],
            'CHILDID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Дочерний ID',
                'length' => 19,
            ],
            'CHANGEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'ID изменившей транзакции',
            ],
        ],
    ],
    'NORMATIVE_DOCS_TYPES' => [
        'insertFileMask' => '/^AS_NORMATIVE_DOCS_TYPES_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_NORMATIVE_DOCS_TYPES_\\d+_.*\\.XML$/',
        'description' => 'Сведения по типам нормативных документов',
        'xmlPath' => '/NDOCTYPES/NDOCTYPE',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Идентификатор записи',
                'isPrimary' => true,
            ],
            'NAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Наименование',
                'length' => 500,
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата начала действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата окончания действия записи',
            ],
        ],
    ],
    'ROOM_TYPES' => [
        'insertFileMask' => '/^AS_ROOM_TYPES_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_ROOM_TYPES_\\d+_.*\\.XML$/',
        'description' => 'Сведения по типам комнат',
        'xmlPath' => '/ROOMTYPES/ROOMTYPE',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Идентификатор типа (ключ)',
                'length' => 10,
                'isPrimary' => true,
            ],
            'NAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Наименование',
                'length' => 100,
            ],
            'SHORTNAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Краткое наименование',
                'length' => 50,
            ],
            'DESC' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Описание',
                'length' => 250,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTIVE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус активности',
            ],
        ],
    ],
    'OBJECT_LEVELS' => [
        'insertFileMask' => '/^AS_OBJECT_LEVELS_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_OBJECT_LEVELS_\\d+_.*\\.XML$/',
        'description' => 'Сведения по уровням адресных объектов',
        'xmlPath' => '/OBJECTLEVELS/OBJECTLEVEL',
        'fields' => [
            'LEVEL' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уникальный идентификатор записи. Ключевое поле. Номер уровня объекта',
                'length' => 2,
                'isPrimary' => true,
            ],
            'NAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Наименование',
                'length' => 250,
            ],
            'SHORTNAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Краткое наименование',
                'length' => 50,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTIVE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Признак действующего адресного объекта',
            ],
        ],
    ],
    'NORMATIVE_DOCS_KINDS' => [
        'insertFileMask' => '/^AS_NORMATIVE_DOCS_KINDS_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_NORMATIVE_DOCS_KINDS_\\d+_.*\\.XML$/',
        'description' => 'Сведения по видам нормативных документов',
        'xmlPath' => '/NDOCKINDS/NDOCKIND',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Идентификатор записи',
                'isPrimary' => true,
            ],
            'NAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Наименование',
                'length' => 500,
            ],
        ],
    ],
    'ROOMS' => [
        'insertFileMask' => '/^AS_ROOMS_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_ROOMS_\\d+_.*\\.XML$/',
        'description' => 'Сведения по комнатам',
        'xmlPath' => '/ROOMS/ROOM',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уникальный идентификатор записи. Ключевое поле',
                'length' => 19,
                'isPrimary' => true,
            ],
            'OBJECTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор объекта типа INTEGER',
                'length' => 19,
            ],
            'OBJECTGUID' => [
                'type' => 'string',
                'subType' => 'uuid',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор адресного объекта типа UUID',
                'length' => 36,
            ],
            'CHANGEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'ID изменившей транзакции',
                'length' => 19,
            ],
            'NUMBER' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Номер комнаты или офиса',
                'length' => 50,
            ],
            'ROOMTYPE' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Тип комнаты или офиса',
            ],
            'OPERTYPEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус действия над записью – причина появления записи',
            ],
            'PREVID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с предыдущей исторической записью',
                'length' => 19,
            ],
            'NEXTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с последующей исторической записью',
                'length' => 19,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTUAL' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус актуальности адресного объекта ФИАС',
            ],
            'ISACTIVE' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Признак действующего адресного объекта',
            ],
        ],
    ],
    'APARTMENT_TYPES' => [
        'insertFileMask' => '/^AS_APARTMENT_TYPES_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_APARTMENT_TYPES_\\d+_.*\\.XML$/',
        'description' => 'Сведения по типам помещений',
        'xmlPath' => '/APARTMENTTYPES/APARTMENTTYPE',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Идентификатор типа (ключ)',
                'length' => 10,
                'isPrimary' => true,
            ],
            'NAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Наименование',
                'length' => 50,
            ],
            'SHORTNAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Краткое наименование',
                'length' => 50,
            ],
            'DESC' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Описание',
                'length' => 250,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTIVE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус активности',
            ],
        ],
    ],
    'ADDR_OBJ_TYPES' => [
        'insertFileMask' => '/^AS_ADDR_OBJ_TYPES_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_ADDR_OBJ_TYPES_\\d+_.*\\.XML$/',
        'description' => 'Сведения по типам адресных объектов',
        'xmlPath' => '/ADDRESSOBJECTTYPES/ADDRESSOBJECTTYPE',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Идентификатор записи',
                'length' => 10,
                'isPrimary' => true,
            ],
            'LEVEL' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уровень адресного объекта',
            ],
            'SHORTNAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Краткое наименование типа объекта',
                'length' => 50,
            ],
            'NAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Полное наименование типа объекта',
                'length' => 250,
            ],
            'DESC' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Описание',
                'length' => 250,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTIVE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус активности',
            ],
        ],
    ],
    'STEADS' => [
        'insertFileMask' => '/^AS_STEADS_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_STEADS_\\d+_.*\\.XML$/',
        'description' => 'Сведения по земельным участкам',
        'xmlPath' => '/STEADS/STEAD',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уникальный идентификатор записи. Ключевое поле',
                'length' => 19,
                'isPrimary' => true,
            ],
            'OBJECTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор объекта типа INTEGER',
                'length' => 19,
            ],
            'OBJECTGUID' => [
                'type' => 'string',
                'subType' => 'uuid',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор адресного объекта типа UUID',
                'length' => 36,
            ],
            'CHANGEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'ID изменившей транзакции',
                'length' => 19,
            ],
            'NUMBER' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Номер земельного участка',
                'length' => 250,
            ],
            'OPERTYPEID' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус действия над записью – причина появления записи',
                'length' => 2,
            ],
            'PREVID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с предыдущей исторической записью',
                'length' => 19,
            ],
            'NEXTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с последующей исторической записью',
                'length' => 19,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTUAL' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус актуальности адресного объекта ФИАС',
            ],
            'ISACTIVE' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Признак действующего адресного объекта',
            ],
        ],
    ],
    'NORMATIVE_DOCS' => [
        'insertFileMask' => '/^AS_NORMATIVE_DOCS_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_NORMATIVE_DOCS_\\d+_.*\\.XML$/',
        'description' => 'Сведения о нормативном документе, являющемся основанием присвоения адресному элементу наименования',
        'xmlPath' => '/NORMDOCS/NORMDOC',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уникальный идентификатор документа',
                'length' => 19,
                'isPrimary' => true,
            ],
            'NAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Наименование документа',
                'length' => 8000,
            ],
            'DATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата документа',
            ],
            'NUMBER' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Номер документа',
                'length' => 150,
            ],
            'TYPE' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Тип документа',
                'length' => 10,
            ],
            'KIND' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Вид документа',
                'length' => 10,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата обновления',
            ],
            'ORGNAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Наименование органа создвшего нормативный документ',
                'length' => 255,
            ],
            'REGNUM' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Номер государственной регистрации',
                'length' => 100,
            ],
            'REGDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => true,
                'description' => 'Дата государственной регистрации',
            ],
            'ACCDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => true,
                'description' => 'Дата вступления в силу нормативного документа',
            ],
            'COMMENT' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Комментарий',
                'length' => 8000,
            ],
        ],
    ],
    'OPERATION_TYPES' => [
        'insertFileMask' => '/^AS_OPERATION_TYPES_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_OPERATION_TYPES_\\d+_.*\\.XML$/',
        'description' => 'Сведения по статусу действия',
        'xmlPath' => '/OPERATIONTYPES/OPERATIONTYPE',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Идентификатор статуса (ключ)',
                'isPrimary' => true,
            ],
            'NAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Наименование',
                'length' => 100,
            ],
            'SHORTNAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Краткое наименование',
                'length' => 100,
            ],
            'DESC' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Описание',
                'length' => 250,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTIVE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус активности',
            ],
        ],
    ],
    'HOUSES' => [
        'insertFileMask' => '/^AS_HOUSES_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_HOUSES_\\d+_.*\\.XML$/',
        'description' => 'Сведения по номерам домов улиц городов и населенных пунктов',
        'xmlPath' => '/HOUSES/HOUSE',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уникальный идентификатор записи. Ключевое поле',
                'length' => 19,
                'isPrimary' => true,
            ],
            'OBJECTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор объекта типа INTEGER',
                'length' => 19,
            ],
            'OBJECTGUID' => [
                'type' => 'string',
                'subType' => 'uuid',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор адресного объекта типа UUID',
                'length' => 36,
            ],
            'CHANGEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'ID изменившей транзакции',
                'length' => 19,
            ],
            'HOUSENUM' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Основной номер дома',
                'length' => 50,
            ],
            'ADDNUM1' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Дополнительный номер дома 1',
                'length' => 50,
            ],
            'ADDNUM2' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Дополнительный номер дома 1',
                'length' => 50,
            ],
            'HOUSETYPE' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Основной тип дома',
            ],
            'ADDTYPE1' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Дополнительный тип дома 1',
            ],
            'ADDTYPE2' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Дополнительный тип дома 2',
            ],
            'OPERTYPEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус действия над записью – причина появления записи',
            ],
            'PREVID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с предыдущей исторической записью',
                'length' => 19,
            ],
            'NEXTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с последующей исторической записью',
                'length' => 19,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTUAL' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус актуальности адресного объекта ФИАС',
            ],
            'ISACTIVE' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Признак действующего адресного объекта',
            ],
        ],
    ],
    'ADM_HIERARCHY' => [
        'insertFileMask' => '/^AS_ADM_HIERARCHY_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_ADM_HIERARCHY_\\d+_.*\\.XML$/',
        'description' => 'Сведения по иерархии в административном делении',
        'xmlPath' => '/ITEMS/ITEM',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уникальный идентификатор записи. Ключевое поле',
                'length' => 19,
                'isPrimary' => true,
            ],
            'OBJECTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор объекта',
                'length' => 19,
            ],
            'PARENTOBJID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор родительского объекта',
                'length' => 19,
            ],
            'CHANGEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'ID изменившей транзакции',
                'length' => 19,
            ],
            'REGIONCODE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Код региона',
                'length' => 4,
            ],
            'AREACODE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Код района',
                'length' => 4,
            ],
            'CITYCODE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Код города',
                'length' => 4,
            ],
            'PLACECODE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Код населенного пункта',
                'length' => 4,
            ],
            'PLANCODE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Код ЭПС',
                'length' => 4,
            ],
            'STREETCODE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Код улицы',
                'length' => 4,
            ],
            'PREVID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с предыдущей исторической записью',
                'length' => 19,
            ],
            'NEXTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с последующей исторической записью',
                'length' => 19,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTIVE' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Признак действующего адресного объекта',
            ],
            'PATH' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Материализованный путь к объекту (полная иерархия)',
            ],
        ],
    ],
    'CARPLACES' => [
        'insertFileMask' => '/^AS_CARPLACES_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_CARPLACES_\\d+_.*\\.XML$/',
        'description' => 'Сведения по машино-местам',
        'xmlPath' => '/CARPLACES/CARPLACE',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уникальный идентификатор записи. Ключевое поле',
                'length' => 19,
                'isPrimary' => true,
            ],
            'OBJECTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор объекта типа INTEGER',
                'length' => 19,
            ],
            'OBJECTGUID' => [
                'type' => 'string',
                'subType' => 'uuid',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор адресного объекта типа UUID',
                'length' => 36,
            ],
            'CHANGEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'ID изменившей транзакции',
                'length' => 19,
            ],
            'NUMBER' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Номер машиноместа',
                'length' => 50,
            ],
            'OPERTYPEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус действия над записью – причина появления записи',
            ],
            'PREVID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с предыдущей исторической записью',
                'length' => 19,
            ],
            'NEXTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с последующей исторической записью',
                'length' => 19,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTUAL' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус актуальности адресного объекта ФИАС',
            ],
            'ISACTIVE' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Признак действующего адресного объекта',
            ],
        ],
    ],
    'CHANGE_HISTORY' => [
        'fields' => [
            'CHANGEID' => [
                'isPrimary' => true,
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'ID изменившей транзакции',
                'length' => 19,
            ],
            'OBJECTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уникальный ID объекта',
                'length' => 19,
            ],
            'ADROBJECTID' => [
                'type' => 'string',
                'subType' => 'uuid',
                'isNullable' => false,
                'description' => 'Уникальный ID изменившей транзакции (GUID)',
                'length' => 36,
            ],
            'OPERTYPEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Тип операции',
                'length' => 10,
            ],
            'NDOCID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'ID документа',
                'length' => 19,
            ],
            'CHANGEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата изменения',
            ],
        ],
        'insertFileMask' => '/^AS_CHANGE_HISTORY_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_CHANGE_HISTORY_\\d+_.*\\.XML$/',
        'description' => 'Сведения по истории изменений',
        'xmlPath' => '/ITEMS/ITEM',
    ],
    'ADDR_OBJ' => [
        'insertFileMask' => '/^AS_ADDR_OBJ_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_ADDR_OBJ_\\d+_.*\\.XML$/',
        'description' => 'Сведения классификатора адресообразующих элементов',
        'xmlPath' => '/ADDRESSOBJECTS/OBJECT',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уникальный идентификатор записи. Ключевое поле',
                'length' => 19,
                'isPrimary' => true,
            ],
            'OBJECTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор адресного объекта типа INTEGER',
                'length' => 19,
            ],
            'OBJECTGUID' => [
                'type' => 'string',
                'subType' => 'uuid',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор адресного объекта типа UUID',
                'length' => 36,
            ],
            'CHANGEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'ID изменившей транзакции',
                'length' => 19,
            ],
            'NAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Наименование',
                'length' => 250,
            ],
            'TYPENAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Краткое наименование типа объекта',
                'length' => 50,
            ],
            'LEVEL' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уровень адресного объекта',
                'length' => 10,
            ],
            'OPERTYPEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус действия над записью – причина появления записи',
            ],
            'PREVID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с предыдущей исторической записью',
                'length' => 19,
            ],
            'NEXTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с последующей исторической записью',
                'length' => 19,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTUAL' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус актуальности адресного объекта ФИАС',
            ],
            'ISACTIVE' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Признак действующего адресного объекта',
            ],
        ],
    ],
    'PARAM_TYPES' => [
        'insertFileMask' => '/^AS_PARAM_TYPES_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_PARAM_TYPES_\\d+_.*\\.XML$/',
        'description' => 'Сведения по типу параметра',
        'xmlPath' => '/PARAMTYPES/PARAMTYPE',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Идентификатор типа параметра (ключ)',
                'length' => 2,
                'isPrimary' => true,
            ],
            'NAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Наименование',
                'length' => 50,
            ],
            'CODE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Краткое наименование',
                'length' => 50,
            ],
            'DESC' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Описание',
                'length' => 120,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTIVE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус активности',
            ],
        ],
    ],
    'PARAM' => [
        'insertFileMask' => '/^AS_[a-zA-Z_]+_PARAMS_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_[a-zA-Z_]+_PARAMS_.*\\.XML$/',
        'description' => 'Сведения о классификаторе параметров адресообразующих элементов и объектов недвижимости ',
        'xmlPath' => '/PARAMS/PARAM',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Идентификатор записи',
                'length' => 19,
                'isPrimary' => true,
            ],
            'OBJECTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор адресного объекта ',
                'length' => 19,
            ],
            'CHANGEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'ID изменившей транзакции',
                'length' => 19,
            ],
            'CHANGEIDEND' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'ID завершившей транзакции',
                'length' => 19,
            ],
            'TYPEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Тип параметра',
                'length' => 4,
            ],
            'VALUE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Значение параметра',
                'length' => 8000,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата начала действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата окончания действия записи',
            ],
        ],
    ],
    'REESTR_OBJECTS' => [
        'insertFileMask' => '/^AS_REESTR_OBJECTS_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_REESTR_OBJECTS_\\d+_.*\\.XML$/',
        'description' => 'Сведения об адресном элементе в части его идентификаторов',
        'xmlPath' => '/REESTR_OBJECTS/OBJECT',
        'fields' => [
            'OBJECTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уникальный идентификатор объекта',
                'length' => 19,
                'isPrimary' => true,
            ],
            'CREATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата создания',
            ],
            'CHANGEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'ID изменившей транзакции',
                'length' => 19,
            ],
            'LEVELID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уровень объекта',
                'length' => 10,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата обновления',
            ],
            'OBJECTGUID' => [
                'type' => 'string',
                'subType' => 'uuid',
                'isNullable' => false,
                'description' => 'GUID объекта',
                'length' => 36,
            ],
            'ISACTIVE' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Признак действующего объекта (1 - действующий, 0 - не действующий)',
            ],
        ],
    ],
    'HOUSE_TYPES' => [
        'insertFileMask' => '/^AS_HOUSE_TYPES_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_HOUSE_TYPES_\\d+_.*\\.XML$/',
        'description' => 'Сведения по типам домов',
        'xmlPath' => '/HOUSETYPES/HOUSETYPE',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Идентификатор',
                'length' => 10,
                'isPrimary' => true,
            ],
            'NAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Наименование',
                'length' => 50,
            ],
            'SHORTNAME' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Краткое наименование',
                'length' => 50,
            ],
            'DESC' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Описание',
                'length' => 250,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTIVE' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Статус активности',
            ],
        ],
    ],
    'MUN_HIERARCHY' => [
        'insertFileMask' => '/^AS_MUN_HIERARCHY_\\d+_.*\\.XML$/',
        'deleteFileMask' => '/^AS_DEL_MUN_HIERARCHY_\\d+_.*\\.XML$/',
        'description' => 'Сведения по иерархии в муниципальном делении',
        'xmlPath' => '/ITEMS/ITEM',
        'fields' => [
            'ID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Уникальный идентификатор записи. Ключевое поле',
                'length' => 19,
                'isPrimary' => true,
            ],
            'OBJECTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Глобальный уникальный идентификатор адресного объекта ',
                'length' => 19,
            ],
            'PARENTOBJID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор родительского объекта',
                'length' => 19,
            ],
            'CHANGEID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'ID изменившей транзакции',
                'length' => 19,
            ],
            'OKTMO' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Код ОКТМО',
                'length' => 11,
            ],
            'PREVID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с предыдущей исторической записью',
                'length' => 19,
            ],
            'NEXTID' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => true,
                'description' => 'Идентификатор записи связывания с последующей исторической записью',
                'length' => 19,
            ],
            'UPDATEDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Дата внесения (обновления) записи',
            ],
            'STARTDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Начало действия записи',
            ],
            'ENDDATE' => [
                'type' => 'string',
                'subType' => 'date',
                'isNullable' => false,
                'description' => 'Окончание действия записи',
            ],
            'ISACTIVE' => [
                'type' => 'int',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Признак действующего адресного объекта',
            ],
            'PATH' => [
                'type' => 'string',
                'subType' => '',
                'isNullable' => false,
                'description' => 'Материализованный путь к объекту (полная иерархия)',
            ],
        ],
    ],
];
