# Contributing to Volty

All and any contributions, no matter their complexity, are welcome.

All contributions fall under the project's [MIT License](https://github.com/lionkor/Volty/blob/master/LICENSE).

## Contributing Source-Code

1. Fork the repository.

2. Create a new branch for your feature. 

   For example, if you're adding "cool feature", you could make a branch called `add-cool-feature`.

2. Make your changes.
  
   When making changes, please try to follow the general code-style of the project. This means, as a quick run-down: `snake_case` function and variable names, 
   `m_` prefix for private member fields, `PascalCase` for typenames. Use `clang-format` with the `.clang-format` file in the repository for all other formatting.

3. Create a pull-request on [`lionkor/Volty`](https://github.com/lionkor/Volty).
   
   Please include a summary of what you changed, what you're unsure about, and what works/doesn't work. It's okay to pull-request almost-done work,
   if you're unsure oh how to finish it. Once pull-requested, we can all have a discussion on how to maybe complete the work or fix issues.
   
If any questions arise, feel free to write to `development(at)kortlepel.com`.

## Contributing Documentation

Whether code-comments, README/Wiki changes or anything else, documentation is *very* welcome.

For this, fork the repository, create a new branch with a name such as `improve-readme`, and write away! 
Even small grammar/spelling improvements are welcome.

Once you're done, create a pull-request on [`lionkor/Volty`](https://github.com/lionkor/Volty).

## Contributing Ideas

If you have an idea but you're not sure you could implement it by yourself, feel free to open an [issue](https://github.com/lionkor/Volty/issues) explaining what you'd like to see changed, added, removed or improved. 

