using System;
using FluentAssertions;
using Networking.Files.PcapNG;
using Xunit;

namespace Networking.Files.Tests.PcapNGTests.InterfaceStatisticsBlockTests
{
    public class InterfaceStatisticsBlock_Test
    {
        [Fact]
        public void interface_statistics_block()
        {
            var interfaceStatisticsBlock = new InterfaceStatisticsBlock
            {
                IsLittleEndian = true,
                Bytes = new Byte[] {
                    0x05,0x00,0x00,0x00,
                    0x6C,0x00,0x00,0x00,
                    0x00,0x00,0x00,0x00,
                    0x72,0x1D,0x05,0x00,
                    0x34,0xED,0x8E,0xC9,
                    0x01,0x00,0x1C,0x00,
                    0x43,0x6F,0x75,0x6E,
                    0x74,0x65,0x72,0x73,
                    0x20,0x70,0x72,0x6F,
                    0x76,0x69,0x64,0x65,
                    0x64,0x20,0x62,0x79,
                    0x20,0x64,0x75,0x6D,
                    0x70,0x63,0x61,0x70,
                    0x02,0x00,0x08,0x00,
                    0x72,0x1D,0x05,0x00,
                    0x24,0x66,0xE9,0xC8,
                    0x03,0x00,0x08,0x00,
                    0x72,0x1D,0x05,0x00,
                    0x24,0xED,0x8E,0xC9,
                    0x04,0x00,0x08,0x00,
                    0x7C,0x00,0x00,0x00,
                    0x00,0x00,0x00,0x00,
                    0x05,0x00,0x08,0x00,
                    0x00,0x00,0x00,0x00,
                    0x00,0x00,0x00,0x00,
                    0x00,0x00,0x00,0x00,
                    0x6C,0x00,0x00,0x00
                }
            };

            interfaceStatisticsBlock.Should().NotBeAssignableTo<IPacket>();
            interfaceStatisticsBlock.IsPacket.Should().Be(false);
            interfaceStatisticsBlock.TotalLength.Should().Be(0x6c);
            interfaceStatisticsBlock.InterfaceId.Should().Be(0);
        }
    }
}
