//! `SeaORM` Entity, @generated by sea-orm-codegen 1.1.3

use sea_orm::entity::prelude::*;
use serde::{Deserialize, Serialize};

#[derive(Copy, Clone, Default, Debug, DeriveEntity)]
pub struct Entity;

impl EntityName for Entity {
    fn table_name(&self) -> &str {
        "sys_oper_log"
    }
}

#[derive(Clone, Debug, PartialEq, DeriveModel, DeriveActiveModel, Eq, Serialize, Deserialize)]
pub struct Model {
    pub oper_id: String,
    pub time_id: i64,
    pub title: String,
    pub business_type: String,
    pub method: String,
    pub request_method: String,
    pub operator_type: String,
    pub oper_name: String,
    pub dept_name: String,
    pub oper_url: String,
    pub oper_ip: String,
    pub oper_location: String,
    pub oper_param: String,
    pub path_param: String,
    pub json_result: String,
    pub status: String,
    pub error_msg: String,
    pub duration: i64,
    pub oper_time: DateTime,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveColumn)]
pub enum Column {
    OperId,
    TimeId,
    Title,
    BusinessType,
    Method,
    RequestMethod,
    OperatorType,
    OperName,
    DeptName,
    OperUrl,
    OperIp,
    OperLocation,
    OperParam,
    PathParam,
    JsonResult,
    Status,
    ErrorMsg,
    Duration,
    OperTime,
}

#[derive(Copy, Clone, Debug, EnumIter, DerivePrimaryKey)]
pub enum PrimaryKey {
    OperId,
}

impl PrimaryKeyTrait for PrimaryKey {
    type ValueType = String;
    fn auto_increment() -> bool {
        false
    }
}

#[derive(Copy, Clone, Debug, EnumIter)]
pub enum Relation {}

impl ColumnTrait for Column {
    type EntityName = Entity;
    fn def(&self) -> ColumnDef {
        match self {
            Self::OperId => ColumnType::String(StringLen::N(32u32)).def(),
            Self::TimeId => ColumnType::BigInteger.def(),
            Self::Title => ColumnType::String(StringLen::N(50u32)).def(),
            Self::BusinessType => ColumnType::Char(Some(1u32)).def(),
            Self::Method => ColumnType::String(StringLen::N(100u32)).def(),
            Self::RequestMethod => ColumnType::String(StringLen::N(10u32)).def(),
            Self::OperatorType => ColumnType::Char(Some(1u32)).def(),
            Self::OperName => ColumnType::String(StringLen::N(50u32)).def(),
            Self::DeptName => ColumnType::String(StringLen::N(50u32)).def(),
            Self::OperUrl => ColumnType::String(StringLen::N(5000u32)).def(),
            Self::OperIp => ColumnType::String(StringLen::N(50u32)).def(),
            Self::OperLocation => ColumnType::String(StringLen::N(255u32)).def(),
            Self::OperParam => ColumnType::Text.def(),
            Self::PathParam => ColumnType::Text.def(),
            Self::JsonResult => ColumnType::custom("LONGTEXT").def(),
            Self::Status => ColumnType::Char(Some(1u32)).def(),
            Self::ErrorMsg => ColumnType::String(StringLen::N(2000u32)).def(),
            Self::Duration => ColumnType::BigInteger.def(),
            Self::OperTime => ColumnType::DateTime.def(),
        }
    }
}

impl RelationTrait for Relation {
    fn def(&self) -> RelationDef {
        panic!("No RelationDef")
    }
}

impl ActiveModelBehavior for ActiveModel {}
