//! `SeaORM` Entity, @generated by sea-orm-codegen 1.1.3

use sea_orm::entity::prelude::*;
use serde::{Deserialize, Serialize};

#[derive(Copy, Clone, Default, Debug, DeriveEntity)]
pub struct Entity;

impl EntityName for Entity {
    fn table_name(&self) -> &str {
        "sys_job_log"
    }
}

#[derive(Clone, Debug, PartialEq, DeriveModel, DeriveActiveModel, Eq, Serialize, Deserialize)]
pub struct Model {
    pub job_log_id: String,
    pub job_id: String,
    pub lot_id: i64,
    pub lot_order: i64,
    pub job_name: String,
    pub job_group: String,
    pub invoke_target: String,
    pub job_params: Option<String>,
    pub job_message: Option<String>,
    pub status: String,
    pub exception_info: Option<String>,
    pub is_once: Option<String>,
    pub created_at: DateTime,
    pub elapsed_time: i64,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveColumn)]
pub enum Column {
    JobLogId,
    JobId,
    LotId,
    LotOrder,
    JobName,
    JobGroup,
    InvokeTarget,
    JobParams,
    JobMessage,
    Status,
    ExceptionInfo,
    IsOnce,
    CreatedAt,
    ElapsedTime,
}

#[derive(Copy, Clone, Debug, EnumIter, DerivePrimaryKey)]
pub enum PrimaryKey {
    JobLogId,
}

impl PrimaryKeyTrait for PrimaryKey {
    type ValueType = String;
    fn auto_increment() -> bool {
        false
    }
}

#[derive(Copy, Clone, Debug, EnumIter)]
pub enum Relation {}

impl ColumnTrait for Column {
    type EntityName = Entity;
    fn def(&self) -> ColumnDef {
        match self {
            Self::JobLogId => ColumnType::String(StringLen::N(32u32)).def(),
            Self::JobId => ColumnType::String(StringLen::N(32u32)).def(),
            Self::LotId => ColumnType::BigInteger.def(),
            Self::LotOrder => ColumnType::BigInteger.def(),
            Self::JobName => ColumnType::String(StringLen::N(64u32)).def(),
            Self::JobGroup => ColumnType::String(StringLen::N(64u32)).def(),
            Self::InvokeTarget => ColumnType::String(StringLen::N(500u32)).def(),
            Self::JobParams => ColumnType::String(StringLen::N(500u32)).def().null(),
            Self::JobMessage => ColumnType::String(StringLen::N(500u32)).def().null(),
            Self::Status => ColumnType::Char(Some(1u32)).def(),
            Self::ExceptionInfo => ColumnType::String(StringLen::N(2000u32)).def().null(),
            Self::IsOnce => ColumnType::Char(Some(1u32)).def().null(),
            Self::CreatedAt => ColumnType::DateTime.def(),
            Self::ElapsedTime => ColumnType::BigInteger.def(),
        }
    }
}

impl RelationTrait for Relation {
    fn def(&self) -> RelationDef {
        panic!("No RelationDef")
    }
}

impl ActiveModelBehavior for ActiveModel {}
