<p align="center">
  <img src='data/logo.svg' />
  <br/>
  <span size="30">Poem-Admin</span>
  <br>
   <a href="./README.md"><span>中文</span></a>   |    <a href="./README_EN.md"><span>english</span></a>
</p>

## Introduction

An Admin panel build with [axum](https://github.com/tokio-rs/axum)/[poem](https://github.com/poem-web/poem),[sea-orm](https://github.com/SeaQL/sea-orm),[vue3](https://github.com/vuejs/core) etc.

## open-api-version: [branch-openapi](https://github.com/lingdu1234/axum_admin/tree/axum-openapi)


## front-end:     
https://github.com/lingdu1234/IUI314


## Preview：
[iui314.vercel.app](https://iui314.vercel.app/#/)
[preview iui314preview](https://iui314preview.iu1314.top/)

## Completed

- [x] User management：The user is the operator of the system panel. This module is used to configure system users。

- [x] Department management：Configure the  organization (company, department, and group), display data permissions in a tree structure。

- [x] Post management：Set the position of a system user。

- [x] Menu management：Configure system menus, operation permissions,  button permissions, and log etc。

- [x] Role management：assignment of role's Permissions。

- [x] Dictionary management：Maintenance of some relatively fixed data frequently used in the system。

- [x] Login-log：the log of user login behavior。

- [x] User online ：Monitor the users is online。

- [x] Scheduled task：Add modify delete  tasks,also provide the log of the tasks。

- [x] Role-change: change the Permissions by change user's role。

- [x] Data-Permissions：all-permissions，only-department-permissions，department-permissions-and-the-department-is-undert-your-department，Custom-permissions，permissions of yourself (five modes)

- [x] department-change：an user can set a lot of department ,but one is enabled,can be changed,and the permissions is changed by change department；

- [x] System monitoring: a simple monitor of system information；

- [x] Data cache: according to api cache data, divided into public cache (everyone's cache data is consistent, used for public data cache) and personal cache (api cache of different data of different users of the same api), api is associated together through database name. When there is data update, the associated api cache data is cleared, cache time expires, cache data is cleared.

- [x] Operation log: set the logging level of each api in the menu, which is divided into file recording, database recording, and recording at the same time, not recording several modes, and configuring separately according to different api

- [x] front-end permissions management: routes are dynamically generated by the back-end return route; the front-end button-level permissions are uniformly controlled by the back-end return permission flag



## Note

1. The combination of department switching, role switching and data permissions can achieve a weird combination of permissions.


## DataBase migration
1. install tools 'sea-orm cli' : `cargo install sea-orm-cli`
2. set the database url at .env file
3. run：`sea-orm-cli migrate up`

* reapply all migrations：`sea-orm-cli migrate fresh`
* Rollback last applied migrations：`sea-orm-cli migrate down`
* MORE：[https://www.sea-ql.org/SeaORM/docs/migration/running-migration](https://www.sea-ql.org/SeaORM/docs/migration/running-migration)
