# BeeNote - Full stack CRUD web application built with Next.js

***Tech stack: Next.js + Tailwind + DaisyUI + Tiptap + PocketBase + AWS SES + ChatGPT***

BeeNote is a web application for language learning, showcasing several open source web dev libraries including Next.js, DaisyUI and PocketBase. 

<img src="screenshot.png" style="zoom:80%;" />

## Features

- [app directory](https://beta.nextjs.org/docs/routing/fundamentals#the-app-directory) introduced in next.js 13 for routing.
- CRUD operations for user accounts and contents.
- Audio recording and file uploading.
- [TailwindCSS](https://tailwindcss.com/) and [DaisyUI](https://daisyui.com/) for styling.
- Rich text editor built with [Tiptap](https://tiptap.dev/).
- [PocketBase](https://pocketbase.io/) for database and user authentication.
- [AWS SES](https://aws.amazon.com/ses/) for email sending.
- [ChatGPT](https://platform.openai.com/docs/introduction) for AI writing.
- Dark theme support.

For more details see this [blog post](https://lifeitech.github.io/posts/beenote/). 

## TODO

- [ ] Add more signup options with OAuth2 providers.
- [ ] Implement batch delete when PocketBase implemented such functionality.
- [ ] Add helpful features like keypad for different languages.
- [ ] Implement drag-and-sort for alphabets and vocabularies.
