/***************************************************************************
 *   Copyright (C) 2020 by Kyle Hayes                                      *
 *   Author Kyle Hayes  kyle.hayes@gmail.com                               *
 *                                                                         *
 * This software is available under either the Mozilla Public License      *
 * version 2.0 or the GNU LGPL version 2 (or later) license, whichever     *
 * you choose.                                                             *
 *                                                                         *
 * MPL 2.0:                                                                *
 *                                                                         *
 *   This Source Code Form is subject to the terms of the Mozilla Public   *
 *   License, v. 2.0. If a copy of the MPL was not distributed with this   *
 *   file, You can obtain one at http://mozilla.org/MPL/2.0/.              *
 *                                                                         *
 *                                                                         *
 * LGPL 2:                                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#pragma once


typedef struct attr_entry_t *attr_entry;
typedef struct attr_t *attr;

attr_entry find_entry(attr a, const char *name);
extern attr attr_create(void);
extern attr attr_create_from_str(const char *attr_str);
extern int attr_set_str(attr attrs, const char *name, const char *val);
extern int attr_set_int(attr attrs, const char *name, int val);
extern int attr_set_float(attr attrs, const char *name, float val);
extern const char *attr_get_str(attr attrs, const char *name, const char *def);
extern int attr_get_int(attr attrs, const char *name, int def);
extern float attr_get_float(attr attrs, const char *name, float def);
extern int attr_remove(attr attrs, const char *name);
extern void attr_destroy(attr attrs);


