---
title: "Bindings"
draft: false
weight: 110
---

GEOS can be accessed from a variety of other languages via bindings to the library.

## Go
* [gogeos](https://github.com/twpayne/go-geos)

## Haskell
* [geos](http://hackage.haskell.org/package/geos)
* [hgeos](http://hackage.haskell.org/package/hgeos)

## Javascript
* [node-geos](https://github.com/kashif/node-geos)

## Julia
* [LibGEOS.jl](https://github.com/JuliaGeo/LibGEOS.jl)

## PHP
* [php-geos](https://git.osgeo.org/gitea/geos/php-geos).
* [GeoPHP](https://geophp.net/geos.html).

## Python
Python bindings are available via:

* [Shapely](http://pypi.python.org/pypi/Shapely)
* [PyGEOS](https://github.com/pygeos/pygeos)
* Calling functions from libgeos_c via Python ctypes
* [GeoPandas](https://github.com/geopandas/geopandas)

## R
* [sf](https://CRAN.R-project.org/package=sf)
* [geos](https://cran.r-project.org/web/packages/geos/index.html)

## Ruby
* [RGeo](https://github.com/rgeo/rgeo).

## Rust
* [geos crate](https://crates.io/crates/geos)

## Swift
* [GeoSwift](https://github.com/GEOSwift/GEOSwift)

Geospatial applications using GEOS include:

## Databases

 * [PostGIS](https://postgis.net)
 * [INGRES](http://www.ingres.com/)
 * [MonetDB](http://monetdb.cwi.nl/)
 * [SpatiaLite](http://www.gaia-gis.it/spatialite/)
 * [CockroachDB](https://github.com/cockroachdb/cockroach)
 * [DuckDB](https://github.com/duckdblabs/duckdb_spatial)

## Applications

 * [GDAL/OGR](https://gdal.org/)
 * [GRASS GIS](https://grass.osgeo.org/)
 * [MapServer](https://mapserver.org/)
 * [MapGuide Open Source](https://www.osgeo.org/projects/mapguide-open-source/)
 * [MapWindow GIS](https://www.mapwindow.org/)
 * [osgEarth](http://osgearth.org)
 * [QGIS](https://qgis.org/)
