---
title: "Version 3.11.0"
type: posts
date: 2022-07-01T00:00:00
draft: false
---

The 3.11.0 release of GEOS is now available [to download]({{< ref "/usage/download" >}}).

This release includes new features for building "concave hulls" for both point and polygon input. For polygon input, the hull will be guaranteed to not cross into the interiors of the input polygons.

The line merger has been enhanced to support a mode that only merges lines which share orientation.

The offset curve algorithm has been updated to be more reliable for different kinds of semi-degenerate inputs, and may output different curves than the previous implementation, for those kinds of inputs. For "normal" inputs, the results should look very much like the old implementation.

As usual, numerous bugs have been fixed, and a few performance improvements discovered and implemented.

 <!--more-->

### New Things

* OffsetCurve ([GH-530](https://github.com/libgeos/geos/issues/530), Paul Ramsey/Martin Davis)
* ConcaveHull ([GH-549](https://github.com/libgeos/geos/issues/549), Paul Ramsey/Martin Davis)
* PolygonHull ([GH-603](https://github.com/libgeos/geos/issues/603), Paul Ramsey/Martin Davis)
* LineMerger directed option ([GH-597](https://github.com/libgeos/geos/issues/597), Sergei Sh)
* CAPI: GEOSHilbertCode ([GH-556](https://github.com/libgeos/geos/issues/556), Brendan Ward)
* CAPI: GEOSGeom_createRectangle ([GH-558](https://github.com/libgeos/geos/issues/558), Brendan Ward)
* CAPI: GEOSGeom_transformXY ([GH-563](https://github.com/libgeos/geos/issues/563), Dan Baston/Brendan Ward)
* CAPI: GEOSRemoveRepeatedPoints ([GH-599](https://github.com/libgeos/geos/issues/599), Paul Ramsey)
* CAPI: GEOSLineMergeDirected ([GH-597](https://github.com/libgeos/geos/issues/597), Sergei Sh)
* CAPI: setFixStructure for WKB/WKT readers to automatically repair
    structural errors in the input ([GH-639](https://github.com/libgeos/geos/issues/639), Paul Ramsey)

### Fixes & Improvements

* Fix unaryUnion to avoid segfault with empty polygon ([GH-501](https://github.com/libgeos/geos/issues/501), Mike Taves)
* Fix SnapRoundingNoder to use tolerance in noding; also fixes GeometryPrecisionReducer ([GH-504](https://github.com/libgeos/geos/issues/504), Sergei Sh)
* Allow direct setting of grid size ([GH-513](https://github.com/libgeos/geos/issues/513), Martin Davis)
* Allow GEOS to be used as a CMake subproject ([GH-518](https://github.com/libgeos/geos/issues/518), Robert Coup)
* Remove .inl inline files in favour of header declaration ([GH-543](https://github.com/libgeos/geos/issues/543), Paul Ramsey)
* Add SnappingNoder seeding (Martin Davis)
* Add OverlayNG area check heuristic ([JTS-812](https://github.com/locationtech/jts/issues/812), Paul Ramsey)
* Fix RelateOp (and intersects predicate) for lines with intersections very near boundary ([GH-570](https://github.com/libgeos/geos/issues/570), Martin Davis)
* Fix IsValidOp to handle repeated node points ([JTS-845](https://github.com/locationtech/jts/issues/845), Martin Davis)
* Fix IsSimpleOp to handle closed LineStrings with repeated endpoints ([JTS-851](https://github.com/locationtech/jts/issues/851), Martin Davis)
* Fix LengthIndexedLine (via LengthLocationMap fix) ([JTS-859](https://github.com/locationtech/jts/issues/859), Martin Davis)
* Fix PolygonHoleJoiner ([JTS-862](https://github.com/locationtech/jts/issues/862), Martin Davis)
* Improve `test_geos_unit` application error checking and reporting
* Fix MinimumDiameter getMinimumRectangle for flat input ([JTS-875](https://github.com/locationtech/jts/issues/875), Martin Davis)
* Fix BufferOp inverted ring check ([JTS-878](https://github.com/locationtech/jts/issues/878), Martin Davis)
* Fix OverlayNG geomunion to avoid lines in result (Martin Davis)


