// FPIOA Implementation

//#include "include/types.h"
//#include "include/fpioa.h"
//#include "include/riscv.h"
//#include "include/sysctl.h"
//#include "include/memlayout.h"

#include <HAL/Drivers/_fpioa.h>

/* Copyright 2018 Canaan Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
volatile fpioa_t *const fpioa = (volatile fpioa_t *)FPIOA_V;

/**
 * @brief      Internal used FPIOA function initialize cell
 *
 *             This is NOT fpioa_io_config_t, can't assign directly
 *
 */
typedef struct _fpioa_assign_t
{
    uint32 ch_sel : 8;
    /* Channel select from 256 input. */
    uint32 ds : 4;
    /* Driving selector. */
    uint32 oe_en : 1;
    /* Static output enable, will AND with OE_INV. */
    uint32 oe_inv : 1;
    /* Invert output enable. */
    uint32 do_sel : 1;
    /* Data output select: 0 for DO, 1 for OE. */
    uint32 do_inv : 1;
    /* Invert the result of data output select (DO_SEL). */
    uint32 pu : 1;
    /* Pull up enable. 0 for nothing, 1 for pull up. */
    uint32 pd : 1;
    /* Pull down enable. 0 for nothing, 1 for pull down. */
    uint32 resv0 : 1;
    /* Reserved bits. */
    uint32 sl : 1;
    /* Slew rate control enable. */
    uint32 ie_en : 1;
    /* Static input enable, will AND with IE_INV. */
    uint32 ie_inv : 1;
    /* Invert input enable. */
    uint32 di_inv : 1;
    /* Invert Data input. */
    uint32 st : 1;
    /* Schmitt trigger. */
    uint32 tie_en : 1;
    /* Input tie enable, 1 for enable, 0 for disable. */
    uint32 tie_val : 1;
    /* Input tie value, 1 for high, 0 for low. */
    uint32 resv1 : 5;
    /* Reserved bits. */
    uint32 pad_di : 1;
    /* Read current PAD's data input. */
} __attribute__((packed, aligned(4))) fpioa_assign_t;

/* Function list */
static const fpioa_assign_t function_config[FUNC_MAX] =
    {
        {.ch_sel = FUNC_JTAG_TCLK,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_JTAG_TDI,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_JTAG_TMS,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_JTAG_TDO,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_D0,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_D1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_D2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_D3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_D4,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_D5,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_D6,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_D7,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_SS0,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_SS1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_SS2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_SS3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_ARB,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 1,
         .tie_val = 1,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI0_SCLK,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UARTHS_RX,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UARTHS_TX,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_RESV6,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_RESV7,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CLK_SPI1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CLK_I2C1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS0,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS4,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS5,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS6,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS7,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS8,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS9,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS10,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS11,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS12,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS13,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS14,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS15,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS16,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS17,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS18,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS19,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS20,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS21,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS22,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS23,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS24,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS25,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS26,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS27,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS28,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS29,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS30,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIOHS31,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIO0,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIO1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIO2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIO3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIO4,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIO5,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIO6,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_GPIO7,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_RX,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_TX,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_RX,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_TX,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_RX,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_TX,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_D0,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_D1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_D2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_D3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_D4,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_D5,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_D6,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_D7,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_SS0,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_SS1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_SS2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_SS3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_ARB,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 1,
         .tie_val = 1,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI1_SCLK,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI_SLAVE_D0,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 1,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI_SLAVE_SS,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SPI_SLAVE_SCLK,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S0_MCLK,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S0_SCLK,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S0_WS,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S0_IN_D0,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S0_IN_D1,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S0_IN_D2,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S0_IN_D3,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S0_OUT_D0,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S0_OUT_D1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S0_OUT_D2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S0_OUT_D3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S1_MCLK,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S1_SCLK,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S1_WS,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S1_IN_D0,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S1_IN_D1,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S1_IN_D2,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S1_IN_D3,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S1_OUT_D0,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S1_OUT_D1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S1_OUT_D2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S1_OUT_D3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S2_MCLK,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S2_SCLK,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S2_WS,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S2_IN_D0,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S2_IN_D1,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S2_IN_D2,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S2_IN_D3,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S2_OUT_D0,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S2_OUT_D1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S2_OUT_D2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2S2_OUT_D3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_RESV0,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_RESV1,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_RESV2,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_RESV3,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_RESV4,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_RESV5,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2C0_SCLK,
         .ds = 0x0,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 1,
         .pd = 0,
         .resv1 = 0,
         .sl = 1,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2C0_SDA,
         .ds = 0x0,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 1,
         .pd = 0,
         .resv1 = 0,
         .sl = 1,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2C1_SCLK,
         .ds = 0x0,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 1,
         .pd = 0,
         .resv1 = 0,
         .sl = 1,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2C1_SDA,
         .ds = 0x0,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 1,
         .pd = 0,
         .resv1 = 0,
         .sl = 1,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2C2_SCLK,
         .ds = 0x0,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 1,
         .pd = 0,
         .resv1 = 0,
         .sl = 1,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_I2C2_SDA,
         .ds = 0x0,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 1,
         .pd = 0,
         .resv1 = 0,
         .sl = 1,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_XCLK,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_RST,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_PWDN,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_VSYNC,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_HREF,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_PCLK,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_D0,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_D1,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_D2,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_D3,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_D4,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_D5,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_D6,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CMOS_D7,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SCCB_SCLK,
         .ds = 0x0,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 1,
         .pd = 0,
         .resv1 = 0,
         .sl = 1,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_SCCB_SDA,
         .ds = 0x0,
         .oe_en = 1,
         .oe_inv = 1,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 1,
         .pd = 0,
         .resv1 = 0,
         .sl = 1,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_CTS,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_DSR,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_DCD,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_RI,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_SIR_IN,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_DTR,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_RTS,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_OUT2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_OUT1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_SIR_OUT,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_BAUD,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_RE,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_DE,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART1_RS485_EN,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_CTS,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_DSR,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_DCD,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_RI,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_SIR_IN,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_DTR,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_RTS,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_OUT2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_OUT1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_SIR_OUT,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_BAUD,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_RE,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_DE,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART2_RS485_EN,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_CTS,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_DSR,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_DCD,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_RI,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_SIR_IN,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_DTR,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_RTS,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_OUT2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_OUT1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_SIR_OUT,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_BAUD,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_RE,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_DE,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_UART3_RS485_EN,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_TIMER0_TOGGLE1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_TIMER0_TOGGLE2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_TIMER0_TOGGLE3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_TIMER0_TOGGLE4,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_TIMER1_TOGGLE1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_TIMER1_TOGGLE2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_TIMER1_TOGGLE3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_TIMER1_TOGGLE4,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_TIMER2_TOGGLE1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_TIMER2_TOGGLE2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_TIMER2_TOGGLE3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_TIMER2_TOGGLE4,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CLK_SPI2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CLK_I2C2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL0,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL4,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL5,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL6,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL7,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL8,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL9,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL10,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL11,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL12,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL13,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 1,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL14,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 1,
         .pd = 0,
         .resv1 = 0,
         .sl = 1,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL15,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL16,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL17,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_CONSTANT,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_INTERNAL18,
         .ds = 0x0,
         .oe_en = 0,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 1,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 1,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG0,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG1,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG2,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG3,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG4,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG5,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG6,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG7,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG8,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG9,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG10,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG11,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG12,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG13,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG14,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG15,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG16,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG17,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG18,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG19,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG20,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG21,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG22,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG23,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG24,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG25,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG26,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG27,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG28,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG29,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG30,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
        {.ch_sel = FUNC_DEBUG31,
         .ds = 0xf,
         .oe_en = 1,
         .oe_inv = 0,
         .do_sel = 0,
         .do_inv = 0,
         .pu = 0,
         .pd = 0,
         .resv1 = 0,
         .sl = 0,
         .ie_en = 0,
         .ie_inv = 0,
         .di_inv = 0,
         .st = 0,
         .tie_en = 0,
         .tie_val = 0,
         .resv0 = 0,
         .pad_di = 0},
};

// int fpioa_init(void)
// {
//     int i = 0;

//     /* Enable fpioa clock in system controller */
//     sysctl_clock_enable(SYSCTL_CLOCK_FPIOA);

//     /* Initialize tie */
//     fpioa_tie_t tie = {0};

//     /* Set tie enable and tie value */
//     for(i = 0; i < FUNC_MAX; i++)
//     {
//         tie.en[i / 32] |= (function_config[i].tie_en << (i % 32));
//         tie.val[i / 32] |= (function_config[i].tie_val << (i % 32));
//     }

//     /* Atomic write every 32bit register to fpioa function */
//     for(i = 0; i < FUNC_MAX / 32; i++)
//     {
//         /* Set value before enable */
//         fpioa->tie.val[i] = tie.val[i];
//         fpioa->tie.en[i] = tie.en[i];
//     }

//     return 0;
// }

// int fpioa_get_io(int number, fpioa_io_config_t *cfg)
// {
//     /* Check parameters */
//     if(number < 0 || number >= FPIOA_NUM_IO || cfg == NULL)
//         return -1;
//     /* Atomic read register */
//     *cfg = fpioa->io[number];
//     return 0;
// }

// int fpioa_set_io(int number, fpioa_io_config_t *cfg)
// {
//     /* Check parameters */
//     if(number < 0 || number >= FPIOA_NUM_IO || cfg == NULL)
//         return -1;
//     /* Atomic write register */
//     fpioa->io[number] = *cfg;
//     return 0;
// }

int fpioa_set_io_pull(int number, fpioa_pull_t pull)
{
    /* Check parameters */
    if(number < 0 || number >= FPIOA_NUM_IO || pull >= FPIOA_PULL_MAX)
        return -1;

    /* Atomic read register */
    fpioa_io_config_t cfg = fpioa->io[number];

    switch(pull)
    {
        case FPIOA_PULL_NONE:
            cfg.pu = 0;
            cfg.pd = 0;
            break;
        case FPIOA_PULL_DOWN:
            cfg.pu = 0;
            cfg.pd = 1;
            break;
        case FPIOA_PULL_UP:
            cfg.pu = 1;
            cfg.pd = 0;
            break;
        default:
            break;
    }
    /* Atomic write register */
    fpioa->io[number] = cfg;
    return 0;
}

// int fpioa_get_io_pull(int number)
// {
//     /* Check parameters */
//     if(number < 0 || number >= FPIOA_NUM_IO)
//         return -1;

//     fpioa_pull_t pull;
//     /* Atomic read register */
//     fpioa_io_config_t cfg = fpioa->io[number];

//     if(cfg.pu == 0 && cfg.pd == 1)
//         pull = FPIOA_PULL_DOWN;
//     else if(cfg.pu == 1 && cfg.pd == 0)
//         pull = FPIOA_PULL_UP;
//     else
//         pull = FPIOA_PULL_NONE;
//     return pull;
// }

// int fpioa_set_io_driving(int number, fpioa_driving_t driving)
// {
//     /* Check parameters */
//     if(number < 0 || number >= FPIOA_NUM_IO || driving >= FPIOA_DRIVING_MAX)
//         return -1;

//     /* Atomic read register */
//     fpioa_io_config_t cfg = fpioa->io[number];
//     /* Set IO driving */
//     cfg.ds = driving;
//     /* Atomic write register */
//     fpioa->io[number] = cfg;
//     return 0;
// }

// int fpioa_set_sl(int number, uint8 sl_enable)
// {
//     /* Check parameters */
//     if(number < 0 || number >= FPIOA_NUM_IO)
//         return -1;

//     /* Atomic read register */
//     fpioa_io_config_t cfg = fpioa->io[number];
//     /* Set IO slew rate */
//     cfg.sl = sl_enable;
//     /* Atomic write register */
//     fpioa->io[number] = cfg;
//     return 0;
// }

// int fpioa_set_st(int number, uint8 st_enable)
// {
//     /* Check parameters */
//     if(number < 0 || number >= FPIOA_NUM_IO)
//         return -1;

//     /* Atomic read register */
//     fpioa_io_config_t cfg = fpioa->io[number];
//     /* Set IO schmitt trigger */
//     cfg.st = st_enable;
//     /* Atomic write register */
//     fpioa->io[number] = cfg;
//     return 0;
// }

// int fpioa_set_oe_inv(int number, uint8 inv_enable)
// {
//     /* Check parameters */
//     if(number < 0 || number >= FPIOA_NUM_IO)
//         return -1;

//     /* Atomic read register */
//     fpioa_io_config_t cfg = fpioa->io[number];
//     /* Set IO schmitt trigger */
//     cfg.oe_inv = inv_enable;
//     /* Atomic write register */
//     fpioa->io[number] = cfg;
//     return 0;
// }

// int fpioa_get_io_driving(int number)
// {
//     /* Check parameters */
//     if(number < 0 || number >= FPIOA_NUM_IO)
//         return -1;

//     return fpioa->io[number].ds;
// }

int fpioa_set_function_raw(int number, fpioa_function_t function)
{
    /* Check parameters */
    if(number < 0 || number >= FPIOA_NUM_IO || function < 0 || function >= FUNC_MAX)
        return -1;
    /* Atomic write register */
    fpioa->io[number] = (const fpioa_io_config_t){
        .ch_sel = function_config[function].ch_sel,
        .ds = function_config[function].ds,
        .oe_en = function_config[function].oe_en,
        .oe_inv = function_config[function].oe_inv,
        .do_sel = function_config[function].do_sel,
        .do_inv = function_config[function].do_inv,
        .pu = function_config[function].pu,
        .pd = function_config[function].pd,
        .sl = function_config[function].sl,
        .ie_en = function_config[function].ie_en,
        .ie_inv = function_config[function].ie_inv,
        .di_inv = function_config[function].di_inv,
        .st = function_config[function].st,
        /* resv and pad_di do not need initialization */
    };
    return 0;
}

int fpioa_set_function(int number, fpioa_function_t function)
{
    uint8 index = 0;
    /* Check parameters */
    if(number < 0 || number >= FPIOA_NUM_IO || function < 0 || function >= FUNC_MAX)
        return -1;
    if(function == FUNC_RESV0)
    {
        fpioa_set_function_raw(number, FUNC_RESV0);
        return 0;
    }
    /* Compare all IO */
    for(index = 0; index < FPIOA_NUM_IO; index++)
    {
        if((fpioa->io[index].ch_sel == function) && (index != number))
            fpioa_set_function_raw(index, FUNC_RESV0);
    }
    fpioa_set_function_raw(number, function);
    return 0;
}

// int fpioa_set_tie_enable(fpioa_function_t function, int enable)
// {
//     /* Check parameters */
//     if(function < 0 || function >= FUNC_MAX)
//         return -1;
//     /* Set tie enable */
//     if(enable)
//         fpioa->tie.en[function / 32] |= (1UL << (function % 32));
//     else
//         fpioa->tie.en[function / 32] &= (~(1UL << (function % 32)));
//     return 0;
// }

// int fpioa_set_tie_value(fpioa_function_t function, int value)
// {
//     /* Check parameters */
//     if(function < 0 || function >= FUNC_MAX)
//         return -1;
//     /* Set tie value */
//     if(value)
//         fpioa->tie.val[function / 32] |= (1UL << (function % 32));
//     else
//         fpioa->tie.val[function / 32] &= (~(1UL << (function % 32)));
//     return 0;
// }

int fpioa_get_io_by_function(fpioa_function_t function)
{
    int index = 0;
    for(index = 0; index < FPIOA_NUM_IO; index++)
    {
        if(fpioa->io[index].ch_sel == function)
            return index;
    }

    return -1;
}

void fpioa_pin_init() {
    fpioa_set_function(27, FUNC_SPI0_SCLK);
    fpioa_set_function(28, FUNC_SPI0_D0);
    fpioa_set_function(26, FUNC_SPI0_D1);
	fpioa_set_function(32, FUNC_GPIOHS7);
//    fpioa_set_function(29, FUNC_SPI0_SS3);
	fpioa_set_function(29, FUNC_SPI0_SS0);
    #ifdef DEBUG
    printf("fpioa_pin_init\n");
    #endif
}
