# 基础设施库

​		由于我们在开发操作系统的过程中没有使用标准库，也不方便使用语言标准库，因此我们需要一套基础设施库。从最基本的输入输出，到字符串操作、内存操作、数据结构等，这些基础设施库设计的好坏会极大影响我们系统设计的效率与效果。

​		由于我在平时开发应用的过程中，封装过一定程度的函数库，其中一部分对系统调用或标准库没有依赖的可以直接拿过来用，比如后面提到的模板工具箱、KOUT、一些数据结构等。

​		除此之外，系统中用到的一些预定义的内容，比如Type.hpp，Error.hpp，都是在每个模块都会高频使用的，也在这一部分进行介绍。



#### Type.hpp

​		这个文件定义了系统中各种类型，主要为了便于移植到位数不同的设备上。

​		此外，也定义了大小端情况，在需要的场合可以结合模板工具箱进行转换。



#### Error.hpp

​		该文件定义了各类型的错误码，便于系统报出错误后快速定位错误来源。

​		此外，提供了Panic和KernelFaultSolver（即KernelMonitor），当发生严重错误时，会进入KernelMonitor，关闭中断，等待用户指令，此时用户可以输出比如shutdown就可以关闭系统，其他如打印进程信息等，更多功能还有待实现。



#### DataStructure

​		目前提供了LinkTable和Tuple两种，LinkTable可以被类继承，从而获得链式结构的特性。Tuple用于同时返回多个返回值。



#### String

​		字符串工具，包括常见的字符串拷贝、比较、拼接等操作，此外，部分操作以模板形式提供，可以支持边长参数列表。



#### Kout.hpp

​		KOUT是类似于cout 的输出流类，并对其进行了各方面的强化，包括通道控制开关、颜色、效果、数据打印等。





--------------------------------------

By：qianpinyi

2022.06.05