## 系统调用具体实现

* SYS_getcwd ：直接从当前进程的CWD获取拷贝给用户即可

* SYS_pipe2 ：创建PipeFileNode，并打开读写两个FileHandle绑定给该进程即可

* SYS_dup ：调用FileHandle的Dump方法进行拷贝即可
* SYS_dup3 ：同上，只不过增加了关闭就FileHandle，指定文件描述符
* SYS_chdir ：直接调用Process类的SetCWD方法即可
* SYS_openat ：根据传入的fd和filename，先根据是否是绝对路径、相对路径、指定文件描述符的相对路径，得到一个规范路径，然后直接调用VFSM来打开文件，并创建FileHandle指向FileNode，并绑定到当前进程即可
* SYS_close ：直接delete找到的对应FileHandle即可
* SYS_getdents64 ：用GetAllFileIn获取文件后按格式填入数组即可
* SYS_read ：直接获取FD对应的FileHandle，并调用它的Read即可
* SYS_write ：直接获取FD对应的FileHandle，并调用它的Write即可
* SYS_linkat ：尚未实现
* SYS_unlinkat ：调用VFSM的Delete方法实现
* SYS_mkdirat ：直接获取到规范路径后调用VFSM的CreateDirectory实现
* SYS_umount2 ：由于文件系统我们已经挂载，因此不可以被unmount掉，直接返回0
* SYS_mount ：由于文件系统我们已经挂载，因此不可以再mount一次，直接返回0
* SYS_fstat ：根据给定的FD拿到FileNode并填充所需数据到目标结构体即可
* SYS_clone ：根据stack指针是否非空，区分是要创建用户现成还是fork，其余部分都与创建进程差不多，区别在于fork需要拷贝整个地址空间，返回地址需要新构造TrapFrame，而创建用户现成则不需要拷贝地址空间，直接引用原有地址空间即可，但其用户栈的地址要通过TrapFrame切换到给定的地方
* SYS_execve ：根据拿到的FileHandle，从ELF创建一个新进程，并让当前进程等待它，等待完成后直接退出
* SYS_wait4： 和内核的Wait子进程类似，不断地检查是否又符合要求的退出了的子进程，如果没有就使用信号量Wait，直到子进程Signal，否则就可以拿到指针，销毁子进程后，完成这次系统调用
* SYS_exit ：直接调用进程对象的Exit方法即可
* SYS_getppid ：直接调用进程对象的GetFa拿到父进程后再调用GetPID拿到PID
* SYS_getpid ：直接调用进程的GetPID获取即可
* SYS_brk ：根据当前进程拿到HeapMemoryRegion指针，调用其Resize方法
* SYS_munmap ：首先获取到这个地址对应的MemapFileRegion指针，进行一次保存后delete即可
* SYS_mmap ：根据要求创建MemapFileRegion对象，绑定到对应文件，插入自己的VMS中的可用区域即可
* SYS_times：直接调用进程对应的几个获取时间的方法即可 
* SYS_uname ：直接填充数据并返回即可
* SYS_sched_yield ：直接调用进程的Rest方法即可
* SYS_gettimeofday ：直接调用GetClockTime按指定格式填写即可
* SYS_nanosleep ：使用信号量的超时等待机制进行Wait，可以实现Sleep的效果







---------------

By：qianpinyi

2022.06.05