# 文件句柄

​		文件句柄是分配给文件的访问文件的一个中介，进程通过文件描述符读写文件即是通过FileHandle来访问FileNode，它与FileNode区别在于，FileNode内部不记录与读写事件有关的信息，例如读写指针的位置、缓冲区等、权限控制等。这些是与进程息息相关的，因此它们将在FileHandle里进行控制。

​		进程内部维护了一个打开的FileHandle表，目前设置的大小为8，为了提供扩展性，FileHandle继承了链表模板，本身可以以链式进行组织，因此进程内部的FileHandle表如果用满了，可以顺着第8个用指针依次向后寻找。

​		在执行一些文件系统相关的系统调用时，用户进程给出的时文件描述符，首先要通过文件描述符找到FileHandle，然后再进行读写等，如果要对FileNode甚至VFS进行操作，则依次通过内部获取指针的方法得到相应对象后处理。

##### 主要成员和说明如下：

###### 公开内部结构：

* 权限枚举：控制FileHandle可以执行哪些操作的标志位
  * F_Read：允许读
  * F_Write：允许写
  * F_Seek：允许Seek
  * F_Size：允许获取大小
* 定位枚举：用于Seek时提供基准
  * Seek_Beg：相对于文件头Seek
  * Seek_Cur：相对于当前位置Seek
  * Seek_End：相对于文件尾Seek

###### 内部保护成员：

* LinkTableT\<FileHandle\>：继承的链表结构，让当前对象可以以链式组织
* FileNode *file：指向的文件结点指针
* Uint64 Pos：当前读写的位置
* Uint64 Flags：权限标志位
* Process *proc：所属进程指针
* Uint32 FD：在所属进程中分配的文件描述符号

###### 主要成员函数：

* Read：类似于C库的读
* Write：类似于C库的写
* Seek：类似于C库的Seek
* Close：关闭FileHandle，会减少指向的文件的引用，并将所属进程的文件表对应位置设为nullptr
* BindToProcess：以某一FD绑定到进程的文件表上，如果FD为-1，则自动分配最小的可用FD
* Dump：拷贝当前FileHandle
* ……



-----------------

By：qianpinyi

2022.06.05