# 文件系统

​		文件系统是为我们的系统引入丰富资源的一个模块，在设计上，我们采用多级的分层和抽象结构，具体实现时采用的是FAT32文件系统。文件系统模块主要由4个类构成，分别为虚拟文件系统管理器(VirtualFileSystemManager 简称VFSM)、虚拟文件系统(VirtualFileSystem 简称VFS)、文件结点(FileNode)、文件句柄(FileHandle)。此外，作为派生实例，我们还编写了FAT32文件系统和StupidFileSystem（用于测试的简易内存文件系统）两种实现。

​		在文件系统模块，我们已经拥有了充足的基础设施支撑，因此所有的类都使用构造函数和析构函数，而非Init和Destroy，并充分利用继承等特性。

​		此前内核载入用户进程的方法为在内核里打包用户进程，然后从内核里拷贝出来执行，这做到了在没有文件系统之前进行用户进程的测试，具体操作方案参考文档0x13。



#### 整体设计结构图

![整体设计结构图](./Pics/POS_Doc-3.png)



#### 文件路径规范

​		我们对文件路径的规范与Linux类似，使用"/"作为路径的分隔符，递归定义出下面几种概念：

* 非法字符集合：IV={'/', '\\', '|', '<', '>', '"', ':', '*', '?'}，共9个保留字符，此处参考Windows重命名时的提示
* 根目录：Root="/"
* 文件名：Name={x^N|x不属于IV，N>=1，且x^N不属于{".", ".."}}
* 当前目录：Cur="."|""
* 上一级目录：Pre=".."
* 路径节：Section=Name|Cur|Pre
* 相对路径：RPath=Section|Section+"/"+RPath
* 绝对路径：APath=Root|APath2，APath2=Root+RPath|APath2+"/"+RPath
* 规范路径：Section仅为Name的绝对路径（即路径中不存在多余的空Section，上一级目录".."和当前目录"."）

VFSM在接收路径时，会将路径先处理成规范路径，再进行处理或转发给VFS，一方面防止路径出现特殊内容，另一方面其他模块处理起来比较简单。



#### 虚拟文件系统VirtualFileSystem

​		虚拟文件系统VFS是对各类文件系统操作的统一抽象，向上层提供统一一致的接口，便于系统各模块之间降低耦合性，增强可维护性。对一个虚拟文件系统而言，它认为自己是根文件系统，整个可以挂在到VFSM的某个结点上作为子树存在。

​		VFS的设计理念是，VFS作为接口向上提供基本的操作功能，具体实现由VFS派生类内部完成。例如移动一个文件，那么就要求在这个文件系统内部完成，外部不关心是用怎样的机制移动的。而如果需要跨文件系统移动或复制文件，则需要VFSM的介入，帮助进行数据拷贝。



#### 文件结点FileNode

​		文件结点一方面是与VFS一样性质地作为基类存在，每个文件系统都应该派生自己的文件结点类。此外，文件结点还作为VFSM对全局目录树管理时的管理单位，每一文件结点代表着目录树上的一个结点。这个结点可以是某个具体文件系统的结点，如FAT32文件结点；也可以是虚拟的文件结点，如根节点、设备文件结点等；也可以是虚拟文件系统的根节点代表。也就是说，文件结点管理着某个文件。

​		文件结点提供了一部分文件操作共性的接口，例如读写文件数据、获取文件信息、获取文件路径等。



#### 虚拟文件系统管理器VirtualFileSystemManager

​		虚拟文件系统管理器VFSM维护全局的目录树结构，对于所有的外部请求，都经过VFSM与特定的VFS进行交互。VFSM会将全局路径转化为VFS使用的局部绝对路径，转发给VFS处理。

​		VFSM的设计理念为区分VFS与使用者的接口，它将各个VFS通过挂载到特定结点的方式有机统一起来。包括设备文件、链接等全部放在目录树上，在VFSM的统一管理之下。VFSM的接口与VFS的接口非常相似，不同的是，VFSM是外部访问文件系统的接口，VFS的接口仅供VFSM使用。



#### 文件句柄FileHandle

​		文件句柄是分配给文件的访问文件的一个中介，进程通过文件描述符读写文件即是通过FileHandle来访问FileNode，它与FileNode区别在于，FileNode内部不记录与读写事件有关的信息，例如读写指针的位置、缓冲区等、权限控制等。这些是与进程息息相关的，因此它们将在FileHandle里进行控制。





--------------------

By：qianpinyi

2022.06.05