# 进程对象



#### Process类

###### 公有内部结构：

* 状态枚举：表示进程处于什么状态，满足进程状态转移图
  * S_None：未分配状态
  * S_Allocated：已分配ID但未初始化状态
  * S_Initing：初始化进行中
  * S_Ready：就绪
  * S_Running：正在运行（内核态）
  * S_UserRunning：正在运行（用户态）
  * S_Sleeping：阻塞态
  * S_Quiting：已退出，等待回收
* 标志位枚举：用于标记对象的特性状态
  * F_Kernel：内核进程/线程标志
  * F_AutoDestroy：无父进程/自动销毁标志，用于避免僵尸进程，如设置此标记位，便捷创建函数将返回位置PID
  * F_GeneratedStack：表明当前的栈是自动分配的，会自行销毁，否则交由外部管理
  * F_OutsideName：当前进程名字是否是从外部引用的，如不是，则会在销毁时销毁
* 特殊的退出返回值：以特殊情况退出时给出的返回值
  * Exit_Normal：即0，表示正常退出
  * Exit_Destroy：由于调用了Destroy进程导致的提前Exit
  * Exit_BadSyscall：由于未知的系统调用导致的进程中止
  * Exit_Execve：尚未使用，预计用于execve调用时原进程退出返回值
* 特殊PID枚举：用于在一些需要PID的场合表示特殊的情况
  * AnyPID：用于Wait等场所表示匹配任意PID
  * UnknownPID：表示无法得知产生了什么PID，但PID确实存在，主要用于避免使用PID时进程已AutoDestroy的情况
  * InvalidPID：表示无法创建进程等情况下返回非法PID
* 轻量级上下文RegContext：该结构体存储了ra、sp、s0~s11寄存器，其余部分可以利用函数调用栈帧来保存

###### 内部保护成员：

* ProcessManger *PM：该进程所属的进程管理器，目前只有POS_PM
* PID ID：进程PID，由进程管理器分配
* Uint32 stat：当前状态
* ClockTime CountingBase：当前阶段计时基准点
* ClockTime RunningDuration：运行时间（包括内核态和用户态）
* ClockTime StartedTime：进程启动的时刻
* ClockTime SleepingDuration：阻塞时间
* ClockTime WaitingDuration：等待时间（就绪态）
* ClockTime UserDuration：用户态执行时间
* void *stack：内核栈地址
* Uint32 StackSize：内核栈大小，默认为4k*4
* Process *fa：父进程
* Process *pre：前一个兄弟进程
* Process *nxt：后一个兄弟进程
* Process *child：第一个孩子进程
* RegContext context：轻量级上下文
* VirtualMemorySpace *VMS：所属虚拟内存空间
* Uint64 flags：标志位
* char *Name：进程名称
* Uint32 Namespace：所属命名空间，目前未使用
* int ReturnedValue：返回值记录，用于其他进程等待获取
* LinkTable\<Process\>SemWaitingLink：当前所处于的信号量等待链，孤立时即不处于阻塞状态
*  ClockTime SemWaitingTargetTime：阻塞等待的目标超时时间，达到该时间后会自动解除阻塞状态
* Semaphore *WaitSem：代表该进程的等待信号量，一般用于等待子进程
* HeapMemoryRegion *Heap：堆段指针
* char *CurrentWorkDirectory：当前工作目录
* FileHandle *FileTable[8]：进程打开的文件表，前后同时穿成一个链表，因此如果超过8个，剩下的会以链式串在后面。

###### 成员函数

* InitForKernelProcess0：为0号进程，即boot进程特别准备的初始化
* CopyFileTable：拷贝进程文件表
* CopyOthers：拷贝其他信息
* Start：通过栈帧开始
* InitFileTable：初始化进程文件表
* DestroyFileTable：销毁进程文件表
* Rest：放弃占用CPU并调度其他可执行进程
* Run：切换到当前进程执行
* Exit：以特定返回值退出
* Start：从给定的函数和用户地址启动
* SetVMS：设置所属虚拟内存空间
* SetStack：设置内核栈
* SetName：设置进程名称
* SetFa：设置父进程，如果由F_AutoDestroy标志则会自动清除
* GetQuitingChild：获取当前已退出的子进程，如果指定AnyPID则存在任意退出的子进程则返回对应指针，否则如果有指定的PID子进程才返回，不然返回nullptr；稍作封装即可实现Wait子进程的功能
* SetCWD：设置当前工作目录
* GetFileHandleFromFD：从文件描述符获取文件句柄（主要是为了兼容Linux文件描述符的编号规则）
* SwitchStat：转换状态到，并更新相关数据
* GetStat：获取保护成员的方法，获取当前状态
* SetHeap：设置进程拥有的HeapMemoryRegion指针
* GetHeap：获取保护成员的方法，获取进程拥有的HeapMemoryRegion指针
* GetCWD：获取保护成员的方法，获取当前的工作目录
* GetWaitSem：获取保护成员的方法，获取进程拥有的等待信号量，一般用于让这个进程等待
* GetReturnedValue：获取保护成员的方法，获取该进程的返回值
* GetFa：获取保护成员的方法，获取父进程
* GetName：获取保护成员的方法，获取进程名称
* GetVMS：获取保护成员的方法，获取进程所属虚拟内存空间
* GetPID：获取保护成员的方法，获取进程PID
* IsKernelProcess：判断是否是内核进程
* IsUserProcess：判断是否是用户进程
* GetRunningDuration：获取保护成员的方法，获取进程执行时间，包括用户态和内核态
* GetStartedTime：获取保护成员的方法，获取进程最开始就绪的时刻
* GetSleepingDuration：获取保护成员的方法，获取进程在阻塞上花费的时间
* GetWaitingDuration：获取保护成员的方法，获取进程在就绪态等待的时间
* GetUserDuration：获取保护成员的方法，获取进程以用户态执行的时间
* Init：进程对象初始化
* Destroy：进程对象销毁



#### ProcessManager类

###### 内部保护成员

* Process Processes[MaxProcessCount]：预开设的所有进程的分配池，后期预计改成使用队列等数据结构动态维护
* Process *CurrentProcess：当前进程指针
* Uint32 ProcessCount：已分配进程总数
* SpinLock lock：访问操作时的全局锁

###### 成员函数

* GetProcess：通过PID获取进程指针
* AllocProcess：分配一个进程
* FreeProcess：回收一个进程
* Current：获取当前进程
* Schedule：进行一次调度
* Init：进程管理器初始化
* Destroy：进程管理器销毁（应该用不到这个功能）



#### 一些具体的用法

###### 创建内核线程

​		即代码中的`CreateKernelThread`函数，其执行流程比较简单，依次为：

1. 分配进程对象
2. 以Kernel属性初始化
3. 设置内核栈
4. 设置所属虚拟内存空间为内核空间
5. 设置Start入口点函数
6. 完成创建，等待调度

###### 创建嵌入的用户进程

​		即代码中的`CreateInnerUserImgProcess`函数，其从内核打包的二进制用户代码创建进程，流程如下（部分顺序可颠倒）：

1. 分配虚拟内存空间VMS对象
2. 初始化VMS
3. 创建VMS（即创建根页表PDT和默认VMR）
4. 分配、初始化并创建代码段、栈段等VMR
5. 插入VMR到VMS中
6. 拷贝或初始化各VMR
7. 分配进程对象
8. 初始化进程为用户进程
9. 设置进程的内核栈
10. 设置所属虚拟内存空间为创建出来的VMS
11. 设置入口点为用户进程载入地址
12. 完成创建，等待调度

###### 通过ELF创建用户进程

​		与上一条类似，只不过多了解析ELF的步骤，详见0x34ELF解析文档。

###### 创建用户线程、Fork进程

​		根据前面两个例子很容易实现，具体实现方案在0x61具体系统调用实现文档中的Clone中详解。

###### 等待子进程

​		目前没有写Wait子进程的函数，不过用提供的成员函数可以很容易做到这样的功能，即：

1. 不断循环，每次都调用`GetQuitingChild`获取已经结束的子进程
2. 判断如果为nullptr，转3，否则转4
3. 通过该进程的`GetWaitSem`函数进行等待，并转1
4. 销毁获取到的子进程对象，完成Wait



-----------------

By：qianpinyi

2022.06.05