# 进程管理

进程管理是我们的系统中核心功能之一，并与其他各个模块都有较高的相关性，因此进程模块设计的好坏会影响到其他模块。本章节的文档中会涉及部分后面提到的文档，如有必要需要联系起来看。

##### 项目结构上来看，进程管理部分的内容对应Process文件夹里的内容。

##### 从类结构上来看，进程模块涉及到的类/结构体有

* ProcessManager：进程管理器；用于管理、分配、回收、调度进程
* Process：进程；用于表示一个进程实体，是当前系统中最复杂的结构图/类之一，详见0x31进程对象文档介绍
* SpinLock：自旋锁；使用硬件同步实现的自旋锁
* Semaphore：信号量；支持多重唤醒、超时等待的信号量同步机制对象
* Mutex：互斥锁；实际实现时使用的是初值为1的信号量
* ELF_XX系列结构体：用于解析ELF文件使用；具体见文档0x33

##### 实现的主要功能有

* 进程创建、分配、回收
* 进程调度
* 进程启动
* 进程切换
* 进程间等待、通知、同步机制
* 进程父子关系树
* 进程文件表等与其他模块对接的内容
* ELF文件解析
* ……



#### 进程状态转移图

![进程状态转移图](./Pics/POS_Doc-2.png)





#### 与其他模块或类的关系

内存管理：每个进程都有一个所属虚拟内存空间，这是与内存管理模块之间的接口；此外HeapMemoryRegion指针特别地指向了其中堆段的VMR，不过这感觉还不是一个很好的设计，需要改进

文件系统：内部存储`FileHandle`指针，从而得以将文件与进程绑定起来；此外，当前工作目录也是VFSM提供的概念

系统调用：系统调用都是与当前进程有关的，所以基本上会获取当前进程指针来操作；

陷入处理：陷入处理前后需要进行进程状态包括寄存器上下文等的切换与存储，此处的处理非常关键



------------------

By：qianpinyi

2022.06.04