# 遇到的瓶颈和解决方案

​		在我们开发的过程中，遇到过多次瓶颈，即不知道该怎么做了，这时候需要方向性的指引，故记录

1. 最一开始不知道如何上手，不知道如何Boot：参考这个博客[opensbi下的riscv64裸机系列编程1(串口输出) - 云+社区 - 腾讯云 (tencent.com)](https://cloud.tencent.com/developer/article/1770529)

2. 如何启动MMU：通过构造初始页表映射一个偏移量实现，需要弄清楚开启页表前后发生的变化

3. Boot完成后写什么：物理内存管理，要理解物理内存管理是在做什么，实际上就是要管理一个大数组。先写出Kmalloc和Kfree，后续开发才方便

4. 进程/虚拟内存管理具体怎么搞：这个花了好几天才理清的，忘了当时具体是瓶颈在哪里了，进程要和虚拟内存一起搞，比较混乱。。。大概是要把中断和几个特殊的寄存器搞清楚，弄清程序的执行流。具体突破的顺序可以为：内核线程（线程上下文切换），缺页中断（页表的逐级构造），虚拟内存空间（切换根页表）

5. 如何在没有文件系统之前写用户进程：

   ```` 
   连接器参数： --format=binary $(USER_BINS) --format=default
   	其中：左右两侧的--format=binray 和--format=default 指定了区域内的内容会以二进制拷贝的形式放进去
   
   其中用户程序会生成对应的三种符号，在内核里找这段区域的内容载入即可：
   	_binary_obj___user_##x##_out_start
   	_binary_obj___user_##x##_out_size
       _binary_obj___user_##x##_out_end
   ````

6. 上板测试要怎么跑：使用kflash烧录、使用dd命令合并SBI和OS固件、修改启动地址
7. 读写磁盘具体要怎么搞：当时时间不太够了，我们采取的方案是直接上板，移植SDCard驱动，而不使用qemu了，不过这样导致后面的调试变得很麻烦
8. ……



-----------------

By：qianpinyi

2022.06.05