<div align="center">
  <a href="/">
	<img src="./logo.svg"  />
  </a>
  <h1>Versakit</h1>
  <p>一个 Vue3 组件库，支持桌面端。</p>
  <p>
    <a href="">文档</a> | 
    <a href="./README.md">ENGLISH README</a>
  </p>
  <p>
    <img src="https://img.shields.io/badge/vue-v3.2.0%2B-%23407fbc" alt="vue">
    <img src="https://img.shields.io/npm/l/@varlet/ui.svg" alt="license">
  </p>
</div>

---

## 一、简介

Versakit 是一个精心设计的 Vue3 组件库，旨在为开发者提供高度可定制的组件解决方案。它允许你在不依赖特定视觉样式的情况下构建用户界面，赋予你完全掌控组件外观和行为的能力。

## 特性

- 🚀 &nbsp; 提供 20+ 个高质量通用组件
- 💪 &nbsp; 由国人开发，完善的中英文文档和后勤保障
- 🛠️ &nbsp; 支持按需引入
- 🛠️ &nbsp; 支持主题定制
- 🌍 &nbsp; 支持国际化
- 💡 &nbsp; 支持 Typescript
- 💪 &nbsp; 确保 90% 以上单元测试覆盖率，提供稳定性保证
- 🛠️ &nbsp; 支持暗黑模式
- 🔧 &nbsp; 提供官方的 VSCode 插件
- ⌨️ &nbsp; 支持无障碍访问（持续改进中）

## 三、安装

你可以通过以下方式安装 Versakit：

```bash

# 使用 npm
npm install @versakit/ui

# 使用 yarn
yarn add @versakit/ui

# 使用 pnpm
pnpm add @versakit/ui

```

```
import App from './App.vue'
import { createApp } from 'vue'
import Versakit from '@versakit/ui' // 引入组件库
import '@versakit/ui/dist/style.css' // 引入样式

createApp(App).use(Versakit).mount('#app')
```

## 四、文档地址

[组件库文档](https://lenran659.github.io/versakit-docs/)

[github](https://github.com/lenran659/versakit-ui)

[gitee](https://gitee.com/dragon_water/versakit-ui#/dragon_water/versakit-ui/blob/master/%22https:/lenran659.github.io/versakit-docs/%22)

## 五、许可证

Versakit 是在 [MIT] 许可证下发布的。详细信息请查看项目根目录下的`LICENSE`文件。

请注意，你需要根据你的组件库的实际情况对上述内容进行调整和补充，包括准确的安装步骤、详细的组件文档、许可证信息等。如果你的组件库不是基于 React 的，你需要修改示例代码部分以适应相应的技术栈。

### 感谢贡献者们做出的努力

<a href="https://github.com/lenran659/Versakit/graphs/contributors">
 <img src="https://avatars.githubusercontent.com/u/74483049?s=400&u=102dfac48d0067d9d7a5576134e409590bbfaafe&v=4" width="64" height="64" style="border-radius:50%"  />
  <img src="https://avatars.githubusercontent.com/u/131731035?v=4" width="64" height="64" style="border-radius:50%" />
  <img src="https://avatars.githubusercontent.com/u/122306263?v=4" width="64" height="64" style="border-radius:50%" />
  <img src="https://avatars.githubusercontent.com/u/180088207?v=4" width="64" height="64"  style="border-radius:50%" />
  <img src="https://avatars.githubusercontent.com/u/120795714?v=4" width="64" height="64"  style="border-radius:50%" />
</a>
