# Antes de Empezar

Antes de que podamos empezar a construir nuestro negocio SaaS, hay algunas decisiones que debemos tomar.

- **Nombre**
- **Diseño**
- **Dominio**

## Nombre

Este no es un curso de branding / marketing, pero compartiré algunas palabras acerca del nombre de tu producto. Debería ser fácil de recordar. Ya sea eligiendo una palabra nueva o única (por ejemplo, Vercel) o describiendo el producto (por ejemplo, Fast Feedback).

Un ejercicio que uso para escoger nombres de marcas es escribir 5-10 palabras relacionadas con el producto y aquello que el cliente recibirá. ¿Cómo hace que su vida sea más fácil? ¿Qué problema está tratando de resolver? Después, utiliza herramientas como [Domain Name Generator](https://www.shopify.com/tools/domain-name-generator) para generar las ideas.

También puedes utilizar [Thesaurus](https://www.thesaurus.com/) para encontrar palabras relacionadas. Mi idea inicial para Fast Feedback fue "Instant Feedback". Después de buscar sinónimos por un momento, decidí que "fast" era más corto y fácil de recordar.

## Diseño

Resumiendo: si no puedes diseñar, contrata a un diseñador. Si no puede contratar a un diseñador, considera utilizar un [framework de diseño](https://material.io/design), plantilla, o un editor visual como [Divjoy](https://divjoy.com/).

**El diseño de tu producto es más importante de lo que crees.** Persigue la simplicidad.

Aquí está el proceso de diseño que seguí para Fast Feedback. Primero, empecé con [Excalidraw](https://excalidraw.com/) para generar rápidamente _mockups_ de baja fidelidad.

![Excalidraw](/excalidraw.png)

Después, hice la transición a alta fidelidad con [Figma](https://www.figma.com/).

![Figma](/figma.png)

Finalmente, utilizé [OpenChakra](https://openchakra.app/) para convertir los mockups en código real de React con [Chakra UI](https://chakra-ui.com/).

![Open Chakra](/openchakra.png)

## Dominio

Vamos a ser honestos – probablemente compraste primero el dominio, ¿verdad? Encontrar un gran nombre de dominio es un reto. Normalmente checkeo dominios en el proceso de selección en el nombre de mi marca. Otro truco es comprobar la disponibilidad de las cuentas en redes sociales al mismo tiempo.

Este curso utiliza Vercel para alojar y depslegar tu producto. Vercel te permite comprar nombres de dominio directamente desde su sitio web (o su CLI) y generar instantáneamente un certificado SSL. Puedes ir de la idea del nombre del dominio a un sitio de producción en tan solo unos minutos.

- Después de crear una cuenta en Vercel, dirígete a [dominios](https://vercel.com/domains).
- Encuentra el nombre de dominio perfecto para tu marca.
- Compra el dominio.
- Vercel automáticamente configura las DNS y gestiona / renueva los certificados SSL.

![Nombre de Dominio](/domain-name.png)
