# Before Starting

Before we can start building our SaaS business, there's a few decisions we'll need to make.

- **Name**
- **Design**
- **Domain**

## Name

This isn't a branding / marketing course, but I'll share some quick words on your product's name. It should be easy to remember. Whether that's by choosing a new or unique word (e.g., Vercel) or by describing the product (e.g., Fast Feedback).

An exercise I use to pick brand names is to write down 5-10 words related to your product and the outcomes customers will receive. How does it make their life easier? What problem are you solving? Then, use tools like a [Domain Name Generator](https://www.shopify.com/tools/domain-name-generator) to generate ideas.

You can also use a [Thesaurus](https://www.thesaurus.com/) to find related words. My initial idea for Fast Feedback was "Instant Feedback". After looking at synonyms for instant, I decided "fast" was shorter and easier to remember.

## Design

Long story short: if you can't design, hire a designer. If you can't hire a designer, consider using a complete [design framework](https://material.io/design), template, or visual editor like [Divjoy](https://divjoy.com/).

**The design of your product is more important than you realize.** Aim for simplicity.

Here's the design process I took for Fast Feedback. First, I start with [Excalidraw](https://excalidraw.com/) to quickly generate low-fidelity mockups.

![Excalidraw](/excalidraw.png)

Then, I transition to high-fidelity with [Figma](https://www.figma.com/).

![Figma](/figma.png)

Finally, I use [OpenChakra](https://openchakra.app/) to turn mockups into real React code with [Chakra UI](https://chakra-ui.com/).

![Open Chakra](/openchakra.png)

## Domain

Let's be honest – you probably bought the domain name first, right? Finding a great domain name is a challenge. I usually check for domains in the process of selecting my brand name. Another tip is to check for social media account availability ahead of time.

This course uses Vercel to host and deploy your product. Vercel allows you to buy domain names directly from their website (or CLI) and instantly generate an SSL certificate. You can go from domain name idea to production site in a few minutes.

- After creating a Vercel account, go to [domains](https://vercel.com/domains).
- Find the perfect domain name for your brand.
- Purchase the domain.
- Vercel will automatically configure DNS and issue / renew SSL certificates.

![Domain Name](/domain-name.png)
