<img src="../assets/img/logo.png" alt="Contentment for Umbraco logo" title="A state of Umbraco happiness." height="130" align="right">

## Contentment for Umbraco

### Data Sources

The following data-sources are available by default with the Contentment package for the [Data List](../editors/data-list.md) and [Text Input](../editors/text-input.md) editors.

#### .NET

- [.NET Countries (ISO 3166)](data-source--countries.md) - All the countries available in the .NET Framework, (as installed on the web server).
- [.NET Currencies (ISO 4217)](data-source--currencies.md) - All the currencies available in the .NET Framework, (as installed on the web server).
- [.NET Enumeration](data-source--enum.md) - Select an enumeration from a .NET assembly as the data source.
- [.NET Languages (ISO 639)](data-source--languages.md) - All the languages available in the .NET Framework, (as installed on the web server).
- [.NET Time Zones (UTC)](data-source--timezone.md) - All the time zones available in the .NET Framework.

#### Data

- [File System](data-source--file-system.md) - Select paths from the physical file system as the data source.
- [JSON Data](data-source--json.md) - Configure JSON data to populate the data source.
- [Number Range](data-source--number-range.md) - Generates a sequence of numbers within a specified range.
- [SQL Data](data-source--sql.md) - Use a SQL Server database query as the data source.
- [Text Delimited Data](data-source--text-delimited.md) - Configure text-delimited data to populate the data source.
- [User-defined List](data-source--user-defined.md) - Manually configure the items for the data source.
- [XML Data](data-source--xml.md) - Configure XML data to populate the data source.

#### Umbraco

- [Examine Query](data-source--examine.md) - Populate the data source from an Examine query.
- [Umbraco Content](data-source--umbraco-content.md) - Select a start node to use its children as the data source.
- [Umbraco Content Properties](data-source--umbraco-content-properties.md) - Populate the data source using a Content Type's properties.
- [Umbraco Content Types](data-source--umbraco-content-types.md) - Populate the data source using Content Types.
- [Umbraco Content by XPath](data-source--umbraco-content-xpath.md) - Use an XPath query to select Umbraco content to use as the data source.
- [Umbraco Dictionary Items](data-source--umbraco-dictionary.md) - Select an Umbraco dictionary item to populate the data source with its child items.
- [Umbraco Entities](data-source--umbraco-entity.md) - Select an Umbraco entity type to populate the data source.
- [Umbraco Files](data-source--umbraco-files.md) - Use files defined in Umbraco, such as scripts or stylesheets.
- [Umbraco Image Crops](data-source--umbraco-image-crop.md) - Select an Image Cropper data-type to use its defined crops to populate the data source.
- [Umbraco Languages](data-source--umbraco-languages.md) - Populate the data source with langauges configured in Umbraco.
- [Umbraco Member Groups](data-source--umbraco-member-group.md) - Populate the data source with Umbraco member groups.
- [Umbraco Members](data-source--umbraco-members.md) - Use Umbraco members to populate the data source.
- [Umbraco Tags](data-source--umbraco-tags.md) - Populate the data source using already defined tags.
- [Umbraco Templates](data-source--umbraco-templates.md) - Populate the data source using defined view templates.
- [Umbraco User Groups](data-source--umbraco-user-groups.md) - Populate the data source with Umbraco user groups.
- [Umbraco Users](data-source--umbraco-users.md) - Use Umbraco users to populate the data source.


#### Web

- [uCssClassName](data-source--ucssclassname.md) - A homage to @marcemarc's bingo-famous uCssClassNameDropdown package!
- [XML Sitemap: Change Frequency](data-source--xml-sitemap-change-frequency.md) - Populate the data source using XML Sitemap change frequency values.
- [XML Sitemap: Priority](data-source--xml-sitemap-priority.md) - Populate the data source using XML Sitemap priority values.
