<img src="assets/img/logo.png" alt="Contentment for Umbraco logo" title="A state of Umbraco happiness." height="130" align="right">

## Contentment for Umbraco

### Documentation

> If there are any parts of the documentation that are unclear, [please do let me know](https://github.com/leekelleher/umbraco-contentment/issues/new/choose).
> 
> Sometimes I can be too close to the code to understand how others (e.g. you) will use it. :v::heart::dove:

#### Property-Editors

Here is the documentation for the Contentment property-editors...

- [Bytes](../docs/editors/bytes.md) - a read-only label to display file sizes in relative bytes.
- [Code Editor](../docs/editors/code-editor.md) - a code snippet editor, _(using the ACE library that is bundled with Umbraco)._
- [Content Blocks](../docs/editors/content-blocks.md) - a block editor, configurable using element types.
- [Data List](../docs/editors/data-list.md) - an editor that combines a custom data source with a custom list editor.
- [Data Picker](../docs/editors/data-picker.md) - advanced picker editor to query a custom data source.
- [Editor Notes](../docs/editors/editor-notes.md) - Similar to [Notes](../docs/editors/notes.md), with enhanced UI options.
- [Icon Picker](../docs/editors/icon-picker.md) - an editor to select an icon (from the Umbraco icon library).
- [List Items](../docs/editors/list-items.md) - an editor to manage items with a name, value, icon and description.
- [Notes](../docs/editors/notes.md) - a read-only label to display rich-text instructional messages for content editors.
- [Number Input](../docs/editors/number-input.md) - a numeric editor, with sizing configurations.
- [Render Macro](../docs/editors/render-macro.md) - a read-only label dynamically generated from an Umbraco Macro.
- [Social Links](../docs/editors/social-links.md) - an editor to manage links for social network platforms.
- [Templated Label](../docs/editors/templated-label.md) - a display label, ideal for showing data from 3rd-party systems.
- [Textbox List](../docs/editors/textbox-list.md) - a multi-textstring editor, adds a textbox for each item in a custom data source.
- [Text Input](../docs/editors/text-input.md) - a textstring editor, configurable with HTML5 options.


##### Prerequisite

The configuration of all these editors will require you to have knowledge of how to create a new Data Type and Document Type in Umbraco.

If you are unfamiliar with how to do this, then please refer to documentation, guides and tutorials that are available.

- [Our Umbraco - Getting Started - Data](https://our.umbraco.com/Documentation/Getting-Started/Data/)
- [Our Umbraco - Getting Started - Data - Defining content](https://our.umbraco.com/Documentation/Getting-Started/Data/Defining-content/)
- [Our Umbraco - Getting Started - Data - Customizing Data Types](https://our.umbraco.com/Documentation/Getting-Started/Data/Data-Types/)

#### Telemetry

Information about Contentment's [telemetry feature](../docs/telemetry.md).

#### Tree Dashboard

Information about Contentment's [tree dashboard](../docs/tree-dashboard.md).
