﻿## Contentment for Umbraco

Contentment is a collection of components for [Umbraco](https://www.nuget.org/packages/UmbracoCms/) that can enhance the CMS editorial experience.

The following property editors are available...

- [Bytes](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/bytes.md) - a read-only label to display file sizes in relative bytes.
- [Code Editor](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/code-editor.md) - a code snippet editor, _(using the ACE library that is bundled with Umbraco)._
- [Content Blocks](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/content-blocks.md) - a block editor, configurable using element types.
- [Data List](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/data-list.md) - an editor that combines a custom data source with a custom list editor.
- [Data Picker](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/data-picker.md) - advanced picker editor to query a custom data source.
- [Editor Notes](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/editor-notes.md) - Similar to [Notes](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/notes.md), with enhanced UI options.
- [Icon Picker](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/icon-picker.md) - an editor to select an icon (from the Umbraco icon library).
- [Notes](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/notes.md) - a read-only label to display rich-text instructional messages for content editors.
- [List Items](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/list-items.md) - an editor to manage items with a name, value, icon and description.
- [Number Input](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/number-input.md) - a numeric editor, with sizing configurations.
- [Render Macro](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/render-macro.md) - a read-only label dynamically generated from an Umbraco Macro.
- [Social Links](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/social-links.md) - an editor to manage links for social network platforms.
- [Templated Label](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/templated-label.md) - a display label, ideal for showing data from 3rd-party systems.
- [Textbox List](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/textbox-list.md) - a multi-textstring editor, adds a textbox for each item in a custom data source.
- [Text Input](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/editors/text-input.md) - a textstring editor, configurable with HTML5 options.

You may find other features within Contentment that have not yet been documented, _let's call those "life's little surprises"._

[Documentation for each of the components](https://github.com/leekelleher/umbraco-contentment/blob/develop/docs/) - with screenshots, use-cases and code examples can be found on the GitHub repository.

If my Umbraco packages are of value to you and/or your business, then [**you could sponsor my open source contributions on GitHub?**](https://github.com/sponsors/leekelleher)

---

Contentment is licensed under the [Mozilla Public License](https://opensource.org/licenses/MPL-2.0).

Copyright &copy; [Lee Kelleher](https://leekelleher.com).
