# Learn You a Haskell for Great Good! 

1.  [Introduction](introduction.html)
    * [About this tutorial](introduction.html#about-this-tutorial)
    * [So what's Haskell?](introduction.html#so-whats-haskell)
    * [What you need to dive in](introduction.html#what-you-need)
2.  [Starting Out](starting-out.html)
    * [Ready, set, go!](starting-out.html#ready-set-go)
    * [Baby's first functions](starting-out.html#babys-first-functions)
    * [An intro to lists](starting-out.html#an-intro-to-lists)
    * [Texas ranges](starting-out.html#texas-ranges)
    * [I'm a list comprehension](starting-out.html#im-a-list-comprehension)
    * [Tuples](starting-out.html#tuples)
3.  [Types and Typeclasses](types-and-typeclasses.html)
    * [Believe the type](types-and-typeclasses.html#believe-the-type)
    * [Type variables](types-and-typeclasses.html#type-variables)
    * [Typeclasses 101](types-and-typeclasses.html#typeclasses-101)
4.  [Syntax in Functions](syntax-in-functions.html)
    * [Pattern matching](syntax-in-functions.html#pattern-matching)
    * [Guards, guards!](syntax-in-functions.html#guards-guards)
    * [Where!?](syntax-in-functions.html#where)
    * [Let it be](syntax-in-functions.html#let-it-be)
    * [Case expressions](syntax-in-functions.html#case-expressions)
5.  [Recursion](recursion.html)
    * [Hello recursion!](recursion.html#hello-recursion)
    * [Maximum awesome](recursion.html#maximum-awesome)
    * [A few more recursive functions](recursion.html#a-few-more-recursive-functions)
    * [Quick, sort!](recursion.html#quick-sort)
    * [Thinking recursively](recursion.html#thinking-recursively)
6.  [Higher Order Functions](higher-order-functions.html)
    * [Curried functions](higher-order-functions.html#curried-functions)
    * [Some higher-orderism is in order](higher-order-functions.html#higher-orderism)
    * [Maps and filters](higher-order-functions.html#maps-and-filters)
    * [Lambdas](higher-order-functions.html#lambdas)
    * [Only folds and horses](higher-order-functions.html#folds)
    * [Function application with $](higher-order-functions.html#function-application)
    * [Function composition](higher-order-functions.html#composition)
7.  [Modules](modules.html)
    * [Loading modules](modules.html#loading-modules)
    * [Data.List](modules.html#data-list)
    * [Data.Char](modules.html#data-char)
    * [Data.Map](modules.html#data-map)
    * [Data.Set](modules.html#data-set)
    * [Making our own modules](modules.html#making-our-own-modules)
8.  [Making Our Own Types and Typeclasses](making-our-own-types-and-typeclasses.html)
    * [Algebraic data types intro](making-our-own-types-and-typeclasses.html#algebraic-data-types)
    * [Record syntax](making-our-own-types-and-typeclasses.html#record-syntax)
    * [Type parameters](making-our-own-types-and-typeclasses.html#type-parameters)
    * [Derived instances](making-our-own-types-and-typeclasses.html#derived-instances)
    * [Type synonyms](making-our-own-types-and-typeclasses.html#type-synonyms)
    * [Recursive data structures](making-our-own-types-and-typeclasses.html#recursive-data-structures)
    * [Typeclasses 102](making-our-own-types-and-typeclasses.html#typeclasses-102)
    * [A yes-no typeclass](making-our-own-types-and-typeclasses.html#a-yes-no-typeclass)
    * [The Functor typeclass](making-our-own-types-and-typeclasses.html#the-functor-typeclass)
    * [Kinds and some type-foo](making-our-own-types-and-typeclasses.html#kinds-and-some-type-foo)
9.  [Input and Output](input-and-output.html)
    * [Hello, world!](input-and-output.html#hello-world)
    * [Files and streams](input-and-output.html#files-and-streams)
    * [Command line arguments](input-and-output.html#command-line-arguments)
    * [Randomness](input-and-output.html#randomness)
    * [Bytestrings](input-and-output.html#bytestrings)
    * [Exceptions](input-and-output.html#exceptions)
10. [Functionally Solving Problems](functionally-solving-problems.html)
    * [Reverse Polish notation calculator](functionally-solving-problems.html#reverse-polish-notation-calculator)
    * [Heathrow to London](functionally-solving-problems.html#heathrow-to-london)
11. [Functors, Applicative Functors and Monoids](functors-applicative-functors-and-monoids.html)
    * [Functors redux](functors-applicative-functors-and-monoids.html#functors-redux)
    * [Applicative functors](functors-applicative-functors-and-monoids.html#applicative-functors)
    * [The newtype keyword](functors-applicative-functors-and-monoids.html#the-newtype-keyword)
    * [Monoids](functors-applicative-functors-and-monoids.html#monoids)
12. [A Fistful of Monads](a-fistful-of-monads.html)
    * [Getting our feet wet with Maybe](a-fistful-of-monads.html#getting-our-feet-wet-with-maybe)
    * [The Monad type class](a-fistful-of-monads.html#the-monad-type-class)
    * [Walk the line](a-fistful-of-monads.html#walk-the-line)
    * [do notation](a-fistful-of-monads.html#do-notation)
    * [The list monad](a-fistful-of-monads.html#the-list-monad)
    * [Monad laws](a-fistful-of-monads.html#monad-laws)
13. [For a Few Monads More](for-a-few-monads-more.html)
    * [Writer? I hardly know her!](for-a-few-monads-more.html#writer)
    * [Reader? Ugh, not this joke again.](for-a-few-monads-more.html#reader)
    * [Tasteful stateful computations](for-a-few-monads-more.html#state)
    * [Error error on the wall](for-a-few-monads-more.html#error)
    * [Some useful monadic functions](for-a-few-monads-more.html#useful-monadic-functions)
    * [Making monads](for-a-few-monads-more.html#making-monads)
14. [Zippers](zippers.html)
    * [Taking a walk](zippers.html#taking-a-walk)
    * [A trail of breadcrumbs](zippers.html#a-trail-of-breadcrumbs)
    * [Focusing on lists](zippers.html#focusing-on-lists)
    * [A very simple file system](zippers.html#a-very-simple-file-system)
    * [Watch your step](zippers.html#watch-your-step)

This work is licensed under a [Creative Commons Attribution-Noncommercial-Share Alike 3.0 Unported License](https://creativecommons.org/licenses/by-nc-sa/3.0/){rel=license rel=nofollow} because I couldn't find a license with an even longer name.

