/**
 * This is a modified mte-kernal that doesn't have external dependencies such as require.js and meaw.js.
 * Original file: /npm/@susisu/mte-kernel@1.0.0/dist/mte-kernel.js
 *
 * Do NOT use SRI with dynamically generated files! More information: https://www.jsdelivr.com/using-sri-with-dynamic-files
 */
"use strict";class Point{constructor(t,e){this._row=t,this._column=e}get row(){return this._row}get column(){return this._column}equals(t){return this.row===t.row&&this.column===t.column}}class Range{constructor(t,e){this._start=t,this._end=e}get start(){return this._start}get end(){return this._end}}class Focus{constructor(t,e,o){this._row=t,this._column=e,this._offset=o}get row(){return this._row}get column(){return this._column}get offset(){return this._offset}posEquals(t){return this.row===t.row&&this.column===t.column}setRow(t){return new Focus(t,this.column,this.offset)}setColumn(t){return new Focus(this.row,t,this.offset)}setOffset(t){return new Focus(this.row,this.column,t)}}const Alignment=Object.freeze({NONE:"none",LEFT:"left",RIGHT:"right",CENTER:"center"}),DefaultAlignment=Object.freeze({LEFT:Alignment.LEFT,RIGHT:Alignment.RIGHT,CENTER:Alignment.CENTER}),HeaderAlignment=Object.freeze({FOLLOW:"follow",LEFT:Alignment.LEFT,RIGHT:Alignment.RIGHT,CENTER:Alignment.CENTER});class TableCell{constructor(t){this._rawContent=t,this._content=t.trim(),this._paddingLeft=""===this._content?""===this._rawContent?0:1:this._rawContent.length-this._rawContent.trimLeft().length,this._paddingRight=this._rawContent.length-this._content.length-this._paddingLeft}get rawContent(){return this._rawContent}get content(){return this._content}get paddingLeft(){return this._paddingLeft}get paddingRight(){return this._paddingRight}toText(){return this.rawContent}isDelimiter(){return/^\s*:?-+:?\s*$/.test(this.rawContent)}getAlignment(){if(this.isDelimiter())return":"===this.content[0]?":"===this.content[this.content.length-1]?Alignment.CENTER:Alignment.LEFT:":"===this.content[this.content.length-1]?Alignment.RIGHT:Alignment.NONE}computeContentOffset(t){return""===this.content||t<this.paddingLeft?0:t<this.paddingLeft+this.content.length?t-this.paddingLeft:this.content.length}computeRawOffset(t){return t+this.paddingLeft}}class TableRow{constructor(t,e,o){this._cells=t.slice(),this._marginLeft=e,this._marginRight=o}get marginLeft(){return this._marginLeft}get marginRight(){return this._marginRight}getWidth(){return this._cells.length}getCells(){return this._cells.slice()}getCellAt(t){return this._cells[t]}toText(){if(0===this._cells.length)return this.marginLeft;{const t=this._cells.map((t=>t.toText())).join("|");return`${this.marginLeft}|${t}|${this.marginRight}`}}isDelimiter(){return this._cells.every((t=>t.isDelimiter()))}}class Table{constructor(t){this._rows=t.slice()}getHeight(){return this._rows.length}getWidth(){return this._rows.map((t=>t.getWidth())).reduce(((t,e)=>Math.max(t,e)),0)}getHeaderWidth(){if(0!==this._rows.length)return this._rows[0].getWidth()}getRows(){return this._rows.slice()}getRowAt(t){return this._rows[t]}getDelimiterRow(){const t=this._rows[1];if(void 0!==t)return t.isDelimiter()?t:void 0}getCellAt(t,e){const o=this._rows[t];if(void 0!==o)return o.getCellAt(e)}getFocusedCell(t){return this.getCellAt(t.row,t.column)}toLines(){return this._rows.map((t=>t.toText()))}focusOfPosition(t,e){const o=t.row-e,n=this._rows[o];if(void 0!==n){if(t.column<n.marginLeft.length+1)return new Focus(o,-1,t.column);{const e=n.getCells().map((t=>t.rawContent.length));let s=n.marginLeft.length+1,r=0;for(;r<e.length&&!(s+e[r]+1>t.column);r++)s+=e[r]+1;const i=t.column-s;return new Focus(o,r,i)}}}positionOfFocus(t,e){const o=this._rows[t.row];if(void 0===o)return;const n=t.row+e;if(t.column<0)return new Point(n,t.offset);const s=o.getCells().map((t=>t.rawContent.length)),r=Math.min(t.column,s.length);let i=o.marginLeft.length+1;for(let t=0;t<r;t++)i+=s[t]+1;return new Point(n,i+t.offset)}selectionRangeOfFocus(t,e){const o=this._rows[t.row];if(void 0===o)return;const n=o.getCellAt(t.column);if(void 0===n)return;if(""===n.content)return;const s=t.row+e,r=o.getCells().map((t=>t.rawContent.length));let i=o.marginLeft.length+1;for(let e=0;e<t.column;e++)i+=r[e]+1;return i+=n.paddingLeft,new Range(new Point(s,i),new Point(s,i+n.content.length))}}function _splitCells(t){const e=[];let o="",n=t;for(;""!==n;)switch(n[0]){case"`":{const t=n.match(/^`*/)[0];let e=t,s=n.substr(t.length),r=!1;for(;""!==s;)if("`"===s[0]){const o=s.match(/^`*/)[0];if(e+=o,s=s.substr(o.length),o.length===t.length){r=!0;break}}else e+=s[0],s=s.substr(1);r?(o+=e,n=s):(o+="`",n=n.substr(1))}break;case"\\":n.length>=2?(o+=n.substr(0,2),n=n.substr(2)):(o+="\\",n=n.substr(1));break;case"|":e.push(o),o="",n=n.substr(1);break;default:o+=n[0],n=n.substr(1)}return e.push(o),e}function _readRow(t){let e,o,n=_splitCells(t);return n.length>0&&/^\s*$/.test(n[0])?(e=n[0],n=n.slice(1)):e="",n.length>1&&/^\s*$/.test(n[n.length-1])?(o=n[n.length-1],n=n.slice(0,n.length-1)):o="",new TableRow(n.map((t=>new TableCell(t))),e,o)}function readTable(t){return new Table(t.map(_readRow))}function _delimiterText(t,e){const o="-".repeat(e);switch(t){case Alignment.NONE:return` ${o} `;case Alignment.LEFT:return`:${o} `;case Alignment.RIGHT:return` ${o}:`;case Alignment.CENTER:return`:${o}:`;default:throw new Error("Unknown alignment: "+t)}}function _extendArray(t,e,o){const n=t.slice();for(let s=t.length;s<e;s++)n.push(o(s,t));return n}function completeTable(t,e){const o=t.getHeight(),n=t.getWidth();if(0===o)throw new Error("Empty table");const s=t.getRows(),r=[],i=s[0],l=i.getCells();r.push(new TableRow(_extendArray(l,n,(t=>new TableCell(t===l.length?i.marginRight:""))),i.marginLeft,l.length<n?"":i.marginRight));const a=t.getDelimiterRow();if(void 0!==a){const t=a.getCells();r.push(new TableRow(_extendArray(t,n,(o=>new TableCell(_delimiterText(Alignment.NONE,o===t.length?Math.max(e.minDelimiterWidth,a.marginRight.length-2):e.minDelimiterWidth)))),a.marginLeft,t.length<n?"":a.marginRight))}else r.push(new TableRow(_extendArray([],n,(()=>new TableCell(_delimiterText(Alignment.NONE,e.minDelimiterWidth)))),"",""));for(let t=void 0!==a?2:1;t<o;t++){const e=s[t],o=e.getCells();r.push(new TableRow(_extendArray(o,n,(t=>new TableCell(t===o.length?e.marginRight:""))),e.marginLeft,o.length<n?"":e.marginRight))}return{table:new Table(r),delimiterInserted:void 0===a}}function _computeTextWidth(t,e){const o=e.normalize?t.normalize("NFC"):t;let n=0;for(const t of o)if(e.wideChars.has(t))n+=2;else if(e.narrowChars.has(t))n+=1;else switch(t){case"F":case"W":n+=2;break;case"A":n+=e.ambiguousAsWide?2:1;break;default:n+=1}return n}function _alignText(t,e,o,n){const s=e-_computeTextWidth(t,n);if(s<0)return t;switch(o){case Alignment.NONE:throw new Error("Unexpected default alignment");case Alignment.LEFT:return t+" ".repeat(s);case Alignment.RIGHT:return" ".repeat(s)+t;case Alignment.CENTER:return" ".repeat(Math.floor(s/2))+t+" ".repeat(Math.ceil(s/2));default:throw new Error("Unknown alignment: "+o)}}function _padText(t){return` ${t} `}function _formatTable(t,e){const o=t.getHeight(),n=t.getWidth();if(0===o)return{table:t,marginLeft:""};const s=t.getRowAt(0).marginLeft;if(0===n){const t=new Array(o).fill().map((()=>new TableRow([],s,"")));return{table:new Table(t),marginLeft:s}}const r=t.getDelimiterRow(),i=new Array(n).fill(0);if(void 0!==r){const t=r.getWidth();for(let o=0;o<t;o++)i[o]=e.minDelimiterWidth}for(let n=0;n<o;n++){if(void 0!==r&&1===n)continue;const o=t.getRowAt(n),s=o.getWidth();for(let t=0;t<s;t++)i[t]=Math.max(i[t],_computeTextWidth(o.getCellAt(t).content,e.textWidthOptions))}const l=void 0!==r?_extendArray(r.getCells().map((t=>t.getAlignment())),n,(()=>e.defaultAlignment)):new Array(n).fill(e.defaultAlignment),a=[],c=t.getRowAt(0);a.push(new TableRow(c.getCells().map(((t,o)=>new TableCell(_padText(_alignText(t.content,i[o],e.headerAlignment===HeaderAlignment.FOLLOW?l[o]===Alignment.NONE?e.defaultAlignment:l[o]:e.headerAlignment,e.textWidthOptions))))),s,"")),void 0!==r&&a.push(new TableRow(r.getCells().map(((t,e)=>new TableCell(_delimiterText(l[e],i[e])))),s,""));for(let n=void 0!==r?2:1;n<o;n++){const o=t.getRowAt(n);a.push(new TableRow(o.getCells().map(((t,o)=>new TableCell(_padText(_alignText(t.content,i[o],l[o]===Alignment.NONE?e.defaultAlignment:l[o],e.textWidthOptions))))),s,""))}return{table:new Table(a),marginLeft:s}}function _weakFormatTable(t,e){const o=t.getHeight(),n=t.getWidth();if(0===o)return{table:t,marginLeft:""};const s=t.getRowAt(0).marginLeft;if(0===n){const t=new Array(o).fill().map((()=>new TableRow([],s,"")));return{table:new Table(t),marginLeft:s}}const r=t.getDelimiterRow(),i=[],l=t.getRowAt(0);i.push(new TableRow(l.getCells().map((t=>new TableCell(_padText(t.content)))),s,"")),void 0!==r&&i.push(new TableRow(r.getCells().map((t=>new TableCell(_delimiterText(t.getAlignment(),e.minDelimiterWidth)))),s,""));for(let e=void 0!==r?2:1;e<o;e++){const o=t.getRowAt(e);i.push(new TableRow(o.getCells().map((t=>new TableCell(_padText(t.content)))),s,""))}return{table:new Table(i),marginLeft:s}}const FormatType=Object.freeze({NORMAL:"normal",WEAK:"weak"});function formatTable(t,e){switch(e.formatType){case FormatType.NORMAL:return _formatTable(t,e);case FormatType.WEAK:return _weakFormatTable(t,e);default:throw new Error("Unknown format type: "+e.formatType)}}function alterAlignment(t,e,o,n){const s=t.getRowAt(1);if(e<0||s.getWidth()-1<e)return t;const r=s.getCells();r[e]=new TableCell(_delimiterText(o,n.minDelimiterWidth));const i=t.getRows();return i[1]=new TableRow(r,s.marginLeft,s.marginRight),new Table(i)}function insertRow(t,e,o){const n=t.getRows();return n.splice(Math.max(e,2),0,o),new Table(n)}function deleteRow(t,e){if(1===e)return t;const o=t.getRows();if(0===e){const t=o[0];o[0]=new TableRow(new Array(t.getWidth()).fill(new TableCell("")),t.marginLeft,t.marginRight)}else o.splice(e,1);return new Table(o)}function moveRow(t,e,o){if(e<=1||o<=1||e===o)return t;const n=t.getRows(),s=n[e];return n.splice(e,1),n.splice(o,0,s),new Table(n)}function insertColumn(t,e,o,n){const s=t.getRows();for(let t=0;t<s.length;t++){const r=s[t],i=s[t].getCells(),l=1===t?new TableCell(_delimiterText(Alignment.NONE,n.minDelimiterWidth)):o[t>1?t-1:t];i.splice(e,0,l),s[t]=new TableRow(i,r.marginLeft,r.marginRight)}return new Table(s)}function deleteColumn(t,e,o){const n=t.getRows();for(let t=0;t<n.length;t++){const s=n[t];let r=s.getCells();r.length<=1?r=[new TableCell(1===t?_delimiterText(Alignment.NONE,o.minDelimiterWidth):"")]:r.splice(e,1),n[t]=new TableRow(r,s.marginLeft,s.marginRight)}return new Table(n)}function moveColumn(t,e,o){if(e===o)return t;const n=t.getRows();for(let t=0;t<n.length;t++){const s=n[t],r=s.getCells(),i=r[e];r.splice(e,1),r.splice(o,0,i),n[t]=new TableRow(r,s.marginLeft,s.marginRight)}return new Table(n)}class Insert{constructor(t,e){this._row=t,this._line=e}get row(){return this._row}get line(){return this._line}}class Delete{constructor(t){this._row=t}get row(){return this._row}}function _applyCommand(t,e,o){if(e instanceof Insert)t.insertLine(o+e.row,e.line);else{if(!(e instanceof Delete))throw new Error("Unknown command");t.deleteLine(o+e.row)}}function applyEditScript(t,e,o){for(const n of e)_applyCommand(t,n,o)}class IList{get car(){throw new Error("Not implemented")}get cdr(){throw new Error("Not implemented")}isEmpty(){throw new Error("Not implemented")}unshift(t){return new Cons(t,this)}toArray(){const t=[];let e=this;for(;!e.isEmpty();)t.push(e.car),e=e.cdr;return t}}class Nil extends IList{constructor(){super()}get car(){throw new Error("Empty list")}get cdr(){throw new Error("Empty list")}isEmpty(){return!0}}class Cons extends IList{constructor(t,e){super(),this._car=t,this._cdr=e}get car(){return this._car}get cdr(){return this._cdr}isEmpty(){return!1}}const nil=new Nil;function shortestEditScript(t,e,o=-1){const n=t.length,s=e.length,r=o>=0?Math.min(o,n+s):n+s,i=new Array(Math.min(r,n)+Math.min(r,s)+1),l=Math.min(r,n);for(let o=0;o<=r;o++){const r=o<=s?o:2*s-o;for(let a=o<=n?-o:o-2*n;a<=r;a+=2){let r,c;if(0===o)r=0,c=nil;else if(a===-o)r=i[l+a+1].i+1,c=i[l+a+1].script.unshift(new Delete(r+a));else if(a===o)r=i[l+a-1].i,c=i[l+a-1].script.unshift(new Insert(r+a-1,e[r+a-1]));else{const t=i[l+a+1].i+1,o=i[l+a-1].i;t>o?(r=t,c=i[l+a+1].script.unshift(new Delete(r+a))):(r=o,c=i[l+a-1].script.unshift(new Insert(r+a-1,e[r+a-1])))}for(;r<n&&r+a<s&&t[r]===e[r+a];)r+=1;if(a===s-n&&r===n)return c.toArray().reverse();i[l+a]={i:r,script:c}}}}class ITextEditor{getCursorPosition(){throw new Error("Not implemented: getCursorPosition")}setCursorPosition(t){throw new Error("Not implemented: setCursorPosition")}setSelectionRange(t){throw new Error("Not implemented: setSelectionRange")}getLastRow(){throw new Error("Not implemented: getLastRow")}acceptsTableEdit(t){throw new Error("Not implemented: acceptsTableEdit")}getLine(t){throw new Error("Not implemented: getLine")}insertLine(t,e){throw new Error("Not implemented: insertLine")}deleteLine(t){throw new Error("Not implemented: deleteLine")}replaceLines(t,e,o){throw new Error("Not implemented: replaceLines")}transact(t){throw new Error("Not implemented: transact")}}function _value(t,e,o){return"object"==typeof t&&null!==t&&void 0!==t[e]?t[e]:o}function _values(t,e){const o={};for(const[n,s]of Object.entries(e))o[n]=_value(t,n,s);return o}function options(t){const e=_values(t,{formatType:FormatType.NORMAL,minDelimiterWidth:3,defaultAlignment:DefaultAlignment.LEFT,headerAlignment:HeaderAlignment.FOLLOW,smartCursor:!1});return e.textWidthOptions=_values(t.textWidthOptions,{normalize:!0,wideChars:new Set,narrowChars:new Set,ambiguousAsWide:!1}),e}function _isTableRow(t){return"|"===t.trimLeft()[0]}function _computeNewOffset(t,e,o,n){if(n){const e=o.table.getFocusedCell(t);return void 0!==e?e.computeRawOffset(0):t.column<0?o.marginLeft.length:0}{const n=e.getFocusedCell(t),s=o.table.getFocusedCell(t);if(void 0!==n&&void 0!==s){const e=Math.min(n.computeContentOffset(t.offset),s.content.length);return s.computeRawOffset(e)}return t.column<0?o.marginLeft.length:0}}class TableEditor{constructor(t){this._textEditor=t,this._scActive=!1,this._scTablePos=null,this._scStartFocus=null,this._scLastFocus=null}resetSmartCursor(){this._scActive=!1}cursorIsInTable(){const t=this._textEditor.getCursorPosition();return this._textEditor.acceptsTableEdit(t.row)&&_isTableRow(this._textEditor.getLine(t.row))}_findTable(){const t=this._textEditor.getCursorPosition(),e=this._textEditor.getLastRow(),o=[];let n=t.row,s=t.row;{const e=this._textEditor.getLine(t.row);if(!this._textEditor.acceptsTableEdit(t.row)||!_isTableRow(e))return;o.push(e)}for(let e=t.row-1;e>=0;e--){const t=this._textEditor.getLine(e);if(!this._textEditor.acceptsTableEdit(e)||!_isTableRow(t))break;o.unshift(t),n=e}for(let n=t.row+1;n<=e;n++){const t=this._textEditor.getLine(n);if(!this._textEditor.acceptsTableEdit(n)||!_isTableRow(t))break;o.push(t),s=n}const r=new Range(new Point(n,0),new Point(s,o[o.length-1].length)),i=readTable(o),l=i.focusOfPosition(t,n);return{range:r,lines:o,table:i,focus:l}}_withTable(t){const e=this._findTable();void 0!==e&&t(e)}_updateLines(t,e,o,n){if(void 0!==n){const e=shortestEditScript(n,o,3);if(void 0!==e)return void applyEditScript(this._textEditor,e,t)}this._textEditor.replaceLines(t,e,o)}_moveToFocus(t,e,o){const n=e.positionOfFocus(o,t);void 0!==n&&this._textEditor.setCursorPosition(n)}_selectFocus(t,e,o){const n=e.selectionRangeOfFocus(o,t);void 0!==n?this._textEditor.setSelectionRange(n):this._moveToFocus(t,e,o)}format(t){this._withTable((({range:e,lines:o,table:n,focus:s})=>{let r=s;const i=completeTable(n,t);i.delimiterInserted&&r.row>0&&(r=r.setRow(r.row+1));const l=formatTable(i.table,t);r=r.setOffset(_computeNewOffset(r,i.table,l,!1)),this._textEditor.transact((()=>{this._updateLines(e.start.row,e.end.row+1,l.table.toLines(),o),this._moveToFocus(e.start.row,l.table,r)}))}))}escape(t){this._withTable((({range:e,lines:o,table:n,focus:s})=>{const r=completeTable(n,t),i=formatTable(r.table,t),l=new Point(e.end.row+(r.delimiterInserted?2:1),0);this._textEditor.transact((()=>{this._updateLines(e.start.row,e.end.row+1,i.table.toLines(),o),l.row>this._textEditor.getLastRow()&&this._textEditor.insertLine(l.row,""),this._textEditor.setCursorPosition(l)})),this.resetSmartCursor()}))}alignColumn(t,e){this._withTable((({range:o,lines:n,table:s,focus:r})=>{let i=r;const l=completeTable(s,e);l.delimiterInserted&&i.row>0&&(i=i.setRow(i.row+1));let a=l.table;0<=i.column&&i.column<=a.getHeaderWidth()-1&&(a=alterAlignment(l.table,i.column,t,e));const c=formatTable(a,e);i=i.setOffset(_computeNewOffset(i,l.table,c,!1)),this._textEditor.transact((()=>{this._updateLines(o.start.row,o.end.row+1,c.table.toLines(),n),this._moveToFocus(o.start.row,c.table,i)}))}))}selectCell(t){this._withTable((({range:e,lines:o,table:n,focus:s})=>{let r=s;const i=completeTable(n,t);i.delimiterInserted&&r.row>0&&(r=r.setRow(r.row+1));const l=formatTable(i.table,t);r=r.setOffset(_computeNewOffset(r,i.table,l,!1)),this._textEditor.transact((()=>{this._updateLines(e.start.row,e.end.row+1,l.table.toLines(),o),this._selectFocus(e.start.row,l.table,r)}))}))}moveFocus(t,e,o){this._withTable((({range:n,lines:s,table:r,focus:i})=>{let l=i;const a=completeTable(r,o);a.delimiterInserted&&l.row>0&&(l=l.setRow(l.row+1));const c=l;if(0!==t){const e=a.table.getHeight(),o=l.row<1&&l.row+t>=1?1:l.row>1&&l.row+t<=1?-1:0;l=l.setRow(Math.min(Math.max(l.row+t+o,0),e<=2?0:e-1))}if(0!==e){const t=a.table.getHeaderWidth();l.column<0&&e<0||l.column>t-1&&e>0||(l=l.setColumn(Math.min(Math.max(l.column+e,0),t-1)))}const w=!l.posEquals(c),h=formatTable(a.table,o);l=l.setOffset(_computeNewOffset(l,a.table,h,w)),this._textEditor.transact((()=>{this._updateLines(n.start.row,n.end.row+1,h.table.toLines(),s),w?this._selectFocus(n.start.row,h.table,l):this._moveToFocus(n.start.row,h.table,l)})),w&&this.resetSmartCursor()}))}nextCell(t){this._withTable((({range:e,lines:o,table:n,focus:s})=>{const r=null!==this._scTablePos&&!e.start.equals(this._scTablePos)||null!==this._scLastFocus&&!s.posEquals(this._scLastFocus);this._scActive&&r&&this.resetSmartCursor();let i=s;const l=completeTable(n,t);l.delimiterInserted&&i.row>0&&(i=i.setRow(i.row+1));const a=i;let c=l.table;if(1===i.row){if(i=i.setRow(2),t.smartCursor?(i.column<0||c.getHeaderWidth()-1<i.column)&&(i=i.setColumn(0)):i=i.setColumn(0),i.row>c.getHeight()-1){const t=new Array(c.getHeaderWidth()).fill(new TableCell(""));c=insertRow(c,c.getHeight(),new TableRow(t,"",""))}}else{if(i.column>c.getHeaderWidth()-1){const e=new Array(c.getHeight()-1).fill(new TableCell(""));c=insertColumn(c,c.getHeaderWidth(),e,t)}i=i.setColumn(i.column+1)}const w=formatTable(c,t);i=i.setOffset(_computeNewOffset(i,c,w,!0));const h=w.table.toLines();i.column>w.table.getHeaderWidth()-1&&(h[i.row]+=" ",i=i.setOffset(1)),this._textEditor.transact((()=>{this._updateLines(e.start.row,e.end.row+1,h,o),this._selectFocus(e.start.row,w.table,i)})),t.smartCursor&&(this._scActive||(this._scActive=!0,this._scTablePos=e.start,a.column<0||w.table.getHeaderWidth()-1<a.column?this._scStartFocus=new Focus(a.row,0,0):this._scStartFocus=a),this._scLastFocus=i)}))}previousCell(t){this._withTable((({range:e,lines:o,table:n,focus:s})=>{let r=s;const i=completeTable(n,t);i.delimiterInserted&&r.row>0&&(r=r.setRow(r.row+1));const l=r;0===r.row?r.column>0&&(r=r.setColumn(r.column-1)):r=1===r.row?new Focus(0,i.table.getHeaderWidth()-1,r.offset):r.column>0?r.setColumn(r.column-1):new Focus(2===r.row?0:r.row-1,i.table.getHeaderWidth()-1,r.offset);const a=!r.posEquals(l),c=formatTable(i.table,t);r=r.setOffset(_computeNewOffset(r,i.table,c,a)),this._textEditor.transact((()=>{this._updateLines(e.start.row,e.end.row+1,c.table.toLines(),o),a?this._selectFocus(e.start.row,c.table,r):this._moveToFocus(e.start.row,c.table,r)})),a&&this.resetSmartCursor()}))}nextRow(t){this._withTable((({range:e,lines:o,table:n,focus:s})=>{const r=null!==this._scTablePos&&!e.start.equals(this._scTablePos)||null!==this._scLastFocus&&!s.posEquals(this._scLastFocus);this._scActive&&r&&this.resetSmartCursor();let i=s;const l=completeTable(n,t);l.delimiterInserted&&i.row>0&&(i=i.setRow(i.row+1));const a=i;let c=l.table;if(i=0===i.row?i.setRow(2):i.setRow(i.row+1),t.smartCursor?this._scActive?i=i.setColumn(this._scStartFocus.column):(i.column<0||c.getHeaderWidth()-1<i.column)&&(i=i.setColumn(0)):i=i.setColumn(0),i.row>c.getHeight()-1){const t=new Array(c.getHeaderWidth()).fill(new TableCell(""));c=insertRow(c,c.getHeight(),new TableRow(t,"",""))}const w=formatTable(c,t);i=i.setOffset(_computeNewOffset(i,c,w,!0)),this._textEditor.transact((()=>{this._updateLines(e.start.row,e.end.row+1,w.table.toLines(),o),this._selectFocus(e.start.row,w.table,i)})),t.smartCursor&&(this._scActive||(this._scActive=!0,this._scTablePos=e.start,a.column<0||w.table.getHeaderWidth()-1<a.column?this._scStartFocus=new Focus(a.row,0,0):this._scStartFocus=a),this._scLastFocus=i)}))}insertRow(t){this._withTable((({range:e,lines:o,table:n,focus:s})=>{let r=s;const i=completeTable(n,t);i.delimiterInserted&&r.row>0&&(r=r.setRow(r.row+1)),r.row<=1&&(r=r.setRow(2)),r=r.setColumn(0);const l=new Array(i.table.getHeaderWidth()).fill(new TableCell("")),a=insertRow(i.table,r.row,new TableRow(l,"","")),c=formatTable(a,t);r=r.setOffset(_computeNewOffset(r,a,c,!0)),this._textEditor.transact((()=>{this._updateLines(e.start.row,e.end.row+1,c.table.toLines(),o),this._moveToFocus(e.start.row,c.table,r)})),this.resetSmartCursor()}))}deleteRow(t){this._withTable((({range:e,lines:o,table:n,focus:s})=>{let r=s;const i=completeTable(n,t);i.delimiterInserted&&r.row>0&&(r=r.setRow(r.row+1));let l=i.table,a=!1;1!==r.row&&(l=deleteRow(l,r.row),a=!0,r.row>l.getHeight()-1&&(r=r.setRow(2===r.row?0:r.row-1)));const c=formatTable(l,t);r=r.setOffset(_computeNewOffset(r,l,c,a)),this._textEditor.transact((()=>{this._updateLines(e.start.row,e.end.row+1,c.table.toLines(),o),a?this._selectFocus(e.start.row,c.table,r):this._moveToFocus(e.start.row,c.table,r)})),this.resetSmartCursor()}))}moveRow(t,e){this._withTable((({range:o,lines:n,table:s,focus:r})=>{let i=r;const l=completeTable(s,e);l.delimiterInserted&&i.row>0&&(i=i.setRow(i.row+1));let a=l.table;if(i.row>1){const e=Math.min(Math.max(i.row+t,2),a.getHeight()-1);a=moveRow(a,i.row,e),i=i.setRow(e)}const c=formatTable(a,e);i=i.setOffset(_computeNewOffset(i,a,c,!1)),this._textEditor.transact((()=>{this._updateLines(o.start.row,o.end.row+1,c.table.toLines(),n),this._moveToFocus(o.start.row,c.table,i)})),this.resetSmartCursor()}))}insertColumn(t){this._withTable((({range:e,lines:o,table:n,focus:s})=>{let r=s;const i=completeTable(n,t);i.delimiterInserted&&r.row>0&&(r=r.setRow(r.row+1)),1===r.row&&(r=r.setRow(0)),r.column<0&&(r=r.setColumn(0));const l=new Array(i.table.getHeight()-1).fill(new TableCell("")),a=insertColumn(i.table,r.column,l,t),c=formatTable(a,t);r=r.setOffset(_computeNewOffset(r,a,c,!0)),this._textEditor.transact((()=>{this._updateLines(e.start.row,e.end.row+1,c.table.toLines(),o),this._moveToFocus(e.start.row,c.table,r)})),this.resetSmartCursor()}))}deleteColumn(t){this._withTable((({range:e,lines:o,table:n,focus:s})=>{let r=s;const i=completeTable(n,t);i.delimiterInserted&&r.row>0&&(r=r.setRow(r.row+1)),1===r.row&&(r=r.setRow(0));let l=i.table,a=!1;0<=r.column&&r.column<=l.getHeaderWidth()-1&&(l=deleteColumn(i.table,r.column,t),a=!0,r.column>l.getHeaderWidth()-1&&(r=r.setColumn(l.getHeaderWidth()-1)));const c=formatTable(l,t);r=r.setOffset(_computeNewOffset(r,l,c,a)),this._textEditor.transact((()=>{this._updateLines(e.start.row,e.end.row+1,c.table.toLines(),o),a?this._selectFocus(e.start.row,c.table,r):this._moveToFocus(e.start.row,c.table,r)})),this.resetSmartCursor()}))}moveColumn(t,e){this._withTable((({range:o,lines:n,table:s,focus:r})=>{let i=r;const l=completeTable(s,e);l.delimiterInserted&&i.row>0&&(i=i.setRow(i.row+1));let a=l.table;if(0<=i.column&&i.column<=a.getHeaderWidth()-1){const e=Math.min(Math.max(i.column+t,0),a.getHeaderWidth()-1);a=moveColumn(a,i.column,e),i=i.setColumn(e)}const c=formatTable(a,e);i=i.setOffset(_computeNewOffset(i,a,c,!1)),this._textEditor.transact((()=>{this._updateLines(o.start.row,o.end.row+1,c.table.toLines(),n),this._moveToFocus(o.start.row,c.table,i)})),this.resetSmartCursor()}))}formatAll(t){this._textEditor.transact((()=>{let e,o=this._textEditor.getCursorPosition(),n=[],s=this._textEditor.getLastRow();for(let r=0;r<=s;r++){const i=this._textEditor.getLine(r);if(this._textEditor.acceptsTableEdit(r)&&_isTableRow(i))n.push(i),void 0===e&&(e=r);else if(void 0!==e){const i=r-1,l=new Range(new Point(e,0),new Point(i,n[n.length-1].length)),a=readTable(n),c=a.focusOfPosition(o,e),w=void 0!==c;let h=c;const u=completeTable(a,t);w&&u.delimiterInserted&&h.row>0&&(h=h.setRow(h.row+1));const m=formatTable(u.table,t);w&&(h=h.setOffset(_computeNewOffset(h,u.table,m,!1)));const g=m.table.toLines();this._updateLines(l.start.row,l.end.row+1,g,n);const d=g.length-n.length;w?o=m.table.positionOfFocus(h,e):o.row>i&&(o=new Point(o.row+d,o.column)),n=[],e=void 0,s+=d,r+=d}}if(void 0!==e){const r=s,i=new Range(new Point(e,0),new Point(r,n[n.length-1].length)),l=readTable(n);let a=l.focusOfPosition(o,e);const c=completeTable(l,t);c.delimiterInserted&&a.row>0&&(a=a.setRow(a.row+1));const w=formatTable(c.table,t);a=a.setOffset(_computeNewOffset(a,c.table,w,!1));const h=w.table.toLines();this._updateLines(i.start.row,i.end.row+1,h,n),o=w.table.positionOfFocus(a,e)}this._textEditor.setCursorPosition(o)}))}}
export { ITextEditor, TableEditor, Point, options, Alignment }
//# sourceMappingURL=/sm/0a920c87c8efaf1d3e3365ae39814680631abd3fa4e73f44abf4849e7b66e822.map
