# CDN

`Content Distribute Network`(内容分发网络)是构建在网络之上的内容分发网络，依靠部署在各地的边缘服务器，通过中心平台的负载均衡、内容分发、调度等功能模块，使用户就近获取所需内容，降低网络拥塞，提高用户访问响应速度和命中率。

在之前的[带宽与延迟](/带宽与延迟/带宽与延迟.md)章节，我们就提到了CDN，在该章节中我们讲到从宏观角度可从下面几个方面去思考网络延迟：

* **"第一公里"** 从资源服务器考虑，主要是考虑服务器本身提供的服务能力。
* **"最后一公里"** 离用户最近的接入网络，接入网络多种多样，提供的带宽能力参差不齐，往往造成带宽瓶颈。
* **对等互联关口** 即不同运营商网络之间的互联互通。
* **长途骨干传输** 远距离的传输需要考虑传输介质本身提供的带宽能力；网络传输过程中经过多层网络、路由器交换机等网络设备带来的延迟；大流量访问下骨干网络负载能力有限导致的拥塞问题。

## 传统方式

传统方式下用户访问网站示意图:
![/assets/cdn_traditional.png](/assets/cdn_traditional.png)

详细DNS工作过程参考[从输入URL开始](/带宽与延迟/从输入URL开始.md)章节。

传统方式面临的问题：

* 对应"第一公里"：所有用户访问资源都请求中心服务器，而中心服务器的承受能力有限，当突然有大量用户（可能来自于DDOS攻击）时，会导致中心服务瘫痪，从而使得所有用户无法访问资源，即服务可靠性不足。
* 对应"对等互联关口"：使用不同运营商网络的用户互访速度受限。
* 对应"长途骨干传输": 没有考虑不同地域的用户访问距离的差异，有可能因为资源服务器与用户距离太远而导致很大的延迟。

## 加入CDN

加入CDN后的网络架构示意图：

![/assets/cdn_addCDN.png](/assets/cdn_addCDN.png)

图片来源于《云计算》

此种方式的优点：
* 将用户流量比较均匀地分散到不同的边缘节点，做负载均衡，有效缓解源服务器的压力。
* CDN加速可以覆盖全球的线路，通过和运营商合作，部署IDC资源，在全国骨干节点商，合理部署CDN边缘分发存储节点,提高访问速度。
* 智能DNS负载均衡服务器与资源节点保持通信，确保资源可用。
* 容灾备份：当某个服务器发生意外故障时，系统将会调用其他临近的健康服务器节点进行服务，进而提供接近100%的可靠性，这就让你的网站可以做到永不宕机。
* 资源与应用解耦，将资源服务交给zCDN商，自身专注业务开发。
## 工作原理
// todo

## 应用

// todo