# 浏览器优化策略

除了之前讲到的提前下载脚本样式等资源外，浏览器还有其他一些针对网络资源的优化策略。

文章来源: [http://bubkoo.com/2015/11/19/prefetching-preloading-prebrowsing/](http://bubkoo.com/2015/11/19/prefetching-preloading-prebrowsing/)

## DNS预解析 DNS-Prefetch

通过 DNS 预解析来告诉浏览器未来我们可能从某个特定的 URL 获取资源，当浏览器真正使用到该域中的某个资源时就可以尽快地完成 DNS 解析。例如，我们将来可能从`example.com`获取图片或音频资源，那么可以在文档顶部的`<head>`标签中加入以下内容：

```html
<link rel="dns-prefetch" href="//example.com">
```

## 预连接 Preconnect

```html
<link rel="preconnect" href="http://example.com">
```

现代浏览器都试着预测网站将来需要哪些连接，然后预先建立 socket 连接，从而消除昂贵的 DNS 查找、TCP 握手和 TLS 往返开销。然而，浏览器还不够聪明，并不能准确预测每个网站的所有预链接目标。好在，在 Firefox 39 和 Chrome 46 中我们可以使用`preconnect`告诉浏览器我们需要进行哪些预连接。

## 预获取 Prefetching

如果我们确定某个资源将来一定会被使用到，我们可以让浏览器预先请求该资源并放入浏览器缓存中。例如，一个图片和脚本或任何可以被浏览器缓存的资源：

```html
<link rel="prefetch" href="image.png">
```

该图片会被预先加载并存入浏览器缓存。某些预获取可能会被浏览器忽略，例如从一个非常缓慢的网络中获取一个庞大的字体文件。

## Subresources

这是另一个预获取方式，这种方式指定的预获取资源具有最高的优先级，在所有`prefetch`项之前进行：

```html
<link rel="subresource" href="styles.css">
```

`rel=prefetch`为将来的页面提供了一种低优先级的资源预加载方式，而`rel=subresource`为当前页面提供了一种高优先级的资源预加载。所以，如果资源是当前页面必须的，或者资源需要尽快可用，那么最好使用`subresource`而不是`prefetch`。

## 预渲染 Prerender

```html
<link rel="prerender" href="http://example.com">
```

这类似于在一个隐藏的 tab 页中打开了某个链接 – 将下载所有资源、创建 DOM 结构、完成页面布局、应用 CSS 样式和执行 JavaScript 脚本等。当用户真正访问该链接时，隐藏的页面就切换为可见，使页面看起来就是瞬间加载完成一样。Google 搜索在其即时搜索页面中已经应用该技术多年了，微软也宣称将在 IE11 中支持该特性。

